/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.autoplot.help.AutoplotHelpSystem;
import org.das2.components.DatumEditor;
import org.das2.components.propertyeditor.ColorEditor;
import org.das2.components.propertyeditor.EnumerationEditor;
import org.das2.graph.DasCanvas;
import org.das2.graph.GraphUtil;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.layout.GroupLayout;
import org.virbo.autoplot.ApplicationModel;
import org.virbo.autoplot.ColorScatterStylePanel;
import org.virbo.autoplot.GuiSupport;
import org.virbo.autoplot.HugeScatterStylePanel;
import org.virbo.autoplot.RenderType;
import org.virbo.autoplot.SeriesStylePanel;
import org.virbo.autoplot.SpectrogramStylePanel;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.DomUtil;
import org.virbo.autoplot.dom.PlotElement;

public class PlotStylePanel
extends JPanel {
    private static final int ICON_SIZE = 16;
    private static final Color[] fores = new Color[]{Color.BLACK, Color.WHITE, Color.WHITE};
    private static final Color[] backs = new Color[]{Color.WHITE, Color.BLACK, Color.BLUE.darker()};
    ApplicationModel applicationModel;
    EnumerationEditor psymEditor;
    EnumerationEditor lineEditor;
    EnumerationEditor edit;
    EnumerationEditor rebin;
    ColorEditor colorEditor;
    ColorEditor fillColorEditor;
    DatumEditor referenceEditor;
    BindingGroup elementBindingContext;
    PlotElement currentElement;
    Application dom;
    private transient PropertyChangeListener renderTypeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent ev) {
            PlotStylePanel.this.doElementBindings();
        }
    };
    private transient PropertyChangeListener colorListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            PlotStylePanel.this.checkColors();
        }
    };
    private JButton backgroundColorButton;
    private JCheckBox fittedCB;
    private JLabel fontLabel;
    private JComboBox foreBackColorsList;
    private JButton foregroundColorButton;
    private JLabel heightLabel;
    private JFormattedTextField heightTextField;
    private JLabel jLabel1;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel7;
    private JSplitPane jSplitPane2;
    private JCheckBox majorTicksCheckBox;
    private JCheckBox minorGridCheckBox;
    private JButton pickFontButton;
    private JPanel plotPanel;
    private JPanel stylePanel;
    private JLabel widthLabel;
    private JFormattedTextField widthTextField;

    public PlotStylePanel(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        this.dom = applicationModel.getDocumentModel();
        this.dom.getController().addPropertyChangeListener("plotElement", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                PlotStylePanel.this.doElementBindings();
            }
        });
        this.initComponents();
        this.validate();
        Runnable run = new Runnable(){

            public void run() {
                PlotStylePanel.this.doOptionsBindings();
                PlotStylePanel.this.doElementBindings();
                String ff = PlotStylePanel.this.dom.getController().getCanvas().getFont();
                PlotStylePanel.this.fontLabel.setText(ff);
                DasCanvas c = PlotStylePanel.this.dom.getController().getDasCanvas();
                int index = 3;
                for (int i = 0; i < fores.length; ++i) {
                    if (!fores[i].equals(c.getForeground()) || !backs[i].equals(c.getBackground())) continue;
                    index = i;
                }
                PlotStylePanel.this.foreBackColorsList.setSelectedIndex(index);
            }
        };
        SwingUtilities.invokeLater(run);
        AutoplotHelpSystem.getHelpSystem().registerHelpID((Component)this.plotPanel, "stylePanel");
    }

    private synchronized void doOptionsBindings() {
        BindingGroup bc = new BindingGroup();
        AutoBinding b = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.dom.getOptions(), (Property)BeanProperty.create((String)"drawGrid"), (Object)this.majorTicksCheckBox, (Property)BeanProperty.create((String)"selected"));
        bc.addBinding((Binding)b);
        b = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.dom.getOptions(), (Property)BeanProperty.create((String)"drawMinorGrid"), (Object)this.minorGridCheckBox, (Property)BeanProperty.create((String)"selected"));
        bc.addBinding((Binding)b);
        Converter colorIconConverter = new Converter(){

            public Object convertForward(Object s) {
                return GraphUtil.colorIcon((Color)((Color)s), (int)16, (int)16);
            }

            public Object convertReverse(Object t) {
                return Color.RED;
            }
        };
        b = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.dom.getOptions(), (Property)BeanProperty.create((String)"foreground"), (Object)this.foregroundColorButton, (Property)BeanProperty.create((String)"icon"));
        b.setConverter(colorIconConverter);
        bc.addBinding((Binding)b);
        b = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.dom.getOptions(), (Property)BeanProperty.create((String)"background"), (Object)this.backgroundColorButton, (Property)BeanProperty.create((String)"icon"));
        b.setConverter(colorIconConverter);
        bc.addBinding((Binding)b);
        b = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.dom.getCanvases(0), (Property)BeanProperty.create((String)"font"), (Object)this.fontLabel, (Property)BeanProperty.create((String)"text"));
        bc.addBinding((Binding)b);
        b = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.dom.getCanvases(0), (Property)BeanProperty.create((String)"fitted"), (Object)this.fittedCB, (Property)BeanProperty.create((String)"selected"));
        bc.addBinding((Binding)b);
        b = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.dom.getCanvases(0), (Property)BeanProperty.create((String)"height"), (Object)this.heightTextField, (Property)BeanProperty.create((String)"text_ON_ACTION_OR_FOCUS_LOST"));
        bc.addBinding((Binding)b);
        b = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.dom.getCanvases(0), (Property)BeanProperty.create((String)"width"), (Object)this.widthTextField, (Property)BeanProperty.create((String)"text_ON_ACTION_OR_FOCUS_LOST"));
        bc.addBinding((Binding)b);
        bc.bind();
    }

    private synchronized void doElementBindings() {
        PlotElement element;
        if (this.currentElement != null) {
            this.currentElement.getStyle().removePropertyChangeListener("color", this.colorListener);
            this.currentElement.removePropertyChangeListener("renderType", this.renderTypeListener);
        }
        if ((element = this.dom.getController().getPlotElement()) == null) {
            return;
        }
        if (this.stylePanel.getComponentCount() == 1) {
            this.stylePanel.remove(this.stylePanel.getComponent(0));
        }
        JPanel editorPanel = null;
        editorPanel = element.getRenderType() == RenderType.spectrogram || element.getRenderType() == RenderType.nnSpectrogram ? new SpectrogramStylePanel(this.applicationModel) : (element.getRenderType() == RenderType.hugeScatter ? new HugeScatterStylePanel(this.applicationModel) : (element.getRenderType() == RenderType.colorScatter ? new ColorScatterStylePanel(this.applicationModel) : new SeriesStylePanel(this.applicationModel)));
        editorPanel.doElementBindings(element);
        this.stylePanel.add((Component)editorPanel, "Center");
        element.addPropertyChangeListener("renderType", this.renderTypeListener);
        element.getStyle().addPropertyChangeListener("color", this.colorListener);
        this.currentElement = element;
        this.repaint();
        this.validate();
        AutoplotHelpSystem.getHelpSystem().registerHelpID((Component)this, "stylePanel");
    }

    private static boolean closeColors(Color cA, Color cB) {
        if (cA.equals(cB)) {
            return true;
        }
        float[] colorA = new float[]{cA.getRed(), cA.getGreen(), cA.getBlue()};
        float[] colorB = new float[]{cB.getRed(), cB.getGreen(), cB.getBlue()};
        double dist = Math.sqrt(Math.pow(colorA[0] - colorB[0], 2.0) + Math.pow(colorA[1] - colorB[1], 2.0) + Math.pow(colorA[2] - colorB[2], 2.0));
        return dist < 5.0;
    }

    private void checkColors() {
        Color back = this.dom.getOptions().getBackground();
        Color fore = this.dom.getOptions().getForeground();
        Color color = this.dom.getOptions().getColor();
        if (PlotStylePanel.closeColors(fore, back)) {
            fore = back.getRed() < 128 ? Color.WHITE : Color.BLACK;
            this.dom.getOptions().setForeground(fore);
        }
        if (PlotStylePanel.closeColors(color, back)) {
            color = back.getRed() < 128 ? Color.WHITE : Color.BLACK;
            this.dom.getOptions().setColor(color);
        }
        List<PlotElement> pe = Arrays.asList(this.dom.getPlotElements());
        for (PlotElement p : pe) {
            System.err.printf("%s %s\n", p.getStyle().getColor(), this.dom.getCanvases(0).getController().getDasCanvas().getForeground());
            if (!PlotStylePanel.closeColors(p.getStyle().getColor(), back)) continue;
            final PlotElement pf = p;
            final Color colorf = color;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    pf.getStyle().setColor(colorf);
                }
            });
        }
    }

    private void initComponents() {
        this.jSplitPane2 = new JSplitPane();
        this.stylePanel = new JPanel();
        this.plotPanel = new JPanel();
        this.majorTicksCheckBox = new JCheckBox();
        this.jLabel12 = new JLabel();
        this.minorGridCheckBox = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.foreBackColorsList = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.foregroundColorButton = new JButton();
        this.backgroundColorButton = new JButton();
        this.fontLabel = new JLabel();
        this.jLabel4 = new JLabel();
        this.pickFontButton = new JButton();
        this.widthLabel = new JLabel();
        this.widthTextField = new JFormattedTextField();
        this.heightTextField = new JFormattedTextField();
        this.heightLabel = new JLabel();
        this.jLabel7 = new JLabel();
        this.fittedCB = new JCheckBox();
        this.setPreferredSize(new Dimension(688, 300));
        this.jSplitPane2.setLastDividerLocation(300);
        this.stylePanel.setMinimumSize(new Dimension(300, 300));
        this.stylePanel.setLayout(new BorderLayout());
        this.jSplitPane2.setLeftComponent(this.stylePanel);
        this.plotPanel.setBorder(BorderFactory.createTitledBorder("Canvas [?]"));
        this.majorTicksCheckBox.setText("major ticks");
        this.majorTicksCheckBox.setToolTipText("Draw grid lines at major ticks ");
        this.jLabel12.setText("Grid:");
        this.minorGridCheckBox.setText("minor ticks");
        this.minorGridCheckBox.setToolTipText("Draw grid lines at minor ticks ");
        this.jLabel1.setText("Fore/Back Colors:");
        this.foreBackColorsList.setModel(new DefaultComboBoxModel<String>(new String[]{"black on white", "white on black", "white on blue", "custom"}));
        this.foreBackColorsList.setToolTipText("Set foreground and background colors");
        this.foreBackColorsList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotStylePanel.this.foreBackColorsListActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Background:");
        this.jLabel2.setText("Foreground:");
        this.foregroundColorButton.setToolTipText("Pick foreground color");
        this.foregroundColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotStylePanel.this.foregroundColorButtonActionPerformed(evt);
            }
        });
        this.backgroundColorButton.setToolTipText("Pick background color");
        this.backgroundColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotStylePanel.this.backgroundColorButtonActionPerformed(evt);
            }
        });
        this.fontLabel.setText("jLabel5");
        this.jLabel4.setText("Canvas Font:");
        this.pickFontButton.setText("Pick");
        this.pickFontButton.setToolTipText("Pick canvas font");
        this.pickFontButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotStylePanel.this.pickFontButtonActionPerformed(evt);
            }
        });
        this.widthLabel.setText("Width:");
        this.widthLabel.setEnabled(false);
        this.widthTextField.setText("100");
        this.widthTextField.setToolTipText("width of fixed size canvas in pixels");
        this.widthTextField.setEnabled(false);
        this.widthTextField.setFocusLostBehavior(0);
        this.heightTextField.setText("100");
        this.heightTextField.setToolTipText("height of fixed size canvas in pixels");
        this.heightTextField.setEnabled(false);
        this.heightTextField.setFocusLostBehavior(0);
        this.heightLabel.setText("Height:");
        this.heightLabel.setEnabled(false);
        this.jLabel7.setText("Canvas Size:");
        this.fittedCB.setText("Adjust to Fit into Application");
        this.fittedCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotStylePanel.this.fittedCBActionPerformed(evt);
            }
        });
        GroupLayout plotPanelLayout = new GroupLayout((Container)this.plotPanel);
        this.plotPanel.setLayout((LayoutManager)plotPanelLayout);
        plotPanelLayout.setHorizontalGroup((GroupLayout.Group)plotPanelLayout.createParallelGroup(1).add((GroupLayout.Group)plotPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)plotPanelLayout.createParallelGroup(1).add((GroupLayout.Group)plotPanelLayout.createSequentialGroup().add((Component)this.jLabel12).addPreferredGap(0).add((Component)this.majorTicksCheckBox).addPreferredGap(0).add((Component)this.minorGridCheckBox)).add((GroupLayout.Group)plotPanelLayout.createSequentialGroup().add((GroupLayout.Group)plotPanelLayout.createParallelGroup(1).add((GroupLayout.Group)plotPanelLayout.createSequentialGroup().add(10, 10, 10).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.foregroundColorButton, -2, 30, -2)).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)plotPanelLayout.createParallelGroup(1).add((GroupLayout.Group)plotPanelLayout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.backgroundColorButton, -2, 28, -2)).add((Component)this.foreBackColorsList, -2, 173, -2))).add((GroupLayout.Group)plotPanelLayout.createSequentialGroup().add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.fontLabel, -2, 191, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.pickFontButton)).add((GroupLayout.Group)plotPanelLayout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)plotPanelLayout.createParallelGroup(1).add((Component)this.widthLabel).add((Component)this.heightLabel)).add((GroupLayout.Group)plotPanelLayout.createParallelGroup(1, false).add((GroupLayout.Group)plotPanelLayout.createSequentialGroup().addPreferredGap(0).add((Component)this.heightTextField, -1, 63, Short.MAX_VALUE)).add((GroupLayout.Group)plotPanelLayout.createSequentialGroup().add(12, 12, 12).add((Component)this.widthTextField)))).add((GroupLayout.Group)plotPanelLayout.createSequentialGroup().add((Component)this.jLabel7).addPreferredGap(0).add((Component)this.fittedCB, -1, 235, Short.MAX_VALUE))).add(12, 12, 12)));
        plotPanelLayout.linkSize(new Component[]{this.backgroundColorButton, this.foregroundColorButton}, 1);
        plotPanelLayout.setVerticalGroup((GroupLayout.Group)plotPanelLayout.createParallelGroup(1).add((GroupLayout.Group)plotPanelLayout.createSequentialGroup().add((GroupLayout.Group)plotPanelLayout.createParallelGroup(3).add((Component)this.majorTicksCheckBox).add((Component)this.jLabel12).add((Component)this.minorGridCheckBox)).add(18, 18, 18).add((GroupLayout.Group)plotPanelLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.foreBackColorsList, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)plotPanelLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jLabel3).add((Component)this.backgroundColorButton, -2, 23, -2).add((Component)this.foregroundColorButton, -2, 23, -2)).addPreferredGap(1).add((GroupLayout.Group)plotPanelLayout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.fontLabel).add((Component)this.pickFontButton)).add(18, 18, 18).add((GroupLayout.Group)plotPanelLayout.createParallelGroup(3).add((Component)this.jLabel7).add((Component)this.fittedCB)).addPreferredGap(0).add((GroupLayout.Group)plotPanelLayout.createParallelGroup(3).add((Component)this.widthLabel).add((Component)this.widthTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)plotPanelLayout.createParallelGroup(3).add((Component)this.heightLabel).add((Component)this.heightTextField, -2, -1, -2)).addContainerGap(30, Short.MAX_VALUE)));
        this.jSplitPane2.setRightComponent(this.plotPanel);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSplitPane2, -1, 671, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSplitPane2, -1, 300, Short.MAX_VALUE));
    }

    private void foreBackColorsListActionPerformed(ActionEvent evt) {
        int i = this.foreBackColorsList.getSelectedIndex();
        if (i < fores.length) {
            this.foregroundColorButton.setIcon(GraphUtil.colorIcon((Color)fores[i], (int)16, (int)16));
            this.backgroundColorButton.setIcon(GraphUtil.colorIcon((Color)backs[i], (int)16, (int)16));
            List<PlotElement> pe = Arrays.asList(this.dom.getPlotElements());
            for (PlotElement p : pe) {
                if (!p.getStyle().getColor().equals(this.dom.getCanvases(0).getController().getDasCanvas().getForeground())) continue;
                p.getStyle().setColor(fores[i]);
            }
            this.dom.getOptions().setForeground(fores[i]);
            this.dom.getOptions().setColor(fores[i]);
            this.dom.getOptions().setBackground(backs[i]);
        }
        this.checkColors();
    }

    private void foregroundColorButtonActionPerformed(ActionEvent evt) {
        Color c = JColorChooser.showDialog(this, "Foreground Color", this.foregroundColorButton.getBackground());
        if (c != null) {
            this.foreBackColorsList.setSelectedIndex(fores.length);
            List<PlotElement> pe = Arrays.asList(this.dom.getPlotElements());
            for (PlotElement p : pe) {
                if (!p.getStyle().getColor().equals(this.dom.getOptions().getForeground())) continue;
                p.getStyle().setColor(c);
            }
            this.foregroundColorButton.setIcon(GraphUtil.colorIcon((Color)c, (int)16, (int)16));
            this.dom.getCanvases(0).getController().getDasCanvas().setForeground(c);
            this.dom.getOptions().setForeground(c);
            this.dom.getOptions().setColor(c);
            this.checkColors();
        }
    }

    private void backgroundColorButtonActionPerformed(ActionEvent evt) {
        Color c = JColorChooser.showDialog(this, "Background Color", this.backgroundColorButton.getBackground());
        if (c != null) {
            this.foreBackColorsList.setSelectedIndex(fores.length);
            this.backgroundColorButton.setIcon(GraphUtil.colorIcon((Color)c, (int)16, (int)16));
            this.dom.getOptions().setBackground(c);
            this.checkColors();
        }
    }

    private void pickFontButtonActionPerformed(ActionEvent evt) {
        Font f = GuiSupport.pickFont((JFrame)SwingUtilities.getWindowAncestor(this), this.applicationModel);
        if (f != null) {
            this.fontLabel.setText(DomUtil.encodeFont(f));
        }
    }

    private void fittedCBActionPerformed(ActionEvent evt) {
        boolean s = !this.fittedCB.isSelected();
        this.widthTextField.setEnabled(s);
        this.heightTextField.setEnabled(s);
        this.widthLabel.setEnabled(s);
        this.heightLabel.setEnabled(s);
    }

    static interface StylePanel {
        public void doElementBindings(PlotElement var1);
    }
}

