/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Scanner;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.TimeParser;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.jdesktop.layout.GroupLayout;
import org.virbo.datasource.AutoplotSettings;

public class RecentUrisGUI
extends JPanel {
    String selectedURI = null;
    boolean empty = false;
    private String filter;
    private JScrollPane jScrollPane1;
    private JTree jTree1;

    public RecentUrisGUI() {
        Object child;
        this.initComponents();
        this.jTree1.setModel(new MyTreeModel());
        this.jTree1.setCellRenderer(new MyCellRenderer());
        Object r = this.jTree1.getModel().getRoot();
        int c = 0;
        int SHOW_URIS = 30;
        TreeModel jt = this.jTree1.getModel();
        for (int i = 0; i < jt.getChildCount(jt.getRoot()) && c < 30; c += jt.getChildCount(child), ++i) {
            child = jt.getChild(r, i);
            this.jTree1.expandPath(new TreePath(new Object[]{r, child}));
        }
        this.jTree1.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                Object o = e.getPath().getLastPathComponent();
                if (o instanceof String[]) {
                    String[] pp = (String[])o;
                    RecentUrisGUI.this.selectedURI = pp[1];
                }
            }
        });
    }

    public String getSelectedURI() {
        return this.selectedURI;
    }

    public static void main(String[] args) {
        RecentUrisGUI t = new RecentUrisGUI();
        int i = JOptionPane.showConfirmDialog(null, t);
        if (i == 0) {
            System.err.println(t.getSelectedURI());
        }
    }

    void setFilter(String filter) {
        this.filter = filter;
        this.update();
    }

    private void update() {
        Object child;
        this.jTree1.setModel(new MyTreeModel());
        Object r = this.jTree1.getModel().getRoot();
        int c = 0;
        int SHOW_URIS = 30;
        TreeModel jt = this.jTree1.getModel();
        for (int i = 0; i < jt.getChildCount(jt.getRoot()) && c < 30; c += jt.getChildCount(child), ++i) {
            child = jt.getChild(r, i);
            this.jTree1.expandPath(new TreePath(new Object[]{r, child}));
        }
    }

    private static boolean containsIgnoreCase(String xXx, String xx) {
        return xXx.toLowerCase().contains(xx);
    }

    protected JTree getTree() {
        return this.jTree1;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jTree1.setRootVisible(false);
        this.jScrollPane1.setViewportView(this.jTree1);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 300, Short.MAX_VALUE));
    }

    final class MyTreeModel
    implements TreeModel {
        private final Object root = new Object();
        private TreeMap<Datum, String[]> uris;
        private DatumRange[] list;
        private boolean[] skip;

        MyTreeModel() {
            try {
                boolean ok;
                Datum now = TimeUtil.now();
                this.list = new DatumRange[8];
                this.list[0] = new DatumRange(TimeUtil.prevMidnight((Datum)now), TimeUtil.nextMidnight((Datum)now));
                this.list[1] = this.list[0].previous();
                this.list[2] = new DatumRange(TimeUtil.prevWeek((Datum)this.list[1].min()), this.list[1].min());
                this.list[3] = new DatumRange(TimeUtil.prev((int)2, (Datum)this.list[2].min()), this.list[2].min());
                this.list[4] = new DatumRange(TimeUtil.prev((int)98, (Datum)this.list[3].min()), this.list[3].min());
                this.list[5] = new DatumRange(TimeUtil.prev((int)98, (Datum)this.list[4].min()), this.list[4].min());
                this.list[6] = new DatumRange(TimeUtil.prev((int)99, (Datum)this.list[5].min()), this.list[5].min());
                this.list[7] = new DatumRange(Datum.create((int)0, (Units)Units.t1970), this.list[6].min());
                File f2 = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "bookmarks/");
                if (!f2.exists() && !(ok = f2.mkdirs())) {
                    throw new RuntimeException("unable to create folder " + f2);
                }
                this.uris = new TreeMap();
                TimeParser tp = TimeParser.create((String)"%Y-%m-%dT%H:%M:%S.%{milli}Z");
                LinkedHashMap<String, String> daysURIs = new LinkedHashMap<String, String>();
                String filt = RecentUrisGUI.this.filter;
                if (filt != null && filt.length() == 0) {
                    filt = null;
                }
                if (filt != null) {
                    filt = filt.toLowerCase();
                }
                long tzOffsetMs = Calendar.getInstance().getTimeZone().getRawOffset();
                String midnight = tp.format(Units.t1970.createDatum(0).subtract((double)tzOffsetMs, Units.milliseconds), null);
                File f3 = new File(f2, "history.txt");
                if (f3.exists() && f3.canRead()) {
                    Scanner scan = new Scanner(f3);
                    while (scan.hasNextLine()) {
                        String line = scan.nextLine();
                        String[] ss = line.split("\\s+", 2);
                        if (ss.length < 2) continue;
                        try {
                            if (filt != null && !RecentUrisGUI.containsIgnoreCase(ss[1], filt)) continue;
                            if (ss[0].compareTo(midnight) > 0 || !scan.hasNextLine()) {
                                if (!scan.hasNextLine()) {
                                    daysURIs.remove(ss[1]);
                                    daysURIs.put(ss[1], ss[0]);
                                }
                                Datum tlocal = null;
                                for (String uri : daysURIs.keySet()) {
                                    tlocal = tp.parse((String)daysURIs.get(uri)).getTimeDatum().add((double)tzOffsetMs, Units.milliseconds);
                                    this.uris.put(tlocal, new String[]{tp.format(tlocal, null), uri});
                                }
                                daysURIs = new LinkedHashMap();
                                if (tlocal == null) {
                                    tlocal = tp.parse(ss[0]).getTimeDatum().add((double)tzOffsetMs, Units.milliseconds);
                                }
                                midnight = tp.format(TimeUtil.nextMidnight(tlocal).subtract((double)tzOffsetMs, Units.milliseconds), null);
                            }
                            daysURIs.remove(ss[1]);
                            daysURIs.put(ss[1], ss[0]);
                        }
                        catch (ParseException ex) {
                            Logger.getLogger(RecentUrisGUI.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
                this.skip = new boolean[8];
                int newListLen = this.list.length;
                for (int i = 0; i < this.list.length; ++i) {
                    if (this.getChildCount(this.list[i]) == 0) {
                        this.skip[i] = true;
                        --newListLen;
                        continue;
                    }
                    this.skip[i] = false;
                }
                if (newListLen == 0) {
                    RecentUrisGUI.this.empty = true;
                    newListLen = 1;
                    this.skip[0] = false;
                } else {
                    RecentUrisGUI.this.empty = false;
                }
                DatumRange[] newlist = new DatumRange[newListLen];
                int j = 0;
                for (int i = 0; i < this.list.length; ++i) {
                    if (this.skip[i]) continue;
                    newlist[j] = this.list[i];
                    ++j;
                }
                this.list = newlist;
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(RecentUrisGUI.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        public Object getRoot() {
            return this.root;
        }

        public Object getChild(Object parent, int index) {
            if (parent == this.root) {
                if (RecentUrisGUI.this.empty) {
                    return "no items in history";
                }
                return this.list[index];
            }
            if (parent instanceof DatumRange) {
                DatumRange range = (DatumRange)parent;
                SortedMap<Datum, String[]> submap = this.uris.subMap(range.min(), range.max());
                Iterator<String[]> i = submap.values().iterator();
                for (int j = submap.size() - 1; j > index; --j) {
                    i.next();
                }
                return i.next();
            }
            return new IndexOutOfBoundsException("no child at index=" + index);
        }

        public int getChildCount(Object parent) {
            if (parent == this.root) {
                return this.list.length;
            }
            if (parent instanceof DatumRange) {
                DatumRange range = (DatumRange)parent;
                SortedMap<Datum, String[]> submap = this.uris.subMap(range.min(), range.max());
                return submap.size();
            }
            return 0;
        }

        public boolean isLeaf(Object node) {
            return node instanceof String[] || this.getChildCount(node) == 0;
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        public int getIndexOfChild(Object parent, Object child) {
            for (int i = 0; i < this.getChildCount(parent); ++i) {
                if (this.getChild(parent, i) != child) continue;
                return i;
            }
            return -1;
        }

        public void addTreeModelListener(TreeModelListener l) {
        }

        public void removeTreeModelListener(TreeModelListener l) {
        }
    }

    class MyCellRenderer
    extends DefaultTreeCellRenderer {
        MyCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof String[]) {
                value = ((String[])value)[1];
            } else if (value instanceof DatumRange) {
                int count = tree.getModel().getChildCount(value);
                value = String.format("%s (%d)", value, count);
            }
            return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        }
    }
}

