/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot;

import java.awt.Component;
import java.awt.Image;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.das2.DasApplication;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetAdapter;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableUtil;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorUtil;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.TimeParser;
import org.das2.fsm.FileStorageModelNew;
import org.das2.graph.DasCanvas;
import org.das2.util.DasPNGEncoder;
import org.das2.util.awt.GraphicsOutput;
import org.das2.util.awt.PdfGraphicsOutput;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.python.core.PyJavaInstance;
import org.virbo.aggregator.AggregatingDataSourceFactory;
import org.virbo.autoplot.ApplicationModel;
import org.virbo.autoplot.AutoplotUI;
import org.virbo.autoplot.RenderType;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.DataSourceFilter;
import org.virbo.autoplot.dom.Plot;
import org.virbo.autoplot.dom.PlotElement;
import org.virbo.autoplot.scriptconsole.ExitExceptionHandler;
import org.virbo.dataset.ArrayDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSourceFormat;
import org.virbo.datasource.URISplit;
import org.virbo.qstream.SimpleStreamFormatter;
import org.virbo.qstream.StreamException;

public class ScriptContext
extends PyJavaInstance {
    private static ApplicationModel model = null;
    private static Application dom = null;
    private static AutoplotUI view = null;
    private static OutputStream out = System.out;

    private static synchronized void maybeInitModel() {
        if (model == null) {
            model = new ApplicationModel();
            model.setExceptionHandler(new ExitExceptionHandler());
            model.addDasPeersToApp();
            dom = model.getDocumentModel();
        }
    }

    protected static void setApplicationModel(ApplicationModel m) {
        model = m;
        dom = m.getDocumentModel();
    }

    private static synchronized void maybeInitView() {
        ScriptContext.maybeInitModel();
        if (view == null) {
            view = new AutoplotUI(model);
            view.setVisible(true);
        }
    }

    protected static void setView(AutoplotUI v) {
        view = v;
    }

    public static Window getViewWindow() {
        return view;
    }

    public static void _setOutputStream(OutputStream out) {
        ScriptContext.out = out;
    }

    public static void setCanvasSize(int width, int height) throws InterruptedException {
        ScriptContext.maybeInitModel();
        ScriptContext.model.canvas.setSize(width, height);
        model.getDocumentModel().getCanvases(0).setWidth(width);
        model.getDocumentModel().getCanvases(0).setHeight(height);
        model.waitUntilIdle(false);
    }

    public static void setDataSourceURL(String surl) throws InterruptedException {
        model.setDataSourceURL(surl);
        model.waitUntilIdle(false);
    }

    public static void plot(String suri) throws InterruptedException {
        ScriptContext.maybeInitModel();
        if (view != null) {
            ScriptContext.view.dataSetSelector.setValue(suri);
        }
        model.resetDataSetSourceURL(suri, (ProgressMonitor)new NullProgressMonitor());
        model.waitUntilIdle(false);
    }

    public static void plot(String surl1, String surl2) throws InterruptedException {
        ScriptContext.maybeInitModel();
        if (surl1.endsWith(".vap") || surl1.contains(".vap?")) {
            throw new IllegalArgumentException("cannot load vap here in two-argument plot");
        }
        DataSourceFilter dsf = model.getDocumentModel().getDataSourceFilters(0);
        List<PlotElement> pes = dom.getController().getPlotElementsFor(dsf);
        PlotElement pe = pes.size() > 0 ? pes.get(0) : null;
        Plot p = pe == null ? dom.getPlots(0) : dom.getController().getPlotFor(pe);
        dom.getController().doplot(p, pe, surl1, surl2);
        model.waitUntilIdle(false);
    }

    public static void plot(int chNum, String surl) throws InterruptedException {
        ScriptContext.maybeInitModel();
        model.setDataSet(chNum, null, surl);
        model.waitUntilIdle(false);
    }

    public static void plot(int chNum, String label, String surl) throws InterruptedException {
        ScriptContext.maybeInitModel();
        model.setDataSet(chNum, label, surl);
        model.waitUntilIdle(false);
    }

    public static void plot(QDataSet ds) throws InterruptedException {
        ScriptContext.plot(0, (String)null, ds);
    }

    public static void plot(QDataSet x, QDataSet y) throws InterruptedException {
        ScriptContext.plot(0, (String)null, x, y);
    }

    public static void plot(QDataSet x, QDataSet y, QDataSet z) throws InterruptedException {
        ScriptContext.plot(0, null, x, y, z);
    }

    public static void plot(int chNum, QDataSet ds) throws InterruptedException {
        ScriptContext.plot(chNum, (String)null, ds);
    }

    public static void plot(int chNum, QDataSet x, QDataSet y) throws InterruptedException {
        ScriptContext.plot(chNum, (String)null, x, y);
    }

    public static void plot(int chNum, QDataSet x, QDataSet y, QDataSet z) throws InterruptedException {
        ScriptContext.plot(chNum, null, x, y, z);
    }

    public static void plot(int chNum, String label, QDataSet ds) throws InterruptedException {
        ScriptContext.maybeInitModel();
        model.setDataSet(chNum, label, ds);
        model.waitUntilIdle(false);
    }

    public static void plot(int chNum, String label, QDataSet x, QDataSet y) throws InterruptedException {
        ScriptContext.maybeInitModel();
        ArrayDataSet yds = ArrayDataSet.copy((QDataSet)y);
        if (x != null) {
            yds.putProperty("DEPEND_0", (Object)x);
        }
        model.setDataSet(chNum, label, (QDataSet)yds);
        model.waitUntilIdle(false);
    }

    public static void plot(int chNum, String label, QDataSet x, QDataSet y, QDataSet z) throws InterruptedException {
        ScriptContext.maybeInitModel();
        if (z.rank() == 1) {
            ArrayDataSet yds = ArrayDataSet.copy((QDataSet)y);
            yds.putProperty("DEPEND_0", (Object)x);
            yds.putProperty("PLANE_0", (Object)z);
            model.setDataSet(chNum, label, (QDataSet)yds);
        } else {
            ArrayDataSet zds = ArrayDataSet.copy((QDataSet)z);
            if (x != null) {
                zds.putProperty("DEPEND_0", (Object)x);
            }
            if (y != null) {
                zds.putProperty("DEPEND_1", (Object)y);
            }
            model.setDataSet(chNum, label, (QDataSet)zds);
        }
        model.waitUntilIdle(false);
    }

    public static void setStatus(String message) {
        dom.getController().setStatus(message);
    }

    public static void addTab(String label, JComponent c) {
        ScriptContext.maybeInitView();
        int n = view.getTabs().getComponentCount();
        for (int i = 0; i < n; ++i) {
            String titleAt = view.getTabs().getTitleAt(i);
            if (!titleAt.equals(label) && !titleAt.equals("(" + label + ")")) continue;
            view.getTabs().remove(i);
            break;
        }
        view.getTabs().add(label, (Component)c);
    }

    public static void setRenderStyle(String name) {
        dom.getController().getPlotElement().setRenderType(RenderType.valueOf(name));
    }

    public static void writeToPng(String filename) throws InterruptedException, IOException {
        if (!filename.endsWith(".png") && !filename.endsWith(".PNG")) {
            filename = filename + ".png";
        }
        model.waitUntilIdle(false);
        int width = model.getDocumentModel().getCanvases(0).getWidth();
        int height = model.getDocumentModel().getCanvases(0).getHeight();
        ScriptContext.writeToPng(filename, width, height);
        ScriptContext.setStatus("wrote to " + filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToPng(String filename, int width, int height) throws InterruptedException, IOException {
        if (!filename.endsWith(".png") && !filename.endsWith(".PNG")) {
            filename = filename + ".png";
        }
        FileOutputStream out1 = new FileOutputStream(filename);
        Image image = ScriptContext.model.canvas.getImage(width, height);
        DasPNGEncoder encoder = new DasPNGEncoder();
        encoder.addText("Creation Time", new Date().toString());
        try {
            encoder.write((BufferedImage)image, (OutputStream)out1);
        }
        catch (IOException ioe) {
            try {
                out1.close();
            }
            catch (IOException ioe2) {
                throw new RuntimeException(ioe2);
            }
        }
        finally {
            try {
                out1.close();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToPng(BufferedImage image, String filename) throws IOException {
        FileOutputStream out1 = new FileOutputStream(filename);
        DasPNGEncoder encoder = new DasPNGEncoder();
        encoder.addText("Creation Time", new Date().toString());
        try {
            encoder.write(image, (OutputStream)out1);
        }
        catch (IOException ioe) {
            try {
                out1.close();
            }
            catch (IOException ioe2) {
                throw new RuntimeException(ioe2);
            }
        }
        finally {
            try {
                out1.close();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    public static void peekAt(Object o) throws IOException {
        out.write(o.toString().getBytes());
    }

    public static void writeToPng(OutputStream out) throws InterruptedException, IOException {
        model.waitUntilIdle(false);
        DasCanvas c = model.getCanvas();
        int width = model.getDocumentModel().getCanvases(0).getWidth();
        int height = model.getDocumentModel().getCanvases(0).getHeight();
        Image image = c.getImage(width, height);
        DasPNGEncoder encoder = new DasPNGEncoder();
        encoder.addText("Creation Time", new Date().toString());
        encoder.write((BufferedImage)image, out);
    }

    public static void writeToPdf(String filename) throws InterruptedException, IOException {
        if (!filename.endsWith(".pdf") && !filename.endsWith(".PDF")) {
            filename = filename + ".pdf";
        }
        model.waitUntilIdle(false);
        int width = model.getDocumentModel().getCanvases(0).getWidth();
        int height = model.getDocumentModel().getCanvases(0).getHeight();
        model.getCanvas().setSize(width, height);
        model.getCanvas().validate();
        model.waitUntilIdle(false);
        model.getCanvas().writeToPDF(filename);
        ScriptContext.setStatus("wrote to " + filename);
    }

    public static void writeToPdf(OutputStream out) throws InterruptedException, IOException, IllegalAccessException {
        model.waitUntilIdle(false);
        int width = model.getDocumentModel().getCanvases(0).getWidth();
        int height = model.getDocumentModel().getCanvases(0).getHeight();
        model.getCanvas().setSize(width, height);
        model.getCanvas().validate();
        model.waitUntilIdle(false);
        model.getCanvas().writeToGraphicsOutput(out, (GraphicsOutput)new PdfGraphicsOutput());
    }

    public static BufferedImage writeToBufferedImage(Application applicationIn) {
        ApplicationModel appmodel = new ApplicationModel();
        appmodel.addDasPeersToApp();
        appmodel.getDocumentModel().syncTo(applicationIn);
        int height = applicationIn.getCanvases(0).getHeight();
        int width = applicationIn.getCanvases(0).getWidth();
        BufferedImage image = (BufferedImage)appmodel.getCanvas().getImage(width, height);
        return image;
    }

    public static BufferedImage writeToBufferedImage() throws InterruptedException {
        model.waitUntilIdle(false);
        int height = model.getDocumentModel().getCanvases(0).getHeight();
        int width = model.getDocumentModel().getCanvases(0).getWidth();
        BufferedImage image = (BufferedImage)model.getDocumentModel().getCanvases(0).getController().getDasCanvas().getImage(width, height);
        return image;
    }

    public static String[] getTimeRangesFor(String surl, String timeRange, String format) throws IOException, ParseException {
        DatumRange dr = DatumRangeUtil.parseTimeRange((String)timeRange);
        FileStorageModelNew fsm = AggregatingDataSourceFactory.getFileStorageModel((String)surl);
        TimeParser tf = TimeParser.create((String)format);
        String[] ss = fsm.getNamesFor(dr);
        String[] result = new String[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            DatumRange dr2 = fsm.getRangeFor(ss[i]);
            result[i] = tf.format(dr2.min(), dr2.max());
        }
        return result;
    }

    public static String[] generateTimeRanges(String spec, String srange) throws ParseException {
        TimeParser tp = TimeParser.create((String)spec);
        DatumRange range = DatumRangeUtil.parseTimeRange((String)srange);
        String sstart = tp.format(range.min(), null);
        tp.parse(sstart);
        DatumRange curr = tp.getTimeRange();
        ArrayList<String> result = new ArrayList<String>();
        while (range.intersects(curr)) {
            String scurr = tp.format(curr.min(), curr.max());
            result.add(scurr);
            curr = curr.next();
        }
        return result.toArray(new String[result.size()]);
    }

    public static void setTitle(String title) {
        model.getDocumentModel().getController().getPlot().setTitle(title);
    }

    public static void createGui() {
        ScriptContext.maybeInitView();
    }

    public static ApplicationModel getApplicationModel() {
        ScriptContext.maybeInitModel();
        return model;
    }

    public static boolean isModelInitialized() {
        return model != null;
    }

    public static void bind(Object src, String srcProp, Object dst, String dstProp) {
        if (DasApplication.hasAllPermission()) {
            BeanProperty srcbp = BeanProperty.create((String)srcProp);
            Object value = srcbp.getValue(src);
            if (value == null) {
                System.err.println("warning: src property " + srcProp + " of " + src + " is null");
            }
            BeanProperty dstbp = BeanProperty.create((String)dstProp);
            dstbp.setValue(dst, value);
            dstbp.getValue(dst);
            AutoBinding b = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)src, (Property)srcbp, (Object)dst, (Property)dstbp);
            b.bind();
        } else {
            System.err.println("bindings disabled in applet environment");
        }
    }

    public static void dumpToQStream(QDataSet ds, OutputStream out, boolean ascii) throws IOException {
        try {
            SimpleStreamFormatter f = new SimpleStreamFormatter();
            f.format(ds, out, ascii);
        }
        catch (StreamException ex) {
            Logger.getLogger(ScriptContext.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void dumpToDas2Stream(QDataSet ds, boolean ascii) {
        try {
            ByteArrayOutputStream bufout = new ByteArrayOutputStream(10000);
            DataSet lds = DataSetAdapter.createLegacyDataSet((QDataSet)ds);
            if (ascii) {
                if (lds instanceof TableDataSet) {
                    TableUtil.dumpToAsciiStream((TableDataSet)((TableDataSet)lds), (OutputStream)bufout);
                } else {
                    VectorUtil.dumpToAsciiStream((VectorDataSet)((VectorDataSet)lds), (OutputStream)bufout);
                }
            } else if (lds instanceof TableDataSet) {
                TableUtil.dumpToBinaryStream((TableDataSet)((TableDataSet)lds), (OutputStream)bufout);
            } else {
                VectorUtil.dumpToBinaryStream((VectorDataSet)((VectorDataSet)lds), (OutputStream)bufout);
            }
            out.write(bufout.toByteArray());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void dumpToDas2Stream(QDataSet ds, String file, boolean ascii) throws IOException {
        if (file.startsWith("file:/")) {
            file = new URL(file).getPath();
        }
        FileOutputStream bufout = new FileOutputStream(file);
        DataSet lds = DataSetAdapter.createLegacyDataSet((QDataSet)ds);
        if (ascii) {
            if (lds instanceof TableDataSet) {
                TableUtil.dumpToAsciiStream((TableDataSet)((TableDataSet)lds), (OutputStream)bufout);
            } else {
                VectorUtil.dumpToAsciiStream((VectorDataSet)((VectorDataSet)lds), (OutputStream)bufout);
            }
        } else if (lds instanceof TableDataSet) {
            TableUtil.dumpToBinaryStream((TableDataSet)((TableDataSet)lds), (OutputStream)bufout);
        } else {
            VectorUtil.dumpToBinaryStream((VectorDataSet)((VectorDataSet)lds), (OutputStream)bufout);
        }
    }

    public static void formatDataSet(QDataSet ds, String file) throws Exception {
        URI uri;
        DataSourceFormat format;
        if (!file.contains(":/")) {
            file = new File(file).getCanonicalFile().toString();
        }
        if ((format = DataSetURI.getDataSourceFormat((URI)(uri = DataSetURI.getURIValid((String)file)))) == null) {
            throw new IllegalArgumentException("no format for extension: " + file);
        }
        format.formatData(DataSetURI.fromUri((URI)uri), ds, (ProgressMonitor)new NullProgressMonitor());
    }

    public static Application getDocumentModel() {
        ScriptContext.maybeInitModel();
        return dom;
    }

    public static void waitUntilIdle() throws InterruptedException {
        model.waitUntilIdle(false);
    }

    public static void save(String filename) throws IOException {
        ScriptContext.maybeInitModel();
        if (!filename.endsWith(".vap")) {
            throw new IllegalArgumentException("filename must end in vap");
        }
        if (!filename.startsWith("file:")) {
            filename = "file://" + new File(filename).getAbsolutePath().replaceAll("\\\\", "/");
        }
        URISplit split = URISplit.parse((String)filename);
        String uri = DataSetURI.fromUri((URI)split.resourceUri);
        if (!uri.startsWith("file:/")) {
            throw new IllegalArgumentException("save only supported to files, got " + split.resourceUri);
        }
        String f = uri.startsWith("file:///") ? split.file.substring(7) : split.file.substring(5);
        model.doSave(new File(f));
    }

    public static String[] getCompletions(String file) throws Exception {
        List cc = DataSetURI.getCompletions((String)file, (int)file.length(), (ProgressMonitor)new NullProgressMonitor());
        String[] result = new String[cc.size()];
        for (int i = 0; i < cc.size(); ++i) {
            result[i] = ((DataSetURI.CompletionResult)cc.get((int)i)).completion;
        }
        return result;
    }

    public static void load(String filename) throws IOException {
        try {
            ScriptContext.plot(filename);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void reset() {
        ScriptContext.maybeInitModel();
        dom.getController().reset();
    }

    protected static void close() {
        model = null;
        view = null;
        out = null;
    }
}

