/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.dom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.ApplicationController;
import org.virbo.autoplot.dom.ApplicationControllerSupport;
import org.virbo.autoplot.dom.ArrayNodeDiff;
import org.virbo.autoplot.dom.BindingModel;
import org.virbo.autoplot.dom.Canvas;
import org.virbo.autoplot.dom.Column;
import org.virbo.autoplot.dom.Connector;
import org.virbo.autoplot.dom.DataSourceFilter;
import org.virbo.autoplot.dom.Diff;
import org.virbo.autoplot.dom.DomNode;
import org.virbo.autoplot.dom.DomUtil;
import org.virbo.autoplot.dom.Plot;
import org.virbo.autoplot.dom.PlotController;
import org.virbo.autoplot.dom.PlotElement;
import org.virbo.autoplot.dom.PropertyChangeDiff;
import org.virbo.autoplot.dom.Row;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationControllerSyncSupport {
    ApplicationController controller;
    Application application;
    Logger logger = Logger.getLogger("virbo.autoplot");

    ApplicationControllerSyncSupport(ApplicationController controller) {
        this.controller = controller;
        this.application = controller.application;
    }

    protected void syncToCanvases(Canvas[] canvases, Map<String, String> layoutIds) {
        if (canvases.length != this.application.canvases.size()) {
            throw new IllegalArgumentException("not implemented");
        }
        for (int i = 0; i < canvases.length; ++i) {
            this.application.canvases.get((int)i).controller.syncTo(canvases[i], new ArrayList<String>(), layoutIds);
        }
    }

    protected void syncToPlotElements(PlotElement[] elements, Map<String, String> nameMap) {
        int i;
        while (this.application.plotElements.size() < elements.length) {
            i = this.application.plotElements.size();
            String idd = elements[i].getPlotId();
            Plot p = null;
            for (int j = 0; j < this.application.getPlots().length; ++j) {
                if (!this.application.getPlots(j).getId().equals(idd)) continue;
                p = this.application.getPlots(j);
            }
            DataSourceFilter dsf = null;
            for (int j = 0; j < this.application.getDataSourceFilters().length; ++j) {
                if (!this.application.getDataSourceFilters(j).getId().equals(elements[i].getDataSourceFilterId())) continue;
                dsf = this.application.getDataSourceFilters(j);
            }
            this.controller.addPlotElement(p, dsf);
        }
        while (this.application.plotElements.size() > elements.length && elements.length > 0) {
            this.controller.deletePlotElement(this.application.plotElements.get(this.application.plotElements.size() - 1));
        }
        for (i = 0; i < elements.length; ++i) {
            this.application.plotElements.get(i).syncTo(elements[i], Arrays.asList("plotId", "dataSourceFilterId", "renderType", "style"));
            this.application.plotElements.get(i).setPlotId(nameMap.get(elements[i].getPlotId()));
            this.application.plotElements.get(i).setRenderType(elements[i].getRenderType());
            this.application.plotElements.get(i).getController().maybeCreateDasPeer();
            this.application.plotElements.get(i).getStyle().syncTo(elements[i].getStyle());
            this.application.plotElements.get(i).setDataSourceFilterId(nameMap.get(elements[i].getDataSourceFilterId()));
            this.application.plotElements.get(i).getController().setDsfReset(false);
        }
    }

    protected void syncToPlots(Plot[] plots, Map<String, String> nameMap) {
        List<Diff> diffs = DomUtil.getArrayDiffs("plots", plots, this.application.getPlots());
        for (Diff d : diffs) {
            ArrayNodeDiff and;
            if (d instanceof ArrayNodeDiff && (and = (ArrayNodeDiff)d).getAction() == ArrayNodeDiff.Action.Delete) {
                Plot domPlot = (Plot)and.getNode();
                List<PlotElement> eles = this.controller.getPlotElementsFor(domPlot);
                if (domPlot.controller != null) {
                    domPlot.controller.deleteDasPeer();
                }
                this.controller.unbind(domPlot);
                this.controller.unbind(domPlot.getXaxis());
                this.controller.unbind(domPlot.getYaxis());
                this.controller.unbind(domPlot.getZaxis());
                for (PlotElement pe : eles) {
                    domPlot.controller.removePlotElement(pe);
                    pe.plotId = "";
                    pe.getController().renderer = null;
                    pe.getController().setResetPlotElement(true);
                }
            }
            if (d instanceof PropertyChangeDiff) continue;
            d.doDiff(this.application);
        }
        for (int i = 0; i < this.application.getPlots().length; ++i) {
            this.application.getPlots(i).syncTo(plots[i]);
        }
        for (Plot p : this.application.getPlots()) {
            if (p.controller == null) {
                Column col;
                Row row;
                if (p.getRowId().equals("")) {
                    row = this.application.controller.getCanvas().marginRow;
                } else {
                    row = (Row)DomUtil.getElementById(this.application, p.getRowId());
                    if (row == null) {
                        row = this.application.controller.getCanvas().marginRow;
                    }
                }
                if (p.getColumnId().equals("")) {
                    col = this.application.controller.getCanvas().marginColumn;
                } else {
                    col = (Column)DomUtil.getElementById(this.application, p.getColumnId());
                    if (col == null) {
                        col = this.application.controller.getCanvas().marginColumn;
                    }
                }
                this.logger.log(Level.FINE, "adding controller for new node {0}", p);
                new PlotController(this.application, p).createDasPeer(row.controller.getCanvas(), row, col);
            }
            nameMap.put(p.getId(), p.getId());
        }
    }

    protected void syncConnectors(Connector[] connectors) {
        ArrayList<Connector> addConnectors = new ArrayList<Connector>();
        ArrayList<Connector> deleteConnectors = new ArrayList<Connector>();
        List<Connector> thisConnectors = Arrays.asList(this.application.getConnectors());
        List<Connector> thatConnectors = Arrays.asList(connectors);
        for (Connector c : thatConnectors) {
            if (thisConnectors.contains(c)) continue;
            addConnectors.add(c);
        }
        for (Connector c : this.application.connectors) {
            if (thatConnectors.contains(c)) continue;
            deleteConnectors.add(c);
        }
        for (Connector c : addConnectors) {
            Plot plotA = (Plot)DomUtil.getElementById(this.application, c.plotA);
            Plot plotB = (Plot)DomUtil.getElementById(this.application, c.plotB);
            this.controller.addConnector(plotA, plotB);
        }
        for (Connector c : deleteConnectors) {
            this.controller.deleteConnector(c);
        }
    }

    protected void syncBindingsNew(BindingModel[] bindings, Map<String, String> idMap) {
        List<Diff> diffs = DomUtil.getArrayDiffs("bindings", bindings, this.application.getBindings());
        for (Diff d : diffs) {
            if (d instanceof ArrayNodeDiff) {
                ArrayNodeDiff and = (ArrayNodeDiff)d;
                if (and.getAction() == ArrayNodeDiff.Action.Delete) {
                    BindingModel domBinding = (BindingModel)and.getNode();
                    this.controller.deleteBinding(domBinding);
                }
                if (and.getAction() != ArrayNodeDiff.Action.Insert) continue;
                BindingModel c = (BindingModel)and.getNode();
                DomNode src = DomUtil.getElementById(this.application, idMap.get(c.srcId));
                DomNode dst = DomUtil.getElementById(this.application, idMap.get(c.dstId));
                if (src == null || dst == null) {
                    Logger.getLogger(ApplicationControllerSupport.class.getName()).finer("node was null");
                    continue;
                }
                this.controller.bind(src, c.srcProperty, dst, c.dstProperty);
                continue;
            }
            d.doDiff(this.application);
        }
    }

    protected void syncBindings(BindingModel[] bindings) {
        this.syncBindingsNew(bindings, new HashMap<String, String>());
    }

    protected void syncToDataSourceFilters(DataSourceFilter[] dataSourceFilters, Map<String, String> nameMap) {
        while (this.application.dataSourceFilters.size() < dataSourceFilters.length) {
            this.controller.addDataSourceFilter();
        }
        while (this.application.dataSourceFilters.size() > dataSourceFilters.length) {
            DataSourceFilter dsf = this.application.dataSourceFilters.get(this.application.dataSourceFilters.size() - 1);
            List<PlotElement> elements = this.controller.getPlotElementsFor(dsf);
            for (PlotElement element : elements) {
                element.setDataSourceFilterId("");
            }
        }
        for (int i = 0; i < dataSourceFilters.length; ++i) {
            this.application.dataSourceFilters.get(i).syncTo(dataSourceFilters[i]);
            nameMap.put(dataSourceFilters[i].getId(), this.application.dataSourceFilters.get(i).getId());
        }
    }
}

