/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.dom;

import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdesktop.beansbinding.Converter;
import org.virbo.autoplot.dom.DomNode;

public class BindingSupport {
    final Map<Object, List<BindingImpl>> implBindingContexts = new HashMap<Object, List<BindingImpl>>();

    protected BindingSupport() {
    }

    private PropertyChangeListener propListener(final Object p, final Method setter, final Method getter, final Converter c, final boolean forward) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                try {
                    if (c == null) {
                        Object oldValue = getter.invoke(p, new Object[0]);
                        if (oldValue == null) {
                            System.err.println("oldValue is null!!!");
                        }
                        if (oldValue != null && oldValue.equals(evt.getNewValue())) {
                            return;
                        }
                        setter.invoke(p, evt.getNewValue());
                        if (new Exception().getStackTrace().length > 300) {
                            System.err.println("setter: " + setter);
                            System.err.println("old:" + evt.getOldValue() + "  new:" + evt.getNewValue());
                            System.err.println("this is that bad state!");
                        }
                    } else {
                        if (Thread.currentThread().getStackTrace().length > 70) {
                            System.err.println("Problem detected in stack trace, circular call");
                            return;
                        }
                        if (forward) {
                            setter.invoke(p, c.convertForward(evt.getNewValue()));
                        } else {
                            setter.invoke(p, c.convertReverse(evt.getNewValue()));
                        }
                    }
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private void lookupGetterSetter(Object src, String propName, BindingImpl bi) {
        try {
            Class<?> c = src.getClass();
            PropertyDescriptor pd = new PropertyDescriptor(propName, c);
            Method setter = pd.getWriteMethod();
            Method getter = pd.getReadMethod();
            if (src == bi.src) {
                bi.srcSetter = setter;
                bi.srcGetter = getter;
            } else {
                bi.dstSetter = setter;
                bi.dstGetter = getter;
            }
            return;
        }
        catch (IntrospectionException ex) {
            Logger.getLogger(BindingSupport.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(DomNode src, String srcProp, Object dst, String dstProp, Converter c) {
        PropertyChangeListener dstListener;
        if (srcProp.contains(".")) {
            throw new IllegalArgumentException("src property name cannot contain periods: " + srcProp);
        }
        if (dstProp.contains(".")) {
            throw new IllegalArgumentException("dst property name cannot contain periods: " + dstProp);
        }
        BindingImpl bi = new BindingImpl();
        bi.dst = dst;
        bi.src = src;
        bi.srcProp = srcProp;
        bi.dstProp = dstProp;
        this.lookupGetterSetter(src, srcProp, bi);
        this.lookupGetterSetter(dst, dstProp, bi);
        try {
            Object val = bi.srcGetter.invoke((Object)src, new Object[0]);
            if (c != null) {
                val = c.convertForward(val);
            }
            bi.dstSetter.invoke(dst, val);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        PropertyChangeListener srcListener = this.propListener(dst, bi.dstSetter, bi.dstGetter, c, true);
        src.addPropertyChangeListener(srcProp, srcListener);
        bi.dstListener = dstListener = this.propListener(src, bi.srcSetter, bi.srcGetter, c, false);
        bi.srcListener = srcListener;
        try {
            Method apcl = dst.getClass().getMethod("addPropertyChangeListener", String.class, PropertyChangeListener.class);
            apcl.invoke(dst, dstProp, dstListener);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(BindingSupport.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(BindingSupport.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(BindingSupport.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(BindingSupport.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(BindingSupport.class.getName()).log(Level.SEVERE, null, ex);
        }
        Map<Object, List<BindingImpl>> map = this.implBindingContexts;
        synchronized (map) {
            List<BindingImpl> list = this.implBindingContexts.get(src);
            if (list == null) {
                list = new ArrayList<BindingImpl>();
                this.implBindingContexts.put(src, list);
            }
            list.add(bi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(DomNode master) {
        Map<Object, List<BindingImpl>> map = this.implBindingContexts;
        synchronized (map) {
            List<BindingImpl> list = this.implBindingContexts.get(master);
            if (list == null) {
                return;
            }
            for (BindingImpl bi : list) {
                try {
                    Method apcl = bi.dst.getClass().getMethod("removePropertyChangeListener", String.class, PropertyChangeListener.class);
                    apcl.invoke(bi.dst, bi.dstProp, bi.dstListener);
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger(BindingSupport.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IllegalArgumentException ex) {
                    Logger.getLogger(BindingSupport.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (InvocationTargetException ex) {
                    Logger.getLogger(BindingSupport.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (NoSuchMethodException ex) {
                    Logger.getLogger(BindingSupport.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (SecurityException ex) {
                    Logger.getLogger(BindingSupport.class.getName()).log(Level.SEVERE, null, ex);
                }
                bi.src.removePropertyChangeListener(bi.srcProp, bi.srcListener);
            }
            list.clear();
            this.implBindingContexts.remove(master);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(DomNode master, String property, Object dst, String dstProp) {
        Map<Object, List<BindingImpl>> map = this.implBindingContexts;
        synchronized (map) {
            List<BindingImpl> list = this.implBindingContexts.get(master);
            if (list == null) {
                return;
            }
            ArrayList<BindingImpl> list2 = new ArrayList<BindingImpl>(list);
            for (BindingImpl bi : list) {
                if (!bi.srcProp.equals(property) || bi.dst != dst || !bi.dstProp.equals(dstProp)) continue;
                try {
                    Method apcl = bi.dst.getClass().getMethod("removePropertyChangeListener", String.class, PropertyChangeListener.class);
                    apcl.invoke(bi.dst, bi.dstProp, bi.dstListener);
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger(BindingSupport.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IllegalArgumentException ex) {
                    Logger.getLogger(BindingSupport.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (InvocationTargetException ex) {
                    Logger.getLogger(BindingSupport.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (NoSuchMethodException ex) {
                    Logger.getLogger(BindingSupport.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (SecurityException ex) {
                    Logger.getLogger(BindingSupport.class.getName()).log(Level.SEVERE, null, ex);
                }
                bi.src.removePropertyChangeListener(bi.srcProp, bi.srcListener);
                list2.remove(bi);
            }
            if (list2.isEmpty()) {
                this.implBindingContexts.remove(master);
            } else {
                this.implBindingContexts.put(master, list2);
            }
        }
    }

    private static class BindingImpl {
        PropertyChangeListener srcListener;
        PropertyChangeListener dstListener;
        DomNode src;
        Object dst;
        String dstProp;
        String srcProp;
        Method dstSetter;
        Method srcSetter;
        Method dstGetter;
        Method srcGetter;

        private BindingImpl() {
        }
    }
}

