/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.dom;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.das2.CancelledOperationException;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasPlot;
import org.das2.system.RequestProcessor;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.autoplot.ApplicationModel;
import org.virbo.autoplot.AutoplotUtil;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.ApplicationController;
import org.virbo.autoplot.dom.Axis;
import org.virbo.autoplot.dom.BindingModel;
import org.virbo.autoplot.dom.ChangesSupport;
import org.virbo.autoplot.dom.DataSourceFilter;
import org.virbo.autoplot.dom.DomNode;
import org.virbo.autoplot.dom.DomNodeController;
import org.virbo.autoplot.dom.DomUtil;
import org.virbo.autoplot.dom.Plot;
import org.virbo.autoplot.dom.PlotElement;
import org.virbo.autoplot.dom.PlotElementUtil;
import org.virbo.autoplot.dom.TimeSeriesBrowseController;
import org.virbo.autoplot.util.RunLaterListener;
import org.virbo.dataset.ArrayDataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.RankZeroDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.HtmlResponseIOException;
import org.virbo.datasource.URISplit;
import org.virbo.datasource.capability.Caching;
import org.virbo.datasource.capability.TimeSeriesBrowse;
import org.virbo.datasource.capability.Updating;
import org.virbo.dsutil.AutoHistogram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceController
extends DomNodeController {
    static final Logger logger = Logger.getLogger("vap.dataSourceController");
    DataSourceFilter dsf;
    private ApplicationModel model;
    private Application dom;
    private ProgressMonitor mon;
    private PropertyChangeListener updateSlicePropertyChangeListener = new PropertyChangeListener(){

        public String toString() {
            return "" + DataSourceController.this.dsf + " controller updateSlicePropertyChangeListener";
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (DataSourceController.this.dataSet != null) {
                DataSourceController.this.updateFill();
            }
        }
    };
    private PropertyChangeListener updateMePropertyChangeListener = new PropertyChangeListener(){

        public String toString() {
            return "" + DataSourceController.this.dsf + " controller updateMePropertyChangeListener";
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (DataSourceController.this.dataSet != null) {
                logger.fine("change in fill or valid range ->updateFillSoon()");
                DataSourceController.this.updateFillSoon(0);
            }
        }
    };
    private PropertyChangeListener resetMePropertyChangeListener = new PropertyChangeListener(){

        public String toString() {
            return "" + DataSourceController.this.dsf + " controller resetMePropertyChangeListener";
        }

        public void propertyChange(PropertyChangeEvent e) {
            logger.log(Level.FINE, "resetMe: {0} {1}->{2}", new Object[]{e.getPropertyName(), e.getOldValue(), e.getNewValue()});
            if (e.getNewValue() == null && e.getOldValue() == null) {
                return;
            }
            List<Object> whoIsChanging = DataSourceController.this.changesSupport.whoIsChanging(DataSourceController.PENDING_SET_DATA_SOURCE);
            if (whoIsChanging.size() > 0) {
                System.err.println("!!! " + whoIsChanging + " !!!");
                return;
            }
            DataSourceController.this.changesSupport.registerPendingChange(DataSourceController.this.resetMePropertyChangeListener, DataSourceController.PENDING_RESOLVE_DATA_SOURCE);
            DataSourceController.this.setUriNeedsResolution(true);
            if (!((DataSourceController)DataSourceController.this).dom.controller.isValueAdjusting()) {
                DataSourceController.this.changesSupport.performingChange(DataSourceController.this.resetMePropertyChangeListener, DataSourceController.PENDING_RESOLVE_DATA_SOURCE);
                DataSourceController.this.resolveDataSource(false, DataSourceController.this.getMonitor("resetting data source", "resetting data source"));
                DataSourceController.this.changesSupport.changePerformed(DataSourceController.this.resetMePropertyChangeListener, DataSourceController.PENDING_RESOLVE_DATA_SOURCE);
            } else {
                new RunLaterListener("valueAdjusting", ((DataSourceController)DataSourceController.this).dom.controller, true){

                    public void run() {
                        DataSourceController.this.changesSupport.performingChange(DataSourceController.this.resetMePropertyChangeListener, DataSourceController.PENDING_RESOLVE_DATA_SOURCE);
                        if (DataSourceController.this.uriNeedsResolution) {
                            DataSourceController.this.resolveDataSource(true, DataSourceController.this.getMonitor("resetting data source", "resetting data source"));
                        }
                        DataSourceController.this.changesSupport.changePerformed(DataSourceController.this.resetMePropertyChangeListener, DataSourceController.PENDING_RESOLVE_DATA_SOURCE);
                    }
                };
            }
        }
    };
    private TimeSeriesBrowseController timeSeriesBrowseController;
    private boolean haveCheckedInternalTsb = false;
    private static final String PENDING_DATA_SOURCE = "dataSource";
    private static final String PENDING_RESOLVE_DATA_SOURCE = "resolveDataSource";
    private static final String PENDING_SET_DATA_SOURCE = "setDataSource";
    private static final String PENDING_FILL_DATASET = "fillDataSet";
    private static final String PENDING_UPDATE = "update";
    DataSourceFilter[] parentSources;
    PropertyChangeListener parentListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            String prob = DataSourceController.this.checkParents();
            if (prob != null) {
                DataSourceController.this.setStatus("warning: " + prob);
                DataSourceController.this.setDataSetInternal(null, null, ((DataSourceController)DataSourceController.this).dom.controller.isValueAdjusting());
            }
            if (!DataSourceController.this.haveCheckedInternalTsb) {
                DataSourceController.this.maybeAddInternalTimeSeriesBrowse();
            }
        }
    };
    PropertyChangeListener dsfListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            DataSourceController.this.resolveParents();
        }
    };
    private Updating updating;
    private PropertyChangeListener updatesListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            QDataSet ds = (QDataSet)evt.getNewValue();
            if (ds != null) {
                DataSourceController.this.setDataSetInternal(ds);
            } else {
                List<PlotElement> pelements = ((DataSourceController)DataSourceController.this).dom.controller.getPlotElementsFor(DataSourceController.this.dsf);
                for (PlotElement p : pelements) {
                    p.getController().setResetRanges(true);
                }
                DataSourceController.this.update();
            }
        }
    };
    public static final String PROP_RAWPROPERTIES = "rawProperties";
    protected Map<String, Object> rawProperties = null;
    protected TimeSeriesBrowse tsb = null;
    public static final String PROP_TSB = "tsb";
    protected String tsbSuri = null;
    public static final String PROP_TSBSURI = "tsbSuri";
    protected Caching caching = null;
    public static final String PROP_CACHING = "caching";
    public static final String PROP_DATASOURCE = "dataSource";
    protected DataSource dataSource = null;
    protected QDataSet dataSet = null;
    public static final String PROP_DATASET = "dataSet";
    protected QDataSet fillDataSet = null;
    public static final String PROP_FILLDATASET = "fillDataSet";
    protected Exception exception = null;
    public static final String PROP_EXCEPTION = "exception";
    protected QDataSet histogram = null;
    public static final String PROP_HISTOGRAM = "histogram";
    private List<String> depnames = Arrays.asList("first", "second", "last");
    public static final String PROP_DEPNAMES = "depnames";
    protected Map<String, Object> properties = null;
    public static final String PROP_PROPERTIES = "properties";
    protected Map<String, Object> fillProperties = null;
    public static final String PROP_FILLPROPERTIES = "fillProperties";
    protected String reduceDataSetString = null;
    public static final String PROP_REDUCEDATASETSTRING = "reduceDataSetString";
    public static final String PROP_URINEEDSRESOLUTION = "uriNeedsResolution";
    protected boolean uriNeedsResolution = false;
    public static final String PROP_DATASETNEEDSLOADING = "dataSetNeedsLoading";
    protected boolean dataSetNeedsLoading = false;
    protected boolean resetDimensions = false;
    public static final String PROP_RESETDIMENSIONS = "resetDimensions";

    public DataSourceController(ApplicationModel model, DataSourceFilter dsf) {
        super(dsf);
        this.model = model;
        this.dom = model.getDocumentModel();
        this.changesSupport = new ChangesSupport(this.propertyChangeSupport, this);
        this.dsf = dsf;
        dsf.addPropertyChangeListener("filters", this.updateSlicePropertyChangeListener);
        dsf.addPropertyChangeListener("fill", this.updateMePropertyChangeListener);
        dsf.addPropertyChangeListener("validRange", this.updateMePropertyChangeListener);
        dsf.addPropertyChangeListener("uri", this.resetMePropertyChangeListener);
    }

    public int getMaxSliceIndex(int i) {
        if (this.getDataSet() == null) {
            return 0;
        }
        int sliceDimension = i;
        if (sliceDimension == 0) {
            return this.getDataSet().length();
        }
        int[] qube = DataSetUtil.qubeDims((QDataSet)this.getDataSet());
        if (qube == null || qube.length <= sliceDimension) {
            return 0;
        }
        return qube[sliceDimension];
    }

    private void doDimensionNames() {
        QDataSet ds = this.getDataSet();
        String[] depNames = new String[ds.rank()];
        for (int i = 0; i < ds.rank(); ++i) {
            String dname;
            depNames[i] = "dim" + i;
            QDataSet dep0 = (QDataSet)ds.property("DEPEND_" + i);
            if (dep0 == null || (dname = (String)dep0.property("NAME")) == null) continue;
            depNames[i] = dname;
        }
        logger.log(Level.FINE, "dep names: {0}", Arrays.asList(depNames));
        this.setDepnames(Arrays.asList(depNames));
        this.setResetDimensions(false);
    }

    private boolean doesPlotElementSupportTsb(PlotElement p) {
        return p.isAutoComponent() || !p.getComponent().contains("|slice0") && !p.getComponent().contains("|collapse0");
    }

    public synchronized void resetDataSource(boolean valueWasAdjusting, DataSource dataSource) {
        if (dataSource == null) {
            this.setDataSetNeedsLoading(false);
        } else {
            this.setDataSetNeedsLoading(true);
        }
        if (this.timeSeriesBrowseController != null) {
            this.timeSeriesBrowseController.release();
            this.timeSeriesBrowseController = null;
        }
        DataSource oldSource = this.getDataSource();
        if (this.haveCheckedInternalTsb) {
            this.haveCheckedInternalTsb = false;
        }
        if (dataSource == null) {
            this.setCaching(null);
            this.setTsb(null);
            this.setTsbSuri(null);
            if (this.dsf.getUri().length() > 0 && !this.dsf.getUri().startsWith("vap+internal")) {
                this.dsf.setUri("vap+internal:");
            }
        } else {
            this.changesSupport.performingChange(this, PENDING_SET_DATA_SOURCE);
            this.setCaching((Caching)dataSource.getCapability(Caching.class));
            PlotElement pe = this.getPlotElement();
            if (pe != null && this.doesPlotElementSupportTsb(pe)) {
                this.setTsb((TimeSeriesBrowse)dataSource.getCapability(TimeSeriesBrowse.class));
            } else if (pe == null) {
                this.setTsb((TimeSeriesBrowse)dataSource.getCapability(TimeSeriesBrowse.class));
            } else {
                this.setTsb(null);
            }
            if (this.dsf.getUri().length() > 0) {
                this.dsf.setUri(dataSource.getURI());
                this.setUriNeedsResolution(false);
            }
            this.changesSupport.changePerformed(this, PENDING_SET_DATA_SOURCE);
        }
        this.dsf.setValidRange("");
        this.dsf.setFill("");
        if (valueWasAdjusting) {
            this.dataSource = dataSource;
        } else {
            this.setDataSource(dataSource);
            this.setResetDimensions(true);
        }
        if (oldSource == null || !oldSource.equals(dataSource)) {
            List<PlotElement> ps = this.dom.controller.getPlotElementsFor(this.dsf);
            if (this.getTsb() != null && ps.size() > 0) {
                this.setDataSet(null);
                if (ps.size() > 0) {
                    this.timeSeriesBrowseController = new TimeSeriesBrowseController(this, ps.get(0));
                    this.timeSeriesBrowseController.setup(valueWasAdjusting);
                }
            } else if (this.getTsb() != null && ps.size() == 0) {
                String propertyName;
                DomNode node1;
                this.timeSeriesBrowseController = new TimeSeriesBrowseController(this, null);
                Plot p = this.dom.controller.getFirstPlotFor(this.dsf);
                if (p == null) {
                    node1 = this.dom;
                    propertyName = "timeRange";
                } else {
                    node1 = p;
                    propertyName = "context";
                }
                if (!UnitsUtil.isTimeLocation((Units)this.dom.getTimeRange().getUnits())) {
                    List<BindingModel> bms = this.dom.getController().findBindings(this.dom, "timeRange", null, null);
                    if (bms == null || bms.size() == 0) {
                        System.err.println("claiming dom timerange for TSB: " + this.dsf.getUri());
                        p.setContext(this.getTsb().getTimeRange());
                        this.dom.setTimeRange(this.getTsb().getTimeRange());
                        System.err.println("about to setup Gen for " + this);
                        this.timeSeriesBrowseController.setupGen(node1, propertyName);
                        if (node1 != this.dom) {
                            this.dom.controller.bind(this.dom, "timeRange", p, "context");
                        }
                        this.update();
                    } else {
                        System.err.println("unable to use timerange as guide");
                        p.setContext(this.getTsb().getTimeRange());
                        this.timeSeriesBrowseController.setupGen(node1, propertyName);
                        this.update();
                    }
                } else {
                    System.err.println("using plot context for TSB: " + this.dsf.getUri());
                    this.timeSeriesBrowseController.setupGen(node1, propertyName);
                    if (node1 != this.dom) {
                        this.dom.controller.bind(this.dom, "timeRange", p, "context");
                    }
                    this.update();
                }
            } else {
                this.update();
            }
        }
    }

    public synchronized void setDataSetInternal(QDataSet ds) {
        this.setDataSetInternal(ds, null, this.dom.controller.isValueAdjusting());
    }

    public static boolean isTimeSeries(QDataSet ds) {
        Units u;
        QDataSet dep0 = SemanticOps.xtagsDataSet((QDataSet)ds);
        return dep0 != null && UnitsUtil.isTimeLocation((Units)(u = SemanticOps.getUnits((QDataSet)dep0)));
    }

    public synchronized void setDataSetInternal(QDataSet ds, Map<String, Object> rawProperties, boolean immediately) {
        ArrayList problems = new ArrayList();
        if (ds != null && !DataSetUtil.validate((QDataSet)ds, problems)) {
            StringBuilder message = new StringBuilder("data set is invalid:\n");
            new Exception("data set is invalid").printStackTrace();
            for (String s : problems) {
                message.append(s).append("\n");
            }
            if (this.dom.controller.isHeadless()) {
                throw new IllegalArgumentException(message.toString());
            }
            this.model.showMessage(message.toString(), "Data Set is Invalid", 2);
            if (ds instanceof MutablePropertyDataSet) {
                return;
            }
            return;
        }
        if (this.getTimeSeriesBrowseController() != null && ds != null && !DataSourceController.isTimeSeries(ds) && this.getTimeSeriesBrowseController().isListeningToAxis()) {
            this.timeSeriesBrowseController.release();
            Axis xaxis = this.getTimeSeriesBrowseController().domPlot.getXaxis();
            this.dom.getController().unbind(this.dom, "timeRange", xaxis, "range");
            this.dom.setTimeRange(this.timeSeriesBrowseController.getTimeRange());
            this.timeSeriesBrowseController.setupGen(this.dom, "timeRange");
        }
        ApplicationController ac = this.dom.controller;
        if (!immediately && ac.isValueAdjusting()) {
            final QDataSet fds = ds;
            new RunLaterListener("valueAdjusting", ac, false){

                public void run() {
                    DataSourceController.this.setDataSetInternal(fds);
                }
            };
        } else {
            this.setDataSet(ds);
            this.setRawProperties(rawProperties);
            this.setDataSetNeedsLoading(false);
            if (ds == null) {
                this.setDataSet(null);
                this.setProperties(null);
                this.setFillProperties(null);
                this.setFillDataSet(null);
                this.setDepnames(Arrays.asList("first", "second", "third"));
                return;
            }
            this.extractProperties();
            this.doDimensionNames();
            if (DataSetUtil.totalLength((QDataSet)ds) < 200000) {
                this.setStatus("busy: do statistics on the data...");
                this.setHistogram(new AutoHistogram().doit(ds, null));
            } else {
                this.setHistogram(null);
            }
            this.setStatus("busy: apply fill");
            this.updateFill();
            this.setStatus("done, apply fill");
            List<PlotElement> pele = this.dom.controller.getPlotElementsFor(this.dsf);
            if (pele.size() == 0) {
                this.setStatus("warning: done loading data but no plot elements are listening");
            }
        }
    }

    protected synchronized DataSourceFilter[] getParentSources() {
        if (this.parentSources == null) {
            return new DataSourceFilter[0];
        }
        DataSourceFilter[] parentSources1 = new DataSourceFilter[this.parentSources.length];
        System.arraycopy(this.parentSources, 0, parentSources1, 0, this.parentSources.length);
        return parentSources1;
    }

    private synchronized void clearParentSources() {
        if (this.parentSources != null) {
            for (DataSourceFilter parentDsf : this.parentSources) {
                if (parentDsf == null) continue;
                parentDsf.controller.removePropertyChangeListener("fillDataSet", this.parentListener);
            }
        }
        this.parentSources = null;
    }

    private synchronized void maybeAddInternalTimeSeriesBrowse() {
        if (this.haveCheckedInternalTsb) {
            return;
        }
        String uri = this.dsf.getUri();
        if (uri == null) {
            return;
        }
        URISplit split = URISplit.parse((String)uri);
        String[] ss = split.surl.split(",", -2);
        this.tsb = null;
        InternalTimeSeriesBrowse intTsb = null;
        for (int i = 0; i < ss.length; ++i) {
            DataSourceFilter parentDsf = (DataSourceFilter)DomUtil.getElementById(this.dom, ss[i]);
            if (parentDsf != null) {
                parentDsf.controller.addPropertyChangeListener("fillDataSet", this.parentListener);
                this.parentSources[i] = parentDsf;
                TimeSeriesBrowse parentTsb = parentDsf.controller.getTsb();
                if (parentTsb == null) continue;
                if (intTsb == null) {
                    intTsb = new InternalTimeSeriesBrowse(this.dsf.getUri());
                }
                System.err.println("adding to internal tsb: " + parentTsb);
                intTsb.addTimeSeriesBrowse(parentTsb);
                continue;
            }
            logger.log(Level.WARNING, "unable to find parent {0}", ss[i]);
            if (this.parentSources == null) {
                System.err.println("strange case where parent sources is not resolved.");
                return;
            }
            this.parentSources[i] = null;
        }
        if (intTsb != null) {
            this.setTsb(intTsb);
            this.timeSeriesBrowseController = new TimeSeriesBrowseController(this, null);
            Plot p = this.getApplication().getController().getFirstPlotFor(this.dsf);
            if (p != null) {
                this.timeSeriesBrowseController.setupGen(p, "context");
            } else {
                System.err.println("check into this case, shouldn't happen");
            }
        }
        this.haveCheckedInternalTsb = true;
    }

    private synchronized void resolveParents() {
        if (this.dsf.getUri().length() == 0) {
            return;
        }
        URISplit split = URISplit.parse((String)this.dsf.getUri());
        if (!this.dsf.getUri().startsWith("vap+internal:")) {
            System.err.println("unbinding because this doesn't have parents.");
            this.unbind();
            return;
        }
        String[] ss = split.surl.split(",", -2);
        for (int i = 0; i < ss.length; ++i) {
            DataSourceFilter dsf1 = (DataSourceFilter)DomUtil.getElementById(this.dom, ss[i]);
            if (dsf1 != null) {
                dsf1.controller.addPropertyChangeListener("fillDataSet", this.parentListener);
                this.parentSources[i] = dsf1;
                continue;
            }
            logger.log(Level.WARNING, "unable to find parent {0}", ss[i]);
            this.parentSources[i] = null;
        }
    }

    private static Map maybeCopy(Map m) {
        if (m == null) {
            return new HashMap();
        }
        return new HashMap(m);
    }

    private synchronized String checkParents() {
        ArrayDataSet yds;
        QDataSet y = null;
        QDataSet z = null;
        Map xprops = null;
        Map yprops = null;
        Map zprops = null;
        QDataSet ds = null;
        Map props = null;
        if (this.parentSources == null) {
            return "no parent sources";
        }
        if (this.parentSources[0] == null) {
            return "first parent is null";
        }
        QDataSet x = this.parentSources[0].controller.getFillDataSet();
        xprops = DataSourceController.maybeCopy(this.parentSources[0].controller.getFillProperties());
        if (this.parentSources.length > 1) {
            if (this.parentSources[1] == null) {
                return "second parent is null";
            }
            y = this.parentSources[1].controller.getFillDataSet();
            yprops = DataSourceController.maybeCopy(this.parentSources[1].controller.getFillProperties());
        }
        if (this.parentSources.length > 2) {
            if (this.parentSources[2] == null) {
                return "third parent is null";
            }
            z = this.parentSources[2].controller.getFillDataSet();
            zprops = DataSourceController.maybeCopy(this.parentSources[2].controller.getFillProperties());
        }
        if (this.parentSources.length == 1) {
            if (x == null) {
                return "parent dataset is null";
            }
            if (DataSetUtil.validate((QDataSet)x, null)) {
                ds = x;
                props = xprops;
            }
        } else if (this.parentSources.length == 2) {
            if (x == null || y == null) {
                return "first or second dataset is null";
            }
            yds = ArrayDataSet.copy((QDataSet)y);
            if (DataSetUtil.validate((QDataSet)x, (QDataSet)yds, null)) {
                yds.putProperty("DEPEND_0", (Object)x);
                yprops.put("DEPEND_0", xprops);
                if (DataSetUtil.validate((QDataSet)yds, null)) {
                    ds = yds;
                    props = yprops;
                }
            } else {
                logger.fine("intermediate state where y and x have different lengths");
            }
        } else if (this.parentSources.length == 3) {
            if (x == null || y == null || z == null) {
                return "at least one of the three datasets is null";
            }
            if (z.rank() == 1) {
                yds = ArrayDataSet.copy((QDataSet)y);
                yds.putProperty("DEPEND_0", (Object)x);
                yds.putProperty("PLANE_0", (Object)z);
                yprops.put("DEPEND_0", xprops);
                yprops.put("PLANE_0", zprops);
                if (DataSetUtil.validate((QDataSet)yds, null)) {
                    ds = yds;
                    props = yprops;
                }
            } else {
                ArrayDataSet zds = ArrayDataSet.copy((QDataSet)z);
                if (x != null) {
                    zds.putProperty("DEPEND_0", (Object)x);
                }
                if (y != null) {
                    zds.putProperty("DEPEND_1", (Object)y);
                }
                if (DataSetUtil.validate((QDataSet)x, (QDataSet)y, (QDataSet)z, null)) {
                    zprops.put("DEPEND_0", xprops);
                    zprops.put("DEPEND_1", yprops);
                    ds = zds;
                    props = zprops;
                }
            }
        }
        if (ds != null) {
            QDataSet xxds;
            QDataSet xds;
            if (this.tsb != null && this.tsb instanceof InternalTimeSeriesBrowse && (xds = (QDataSet)ds.property("DEPEND_0")) != null && (xxds = (QDataSet)xds.property("DEPEND_0")) != null && UnitsUtil.isTimeLocation((Units)SemanticOps.getUnits((QDataSet)xxds)) && SemanticOps.isMonotonic((QDataSet)xxds)) {
                int idx1;
                DatumRange dr = this.tsb.getTimeRange();
                int idx0 = DataSetUtil.getPreviousIndex((QDataSet)xxds, (Datum)dr.min());
                if (idx0 == (idx1 = DataSetUtil.getNextIndex((QDataSet)xxds, (Datum)dr.max()))) {
                    this.setDataSetInternal(null);
                } else if (idx0 > idx1) {
                    System.err.println("non mono error?");
                    this.setDataSetInternal(null);
                } else {
                    QDataSet trim;
                    ds = trim = ds.trim(idx0, idx1);
                }
            }
            this.setDataSetInternal(ds, props, this.dom.controller.isValueAdjusting());
        }
        return null;
    }

    private synchronized boolean doInternal(String path) {
        if (this.parentSources != null) {
            for (int i = 0; i < this.parentSources.length; ++i) {
                if (this.parentSources[i] == null) continue;
                this.parentSources[i].controller.removePropertyChangeListener("fillDataSet", this.parentListener);
            }
        }
        if (path.trim().length() == 0) {
            return true;
        }
        String[] ss = path.split(",", -2);
        this.parentSources = new DataSourceFilter[ss.length];
        this.resolveParents();
        String prob = this.checkParents();
        if (prob != null) {
            this.setStatus("warning: " + prob);
            return false;
        }
        this.dom.addPropertyChangeListener("dataSourceFilters", this.dsfListener);
        return true;
    }

    protected void unbind() {
        this.dom.removePropertyChangeListener("dataSourceFilters", this.dsfListener);
    }

    private void extractProperties() {
        Map<String, Object> props = AutoplotUtil.extractProperties(this.getDataSet());
        if (this.getDataSource() != null) {
            props = AutoplotUtil.mergeProperties(this.getDataSource().getProperties(), props);
        }
        this.setProperties(props);
    }

    public void doFillValidRange() {
        Map<String, Object> props = this.getProperties();
        Object v = props.get("FILL_VALUE");
        if (v != null) {
            this.dsf.setFill(String.valueOf(v));
        }
        Number vmin = (Number)props.get("VALID_MIN");
        Number vmax = (Number)props.get("VALID_MAX");
        if (vmin != null || vmax != null) {
            if (vmin == null) {
                vmin = -1.0E38;
            }
            if (vmax == null) {
                vmax = 1.0E38;
            }
            this.dsf.setValidRange("" + vmin + " to " + vmax);
        } else {
            this.dsf.setValidRange("");
        }
    }

    private void updateFillSoon(final int delay) {
        this.changesSupport.performingChange(this, "fillDataSet");
        Runnable run = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    if (delay > 0) {
                        try {
                            Thread.sleep(delay);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(DataSourceController.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    DataSourceController.this.updateFill();
                }
                finally {
                    DataSourceController.this.changesSupport.changePerformed(this, "fillDataSet");
                }
            }
        };
        if (delay == 0) {
            logger.finest("delay=0 means I should update fill in this thread");
            run.run();
        } else {
            RequestProcessor.invokeLater((Runnable)run);
        }
    }

    private static void guessCadence(MutablePropertyDataSet xds, QDataSet fillDs) {
        if (xds.length() < 2) {
            return;
        }
        RankZeroDataSet cadence = DataSetUtil.guessCadenceNew((QDataSet)xds, (QDataSet)fillDs);
        if (cadence != null && "log".equals(cadence.property("SCALE_TYPE"))) {
            xds.putProperty("SCALE_TYPE", (Object)"log");
        }
        if (cadence != null) {
            xds.putProperty("CADENCE", (Object)cadence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFill() {
        logger.fine("enter updateFill");
        if (this.getDataSet() == null) {
            return;
        }
        this.changesSupport.performingChange(this, "fillDataSet");
        try {
            MutablePropertyDataSet fillDs;
            boolean doSlice;
            Map<String, Object> props = this.getProperties();
            String filters = this.dsf.getFilters();
            boolean bl = doSlice = filters.length() > 0;
            if (doSlice) {
                QDataSet ds;
                if (DataSetOps.isProcessAsync((String)filters)) {
                    System.err.println("asynchronous processes not supported here");
                    this.setReduceDataSetString(null);
                    ds = this.getDataSet();
                } else {
                    ds = DataSetOps.sprocess((String)filters, (QDataSet)this.getDataSet(), (ProgressMonitor)new NullProgressMonitor());
                    this.setReduceDataSetString(filters);
                }
                fillDs = DataSetOps.makePropertiesMutable((QDataSet)ds);
            } else {
                fillDs = DataSetOps.makePropertiesMutable((QDataSet)this.getDataSet());
                this.setReduceDataSetString(null);
            }
            for (int i = 0; i < fillDs.rank(); ++i) {
                QDataSet dep = (QDataSet)fillDs.property("DEPEND_" + i);
                if (dep == null) continue;
                dep = DataSetOps.makePropertiesMutable((QDataSet)dep);
                if (i == 0) {
                    DataSourceController.guessCadence((MutablePropertyDataSet)dep, (QDataSet)fillDs);
                } else if (dep.rank() == 1) {
                    DataSourceController.guessCadence((MutablePropertyDataSet)dep, null);
                } else if (dep.rank() != 2 || dep.length(0) > 2) {
                    // empty if block
                }
                fillDs.putProperty("DEPEND_" + i, (Object)dep);
            }
            double vmin = Double.NEGATIVE_INFINITY;
            double vmax = Double.POSITIVE_INFINITY;
            double fill = Double.NaN;
            try {
                double[] vminMaxFill = PlotElementUtil.parseFillValidRangeInternal(this.dsf.getValidRange(), this.dsf.getFill());
                vmin = vminMaxFill[0];
                vmax = vminMaxFill[1];
                fill = vminMaxFill[2];
            }
            catch (ParseException ex) {
                ex.printStackTrace();
            }
            AutoplotUtil.applyFillValidRange(fillDs, vmin, vmax, fill);
            this.setFillProperties(props);
            if (fillDs == this.getDataSet()) {
                this.fillDataSet = null;
            }
            this.setFillDataSet((QDataSet)fillDs);
        }
        finally {
            this.changesSupport.changePerformed(this, "fillDataSet");
        }
    }

    private synchronized void updateImmediately() {
        try {
            if (this.getDataSource() != null) {
                this.setStatus("busy: loading dataset");
                logger.log(Level.FINE, "loading dataset {0}", this.getDataSource());
                if (this.tsb != null) {
                    logger.log(Level.FINE, "   tsb= {0}", this.tsb.getURI());
                }
                this.loadDataSet();
                if (this.dataSet != null) {
                    this.setStatus("done loading dataset");
                    if (this.dsf.getUri().length() == 0) {
                        System.err.println("dsf.getUri was null");
                        return;
                    }
                } else if (!this.dom.controller.getStatus().startsWith("warning:")) {
                    this.setStatus("no data returned");
                }
            } else if (this.parentSources == null) {
                this.setDataSetInternal(null);
            } else {
                String prob = this.checkParents();
                if (prob != null) {
                    System.err.println(prob);
                }
            }
            if (this.dataSet != null) {
                this.setStatus("ready");
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            this.setStatus("error: " + ex);
            this.model.getExceptionHandler().handleUncaught((Throwable)ex);
        }
    }

    public void cancel() {
        ProgressMonitor monitor;
        DataSource dss = this.dataSource;
        if (dss != null && dss.asynchronousLoad() && !this.dom.controller.isHeadless() && (monitor = this.mon) != null) {
            logger.info("cancel running request");
            monitor.cancel();
        }
    }

    public synchronized void update() {
        this.changesSupport.performingChange(this, PENDING_UPDATE);
        this.setDataSet(null);
        Runnable run = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DataSourceController dataSourceController = DataSourceController.this;
                synchronized (dataSourceController) {
                    DataSourceController.this.updateImmediately();
                    if (DataSourceController.this.dataSource != null) {
                        if (DataSourceController.this.updating != null) {
                            DataSourceController.this.updating.removePropertyChangeListener(DataSourceController.this.updatesListener);
                        }
                        DataSourceController.this.updating = (Updating)DataSourceController.this.dataSource.getCapability(Updating.class);
                        if (DataSourceController.this.updating != null) {
                            DataSourceController.this.updating.addPropertyChangeListener(DataSourceController.this.updatesListener);
                        }
                    }
                }
                DataSourceController.this.changesSupport.changePerformed(this, DataSourceController.PENDING_UPDATE);
            }
        };
        if (this.getDataSource() != null && this.getDataSource().asynchronousLoad() && !this.dom.controller.isHeadless()) {
            logger.fine("invoke later do load");
            if (this.mon != null) {
                System.err.println("double load!");
                if (this.mon != null) {
                    this.mon.cancel();
                }
            }
            RequestProcessor.invokeLater((Runnable)run);
        } else {
            run.run();
        }
    }

    public Map<String, Object> getRawProperties() {
        return this.rawProperties;
    }

    public void setRawProperties(Map<String, Object> rawProperties) {
        Map<String, Object> oldRawProperties = this.rawProperties;
        this.rawProperties = rawProperties;
        this.propertyChangeSupport.firePropertyChange(PROP_RAWPROPERTIES, oldRawProperties, rawProperties);
    }

    public TimeSeriesBrowse getTsb() {
        return this.tsb;
    }

    public void setTsb(TimeSeriesBrowse tsb) {
        TimeSeriesBrowse oldTsb = this.tsb;
        this.tsb = tsb;
        this.propertyChangeSupport.firePropertyChange(PROP_TSB, oldTsb, tsb);
    }

    public String getTsbSuri() {
        return this.tsbSuri;
    }

    public void setTsbSuri(String tsbSuri) {
        String oldTsbSuri = this.tsbSuri;
        this.tsbSuri = tsbSuri;
        this.propertyChangeSupport.firePropertyChange(PROP_TSBSURI, oldTsbSuri, tsbSuri);
    }

    public Caching getCaching() {
        return this.caching;
    }

    public void setCaching(Caching caching) {
        Caching oldCaching = this.caching;
        this.caching = caching;
        this.propertyChangeSupport.firePropertyChange(PROP_CACHING, oldCaching, caching);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSource(DataSource dataSource) {
        DataSource oldDataSource = null;
        DataSourceController dataSourceController = this;
        synchronized (dataSourceController) {
            oldDataSource = this.dataSource;
            this.dataSource = dataSource;
        }
        this.propertyChangeSupport.firePropertyChange("dataSource", oldDataSource, dataSource);
    }

    public QDataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(QDataSet dataSet) {
        QDataSet oldDataSet = this.dataSet;
        this.dataSet = dataSet;
        this.dsf.setFilters("");
        this.propertyChangeSupport.firePropertyChange(PROP_DATASET, oldDataSet, dataSet);
    }

    public QDataSet getFillDataSet() {
        return this.fillDataSet;
    }

    public void setFillDataSet(QDataSet fillDataSet) {
        QDataSet oldFillDataSet = this.fillDataSet;
        this.fillDataSet = fillDataSet;
        this.propertyChangeSupport.firePropertyChange("fillDataSet", oldFillDataSet, fillDataSet);
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        Exception oldException = this.exception;
        this.exception = exception;
        this.propertyChangeSupport.firePropertyChange(PROP_EXCEPTION, oldException, exception);
    }

    public QDataSet getHistogram() {
        return this.histogram;
    }

    public void setHistogram(QDataSet histogram) {
        QDataSet oldHistogram = this.histogram;
        this.histogram = histogram;
        this.propertyChangeSupport.firePropertyChange(PROP_HISTOGRAM, oldHistogram, histogram);
    }

    public List<String> getDepnames() {
        return this.depnames;
    }

    public void setDepnames(List<String> newdepnames) {
        List<String> olddepnames = this.depnames;
        this.depnames = newdepnames;
        if (!((Object)newdepnames).equals(olddepnames)) {
            this.propertyChangeSupport.firePropertyChange(PROP_DEPNAMES, olddepnames, newdepnames);
        }
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        Map<String, Object> oldProperties = this.properties;
        this.properties = properties;
        this.propertyChangeSupport.firePropertyChange(PROP_PROPERTIES, oldProperties, properties);
    }

    public Map<String, Object> getFillProperties() {
        return this.fillProperties;
    }

    public void setFillProperties(Map<String, Object> fillProperties) {
        Map<String, Object> oldFillProperties = this.fillProperties;
        this.fillProperties = fillProperties;
        this.propertyChangeSupport.firePropertyChange(PROP_FILLPROPERTIES, oldFillProperties, fillProperties);
    }

    public String getReduceDataSetString() {
        return this.reduceDataSetString;
    }

    public void setReduceDataSetString(String reduceDataSetString) {
        String oldReduceDataSetString = this.reduceDataSetString;
        this.reduceDataSetString = reduceDataSetString;
        this.propertyChangeSupport.firePropertyChange(PROP_REDUCEDATASETSTRING, oldReduceDataSetString, reduceDataSetString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized QDataSet loadDataSet() {
        ProgressMonitor mymon;
        QDataSet result = null;
        this.mon = mymon = this.getMonitor("loading data", "loading " + this.getDataSource());
        try {
            result = this.getDataSource().getDataSet(mymon);
            if (this.dsf.getUri().length() > 0) {
                this.model.addRecent(this.dsf.getUri());
            }
            logger.log(Level.FINE, "{0} read dataset: {1}", new Object[]{this.getDataSource(), result});
            Map props = this.getDataSource().getMetadata((ProgressMonitor)new NullProgressMonitor());
            this.setDataSetInternal(result, props, this.dom.controller.isValueAdjusting());
            if (this.getTsb() == null && this.getDataSource().getCapability(TimeSeriesBrowse.class) != null) {
                TimeSeriesBrowse tsb1 = (TimeSeriesBrowse)this.getDataSource().getCapability(TimeSeriesBrowse.class);
                PlotElement pe = this.getPlotElement();
                if (pe != null && this.doesPlotElementSupportTsb(pe)) {
                    this.setTsb(tsb1);
                    this.timeSeriesBrowseController = new TimeSeriesBrowseController(this, pe);
                    this.timeSeriesBrowseController.setup(false);
                }
            }
        }
        catch (InterruptedIOException ex) {
            this.setException(ex);
            this.setDataSet(null);
            this.setStatus("interrupted");
            if (this.dsf.getUri().length() > 0) {
                this.model.addException(this.dsf.getUri(), ex);
            }
        }
        catch (CancelledOperationException ex) {
            this.setException((Exception)((Object)ex));
            this.setDataSet(null);
            this.setStatus("operation cancelled");
            if (this.dsf.getUri().length() > 0) {
                this.model.addException(this.dsf.getUri(), (Exception)((Object)ex));
            }
        }
        catch (NoDataInIntervalException e) {
            this.setException((Exception)((Object)e));
            this.setDataSet(null);
            this.setStatus("warning: " + e.getMessage());
            if (this.dsf.getController().getTsb() == null) {
                String title = "no data in interval";
                this.model.showMessage("warning: " + e.getMessage(), title, 2);
            }
        }
        catch (HtmlResponseIOException ex) {
            HtmlResponseIOException htmlEx = ex;
            if (htmlEx.getURL() != null) {
                final String link = htmlEx.getURL().toString();
                JPanel p = new JPanel(new BorderLayout());
                p.add((Component)new JLabel("<html>Unable to open URI: <br>" + this.dsf.getUri() + "<br><br>Downloaded file appears to be HTML.<br><a href=\"" + link + "\">" + link + "</a><br>"), "Center");
                JPanel p1 = new JPanel(new BorderLayout());
                p1.add((Component)new JButton(new AbstractAction("View Page"){

                    public void actionPerformed(ActionEvent ev) {
                        AutoplotUtil.openBrowser(link);
                    }
                }), "East");
                p.add((Component)p1, "South");
                JOptionPane.showMessageDialog((Component)this.model.getCanvas(), p);
            } else {
                JOptionPane.showMessageDialog((Component)this.model.getCanvas(), "<html>Unable to open URI: <br>" + this.dsf.getUri() + "<br><br>" + (Object)((Object)ex));
            }
        }
        catch (IOException e) {
            if (e instanceof FileNotFoundException || e.getMessage() != null && (e.getMessage().contains("No such file") || e.getMessage().contains("timed out"))) {
                String message = e.getMessage();
                if (message.startsWith("550 ")) {
                    message = message.substring(4);
                }
                this.setException(e);
                this.setDataSet(null);
                this.setStatus("warning: " + message);
                String title = e.getMessage().contains("No such file") ? "File not found" : e.getMessage();
                this.model.showMessage(message, title, 2);
            } else if (e.getMessage() != null && e.getMessage().contains("root does not exist")) {
                this.setException(e);
                this.setDataSet(null);
                this.setStatus("warning: " + e.getMessage());
                String title = e.getMessage().contains("No such file") ? "Root does not exist" : e.getMessage();
                this.model.showMessage(e.getMessage(), title, 2);
            } else if (e.getMessage() == null) {
                this.setException(e);
                e.printStackTrace();
                this.setDataSet(null);
                this.setStatus("error: " + e.getClass());
                this.handleException(e);
            } else {
                this.setException(e);
                this.setDataSet(null);
                this.setStatus("error: " + e.getMessage());
                this.handleException(e);
            }
            if (this.dsf.getUri().length() > 0) {
                this.model.addException(this.dsf.getUri(), e);
            }
        }
        catch (Exception e) {
            this.setException(e);
            this.setDataSet(null);
            e.printStackTrace();
            this.setStatus("error: " + e.getMessage());
            this.handleException(e);
            if (this.dsf.getUri().length() > 0) {
                this.model.addException(this.dsf.getUri(), e);
            }
        }
        finally {
            mymon.finished();
            if (mymon == this.mon) {
                this.mon = null;
            } else {
                System.err.println("not my mon, somebody better delete it!");
            }
        }
        return result;
    }

    public synchronized void setSuri(String suri, ProgressMonitor mon) {
        this.dsf.setUri(suri);
        this.setUriNeedsResolution(true);
    }

    public synchronized void resetSuri(String suri, ProgressMonitor mon) {
        String old = this.dsf.getUri();
        if (old.length() > 0 && old.equals(suri)) {
            this.dsf.setUri("");
        }
        this.setSuri(suri, mon);
    }

    private void resolveDataSource(boolean valueWasAdjusting, ProgressMonitor mon) {
        String surl;
        Caching cache1 = this.getCaching();
        if (this.dom.getController().isValueAdjusting()) {
            System.err.println("return of bug first demoed by test033: where the adjusting property is breifly cleared. " + this.dom.getController().changesSupport.isValueAdjusting());
            System.err.println("See https://sourceforge.net/tracker/?func=detail&aid=3409414&group_id=199733&atid=970682");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DataSourceController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if ((surl = this.dsf.getUri()).length() == 0) {
            this.getApplication().getController().deleteParentsOfDataSourceFilter(this.dsf);
            this.clearParentSources();
            this.resetDataSource(valueWasAdjusting, null);
            this.setUriNeedsResolution(false);
            this.setDataSetNeedsLoading(false);
        } else {
            URISplit split = URISplit.parse((String)surl);
            surl = URISplit.format((URISplit)split);
            try {
                mon.started();
                mon.setProgressMessage("getting " + surl);
                if (cache1 != null && cache1.satisfies(surl)) {
                    cache1.resetURI(surl);
                    this.propertyChangeSupport.firePropertyChange("dataSource", null, this.dataSource);
                    this.update();
                    return;
                }
                if (URISplit.implicitVapScheme((URISplit)split).equals("vap+internal")) {
                    this.clearParentSources();
                    this.resetDataSource(valueWasAdjusting, null);
                    boolean ok = this.doInternal(split.path);
                    String msg = null;
                    if (!ok) {
                        msg = this.dom.controller.getStatus();
                    }
                    if (!ok) {
                        this.dom.controller.setStatus(msg);
                    }
                } else {
                    DataSource source = DataSetURI.getDataSource((String)surl);
                    this.clearParentSources();
                    this.resetDataSource(valueWasAdjusting, source);
                }
                this.setUriNeedsResolution(false);
                mon.setProgressMessage("done getting data source");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            finally {
                mon.finished();
            }
        }
    }

    public boolean isUriNeedsResolution() {
        return this.uriNeedsResolution;
    }

    public void setUriNeedsResolution(boolean uriNeedsResolution) {
        boolean oldUriNeedsResolution = this.uriNeedsResolution;
        this.uriNeedsResolution = uriNeedsResolution;
        this.propertyChangeSupport.firePropertyChange(PROP_URINEEDSRESOLUTION, oldUriNeedsResolution, uriNeedsResolution);
    }

    public boolean isDataSetNeedsLoading() {
        return this.dataSetNeedsLoading;
    }

    public void setDataSetNeedsLoading(boolean dataSetNeedsLoading) {
        boolean oldDataSetNeedsLoading = this.dataSetNeedsLoading;
        this.dataSetNeedsLoading = dataSetNeedsLoading;
        this.propertyChangeSupport.firePropertyChange(PROP_DATASETNEEDSLOADING, oldDataSetNeedsLoading, dataSetNeedsLoading);
    }

    public boolean isResetDimensions() {
        return this.resetDimensions;
    }

    public void setResetDimensions(boolean resetDimensions) {
        boolean oldResetDimensions = this.resetDimensions;
        this.resetDimensions = resetDimensions;
        this.propertyChangeSupport.firePropertyChange(PROP_RESETDIMENSIONS, oldResetDimensions, resetDimensions);
    }

    public Application getApplication() {
        return this.dom;
    }

    public TimeSeriesBrowseController getTimeSeriesBrowseController() {
        return this.timeSeriesBrowseController;
    }

    @Override
    public boolean isPendingChanges() {
        TimeSeriesBrowseController tsbc = this.timeSeriesBrowseController;
        if (tsbc != null && tsbc.isPendingChanges()) {
            return true;
        }
        return super.isPendingChanges();
    }

    private void handleException(Exception e) {
        if (this.model.getExceptionHandler() == null) {
            e.printStackTrace();
        } else if (e.getMessage() != null && e.getMessage().contains("nsupported protocol")) {
            this.model.showMessage(e.getMessage(), "Unsupported Protocol", 0);
        } else {
            System.err.println(this.model.getExceptionHandler());
            this.model.getExceptionHandler().handle((Throwable)e);
        }
    }

    private PlotElement getPlotElement() {
        List<PlotElement> pele = this.dom.controller.getPlotElementsFor(this.dsf);
        if (pele.size() == 0) {
            return null;
        }
        return pele.get(0);
    }

    private ProgressMonitor getMonitor(String label, String description) {
        PlotElement pele = this.getPlotElement();
        DasPlot p = null;
        if (pele != null) {
            Plot plot = this.dom.controller.getPlotFor(pele);
            if (plot != null) {
                p = plot.controller.getDasPlot();
            }
        } else {
            Plot plot = this.dom.controller.getFirstPlotFor(this.dsf);
            if (plot != null) {
                p = plot.controller.getDasPlot();
            }
        }
        if (p != null) {
            return this.dom.controller.getMonitorFactory().getMonitor((DasCanvasComponent)p, label, description);
        }
        return this.dom.controller.getMonitorFactory().getMonitor(label, description);
    }

    private void setStatus(String string) {
        this.dom.controller.setStatus(string);
    }

    public String toString() {
        return this.dsf + " controller";
    }

    class InternalTimeSeriesBrowse
    implements TimeSeriesBrowse {
        String uri;
        DatumRange timerange;
        List<TimeSeriesBrowse> parentTsbs = new ArrayList<TimeSeriesBrowse>();

        private InternalTimeSeriesBrowse(String uri) {
            this.uri = uri;
        }

        public void addTimeSeriesBrowse(TimeSeriesBrowse tsb) {
            this.parentTsbs.add(tsb);
            if (this.parentTsbs.size() == 1) {
                this.setTimeRange(tsb.getTimeRange());
                this.setTimeResolution(tsb.getTimeResolution());
            }
        }

        public void setTimeRange(DatumRange dr) {
            for (TimeSeriesBrowse tsb : this.parentTsbs) {
                tsb.setTimeRange(dr);
            }
            this.timerange = dr;
            DataSourceController.this.checkParents();
        }

        public DatumRange getTimeRange() {
            return this.timerange;
        }

        public void setTimeResolution(Datum d) {
            for (TimeSeriesBrowse tsb : this.parentTsbs) {
                tsb.setTimeResolution(d);
            }
        }

        public Datum getTimeResolution() {
            return this.parentTsbs.get(0).getTimeResolution();
        }

        public String getURI() {
            Datum res = this.getTimeResolution();
            return this.uri + "?range=" + this.getTimeRange() + (res == null ? "" : "&resolution=" + res);
        }

        public String toString() {
            Datum res = this.getTimeResolution();
            return "inttsb: " + this.getTimeRange() + " " + (res == null ? "" : "&resolution=" + res);
        }

        public void setURI(String suri) throws ParseException {
            throw new IllegalArgumentException("not implemented");
        }
    }
}

