/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.dom;

import java.awt.Font;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.das2.graph.DasRow;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.ApplicationController;
import org.virbo.autoplot.dom.BindingModel;
import org.virbo.autoplot.dom.Canvas;
import org.virbo.autoplot.dom.Column;
import org.virbo.autoplot.dom.DataSourceFilter;
import org.virbo.autoplot.dom.DomUtil;
import org.virbo.autoplot.dom.Plot;
import org.virbo.autoplot.dom.PlotElement;
import org.virbo.autoplot.dom.Row;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomOps {
    public static void swapPosition(Plot a, Plot b) {
        String trowid = a.getRowId();
        String tcolumnid = a.getColumnId();
        boolean txtv = a.getXaxis().isDrawTickLabels();
        boolean tytv = a.getYaxis().isDrawTickLabels();
        a.setRowId(b.getRowId());
        a.setColumnId(b.getColumnId());
        a.getXaxis().setDrawTickLabels(b.getXaxis().isDrawTickLabels());
        a.getYaxis().setDrawTickLabels(b.getYaxis().isDrawTickLabels());
        b.setRowId(trowid);
        b.setColumnId(tcolumnid);
        b.getXaxis().setDrawTickLabels(txtv);
        b.getYaxis().setDrawTickLabels(tytv);
    }

    public static Plot copyPlot(Plot srcPlot, boolean bindx, boolean bindy, Object direction) {
        Application application = srcPlot.getController().getApplication();
        ApplicationController ac = application.getController();
        Plot that = ac.addPlot(direction);
        that.getController().setAutoBinding(false);
        that.syncTo(srcPlot, Arrays.asList("id", "rowId", "columnId"));
        if (bindx) {
            BindingModel bb = ac.findBinding(application, "timeRange", srcPlot.getXaxis(), "range");
            if (bb == null) {
                ac.bind(srcPlot.getXaxis(), "range", that.getXaxis(), "range");
            } else {
                ac.bind(application, "timeRange", that.getXaxis(), "range");
            }
        }
        if (bindy) {
            ac.bind(srcPlot.getYaxis(), "range", that.getYaxis(), "range");
        }
        return that;
    }

    public static List<PlotElement> copyPlotElements(Plot srcPlot, Plot dstPlot) {
        DataSourceFilter dsf = null;
        ApplicationController ac = srcPlot.getController().getApplication().getController();
        List<PlotElement> srcElements = ac.getPlotElementsFor(srcPlot);
        ArrayList<PlotElement> newElements = new ArrayList<PlotElement>();
        for (PlotElement srcElement : srcElements) {
            PlotElement newp;
            if (!srcElement.getComponent().equals("")) {
                if (srcElement.getController().getParentPlotElement() != null) continue;
                newp = ac.copyPlotElement(srcElement, dstPlot, dsf);
                newElements.add(newp);
                continue;
            }
            newp = ac.copyPlotElement(srcElement, dstPlot, dsf);
            newElements.add(newp);
            List<PlotElement> srcKids = srcElement.controller.getChildPlotElements();
            ArrayList<PlotElement> newKids = new ArrayList<PlotElement>();
            DataSourceFilter dsf1 = ac.getDataSourceFilterFor(newp);
            for (PlotElement k : srcKids) {
                if (!srcElements.contains(k)) continue;
                PlotElement kidp = ac.copyPlotElement(k, dstPlot, dsf1);
                kidp.getController().setParentPlotElement(newp);
                newElements.add(kidp);
                newKids.add(kidp);
            }
        }
        return newElements;
    }

    public static Plot copyPlotAndPlotElements(Plot srcPlot, boolean copyPlotElements, boolean bindx, boolean bindy, Object direction) {
        Plot dstPlot = DomOps.copyPlot(srcPlot, bindx, bindy, direction);
        if (copyPlotElements) {
            DomOps.copyPlotElements(srcPlot, dstPlot);
        }
        return dstPlot;
    }

    public static Column getOrCreateSelectedColumn(Application dom, List<Plot> selectedPlots, boolean create) {
        ArrayList<String> n = new ArrayList<String>();
        for (Plot p : selectedPlots) {
            n.add(p.getColumnId());
        }
        if (n.size() == 1) {
            return (Column)DomUtil.getElementById(dom, (String)n.get(0));
        }
        if (create) {
            Canvas c = dom.getCanvases(0);
            Column col = c.getController().addColumn();
            col.setLeft("0%");
            col.setRight("100%");
            return col;
        }
        return null;
    }

    public static Row getOrCreateSelectedRow(Application dom, List<Plot> selectedPlots, boolean create) {
        ArrayList<String> n = new ArrayList<String>();
        for (Plot p : selectedPlots) {
            if (n.contains(p.getRowId())) continue;
            n.add(p.getRowId());
        }
        if (n.size() == 1) {
            return (Row)DomUtil.getElementById(dom, (String)n.get(0));
        }
        if (create) {
            Row r;
            Row rmax = r = (Row)DomUtil.getElementById(dom.getCanvases(0), (String)n.get(0));
            Row rmin = r;
            for (int i = 1; i < n.size(); ++i) {
                r = (Row)DomUtil.getElementById(dom.getCanvases(0), (String)n.get(i));
                if (r.getController().getDasRow().getDMaximum() > rmax.getController().getDasRow().getDMaximum()) {
                    rmax = r;
                }
                if (r.getController().getDasRow().getDMinimum() >= rmin.getController().getDasRow().getDMinimum()) continue;
                rmin = r;
            }
            Canvas c = dom.getCanvases(0);
            Row row = c.getController().addRow();
            row.setTop(rmin.getTop());
            row.setBottom(rmax.getBottom());
            return row;
        }
        return null;
    }

    public static Plot[] bottomAndTopMostPlot(Application dom, List<Plot> plots) {
        Row r;
        Plot pmax = plots.get(0);
        Plot pmin = plots.get(0);
        Row rmax = r = (Row)DomUtil.getElementById(dom.getCanvases(0), pmax.getRowId());
        Row rmin = r;
        for (Plot p : plots) {
            r = (Row)DomUtil.getElementById(dom.getCanvases(0), p.getRowId());
            if (r.getController().getDasRow().getDMaximum() > rmax.getController().getDasRow().getDMaximum()) {
                rmax = r;
                pmax = p;
            }
            if (r.getController().getDasRow().getDMinimum() >= rmin.getController().getDasRow().getDMinimum()) continue;
            rmin = r;
            pmin = p;
        }
        return new Plot[]{pmax, pmin};
    }

    public static List<Plot> getPlotsFor(Application dom, Row row, boolean visible) {
        ArrayList<Plot> result = new ArrayList<Plot>();
        for (Plot p : dom.getPlots()) {
            if (!p.getRowId().equals(row.getId())) continue;
            if (visible) {
                if (!p.isVisible()) continue;
                result.add(p);
                continue;
            }
            result.add(p);
        }
        return result;
    }

    private static int lineCount(String s) {
        if (s.trim().length() == 0) {
            return 0;
        }
        return s.split("![cC]").length;
    }

    public static void newCanvasLayout(Application dom) {
        Canvas canvas = dom.getCanvases(0);
        double emToPixels = Font.decode(dom.getCanvases((int)0).font).getSize();
        double pixelsToEm = 1.0 / emToPixels;
        Row[] rows = canvas.getRows();
        int nrow = rows.length;
        double TotalPlotHeight = 0.0;
        for (int i = 0; i < nrow; ++i) {
            Plot[] plots = DomOps.getPlotsFor(dom, rows[i], true).toArray(new Plot[0]);
            if (plots.length <= 0) continue;
            DasRow dasRow = rows[i].getController().dasRow;
            TotalPlotHeight += (double)dasRow.getHeight();
        }
        double[] MaxUp = new double[nrow];
        double[] MaxDown = new double[nrow];
        for (int i = 0; i < nrow; ++i) {
            Plot[] plots = DomOps.getPlotsFor(dom, rows[i], true).toArray(new Plot[0]);
            double MaxUpJEm = 0.0;
            double MaxDownJ = 0.0;
            for (int j = 0; j < plots.length; ++j) {
                String title = plots[j].getTitle();
                MaxUpJEm = DomOps.lineCount(title);
                if (MaxUpJEm > 0.0) {
                    MaxUpJEm += 1.0;
                }
                MaxUp[i] = Math.max(MaxUp[i], MaxUpJEm * emToPixels);
                Rectangle plot = plots[j].getController().getDasPlot().getBounds();
                Rectangle axis = plots[j].getXaxis().getController().getDasAxis().getBounds();
                MaxDownJ = axis.getY() + axis.getHeight() - (plot.getY() + plot.getHeight()) + 3.0;
                MaxDown[i] = Math.max(MaxDown[i], MaxDownJ);
            }
        }
        double[] RelativePlotHeight = new double[nrow];
        for (int i = 0; i < nrow; ++i) {
            DasRow dasRow = rows[i].getController().dasRow;
            RelativePlotHeight[i] = 1.0 * (double)dasRow.getHeight() / TotalPlotHeight;
        }
        double NewPlotTotalHeight = canvas.height;
        for (int i = 0; i < nrow; ++i) {
            NewPlotTotalHeight = NewPlotTotalHeight - MaxUp[i] - MaxDown[i];
        }
        double[] PlotHeight = new double[nrow];
        for (int i = 0; i < nrow; ++i) {
            PlotHeight[i] = NewPlotTotalHeight * RelativePlotHeight[i];
        }
        double[] NormalPlotHeight = new double[nrow];
        for (int i = 0; i < nrow; ++i) {
            NormalPlotHeight[i] = (PlotHeight[i] + MaxUp[i] + MaxDown[i]) / (double)canvas.height;
        }
        double position = 0.0;
        for (int i = 0; i < nrow; ++i) {
            String newTop = String.format("%.2f%%%+.1fem", 100.0 * position, MaxUp[i] * pixelsToEm);
            rows[i].setTop(newTop);
            String newBottom = String.format("%.2f%%%+.1fem", 100.0 * (position += NormalPlotHeight[i]), -1.0 * MaxDown[i] * pixelsToEm);
            rows[i].setBottom(newBottom);
        }
    }
}

