/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.dom;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JMenuItem;
import org.das2.components.DasProgressPanel;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasPlot;
import org.das2.graph.DefaultPlotSymbol;
import org.das2.graph.DigitalRenderer;
import org.das2.graph.EventsRenderer;
import org.das2.graph.ImageVectorDataSetRenderer;
import org.das2.graph.PitchAngleDistributionRenderer;
import org.das2.graph.PlotSymbol;
import org.das2.graph.PsymConnector;
import org.das2.graph.RGBImageRenderer;
import org.das2.graph.Renderer;
import org.das2.graph.SeriesRenderer;
import org.das2.graph.SpectrogramRenderer;
import org.das2.system.RequestProcessor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.beansbinding.Converter;
import org.virbo.autoplot.ApplicationModel;
import org.virbo.autoplot.AutoplotUtil;
import org.virbo.autoplot.RenderType;
import org.virbo.autoplot.RenderTypeUtil;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.ApplicationController;
import org.virbo.autoplot.dom.Axis;
import org.virbo.autoplot.dom.ChangesSupport;
import org.virbo.autoplot.dom.DataSourceController;
import org.virbo.autoplot.dom.DataSourceFilter;
import org.virbo.autoplot.dom.DomNode;
import org.virbo.autoplot.dom.DomNodeController;
import org.virbo.autoplot.dom.DomUtil;
import org.virbo.autoplot.dom.Plot;
import org.virbo.autoplot.dom.PlotController;
import org.virbo.autoplot.dom.PlotElement;
import org.virbo.autoplot.dom.PlotElementControllerUtil;
import org.virbo.autoplot.dom.PlotElementStyle;
import org.virbo.autoplot.dom.PlotElementUtil;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.JoinDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.datasource.capability.TimeSeriesBrowse;
import org.virbo.dsops.Ops;
import org.virbo.metatree.MetadataUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotElementController
extends DomNodeController {
    private static final String PENDING_RESET_RANGE = "resetRanges";
    private static final String PENDING_SET_DATASET = "setDataSet";
    private static final String PENDING_COMPONENT_OP = "componentOp";
    static final Logger logger = Logger.getLogger("vap.plotElementController");
    private final Application dom;
    private PlotElement plotElement;
    private DataSourceFilter dsf;
    public static final int SYMSIZE_DATAPOINT_COUNT = 500;
    public static final int LARGE_DATASET_COUNT = 30000;
    private QDataSet processDataSet = null;
    String procressStr = null;
    PropertyChangeListener dsfListener = new PropertyChangeListener(){

        public String toString() {
            return "" + PlotElementController.this;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("filters")) {
                logger.log(Level.FINE, "property change in DSF means I need to autorange: {0}", evt.getPropertyName());
                PlotElementController.this.setResetRanges(true);
                PlotElementController.this.maybeSetPlotAutorange();
            }
        }
    };
    PropertyChangeListener plotElementListener = new PropertyChangeListener(){

        public String toString() {
            return "" + PlotElementController.this;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            logger.log(Level.FINE, "plotElementListener: {0} {1}->{2}", new Object[]{evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()});
            if (evt.getPropertyName().equals("renderType") && !PlotElementController.this.isValueAdjusting()) {
                if (PlotElementController.this.dom.getController().isValueAdjusting()) {
                    // empty if block
                }
                RenderType newRenderType = (RenderType)((Object)evt.getNewValue());
                RenderType oldRenderType = (RenderType)((Object)evt.getOldValue());
                PlotElement parentEle = PlotElementController.this.getParentPlotElement();
                if (parentEle != null) {
                    parentEle.setRenderType(newRenderType);
                } else {
                    if (PlotElementController.this.axisDimensionsChange(oldRenderType, newRenderType)) {
                        PlotElementController.this.resetRanges = true;
                        PlotElementController.this.resetPlotElement(PlotElementController.this.getDataSourceFilter().getController().getFillDataSet(), PlotElementController.this.plotElement.getRenderType());
                    } else {
                        PlotElementController.this.doResetRenderType(newRenderType);
                        PlotElementController.this.updateDataSet();
                    }
                    PlotElementController.this.setResetPlotElement(false);
                }
            } else if (evt.getPropertyName().equals("dataSourceFilterId")) {
                PlotElementController.this.changeDataSourceFilter();
                if (PlotElementController.this.dsfReset) {
                    if (evt.getOldValue() != null) {
                        PlotElementController.this.setResetPlotElement(true);
                        PlotElementController.this.setResetRanges(true);
                    }
                    if (evt.getNewValue().equals("")) {
                        if (PlotElementController.this.getRenderer() != null) {
                            PlotElementController.this.getRenderer().setDataSet(null);
                        }
                    } else {
                        PlotElementController.this.updateDataSet();
                    }
                }
            } else if (evt.getPropertyName().equals("component")) {
                String newv = (String)evt.getNewValue();
                if (DataSetOps.changesDimensions((String)((String)evt.getOldValue()), (String)newv)) {
                    logger.log(Level.FINER, "component property change requires we reset render and dimensions: {0}->{1}", new Object[]{(String)evt.getOldValue(), (String)evt.getNewValue()});
                    PlotElementController.this.setResetPlotElement(true);
                    PlotElementController.this.setResetRanges(true);
                    if (!PlotElementController.this.dom.getController().isValueAdjusting()) {
                        PlotElementController.this.maybeSetPlotAutorange();
                    }
                }
                if (PlotElementController.this.sliceAutoranges) {
                    PlotElementController.this.setResetPlotElement(true);
                    PlotElementController.this.setResetRanges(true);
                    if (!PlotElementController.this.dom.getController().isValueAdjusting()) {
                        PlotElementController.this.maybeSetPlotAutorange();
                    }
                }
                if (newv.startsWith("|")) {
                    PlotElementController.this.dom.getOptions().setDataVisible(true);
                }
                Runnable run = new Runnable(){

                    public void run() {
                        List<Object> lock = PlotElementController.this.changesSupport.whoIsChanging(PlotElementController.PENDING_COMPONENT_OP);
                        if (lock.isEmpty()) {
                            PlotElementController.this.changesSupport.performingChange(PlotElementController.this.plotElementListener, PlotElementController.PENDING_COMPONENT_OP);
                        } else if (!lock.contains(PlotElementController.this.plotElementListener)) {
                            throw new IllegalStateException("shouldn't happen");
                        }
                        PlotElementController.this.setStatus("busy: update data set");
                        PlotElementController.this.updateDataSet();
                        PlotElementController.this.setStatus("done update data set");
                        if (lock.isEmpty()) {
                            PlotElementController.this.changesSupport.changePerformed(PlotElementController.this, PlotElementController.PENDING_COMPONENT_OP);
                        }
                    }
                };
                if (PlotElementController.this.isAsyncProcess(newv)) {
                    RequestProcessor.invokeLater((Runnable)run);
                } else {
                    run.run();
                }
            }
        }
    };
    PropertyChangeListener parentStyleListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            try {
                DomUtil.setPropertyValue(((PlotElementController)PlotElementController.this).plotElement.style, evt.getPropertyName(), evt.getNewValue());
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(PlotElementController.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(PlotElementController.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(PlotElementController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    };
    PropertyChangeListener styleListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("rebinMethod") && (PlotElementController.this.plotElement.getRenderType() == RenderType.nnSpectrogram || PlotElementController.this.plotElement.getRenderType() == RenderType.spectrogram)) {
                if (evt.getNewValue() == SpectrogramRenderer.RebinnerEnum.nearestNeighbor) {
                    ((PlotElementController)PlotElementController.this).plotElement.renderType = RenderType.nnSpectrogram;
                } else if (evt.getNewValue() == SpectrogramRenderer.RebinnerEnum.binAverage) {
                    ((PlotElementController)PlotElementController.this).plotElement.renderType = RenderType.spectrogram;
                }
            }
        }
    };
    public static final String PROP_DATASET = "dataSet";
    protected QDataSet dataSet = null;
    PropertyChangeListener fillDataSetListener = new PropertyChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void propertyChange(PropertyChangeEvent evt) {
            if (!Arrays.asList(PlotElementController.this.dom.getPlotElements()).contains(PlotElementController.this.plotElement)) {
                return;
            }
            PlotElementController.this.changesSupport.performingChange(this, PlotElementController.PENDING_SET_DATASET);
            try {
                QDataSet fillDs = ((PlotElementController)PlotElementController.this).dsf.controller.getFillDataSet();
                logger.log(Level.FINE, "{0} got new dataset: {1}  resetComponent={2}  resetPele={3}  resetRanges={4}", new Object[]{PlotElementController.this.plotElement, fillDs, PlotElementController.this.resetComponent, PlotElementController.this.resetPlotElement, PlotElementController.this.resetRanges});
                if (PlotElementController.this.resetComponent) {
                    PlotElementController.this.plotElement.setComponent("");
                    ((PlotElementController)PlotElementController.this).plotElement.autoComponent = true;
                    PlotElementController.this.setResetComponent(false);
                }
                PlotElementController.this.updateDataSet();
            }
            finally {
                PlotElementController.this.changesSupport.changePerformed(this, PlotElementController.PENDING_SET_DATASET);
            }
        }

        public String toString() {
            return "" + PlotElementController.this;
        }
    };
    PropertyChangeListener dataSourceDataSetListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (PlotElementController.this.dsfReset) {
                PlotElementController.this.setResetComponent(true);
                PlotElementController.this.setResetPlotElement(true);
                PlotElementController.this.setResetRanges(true);
                PlotElementController.this.plotElement.setAutoLabel(true);
                PlotElementController.this.plotElement.setAutoComponent(true);
                PlotElementController.this.plotElement.setAutoRenderType(true);
                PlotElementController.this.maybeSetPlotAutorange();
            }
        }
    };
    public static final String PROP_RESETRANGES = "resetRanges";
    private boolean resetRanges = false;
    public static final String PROP_RESETPLOTELEMENT = "resetPlotElement";
    private boolean resetPlotElement = false;
    public static final String PROP_RESETCOMPONENT = "resetComponent";
    private boolean resetComponent = false;
    public static final String PROP_RESETRENDERTYPE = "resetRenderType";
    private boolean resetRenderType = false;
    public static final String PROP_DSFRESET = "dsfReset";
    private boolean dsfReset = true;
    private boolean sliceAutoranges = false;
    public static final String PROP_SLICEAUTORANGES = "sliceAutoranges";
    protected Renderer renderer = null;
    private PropertyChangeListener parentComponentLister;

    public PlotElementController(ApplicationModel model, Application dom, PlotElement plotElement) {
        super(plotElement);
        this.dom = dom;
        this.plotElement = plotElement;
        plotElement.addPropertyChangeListener("renderType", this.plotElementListener);
        plotElement.addPropertyChangeListener("dataSourceFilterId", this.plotElementListener);
        plotElement.addPropertyChangeListener("component", this.plotElementListener);
        plotElement.getStyle().addPropertyChangeListener(this.styleListener);
    }

    public List<PlotElement> getChildPlotElements() {
        ArrayList<PlotElement> result = new ArrayList<PlotElement>();
        for (PlotElement pp : this.dom.plotElements) {
            if (!pp.getParent().equals(this.plotElement.getId())) continue;
            result.add(pp);
        }
        return result;
    }

    protected void setChildPlotElements(List<PlotElement> peles) {
        for (PlotElement p : peles) {
            p.setParent(this.plotElement.getId());
        }
    }

    protected void setParentPlotElement(PlotElement p) {
        this.plotElement.setParent(p.getId());
    }

    public PlotElement getParentPlotElement() {
        if (this.plotElement.getParent().equals("")) {
            return null;
        }
        for (PlotElement pp : this.dom.plotElements) {
            if (!pp.getId().equals(this.plotElement.getParent())) continue;
            return pp;
        }
        return null;
    }

    void unbindDsf() {
        this.dsf.removePropertyChangeListener("filters", this.dsfListener);
        this.dsf.controller.removePropertyChangeListener("fillDataSet", this.fillDataSetListener);
        this.dsf.controller.removePropertyChangeListener("dataSource", this.dataSourceDataSetListener);
    }

    private void changeDataSourceFilter() {
        if (this.dsf != null) {
            this.unbindDsf();
            List<DomNode> usages = DomUtil.dataSourceUsages(this.dom, this.dsf.getId());
            if (usages.isEmpty()) {
                this.dom.controller.deleteDataSourceFilter(this.dsf);
            }
        }
        assert (this.plotElement.getDataSourceFilterId() != null);
        if (this.plotElement.getDataSourceFilterId().equals("")) {
            return;
        }
        this.dsf = this.dom.controller.getDataSourceFilterFor(this.plotElement);
        if (this.dsf == null) {
            throw new NullPointerException("couldn't find the data for this plot element");
        }
        this.dsf.addPropertyChangeListener("filters", this.dsfListener);
        this.setDataSourceFilterController(this.dsf.controller);
    }

    private Color deriveColor(Color color, int i) {
        float[] colorHSV = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        if (colorHSV[2] < 0.7f) {
            colorHSV[2] = 0.7f;
        }
        if (colorHSV[1] < 0.7f) {
            colorHSV[1] = 0.7f;
        }
        return Color.getHSBColor((float)i / 6.0f, colorHSV[1], colorHSV[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QDataSet processDataSet(String c, QDataSet fillDs) throws RuntimeException {
        String label = null;
        if (c.length() > 0 && !c.startsWith("|")) {
            int idx;
            if (!this.plotElement.getComponent().equals("") && fillDs.length() > 0 && fillDs.rank() == 2) {
                String[] labels = SemanticOps.getComponentLabels((QDataSet)fillDs);
                String comp = this.plotElement.getComponent();
                int ip = comp.indexOf("|");
                if (ip != -1) {
                    comp = comp.substring(0, ip);
                }
                comp = Ops.saferName((String)comp);
                if (fillDs.property("BUNDLE_1") != null) {
                    fillDs = DataSetOps.unbundle((QDataSet)fillDs, (String)comp);
                    label = comp;
                } else {
                    boolean found = false;
                    for (int i = 0; i < labels.length; ++i) {
                        if (!Ops.saferName((String)labels[i]).equals(comp)) continue;
                        fillDs = DataSetOps.slice1((QDataSet)fillDs, (int)i);
                        label = labels[i];
                        found = true;
                        break;
                    }
                    if (!found) {
                        throw new IllegalArgumentException("component not found: " + comp);
                    }
                }
                if (label == null && !this.isPendingChanges()) {
                    RuntimeException ex = new RuntimeException("component not found: " + comp);
                    throw ex;
                }
            }
            c = (idx = c.indexOf("|")) == -1 ? "" : c.substring(idx);
        }
        if (c.length() > 5 && c.startsWith("|")) {
            if (DataSetOps.isProcessAsync((String)c)) {
                PlotElementController plotElementController = this;
                synchronized (plotElementController) {
                    if (c.equals(this.procressStr) && this.processDataSet != null) {
                        fillDs = this.processDataSet;
                    } else {
                        this.processDataSet = null;
                        this.procressStr = null;
                        DasProgressPanel mon = DasProgressPanel.createComponentPanel((DasCanvasComponent)this.getDasPlot(), (String)"process data set");
                        fillDs = DataSetOps.sprocess((String)c, (QDataSet)fillDs, (ProgressMonitor)mon);
                        if (mon.isCancelled()) {
                            this.processDataSet = null;
                            this.procressStr = null;
                        } else {
                            this.processDataSet = fillDs;
                            this.procressStr = c;
                        }
                    }
                }
            }
            PlotElementController plotElementController = this;
            synchronized (plotElementController) {
                this.processDataSet = null;
                this.procressStr = null;
            }
            fillDs = DataSetOps.sprocess((String)c, (QDataSet)fillDs, null);
        }
        return fillDs;
    }

    Map<String, Object> processProperties(String c, Map<String, Object> properties) {
        if (c.length() > 5 && c.startsWith("|")) {
            properties = MetadataUtil.sprocess((String)c, properties);
        }
        return properties;
    }

    private boolean rendererAcceptsData(QDataSet fillDs) {
        if (this.getRenderer() instanceof SpectrogramRenderer) {
            if (fillDs.rank() == 3) {
                QDataSet dep0 = (QDataSet)fillDs.property("DEPEND_0");
                if (dep0 != null) {
                    return false;
                }
                return this.rendererAcceptsData((QDataSet)DataSetOps.slice0((QDataSet)fillDs, (int)0));
            }
            return fillDs.rank() == 2;
        }
        if (this.getRenderer() instanceof SeriesRenderer) {
            if (fillDs.rank() == 1) {
                return true;
            }
            if (fillDs.rank() == 2) {
                return SemanticOps.isBundle((QDataSet)fillDs);
            }
            return false;
        }
        if (this.getRenderer() instanceof ImageVectorDataSetRenderer) {
            if (fillDs.rank() == 1) {
                return true;
            }
            if (fillDs.rank() == 2) {
                return SemanticOps.isBundle((QDataSet)fillDs);
            }
            return false;
        }
        if (this.getRenderer() instanceof RGBImageRenderer) {
            if (fillDs.rank() == 2) {
                return !SemanticOps.isBundle((QDataSet)fillDs);
            }
            if (fillDs.rank() == 3) {
                return fillDs.length(0, 0) < 5;
            }
            return false;
        }
        return true;
    }

    private boolean isAsyncProcess(String cmd) {
        return cmd.contains("fft");
    }

    private void setDataSet(QDataSet fillDs, boolean checkUnits) throws IllegalArgumentException {
        if (!Arrays.asList(this.dom.getPlotElements()).contains(this.plotElement)) {
            return;
        }
        String comp = this.plotElement.getComponent();
        try {
            if (fillDs != null) {
                QDataSet context;
                if (comp.length() > 0) {
                    fillDs = this.processDataSet(comp, fillDs);
                }
                if (checkUnits && this.doUnitsCheck(fillDs)) {
                    Plot plot = this.dom.getController().getPlotFor(this.plotElement);
                    PlotController pc = plot.getController();
                    pc.doPlotElementDefaultsUnitsChange(this.plotElement);
                }
                if ((context = (QDataSet)fillDs.property("CONTEXT_0")) != null) {
                    DatumRange cdr = context.rank() == 1 ? DataSetUtil.asDatumRange((QDataSet)context, (boolean)true) : DatumRange.newDatumRange((double)context.value(), (double)context.value(), (Units)SemanticOps.getUnits((QDataSet)context));
                    Plot plot = this.dom.getController().getPlotFor(this.plotElement);
                    DatumRange oldContext = plot.getContext();
                    if ((oldContext.equals((Object)Axis.DEFAULT_RANGE) || UnitsUtil.isTimeLocation((Units)oldContext.getUnits())) && UnitsUtil.isTimeLocation((Units)cdr.getUnits())) {
                        plot.setContext(cdr);
                    }
                }
            }
            this._setDataSet(fillDs);
        }
        catch (RuntimeException ex) {
            if (this.getRenderer() == null) {
                throw ex;
            }
            this.getRenderer().setException((Exception)ex);
            this.getRenderer().setDataSet(null);
            this._setDataSet(null);
            return;
        }
        if (fillDs != null && this.getRenderer() != null) {
            if (this.rendererAcceptsData(fillDs)) {
                this.getRenderer().setDataSet(fillDs);
            } else {
                this.getRenderer().setDataSet(null);
                this.getRenderer().setException(new Exception("renderer cannot plot " + fillDs));
            }
        }
    }

    public QDataSet getDataSet() {
        return this.dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _setDataSet(QDataSet dataSet) {
        QDataSet oldDataSet = this.dataSet;
        this.dataSet = dataSet;
        PlotElementController plotElementController = this;
        synchronized (plotElementController) {
            this.processDataSet = null;
            this.procressStr = null;
        }
        if ((this.plotElement.getLegendLabel().contains("%{") || this.plotElement.getLegendLabel().contains("$(")) && this.renderer != null) {
            String s = (String)this.getLabelConverter().convertForward((Object)this.plotElement.getLegendLabel());
            this.renderer.setLegendLabel(s);
        }
        this.propertyChangeSupport.firePropertyChange(PROP_DATASET, oldDataSet, dataSet);
    }

    private void updateDataSet() throws IllegalArgumentException {
        QDataSet fillDs;
        if (this.getRenderer() != null) {
            this.getRenderer().setDataSet(null);
        }
        if ((fillDs = this.dsf.controller.getFillDataSet()) != null) {
            if (this.resetPlotElement) {
                if (this.plotElement.getComponent().equals("")) {
                    RenderType renderType;
                    this.plotElement.renderType = renderType = AutoplotUtil.guessRenderType(fillDs);
                    this.resetPlotElement(fillDs, renderType);
                    this.setResetPlotElement(false);
                } else if (this.plotElement.getComponent().startsWith("|")) {
                    try {
                        RenderType renderType;
                        QDataSet fillDs2 = fillDs;
                        String comp = this.plotElement.getComponent();
                        if (comp.length() > 0) {
                            fillDs2 = this.processDataSet(comp, fillDs2);
                        }
                        this.plotElement.renderType = renderType = AutoplotUtil.guessRenderType(fillDs2);
                        this.resetPlotElement(fillDs2, renderType);
                        this.setResetPlotElement(false);
                    }
                    catch (RuntimeException ex) {
                        this.setStatus("warning: Exception in process: " + ex);
                        throw ex;
                    }
                } else {
                    if (this.renderer == null) {
                        this.maybeCreateDasPeer();
                    }
                    try {
                        if (this.resetRanges) {
                            this.doResetRanges();
                        }
                        this.setResetPlotElement(false);
                    }
                    catch (RuntimeException ex) {
                        this.setStatus("warning: Exception in process: " + ex);
                        throw ex;
                    }
                }
            } else if (this.resetRanges) {
                this.doResetRanges();
                this.setResetRanges(false);
            } else if (this.resetRenderType) {
                this.doResetRenderType(this.plotElement.getRenderType());
            }
        }
        if (fillDs == null) {
            if (this.getRenderer() != null) {
                this.getRenderer().setDataSet(null);
                this.getRenderer().setException(null);
            }
            this.setDataSet(null, false);
        } else {
            this.setDataSet(fillDs, true);
        }
    }

    private boolean axisDimensionsChange(RenderType oldRenderType, RenderType newRenderType) {
        if (oldRenderType == newRenderType) {
            return false;
        }
        if (newRenderType == RenderType.pitchAngleDistribution) {
            return true;
        }
        if (oldRenderType == RenderType.spectrogram && newRenderType == RenderType.nnSpectrogram) {
            return false;
        }
        if (oldRenderType == RenderType.nnSpectrogram && newRenderType == RenderType.spectrogram) {
            return false;
        }
        if (newRenderType == RenderType.spectrogram || newRenderType == RenderType.nnSpectrogram) {
            return true;
        }
        return oldRenderType == RenderType.spectrogram || oldRenderType == RenderType.nnSpectrogram;
    }

    private static String[] getDimensionNames(QDataSet ds) {
        String[] depNames = new String[ds.rank()];
        for (int i = 0; i < ds.rank(); ++i) {
            String dname;
            depNames[i] = "dim" + i;
            QDataSet dep0 = (QDataSet)ds.property("DEPEND_" + i);
            if (dep0 == null || (dname = (String)dep0.property("NAME")) == null) continue;
            depNames[i] = dname;
        }
        return depNames;
    }

    private static Units[] getDimensionUnits(QDataSet ds) {
        Units[] depUnits = new Units[ds.rank()];
        for (int i = 0; i < ds.rank(); ++i) {
            Units u;
            depUnits[i] = Units.dimensionless;
            QDataSet dep0 = (QDataSet)ds.property("DEPEND_" + i);
            if (dep0 == null || (u = (Units)dep0.property("UNITS")) == null) continue;
            depUnits[i] = u;
        }
        return depUnits;
    }

    private static String guessSlice(QDataSet fillDs) {
        String[] depNames = PlotElementController.getDimensionNames(fillDs);
        Units[] depUnits = PlotElementController.getDimensionUnits(fillDs);
        int lat = -1;
        int lon = -1;
        ArrayList<Integer> slicePref = new ArrayList<Integer>(Arrays.asList(2, 2, 2, 2, 2));
        for (int i = 0; i < depNames.length; ++i) {
            String n = depNames[i].toLowerCase();
            Units u = depUnits[i];
            if (n.startsWith("lat")) {
                slicePref.set(i, 0);
                lat = i;
                continue;
            }
            if (n.startsWith("lon")) {
                slicePref.set(i, 0);
                lon = i;
                continue;
            }
            if (n.contains("time")) {
                slicePref.set(i, 1);
                continue;
            }
            if (n.contains("epoch")) {
                slicePref.set(i, 1);
                continue;
            }
            if (n.contains("angle")) {
                slicePref.set(i, 4);
                continue;
            }
            if (n.contains("alpha")) {
                slicePref.set(i, 4);
                continue;
            }
            if (n.contains("bundle")) {
                slicePref.set(i, 4);
                continue;
            }
            if (u instanceof EnumerationUnits) {
                slicePref.set(i, 5);
                continue;
            }
            if (fillDs.property("BUNDLE_" + i) == null) continue;
            slicePref.set(i, 5);
        }
        ArrayList<Integer> qube = new ArrayList<Integer>();
        int[] a = DataSetUtil.qubeDims((QDataSet)fillDs);
        for (int i = 0; i < a.length; ++i) {
            qube.add(a[i]);
        }
        String result = "";
        int nslice = fillDs.rank() - 2;
        for (int islice = 0; islice < nslice; ++islice) {
            int[] qubeDims;
            int sliceIndex = 0;
            int bestSlice = 0;
            boolean noPref = true;
            for (int i = 0; i < depNames.length; ++i) {
                if (i > 0 && slicePref.get(i) != slicePref.get(i - 1)) {
                    noPref = false;
                }
                if ((Integer)slicePref.get(i) <= bestSlice) continue;
                sliceIndex = i;
                bestSlice = (Integer)slicePref.get(i);
            }
            if (noPref && (qubeDims = DataSetUtil.qubeDims((QDataSet)fillDs)) != null) {
                int imin = -1;
                int min = Integer.MAX_VALUE;
                int nextMin = Integer.MAX_VALUE;
                for (int i = 0; i < qubeDims.length; ++i) {
                    if (qubeDims[i] >= min) continue;
                    nextMin = min;
                    min = qubeDims[i];
                    imin = i;
                }
                if (min < 4 && nextMin > 10) {
                    sliceIndex = imin;
                }
            }
            int n = (Integer)qube.get(sliceIndex) / 2;
            result = result + "|slice" + sliceIndex + "(" + n + ")";
            if (lat > -1 && lon > -1 && lat < lon) {
                result = result + "|transpose()";
            }
            slicePref.remove(sliceIndex);
            qube.remove(sliceIndex);
        }
        return result;
    }

    private boolean isLastDimBundle(QDataSet ds) {
        if (ds.rank() == 1) {
            return ds.property("BUNDLE_0") != null;
        }
        if (ds.rank() == 2) {
            return ds.property("BUNDLE_1") != null;
        }
        if (ds.rank() == 3) {
            boolean result = ds.property("BUNDLE_1", 0) != null;
            QDataSet dep1 = (QDataSet)ds.property("DEPEND_1", 0);
            if (dep1 != null && dep1.property("UNITS") instanceof EnumerationUnits) {
                result = true;
            }
            return result;
        }
        return false;
    }

    private void addParentComponentListener(PlotElement plotElement, final PlotElement ele) {
        PropertyChangeListener pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("component")) {
                    if (DataSetOps.changesDimensions((String)((String)evt.getOldValue()), (String)((String)evt.getNewValue()))) {
                        return;
                    }
                    Object v = evt.getNewValue();
                    int i = ele.getComponent().indexOf("|unbundle");
                    if (i == -1) {
                        throw new IllegalArgumentException("expected to see unbundle");
                    }
                    String tail = ele.getComponent().substring(i);
                    if (i != -1) {
                        String sv = (String)v;
                        ele.setComponent(sv + tail);
                    }
                }
            }
        };
        plotElement.addPropertyChangeListener(pcl);
        ele.getController().setParentComponentListener(pcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetPlotElement(QDataSet fillDs, RenderType renderType) {
        logger.log(Level.FINEST, "resetPlotElement({0} {1}) ele={2}", new Object[]{fillDs, renderType, this.plotElement});
        if (this.renderer != null) {
            this.renderer.setActive(true);
        }
        if (fillDs != null) {
            boolean weShallAddChildren;
            QDataSet bdesc;
            Object context0;
            boolean shouldHaveChildren;
            boolean shouldSlice;
            int ndim = Ops.dimensionCount((QDataSet)fillDs);
            boolean bl = shouldSlice = fillDs.rank() > 2 && ndim > 3 && this.plotElement.isAutoComponent();
            if (renderType == RenderType.image && fillDs.rank() == 3) {
                shouldSlice = false;
            }
            boolean bl2 = shouldHaveChildren = fillDs.rank() == 2 && renderType != RenderType.spectrogram && renderType != RenderType.nnSpectrogram && renderType != RenderType.digital && renderType != RenderType.eventsBar && renderType != RenderType.image && renderType != RenderType.pitchAngleDistribution && fillDs.length(0) <= 50;
            if (fillDs.rank() == 2 && SemanticOps.isBundle((QDataSet)fillDs) && null != (context0 = (bdesc = (QDataSet)fillDs.property("BUNDLE_1")).property("CONTEXT_0", bdesc.length() - 1)) && context0 instanceof String) {
                shouldHaveChildren = false;
            }
            String[] labels = null;
            if (shouldHaveChildren) {
                labels = SemanticOps.getComponentLabels((QDataSet)fillDs);
            }
            boolean bl3 = weShallAddChildren = this.plotElement.isAutoComponent() && shouldHaveChildren;
            if (!shouldHaveChildren || weShallAddChildren) {
                List<PlotElement> childEles = this.getChildPlotElements();
                for (PlotElement plotElement : childEles) {
                    if (this.dom.plotElements.contains(plotElement)) {
                        this.dom.controller.deletePlotElement(plotElement);
                        PropertyChangeListener parentListener = plotElement.getController().getParentComponentLister();
                        if (parentListener != null) {
                            this.plotElement.removePropertyChangeListener(parentListener);
                        }
                        this.removePropertyChangeListener(this.dsfListener);
                    }
                    this.plotElement.getStyle().removePropertyChangeListener(plotElement.getController().parentStyleListener);
                }
            }
            if (!shouldSlice) {
                this.doResetRenderType(this.plotElement.getRenderType());
            }
            this.setResetPlotElement(false);
            if (this.resetRanges && !shouldSlice) {
                this.doResetRanges();
                this.setResetRanges(false);
            }
            if (shouldHaveChildren) {
                this.renderer.setActive(false);
                this.plotElement.setDisplayLegend(false);
            }
            if (shouldSlice) {
                String existingComponent;
                int dim;
                String component = PlotElementController.guessSlice(fillDs);
                Units[] us = PlotElementController.getDimensionUnits(fillDs);
                Pattern pattern = Pattern.compile("\\|slice(\\d)\\(\\d+\\)");
                Matcher m = pattern.matcher(component);
                if (m.matches() && UnitsUtil.isNominalMeasurement((Units)us[dim = Integer.parseInt(m.group(1))])) {
                    this.setSliceAutoranges(true);
                }
                if (!(existingComponent = this.plotElement.getComponent()).equals("")) {
                    this.plotElement.setComponentAutomatically(existingComponent + component);
                } else {
                    this.plotElement.setComponentAutomatically(component);
                }
                this.doResetRenderType(this.plotElement.getRenderType());
                return;
            }
            if (weShallAddChildren) {
                ChangesSupport.DomLock lock = this.dom.controller.mutatorLock();
                lock.lock("Add Child Elements");
                try {
                    int i;
                    Color c = this.plotElement.getStyle().getColor();
                    Color color = this.plotElement.getStyle().getFillColor();
                    Plot domPlot = this.dom.controller.getPlotFor(this.plotElement);
                    ArrayList<PlotElement> cp = new ArrayList<PlotElement>(fillDs.length(0));
                    int nsubsample = 1 + (fillDs.length(0) - 1) / 12;
                    boolean uniqLabels = true;
                    for (i = 0; i < labels.length; ++i) {
                        for (int j = i + 1; j < labels.length; ++j) {
                            if (!labels[i].equals(labels[j])) continue;
                            uniqLabels = false;
                        }
                    }
                    for (i = 0; i < fillDs.length(0); ++i) {
                        PlotElement ele = this.dom.controller.copyPlotElement(this.plotElement, domPlot, this.dsf);
                        ele.controller.getRenderer().setActive(false);
                        cp.add(ele);
                        ele.setParent(this.plotElement.getId());
                        this.plotElement.getStyle().addPropertyChangeListener(ele.controller.parentStyleListener);
                        ele.getStyle().setColor(this.deriveColor(c, i / nsubsample));
                        ele.getStyle().setFillColor(this.deriveColor(color, i / nsubsample).brighter());
                        String s = this.plotElement.getComponent();
                        String label1 = labels[i];
                        if (s.equals("") && uniqLabels) {
                            s = labels[i];
                            QDataSet ds1 = DataSetOps.unbundle((QDataSet)fillDs, (int)i);
                            String l1 = (String)ds1.property("LABEL");
                            if (l1 != null) {
                                label1 = l1;
                            }
                        } else {
                            s = uniqLabels ? s + "|unbundle('" + labels[i] + "')" : s + "|unbundle('ch_" + i + "')";
                            this.addParentComponentListener(this.plotElement, ele);
                        }
                        ele.setComponentAutomatically(s);
                        ele.setDisplayLegend(true);
                        if (ele.isAutoLabel()) {
                            ele.setLegendLabelAutomatically(label1);
                        }
                        ele.setRenderTypeAutomatically(this.plotElement.getRenderType());
                    }
                    for (i = 0; i < fillDs.length(0); ++i) {
                        PlotElement ele = (PlotElement)cp.get(i);
                        if (i % nsubsample != 0) continue;
                        ele.setActive(true);
                        ele.controller.getRenderer().setActive(true);
                    }
                    this.renderer.setActive(false);
                    this.setChildPlotElements(cp);
                }
                finally {
                    lock.unlock();
                }
            }
        } else {
            this.doResetRenderType(this.plotElement.getRenderType());
        }
    }

    private void maybeSetPlotAutorange() {
        Plot p = this.dom.controller.getPlotFor(this.plotElement);
        if (p == null) {
            return;
        }
        List<PlotElement> eles = this.dom.controller.getPlotElementsFor(p);
        if (DomUtil.oneFamily(eles)) {
            p.getXaxis().setAutoRange(true);
            p.getYaxis().setAutoRange(true);
            p.getZaxis().setAutoRange(true);
            p.getXaxis().setAutoLabel(true);
            p.getYaxis().setAutoLabel(true);
            p.getZaxis().setAutoLabel(true);
            p.setAutoLabel(true);
            p.setAutoBinding(true);
        }
    }

    private void setDataSourceFilterController(DataSourceController dsc) {
        dsc.addPropertyChangeListener("fillDataSet", this.fillDataSetListener);
        dsc.addPropertyChangeListener("dataSource", this.dataSourceDataSetListener);
    }

    public boolean isResetRanges() {
        return this.resetRanges;
    }

    public void setResetRanges(boolean resetRanges) {
        boolean oldResetRanges = this.resetRanges;
        this.resetRanges = resetRanges;
        this.propertyChangeSupport.firePropertyChange("resetRanges", oldResetRanges, resetRanges);
    }

    public boolean isResetPlotElement() {
        return this.resetPlotElement;
    }

    public void setResetPlotElement(boolean resetPlotElement) {
        boolean old = this.resetPlotElement;
        this.resetPlotElement = resetPlotElement;
        this.propertyChangeSupport.firePropertyChange(PROP_RESETPLOTELEMENT, old, resetPlotElement);
    }

    public boolean isResetComponent() {
        return this.resetComponent;
    }

    public void setResetComponent(boolean resetComponent) {
        boolean oldResetComponent = this.resetComponent;
        this.resetComponent = resetComponent;
        this.propertyChangeSupport.firePropertyChange(PROP_RESETCOMPONENT, oldResetComponent, resetComponent);
    }

    public boolean isResetRenderType() {
        return this.resetRenderType;
    }

    public void setResetRenderType(boolean resetRenderType) {
        boolean oldResetRenderType = this.resetRenderType;
        this.resetRenderType = resetRenderType;
        this.propertyChangeSupport.firePropertyChange(PROP_RESETRENDERTYPE, oldResetRenderType, resetRenderType);
    }

    public boolean isDsfReset() {
        return this.dsfReset;
    }

    public void setDsfReset(boolean dsfReset) {
        boolean oldDsfReset = this.dsfReset;
        this.dsfReset = dsfReset;
        this.propertyChangeSupport.firePropertyChange(PROP_DSFRESET, oldDsfReset, dsfReset);
    }

    public boolean isSliceAutoranges() {
        return this.sliceAutoranges;
    }

    public void setSliceAutoranges(boolean sliceAutoranges) {
        boolean oldSliceAutoranges = this.sliceAutoranges;
        this.sliceAutoranges = sliceAutoranges;
        this.propertyChangeSupport.firePropertyChange(PROP_SLICEAUTORANGES, oldSliceAutoranges, sliceAutoranges);
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    private void setRenderer(Renderer renderer) {
        JMenuItem mi;
        Renderer oldRenderer = this.renderer;
        ApplicationController ac = this.dom.controller;
        if (oldRenderer != null) {
            ac.unbind(this.plotElement, "legendLabel", oldRenderer, "legendLabel");
            ac.unbind(this.plotElement, "displayLegend", oldRenderer, "drawLegendLabel");
            ac.unbind(this.plotElement, "active", oldRenderer, "active");
        }
        this.renderer = renderer;
        ac.unbindImpl(this.node);
        if (renderer instanceof SeriesRenderer) {
            this.bindToSeriesRenderer((SeriesRenderer)renderer);
            this.bindToSpectrogramRenderer(new SpectrogramRenderer(null, null));
        } else if (renderer instanceof SpectrogramRenderer) {
            this.bindToSpectrogramRenderer((SpectrogramRenderer)renderer);
            this.bindToSeriesRenderer(new SeriesRenderer());
        } else if (renderer instanceof ImageVectorDataSetRenderer) {
            this.bindToImageVectorDataSetRenderer((ImageVectorDataSetRenderer)renderer);
        } else if (renderer instanceof EventsRenderer) {
            this.bindToEventsRenderer((EventsRenderer)renderer);
        } else {
            this.bindToSpectrogramRenderer(new SpectrogramRenderer(null, null));
            this.bindToSeriesRenderer(new SeriesRenderer());
        }
        Plot mip = ac.getPlotFor(this.plotElement);
        if (mip != null && (mi = mip.getController().getPlotElementPropsMenuItem()) != null) {
            mi.setIcon(renderer.getListIcon());
        }
        renderer.setId("rend_" + this.plotElement.getId());
        ac.bind(this.plotElement, "legendLabel", renderer, "legendLabel", this.getLabelConverter());
        ac.bind(this.plotElement, "displayLegend", renderer, "drawLegendLabel");
        ac.bind(this.plotElement, "active", renderer, "active");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doResetRanges() {
        logger.finest("doResetRanges...");
        this.setStatus("busy: do autorange");
        this.changesSupport.performingChange(this, "resetRanges");
        try {
            Plot plot = this.dom.controller.getPlotFor(this.plotElement);
            PlotElement peleCopy = (PlotElement)this.plotElement.copy();
            peleCopy.setId("");
            peleCopy.setParent("");
            peleCopy.getPlotDefaults().syncTo(plot, Arrays.asList("id", "rowId", "columnId"));
            DataSourceController dsc = this.getDataSourceFilter().getController();
            QDataSet fillDs = this.getDataSourceFilter().controller.getFillDataSet();
            Map<String, Object> props = dsc.getFillProperties();
            String comp = this.plotElement.getComponent();
            if (comp.length() > 0) {
                fillDs = this.processDataSet(comp, fillDs);
                props = this.processProperties(comp, props);
            }
            if (props == null) {
                System.err.println("null properties in doResetRanges");
            }
            if (this.dom.getOptions().isAutolabelling()) {
                String title;
                PlotElementController.doMetadata(peleCopy, props, fillDs);
                String reduceRankString = this.getDataSourceFilter().controller.getReduceDataSetString();
                if (this.dsf.controller.getReduceDataSetString() != null) {
                    title = peleCopy.getPlotDefaults().getTitle();
                    title = title + "!c" + reduceRankString;
                    peleCopy.getPlotDefaults().setTitle(title);
                }
                if (!this.plotElement.getComponent().equals("")) {
                    title = peleCopy.getPlotDefaults().getTitle();
                    title = title + "!c%{CONTEXT}";
                    peleCopy.getPlotDefaults().setTitle(title);
                }
            }
            if (this.dom.getOptions().isAutoranging()) {
                Renderer newRenderer;
                QDataSet xds;
                Units xunits;
                logger.fine("doAutoranging");
                PlotElementController.doAutoranging(peleCopy, props, fillDs);
                TimeSeriesBrowse tsb = this.getDataSourceFilter().getController().getTsb();
                if (tsb != null && fillDs != null && (xunits = (xds = SemanticOps.xtagsDataSet((QDataSet)fillDs)).rank() <= 1 ? (Units)xds.property("UNITS") : (Units)xds.property("UNITS", 0)) != null && UnitsUtil.isTimeLocation((Units)xunits)) {
                    peleCopy.getPlotDefaults().getXaxis().setRange(tsb.getTimeRange());
                }
                if ((newRenderer = this.getRenderer()) instanceof SeriesRenderer && fillDs != null) {
                    QDataSet d = (QDataSet)fillDs.property("DEPEND_0");
                    if (d != null) {
                        ((SeriesRenderer)newRenderer).setCadenceCheck(d.property("CADENCE") != null);
                    } else {
                        ((SeriesRenderer)newRenderer).setCadenceCheck(true);
                    }
                }
            } else {
                this.setStatus("autoranging is disabled");
            }
            if (this.plotElement.getComponent().equals("") && this.plotElement.isAutoLabel()) {
                this.plotElement.setLegendLabelAutomatically(peleCopy.getLegendLabel());
            }
            peleCopy.getPlotDefaults().getXaxis().setAutoRange(true);
            peleCopy.getPlotDefaults().getYaxis().setAutoRange(true);
            peleCopy.getPlotDefaults().getZaxis().setAutoRange(true);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(String.format("done, autorange  x:%s, y:%s ", peleCopy.getPlotDefaults().getXaxis().getRange().toString(), peleCopy.getPlotDefaults().getYaxis().getRange().toString()));
            }
            this.plotElement.setPlotDefaults(peleCopy.getPlotDefaults());
            this.plotElement.style.syncTo(peleCopy.style);
            this.plotElement.renderType = peleCopy.renderType;
            if (this.dom.getOptions().isAutoranging()) {
                this.setStatus("done, autorange");
            }
        }
        finally {
            this.changesSupport.changePerformed(this, "resetRanges");
        }
    }

    private static void doMetadata(PlotElement peleCopy, Map<String, Object> properties, QDataSet fillDs) {
        peleCopy.getPlotDefaults().getXaxis().setLabel("");
        peleCopy.getPlotDefaults().getYaxis().setLabel("");
        peleCopy.getPlotDefaults().getZaxis().setLabel("");
        peleCopy.getPlotDefaults().setTitle("");
        peleCopy.setLegendLabelAutomatically("");
        PlotElementController.doInterpretMetadata(peleCopy, properties, peleCopy.getRenderType());
        PlotElementUtil.unitsCheck(properties, fillDs);
    }

    private static void doInterpretMetadata(PlotElement peleCopy, Map properties, RenderType spec) {
        Map m;
        Object v2;
        Plot plotDefaults = peleCopy.getPlotDefaults();
        Object v = properties.get("TITLE");
        if (v != null) {
            plotDefaults.setTitle((String)v);
        }
        String legendLabel = null;
        v = properties.get("NAME");
        if (v != null) {
            legendLabel = (String)v;
        }
        if ((v = properties.get("LABEL")) != null) {
            legendLabel = (String)v;
        }
        if (legendLabel != null) {
            peleCopy.setLegendLabelAutomatically(legendLabel);
        }
        if (spec == RenderType.spectrogram || spec == RenderType.nnSpectrogram) {
            v = properties.get("SCALE_TYPE");
            if (v != null) {
                plotDefaults.getZaxis().setLog(v.equals("log"));
            }
            if ((v = properties.get("LABEL")) != null) {
                plotDefaults.getZaxis().setLabel((String)v);
            }
            if ((v = properties.get("DEPEND_1")) != null && (v2 = (m = (Map)v).get("LABEL")) != null) {
                plotDefaults.getYaxis().setLabel((String)v2);
            }
        } else {
            Map yprop = null;
            Map xprop = null;
            Map prop = null;
            QDataSet bundle1 = (QDataSet)properties.get("BUNDLE_1");
            if (bundle1 != null) {
                xprop = (Map)properties.get("DEPEND_0");
                if (xprop == null) {
                    xprop = DataSetUtil.getProperties((QDataSet)DataSetOps.slice0((QDataSet)bundle1, (int)0));
                }
                if (spec != RenderType.colorScatter) {
                    prop = properties;
                    yprop = properties;
                } else {
                    prop = DataSetUtil.getProperties((QDataSet)DataSetOps.slice0((QDataSet)bundle1, (int)(bundle1.length() - 1)));
                    yprop = DataSetUtil.getProperties((QDataSet)DataSetOps.slice0((QDataSet)bundle1, (int)1));
                }
            } else {
                prop = properties;
                yprop = properties;
                v = properties.get("PLANE_0");
                if (v != null) {
                    yprop = prop;
                    prop = (Map)v;
                }
            }
            v = yprop.get("SCALE_TYPE");
            if (v != null) {
                plotDefaults.getYaxis().setLog(v.equals("log"));
            }
            if ((v = yprop.get("LABEL")) != null) {
                plotDefaults.getYaxis().setLabel((String)v);
            }
            if (xprop != null && (v = xprop.get("LABEL")) != null) {
                plotDefaults.getXaxis().setLabel((String)v);
            }
            if (spec == RenderType.colorScatter && (v = prop.get("LABEL")) != null) {
                plotDefaults.getZaxis().setLabel((String)v);
            }
        }
        if ((v = properties.get("DEPEND_0")) != null && (v2 = (m = (Map)v).get("LABEL")) != null) {
            plotDefaults.getXaxis().setLabel((String)v2);
        }
    }

    private static void doAutoranging(PlotElement peleCopy, Map<String, Object> props, QDataSet fillDs) {
        RenderType spec = peleCopy.getRenderType();
        if (props == null) {
            props = Collections.EMPTY_MAP;
        }
        if (spec == RenderType.spectrogram || spec == RenderType.nnSpectrogram) {
            QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)fillDs);
            if (xds == null) {
                if (fillDs.property("JOIN_0") != null) {
                    JoinDataSet ds = new JoinDataSet(2);
                    int xtag = 0;
                    for (int i = 0; i < fillDs.length(); ++i) {
                        QDataSet xds1 = (QDataSet)fillDs.property("DEPEND_0", i);
                        if (xds1 == null) {
                            xds1 = Ops.linspace((double)xtag, (double)(xtag + fillDs.length(i) - 1), (int)fillDs.length(i));
                            xtag += fillDs.length(i);
                        }
                        ds.join(xds1);
                    }
                    xds = ds;
                } else {
                    xds = DataSetUtil.indexGenDataSet((int)fillDs.length());
                }
            }
            QDataSet yds = SemanticOps.ytagsDataSet((QDataSet)fillDs);
            Map yprops = (Map)props.get("DEPEND_1");
            if (yds == null) {
                if (fillDs.property("JOIN_0") != null) {
                    JoinDataSet ds = new JoinDataSet(2);
                    for (int i = 0; i < fillDs.length(); ++i) {
                        QDataSet yds1 = (QDataSet)fillDs.property("DEPEND_1", i);
                        if (yds1 == null) {
                            yds1 = Ops.linspace((double)0.0, (double)(fillDs.length(i, 0) - 1), (int)fillDs.length(i, 0));
                        }
                        ds.join(yds1);
                    }
                    yds = ds;
                } else if (fillDs.property("JOIN_0") == null && fillDs.length() > 0 && fillDs.property("DEPEND_0", 0) != null) {
                    JoinDataSet ds = new JoinDataSet(2);
                    Units u = null;
                    for (int i = 0; i < fillDs.length(); ++i) {
                        QDataSet tds = (QDataSet)fillDs.property("DEPEND_0", i);
                        if (u == null) {
                            u = SemanticOps.getUnits((QDataSet)tds);
                        } else {
                            Units tu = SemanticOps.getUnits((QDataSet)tds);
                            if (tu == null) {
                                tu = Units.dimensionless;
                            }
                            if (tu != u) {
                                throw new IllegalArgumentException("Unequal units: wanted " + u + " got " + tu);
                            }
                        }
                        ds.join(tds);
                    }
                    ds.putProperty("UNITS", u);
                    yds = ds;
                } else if (fillDs.rank() > 1) {
                    yds = DataSetUtil.indexGenDataSet((int)fillDs.length(0));
                } else {
                    yds = DataSetUtil.indexGenDataSet((int)10);
                    yprops = null;
                }
            }
            QDataSet zds = yds.length() == fillDs.length(0) && yds.length() > 3 ? fillDs : SemanticOps.getDependentDataSet((QDataSet)fillDs);
            Units xunits = SemanticOps.getUnits((QDataSet)xds);
            Units yunits = SemanticOps.getUnits((QDataSet)yds);
            Units zunits = SemanticOps.getUnits((QDataSet)zds);
            if (UnitsUtil.isOrdinalMeasurement((Units)xunits) || UnitsUtil.isOrdinalMeasurement((Units)yunits) || UnitsUtil.isOrdinalMeasurement((Units)zunits)) {
                return;
            }
            AutoplotUtil.AutoRangeDescriptor xdesc = AutoplotUtil.autoRange(xds, (Map)props.get("DEPEND_0"));
            AutoplotUtil.AutoRangeDescriptor ydesc = AutoplotUtil.autoRange(yds, yprops);
            AutoplotUtil.AutoRangeDescriptor desc = AutoplotUtil.autoRange(zds, props);
            peleCopy.getPlotDefaults().getZaxis().setRange(desc.range);
            peleCopy.getPlotDefaults().getZaxis().setLog(desc.log);
            if (peleCopy.getPlotDefaults().getXaxis().isAutoRange()) {
                peleCopy.getPlotDefaults().getXaxis().setLog(xdesc.log);
                peleCopy.getPlotDefaults().getXaxis().setRange(xdesc.range);
            }
            peleCopy.getPlotDefaults().getYaxis().setLog(ydesc.log);
            peleCopy.getPlotDefaults().getYaxis().setRange(ydesc.range);
        } else if (spec == RenderType.pitchAngleDistribution) {
            QDataSet qube = PitchAngleDistributionRenderer.doAutorange((QDataSet)fillDs);
            if (qube != null) {
                peleCopy.getPlotDefaults().getXaxis().setRange(DataSetUtil.asDatumRange((QDataSet)qube.slice(0), (boolean)true));
                peleCopy.getPlotDefaults().getYaxis().setRange(DataSetUtil.asDatumRange((QDataSet)qube.slice(1), (boolean)true));
                peleCopy.getPlotDefaults().getZaxis().setRange(DataSetUtil.asDatumRange((QDataSet)qube.slice(2), (boolean)true));
            }
        } else if (spec == RenderType.digital || spec == RenderType.eventsBar || spec == RenderType.image) {
            QDataSet qube = DigitalRenderer.doAutorange((QDataSet)fillDs);
            if (qube != null) {
                peleCopy.getPlotDefaults().getXaxis().setRange(DataSetUtil.asDatumRange((QDataSet)qube.slice(0), (boolean)true));
                peleCopy.getPlotDefaults().getYaxis().setRange(DataSetUtil.asDatumRange((QDataSet)qube.slice(1), (boolean)true));
            }
        } else {
            boolean isSeries;
            AutoplotUtil.AutoRangeDescriptor ydesc;
            QDataSet depend0;
            Object hist = null;
            if (SemanticOps.isBundle((QDataSet)fillDs)) {
                depend0 = SemanticOps.xtagsDataSet((QDataSet)fillDs);
                if (spec == RenderType.colorScatter) {
                    ydesc = AutoplotUtil.autoRange(DataSetOps.unbundle((QDataSet)fillDs, (int)1), props);
                } else {
                    ydesc = AutoplotUtil.autoRange(DataSetOps.unbundle((QDataSet)fillDs, (int)(fillDs.length(0) - 1)), props);
                    for (int i = fillDs.length(0) - 2; i >= 0; --i) {
                        AutoplotUtil.AutoRangeDescriptor ydesc1 = AutoplotUtil.autoRange(DataSetOps.unbundle((QDataSet)fillDs, (int)i), props);
                        if (ydesc1.range.getUnits().isConvertableTo(ydesc.range.getUnits())) {
                            ydesc.range = DatumRangeUtil.union((DatumRange)ydesc.range, (DatumRange)ydesc1.range);
                            continue;
                        }
                        break;
                    }
                }
            } else {
                ydesc = AutoplotUtil.autoRange(fillDs, props);
                depend0 = (QDataSet)fillDs.property("DEPEND_0");
            }
            boolean hasRenderType = props.get("RENDER_TYPE") != null;
            boolean bl = isSeries = depend0 == null || DataSetUtil.isMonotonic((QDataSet)depend0);
            if (!hasRenderType) {
                if (isSeries) {
                    peleCopy.getStyle().setSymbolConnector(PsymConnector.SOLID);
                } else {
                    peleCopy.getStyle().setSymbolConnector(PsymConnector.NONE);
                    if (peleCopy.getRenderType() == RenderType.series) {
                        peleCopy.setRenderType(RenderType.scatter);
                    }
                }
            }
            peleCopy.getPlotDefaults().getYaxis().setLog(ydesc.log);
            peleCopy.getPlotDefaults().getYaxis().setRange(ydesc.range);
            QDataSet xds = depend0;
            if (xds == null) {
                xds = DataSetUtil.indexGenDataSet((int)fillDs.length());
            }
            if (peleCopy.getPlotDefaults().getXaxis().isAutoRange()) {
                AutoplotUtil.AutoRangeDescriptor xdesc = AutoplotUtil.autoRange(xds, (Map)props.get("DEPEND_0"));
                peleCopy.getPlotDefaults().getXaxis().setLog(xdesc.log);
                peleCopy.getPlotDefaults().getXaxis().setRange(xdesc.range);
            }
            if (spec == RenderType.colorScatter) {
                AutoplotUtil.AutoRangeDescriptor zdesc;
                if (fillDs.property("BUNDLE_1") != null) {
                    zdesc = AutoplotUtil.autoRange(DataSetOps.unbundle((QDataSet)fillDs, (int)(fillDs.length(0) - 1)), null);
                } else {
                    QDataSet plane0 = (QDataSet)fillDs.property("PLANE_0");
                    if (plane0 != null) {
                        zdesc = AutoplotUtil.autoRange(plane0, (Map)props.get("PLANE_0"));
                        peleCopy.getPlotDefaults().getZaxis().setLog(zdesc.log);
                        peleCopy.getPlotDefaults().getZaxis().setRange(zdesc.range);
                        peleCopy.getPlotDefaults().getZaxis().setRange(zdesc.range);
                    } else {
                        Logger.getLogger("autoplot.plotelementcontroller").warning("expected color plane_0");
                    }
                }
            }
            if (fillDs.length() > 30000) {
                peleCopy.getStyle().setSymbolConnector(PsymConnector.NONE);
                peleCopy.getStyle().setPlotSymbol((PlotSymbol)DefaultPlotSymbol.CIRCLES);
                peleCopy.getStyle().setSymbolSize(1.0);
            } else {
                peleCopy.getStyle().setPlotSymbol((PlotSymbol)DefaultPlotSymbol.CIRCLES);
                if (fillDs.length() > 500) {
                    peleCopy.getStyle().setSymbolSize(1.0);
                } else {
                    peleCopy.getStyle().setSymbolSize(3.0);
                }
            }
        }
    }

    private boolean doUnitsCheck(QDataSet fillDs) {
        Units zunits;
        Units yunits;
        Units xunits;
        RenderType spec = this.plotElement.getRenderType();
        Map props = new HashMap();
        if (props == null) {
            props = Collections.EMPTY_MAP;
        }
        DatumRange xrange = this.plotElement.getPlotDefaults().getXaxis().getRange();
        DatumRange yrange = this.plotElement.getPlotDefaults().getYaxis().getRange();
        DatumRange zrange = this.plotElement.getPlotDefaults().getZaxis().getRange();
        if (spec == RenderType.spectrogram || spec == RenderType.nnSpectrogram || spec == RenderType.pitchAngleDistribution) {
            QDataSet xds = (QDataSet)fillDs.property("DEPEND_0");
            if (xds == null) {
                if (fillDs.property("JOIN_0") != null) {
                    JoinDataSet ds = new JoinDataSet(2);
                    int xtag = 0;
                    for (int i = 0; i < fillDs.length(); ++i) {
                        QDataSet xds1 = (QDataSet)fillDs.property("DEPEND_0", i);
                        if (xds1 == null) {
                            xds1 = Ops.linspace((double)xtag, (double)(xtag + fillDs.length(i) - 1), (int)fillDs.length(i));
                            xtag += fillDs.length(i);
                        }
                        ds.join(xds1);
                    }
                    xds = ds;
                } else {
                    xds = DataSetUtil.indexGenDataSet((int)fillDs.length());
                }
            }
            QDataSet yds = (QDataSet)fillDs.property("DEPEND_1");
            Map yprops = (Map)props.get("DEPEND_1");
            if (yds == null) {
                if (fillDs.property("JOIN_0") != null) {
                    JoinDataSet ds = new JoinDataSet(2);
                    for (int i = 0; i < fillDs.length(); ++i) {
                        QDataSet yds1 = (QDataSet)fillDs.property("DEPEND_1", i);
                        if (yds1 == null) {
                            yds1 = Ops.linspace((double)0.0, (double)(fillDs.length(i, 0) - 1), (int)fillDs.length(i, 0));
                        }
                        ds.join(yds1);
                    }
                    yds = ds;
                } else if (fillDs.property("JOIN_0") == null && fillDs.length() > 0 && fillDs.property("DEPEND_0", 0) != null) {
                    JoinDataSet ds = new JoinDataSet(2);
                    Units u = null;
                    for (int i = 0; i < fillDs.length(); ++i) {
                        QDataSet tds = (QDataSet)fillDs.property("DEPEND_0", i);
                        if (u == null) {
                            u = (Units)tds.property("UNITS");
                            if (u == null) {
                                u = Units.dimensionless;
                            }
                        } else {
                            Units tu = (Units)tds.property("UNITS");
                            if (tu == null) {
                                tu = Units.dimensionless;
                            }
                            if (tu != u) {
                                throw new IllegalArgumentException("Inconvertable units: wanted " + u);
                            }
                        }
                        ds.join(tds);
                    }
                    ds.putProperty("UNITS", u);
                    yds = ds;
                } else if (fillDs.rank() > 1) {
                    yds = DataSetUtil.indexGenDataSet((int)fillDs.length(0));
                } else {
                    yds = DataSetUtil.indexGenDataSet((int)10);
                    yprops = null;
                }
            }
            xunits = SemanticOps.getUnits((QDataSet)xds);
            yunits = SemanticOps.getUnits((QDataSet)yds);
            zunits = SemanticOps.getUnits((QDataSet)fillDs);
            if (spec == RenderType.pitchAngleDistribution) {
                xunits = yunits;
            }
        } else {
            QDataSet depend0;
            if (SemanticOps.isBundle((QDataSet)fillDs)) {
                depend0 = (QDataSet)fillDs.property("DEPEND_0");
                if (depend0 == null) {
                    yunits = SemanticOps.getUnits((QDataSet)DataSetOps.unbundle((QDataSet)fillDs, (int)1));
                    depend0 = DataSetOps.unbundle((QDataSet)fillDs, (int)0);
                } else {
                    yunits = SemanticOps.getUnits((QDataSet)DataSetOps.unbundle((QDataSet)fillDs, (int)0));
                }
            } else {
                yunits = SemanticOps.getUnits((QDataSet)fillDs);
                depend0 = (QDataSet)fillDs.property("DEPEND_0");
            }
            if (fillDs.rank() == 0) {
                return true;
            }
            QDataSet xds = depend0;
            if (xds == null) {
                xds = DataSetUtil.indexGenDataSet((int)fillDs.length());
            }
            xunits = SemanticOps.getUnits((QDataSet)xds);
            zunits = Units.dimensionless;
            if (spec == RenderType.colorScatter) {
                if (fillDs.property("BUNDLE_1") != null) {
                    zunits = SemanticOps.getUnits((QDataSet)DataSetOps.unbundle((QDataSet)fillDs, (int)2));
                } else {
                    QDataSet plane0 = (QDataSet)fillDs.property("PLANE_0");
                    if (plane0 != null) {
                        zunits = Units.dimensionless;
                    } else {
                        Logger.getLogger("autoplot.plotelementcontroller").warning("expected color plane_0");
                    }
                }
            }
        }
        boolean change = false;
        if (xrange.getUnits() == Units.dimensionless && !UnitsUtil.isTimeLocation((Units)xunits) && !xunits.isConvertableTo(xrange.getUnits())) {
            this.plotElement.getPlotDefaults().getXaxis().setRange(new DatumRange(xrange.min().doubleValue(Units.dimensionless), xrange.max().doubleValue(Units.dimensionless), xunits));
            change = true;
        }
        if (yrange.getUnits() == Units.dimensionless && !UnitsUtil.isTimeLocation((Units)yunits) && !yunits.isConvertableTo(yrange.getUnits())) {
            this.plotElement.getPlotDefaults().getYaxis().setRange(new DatumRange(yrange.min().doubleValue(Units.dimensionless), yrange.max().doubleValue(Units.dimensionless), yunits));
            change = true;
        }
        if (zrange.getUnits() == Units.dimensionless && !UnitsUtil.isTimeLocation((Units)zunits) && !zunits.isConvertableTo(zrange.getUnits())) {
            this.plotElement.getPlotDefaults().getZaxis().setRange(new DatumRange(zrange.min().doubleValue(Units.dimensionless), zrange.max().doubleValue(Units.dimensionless), zunits));
            change = true;
        }
        return change;
    }

    public DasPlot getDasPlot() {
        Plot p = this.dom.controller.getPlotFor(this.plotElement);
        if (p == null) {
            return null;
        }
        return p.controller.getDasPlot();
    }

    private DasColorBar getColorbar() {
        Plot p = this.dom.controller.getPlotFor(this.plotElement);
        if (p == null) {
            throw new IllegalArgumentException("no plot found for element (" + this.plotElement + "," + this.plotElement.getPlotId() + ")");
        }
        return p.controller.getDasColorBar();
    }

    public DataSourceFilter getDataSourceFilter() {
        return this.dsf;
    }

    public Application getApplication() {
        return this.dom;
    }

    private static void setupStyle(PlotElement ele) {
        PlotElementStyle s = ele.getStyle();
        if (ele.getRenderType() == RenderType.colorScatter) {
            s.setPlotSymbol((PlotSymbol)DefaultPlotSymbol.CIRCLES);
            s.setSymbolConnector(PsymConnector.NONE);
            s.setFillToReference(false);
        } else if (ele.getRenderType() == RenderType.series) {
            s.setSymbolConnector(PsymConnector.SOLID);
            s.setPlotSymbol((PlotSymbol)DefaultPlotSymbol.CIRCLES);
            s.setFillToReference(false);
        } else if (ele.getRenderType() == RenderType.scatter) {
            s.setSymbolConnector(PsymConnector.NONE);
            s.setPlotSymbol((PlotSymbol)DefaultPlotSymbol.CIRCLES);
            s.setFillToReference(false);
        } else if (ele.getRenderType() == RenderType.stairSteps) {
            s.setSymbolConnector(PsymConnector.SOLID);
            s.setFillToReference(true);
        } else if (ele.getRenderType() == RenderType.fillToZero) {
            s.setSymbolConnector(PsymConnector.SOLID);
            s.setFillToReference(true);
        } else if (ele.getRenderType() == RenderType.nnSpectrogram) {
            s.setRebinMethod(SpectrogramRenderer.RebinnerEnum.nearestNeighbor);
        } else if (ele.getRenderType() == RenderType.spectrogram) {
            s.setRebinMethod(SpectrogramRenderer.RebinnerEnum.binAverage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void maybeCreateDasPeer() {
        Renderer oldRenderer = this.getRenderer();
        DasColorBar cb = null;
        if (RenderTypeUtil.needsColorbar(this.plotElement.getRenderType())) {
            cb = this.getColorbar();
        }
        PlotElementController.setupStyle(this.plotElement);
        Renderer newRenderer = AutoplotUtil.maybeCreateRenderer(this.plotElement.getRenderType(), oldRenderer, cb, false);
        if (cb != null && !this.dom.getController().isValueAdjusting() && RenderTypeUtil.needsColorbar(this.plotElement.getRenderType())) {
            cb.setVisible(true);
        }
        if (oldRenderer != newRenderer || this.getDasPlot() != newRenderer.getParent()) {
            DasPlot plot;
            if (oldRenderer != newRenderer) {
                this.setRenderer(newRenderer);
            }
            if ((plot = this.getDasPlot()) == null) {
                System.err.println("brace yourself for crash...");
                plot = this.getDasPlot();
                if (oldRenderer != null || this.dom.controller.isValueAdjusting()) {
                    // empty if block
                }
            }
            DasPlot oldPlot = null;
            if (oldRenderer != null) {
                oldPlot = oldRenderer.getParent();
                if (oldPlot != null && oldPlot != this.getDasPlot()) {
                    oldRenderer.getParent().removeRenderer(oldRenderer);
                }
                if (oldRenderer != newRenderer) {
                    plot.removeRenderer(oldRenderer);
                }
            }
            if (oldPlot == null || oldRenderer != newRenderer) {
                Application application = this.dom;
                synchronized (application) {
                    if (newRenderer instanceof SpectrogramRenderer) {
                        plot.addRenderer(0, newRenderer);
                    } else {
                        if (plot == null) {
                            throw new IllegalStateException("plot cannot be null");
                        }
                        Renderer[] rends = plot.getRenderers();
                        PlotElement[] pe = new PlotElement[rends.length];
                        for (int i = 0; i < rends.length; ++i) {
                            PlotElement pe1;
                            pe[i] = pe1 = this.dom.controller.findPlotElement(rends[i]);
                        }
                        int best = -1;
                        int myPos = -1;
                        for (int i = 0; i < this.dom.getPlotElements().length; ++i) {
                            if (this.dom.getPlotElements(i) != this.plotElement) continue;
                            myPos = i;
                        }
                        List<Renderer> arends = Arrays.asList(rends);
                        Renderer lastRend = null;
                        for (int i = 0; i < myPos; ++i) {
                            if (i <= best || i >= myPos || !this.dom.getPlotElements(i).getPlotId().equals(this.plotElement.getPlotId()) || !arends.contains(this.dom.getPlotElements(i).getController().getRenderer())) continue;
                            lastRend = this.dom.getPlotElements(i).getController().getRenderer();
                        }
                        int indexUnder = -1;
                        for (int j = 0; j < rends.length; ++j) {
                            if (rends[j] != lastRend) continue;
                            indexUnder = j;
                        }
                        plot.addRenderer(indexUnder + 1, newRenderer);
                    }
                }
            }
            logger.log(Level.FINEST, "plot.addRenderer {0} {1}", new Object[]{plot, newRenderer});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doResetRenderType(RenderType renderType) {
        PlotElement parentPele = this.getParentPlotElement();
        if (parentPele != null) {
            parentPele.setRenderType(renderType);
            return;
        }
        for (PlotElement ch : this.getChildPlotElements()) {
            Renderer oldRenderer = ch.getController().getRenderer();
            ch.renderType = renderType;
            ch.getController().maybeCreateDasPeer();
            if (oldRenderer == ch.getController().getRenderer()) continue;
            QDataSet oldDs = oldRenderer == null ? null : oldRenderer.getDataSet();
            ch.getController().getRenderer().setDataSet(oldDs);
        }
        ChangesSupport.DomLock lock = this.mutatorLock();
        lock.lock("Reset Render Rype");
        try {
            this.plotElement.propertyChangeSupport.firePropertyChange("renderType", null, (Object)renderType);
        }
        finally {
            lock.unlock();
        }
        Renderer oldRenderer = this.getRenderer();
        this.maybeCreateDasPeer();
        if (this.getRenderer() != null && this.getRenderer() != oldRenderer) {
            QDataSet oldDs;
            QDataSet qDataSet = oldDs = oldRenderer == null ? null : oldRenderer.getDataSet();
            if (oldDs != null) {
                this.getRenderer().setDataSet(oldDs);
            }
        }
    }

    public synchronized void bindToSeriesRenderer(SeriesRenderer seriesRenderer) {
        ApplicationController ac = this.dom.controller;
        ac.bind(this.plotElement.style, "lineWidth", seriesRenderer, "lineWidth");
        ac.bind(this.plotElement.style, "color", seriesRenderer, "color");
        ac.bind(this.plotElement.style, "symbolSize", seriesRenderer, "symSize");
        ac.bind(this.plotElement.style, "symbolConnector", seriesRenderer, "psymConnector");
        ac.bind(this.plotElement.style, "plotSymbol", seriesRenderer, "psym");
        ac.bind(this.plotElement.style, "fillColor", seriesRenderer, "fillColor");
        ac.bind(this.plotElement.style, "fillToReference", seriesRenderer, "fillToReference");
        ac.bind(this.plotElement.style, "reference", seriesRenderer, "reference");
        ac.bind(this.plotElement.style, "antiAliased", seriesRenderer, "antiAliased");
    }

    public void bindToSpectrogramRenderer(SpectrogramRenderer spectrogramRenderer) {
        ApplicationController ac = this.dom.controller;
        ac.bind(this.plotElement.style, "rebinMethod", spectrogramRenderer, "rebinner");
        if (spectrogramRenderer.getColorBar() != null) {
            ac.bind(this.plotElement.style, "colortable", spectrogramRenderer.getColorBar(), "type");
        }
    }

    public void bindToImageVectorDataSetRenderer(ImageVectorDataSetRenderer renderer) {
        ApplicationController ac = this.dom.controller;
        ac.bind(this.plotElement.style, "color", renderer, "color");
    }

    public void bindToEventsRenderer(EventsRenderer renderer) {
        ApplicationController ac = this.dom.controller;
        ac.bind(this.plotElement.style, "color", renderer, "color");
    }

    private Converter getLabelConverter() {
        return new Converter(){

            public Object convertForward(Object value) {
                String title = (String)value;
                if (title.contains("CONTEXT")) {
                    String contextStr = "";
                    if (PlotElementController.this.plotElement != null && PlotElementController.this.dataSet != null) {
                        contextStr = DataSetUtil.contextAsString((QDataSet)PlotElementController.this.dataSet);
                        title = DomNodeController.insertString(title, "CONTEXT", contextStr);
                    }
                }
                if (title.contains("TIMERANGE")) {
                    DatumRange tr = PlotElementControllerUtil.getTimeRange(PlotElementController.this.dom, PlotElementController.this.plotElement);
                    title = tr == null ? DomNodeController.insertString(title, "TIMERANGE", "(no timerange)") : DomNodeController.insertString(title, "TIMERANGE", tr.toString());
                }
                if (title.contains("COMPONENT")) {
                    String ss = "";
                    if (PlotElementController.this.plotElement != null) {
                        ss = PlotElementController.this.plotElement.getComponent();
                    }
                    title = DomNodeController.insertString(title, "COMPONENT", ss);
                }
                return title;
            }

            public Object convertReverse(Object value) {
                String title = (String)value;
                String ptitle = PlotElementController.this.plotElement.getLegendLabel();
                if (DomNodeController.containsString(ptitle, "CONTEXT", title)) {
                    title = ptitle;
                } else if (DomNodeController.containsString(ptitle, "TIMERANGE", title)) {
                    title = ptitle;
                } else if (DomNodeController.containsString(ptitle, "COMPONENT", title)) {
                    title = ptitle;
                }
                return title;
            }
        };
    }

    @Override
    public boolean isPendingChanges() {
        return this.getDataSourceFilter().controller.isPendingChanges() || super.isPendingChanges();
    }

    private void setStatus(String string) {
        this.dom.controller.setStatus(string);
    }

    public String toString() {
        return "" + this.plotElement + " controller";
    }

    private void setParentComponentListener(PropertyChangeListener pcl) {
        this.parentComponentLister = pcl;
    }

    private PropertyChangeListener getParentComponentLister() {
        return this.parentComponentLister;
    }
}

