/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.scriptconsole;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import org.das2.jythoncompletion.JythonCompletionProvider;
import org.das2.jythoncompletion.JythonInterpreterProvider;
import org.das2.jythoncompletion.ui.CompletionImpl;
import org.jdesktop.layout.GroupLayout;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyObject;
import org.python.util.InteractiveInterpreter;
import org.python.util.PythonInterpreter;
import org.virbo.autoplot.ApplicationModel;
import org.virbo.autoplot.JythonUtil;
import org.virbo.autoplot.dom.ApplicationController;
import org.virbo.autoplot.scriptconsole.ScriptPanelSupport;
import org.virbo.datasource.DataSetSelector;
import org.virbo.jythonsupport.ui.EditorContextMenu;
import org.virbo.jythonsupport.ui.EditorTextPane;

public class JythonScriptPanel
extends JPanel {
    File file;
    ApplicationModel model;
    ApplicationController applicationController;
    DataSetSelector selector;
    ScriptPanelSupport support;
    static final int CONTEXT_DATA_SOURCE = 1;
    static final int CONTEXT_APPLICATION = 0;
    private int context = 0;
    private JLabel caretPositionLabel;
    private JComboBox contextSelector;
    private JTextField fileNameTextField;
    private JButton interruptButton;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton newScriptButton;
    private JButton openButton;
    private JButton saveAsButton;
    private JButton savePlotButton;
    private EditorTextPane textArea;
    protected String filename = null;
    public static final String PROP_FILENAME = "filename";
    protected boolean dirty = false;
    public static final String PROP_DIRTY = "dirty";

    public JythonScriptPanel(final ApplicationModel model, DataSetSelector selector) {
        this.initComponents();
        this.jScrollPane2.getVerticalScrollBar().setUnitIncrement(12);
        this.jPanel1.add((Component)this.textArea, "Center");
        this.setContext(0);
        this.support = new ScriptPanelSupport(this, model, selector);
        this.model = model;
        this.applicationController = model.getDocumentModel().getController();
        this.selector = selector;
        this.textArea.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                int pos = JythonScriptPanel.this.textArea.getCaretPosition();
                Element root = JythonScriptPanel.this.textArea.getDocument().getDefaultRootElement();
                int irow = root.getElementIndex(pos);
                int icol = pos - root.getElement(irow).getStartOffset();
                String text = "" + (1 + irow) + "," + (1 + icol);
                int isel = JythonScriptPanel.this.textArea.getSelectionEnd() - JythonScriptPanel.this.textArea.getSelectionStart();
                int iselRow0 = root.getElementIndex(JythonScriptPanel.this.textArea.getSelectionStart());
                int iselRow1 = root.getElementIndex(JythonScriptPanel.this.textArea.getSelectionEnd());
                if (isel > 0) {
                    text = iselRow1 > iselRow0 ? "[" + isel + "ch," + (1 + iselRow1 - iselRow0) + "lines]" : "[" + isel + "ch]";
                }
                JythonScriptPanel.this.caretPositionLabel.setText(text);
            }
        });
        this.textArea.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                JythonScriptPanel.this.setDirty(true);
            }

            public void removeUpdate(DocumentEvent e) {
                JythonScriptPanel.this.setDirty(true);
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.textArea.getActionMap().put("save", new AbstractAction("save"){

            public void actionPerformed(ActionEvent e) {
                try {
                    JythonScriptPanel.this.support.save();
                }
                catch (FileNotFoundException ex) {
                    model.getExceptionHandler().handle((Throwable)ex);
                }
                catch (IOException ex) {
                    model.getExceptionHandler().handle((Throwable)ex);
                }
            }
        });
        this.textArea.getInputMap().put(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "save");
        EditorContextMenu menu = new EditorContextMenu(this.textArea);
        menu.addExampleAction((Action)new AbstractAction("makePngWalk.jy"){

            public void actionPerformed(ActionEvent e) {
                JythonScriptPanel.this.loadExample("/scripts/pngwalk/makePngWalk.jy");
            }
        });
        menu.setDataSetSelector(selector);
        JythonCompletionProvider.getInstance().addPropertyChangeListener("message", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JythonScriptPanel.this.applicationController.setStatus(JythonCompletionProvider.getInstance().getMessage());
            }
        });
        this.support.addPropertyChangeListener("interruptable", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    JythonScriptPanel.this.interruptButton.setEnabled(false);
                    JythonScriptPanel.this.savePlotButton.setEnabled(true);
                } else {
                    JythonScriptPanel.this.interruptButton.setEnabled(true);
                    JythonScriptPanel.this.savePlotButton.setEnabled(false);
                }
            }
        });
        CompletionImpl impl = CompletionImpl.get();
        impl.startPopup((JTextComponent)this.textArea);
    }

    private void loadExample(String resourceFile) {
        try {
            URL url = EditorContextMenu.class.getResource(resourceFile);
            if (this.isDirty() && this.support.saveAs() == 2) {
                return;
            }
            this.support.loadInputStream(url.openStream());
        }
        catch (IOException ex) {
            Logger.getLogger(EditorContextMenu.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void updateStatus() {
        if (this.filename == null) {
            this.fileNameTextField.setText("" + (this.dirty ? " *" : ""));
        } else {
            File lfile = new File(this.filename);
            this.getEditorPanel().setEditable(lfile.canWrite());
            this.fileNameTextField.setText(this.filename + (lfile.canWrite() ? "" : " (read only)") + (this.dirty ? " *" : ""));
        }
    }

    int getContext() {
        return this.context;
    }

    void setContext(int context) {
        int oldContext = this.context;
        if (oldContext != context) {
            this.file = null;
        }
        this.context = context;
        this.contextSelector.setSelectedIndex(context);
        if (context == 0) {
            this.textArea.putClientProperty((Object)"JYTHON_INTERPRETER_PROVIDER", (Object)new JythonInterpreterProvider(){

                public PythonInterpreter createInterpreter() throws IOException {
                    InteractiveInterpreter interp = JythonUtil.createInterpreter(true, false);
                    interp.set("dom", (Object)JythonScriptPanel.this.model.getDocumentModel());
                    interp.set("params", (PyObject)new PyDictionary());
                    interp.set("resourceURI", Py.None);
                    return interp;
                }
            });
        } else if (context == 1) {
            this.textArea.putClientProperty((Object)"JYTHON_INTERPRETER_PROVIDER", (Object)new JythonInterpreterProvider(){

                public PythonInterpreter createInterpreter() throws IOException {
                    InteractiveInterpreter interp = JythonUtil.createInterpreter(false, false);
                    interp.set("params", (PyObject)new PyDictionary());
                    interp.set("resourceURI", Py.None);
                    return interp;
                }
            });
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.textArea = new EditorTextPane();
        this.savePlotButton = new JButton();
        this.saveAsButton = new JButton();
        this.openButton = new JButton();
        this.contextSelector = new JComboBox();
        this.caretPositionLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.newScriptButton = new JButton();
        this.interruptButton = new JButton();
        this.fileNameTextField = new JTextField();
        this.textArea.setFont(new Font("Monospaced", 0, 13));
        this.textArea.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                JythonScriptPanel.this.textAreaFocusGained(evt);
            }
        });
        this.jScrollPane1.setViewportView((Component)this.textArea);
        this.savePlotButton.setIcon(new ImageIcon(this.getClass().getResource("/org/virbo/autoplot/go.png")));
        this.savePlotButton.setText("Execute");
        this.savePlotButton.setToolTipText("Execute script.  Ctrl modifier attempts to trace program location.  ");
        this.savePlotButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JythonScriptPanel.this.savePlotButtonActionPerformed(evt);
            }
        });
        this.saveAsButton.setText("Save As...");
        this.saveAsButton.setToolTipText("Save the buffer to a local file.");
        this.saveAsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JythonScriptPanel.this.saveAsButtonActionPerformed(evt);
            }
        });
        this.openButton.setText("Open...");
        this.openButton.setToolTipText("Open the local file to the buffer.");
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JythonScriptPanel.this.openButtonActionPerformed(evt);
            }
        });
        this.contextSelector.setModel(new DefaultComboBoxModel<String>(new String[]{"Application Context", "Data Source Context"}));
        this.contextSelector.setToolTipText("<html>select the context for the script: to create new datasets (data source context), or to control an application (application context)</html>\n");
        this.contextSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JythonScriptPanel.this.contextSelectorActionPerformed(evt);
            }
        });
        this.caretPositionLabel.setText("1,1");
        this.jPanel1.setLayout(new BorderLayout());
        this.jScrollPane2.setViewportView(this.jPanel1);
        this.newScriptButton.setText("New");
        this.newScriptButton.setToolTipText("Reset the buffer to a new file.");
        this.newScriptButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JythonScriptPanel.this.newScriptButtonActionPerformed(evt);
            }
        });
        this.interruptButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/stop.png")));
        this.interruptButton.setText("Stop");
        this.interruptButton.setToolTipText("Interrupt running script");
        this.interruptButton.setEnabled(false);
        this.interruptButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JythonScriptPanel.this.interruptButtonActionPerformed(evt);
            }
        });
        this.fileNameTextField.setEditable(false);
        this.fileNameTextField.setFont(this.fileNameTextField.getFont().deriveFont((float)this.fileNameTextField.getFont().getSize() - 2.0f));
        this.fileNameTextField.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.savePlotButton, -2, 124, -2).addPreferredGap(0).add((Component)this.interruptButton).add(7, 7, 7).add((Component)this.saveAsButton).addPreferredGap(0).add((Component)this.openButton).addPreferredGap(0).add((Component)this.newScriptButton).addPreferredGap(0, 44, Short.MAX_VALUE).add((Component)this.contextSelector, -2, -1, -2)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.fileNameTextField, -1, 490, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.caretPositionLabel, -2, 81, -2)).add((Component)this.jScrollPane2, -1, 583, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.savePlotButton).add((Component)this.contextSelector, -2, -1, -2).add((Component)this.saveAsButton).add((Component)this.openButton).add((Component)this.newScriptButton).add((Component)this.interruptButton)).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 280, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.caretPositionLabel).add((Component)this.fileNameTextField, -2, -1, -2))));
        layout.linkSize(new Component[]{this.interruptButton, this.newScriptButton, this.openButton, this.saveAsButton, this.savePlotButton}, 2);
    }

    private void savePlotButtonActionPerformed(ActionEvent evt) {
        if ((evt.getModifiers() & 2) == 2) {
            this.support.executeScript(true);
        } else {
            this.support.executeScript();
        }
    }

    private void saveAsButtonActionPerformed(ActionEvent evt) {
        this.support.saveAs();
    }

    private void openButtonActionPerformed(ActionEvent evt) {
        this.support.open();
    }

    private void contextSelectorActionPerformed(ActionEvent evt) {
        this.setContext(this.contextSelector.getSelectedIndex());
    }

    private void textAreaFocusGained(FocusEvent evt) {
        CompletionImpl impl = CompletionImpl.get();
        impl.startPopup((JTextComponent)this.textArea);
    }

    private void newScriptButtonActionPerformed(ActionEvent evt) {
        this.support.newScript();
    }

    private void interruptButtonActionPerformed(ActionEvent evt) {
        this.support.interrupt();
    }

    public EditorTextPane getEditorPanel() {
        return this.textArea;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        String oldFilename = this.filename;
        this.filename = filename;
        this.updateStatus();
        this.firePropertyChange(PROP_FILENAME, oldFilename, filename);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        boolean oldDirty = this.dirty;
        this.dirty = dirty;
        if (oldDirty != dirty) {
            this.updateStatus();
        }
        this.firePropertyChange(PROP_DIRTY, oldDirty, dirty);
    }

    public boolean loadFile(File file) throws IOException {
        if (this.isDirty()) {
            return false;
        }
        this.support.loadFile(file);
        return true;
    }
}

