/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.scriptconsole;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingOutputStream
extends ByteArrayOutputStream {
    private String lineSeparator;
    private Logger logger;
    private Level level;

    public LoggingOutputStream(Logger logger, Level level) {
        this.logger = logger;
        this.level = level;
        this.lineSeparator = System.getProperty("line.separator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        LoggingOutputStream loggingOutputStream = this;
        synchronized (loggingOutputStream) {
            super.flush();
            String record = this.toString();
            if (!record.contains(this.lineSeparator)) {
                return;
            }
            super.reset();
            if (record.length() == 0 || record.equals(this.lineSeparator)) {
                return;
            }
            String[] ss = record.split("\n");
            for (int i = 0; i < ss.length; ++i) {
                this.logger.logp(this.level, "", "", ss[i]);
            }
        }
    }
}

