/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.state;

import java.awt.Color;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.beans.BeansUtil;
import org.das2.datum.Datum;
import org.das2.graph.DasColorBar;
import org.das2.graph.DefaultPlotSymbol;
import org.das2.graph.PlotSymbol;
import org.das2.graph.PsymConnector;
import org.das2.graph.SpectrogramRenderer;
import org.das2.system.DasLogger;
import org.das2.system.LoggerId;
import org.virbo.autoplot.RenderType;
import org.virbo.autoplot.dom.BindingModel;
import org.virbo.autoplot.dom.Connector;
import org.virbo.autoplot.dom.DomNode;
import org.virbo.autoplot.dom.DomUtil;
import org.virbo.autoplot.state.BindingModelSerializeDelegate;
import org.virbo.autoplot.state.ColorSerializeDelegate;
import org.virbo.autoplot.state.ConnectorSerializeDelegate;
import org.virbo.autoplot.state.DatumSerializeDelegate;
import org.virbo.autoplot.state.TypeSafeEnumSerializeDelegate;
import org.virbo.autoplot.state.VapScheme;
import org.virbo.qstream.SerializeDelegate;
import org.virbo.qstream.SerializeRegistry;
import org.virbo.qstream.XMLSerializeDelegate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SerializeUtil {
    public static Element getDomElement(Document document, DomNode node, VapScheme scheme) {
        try {
            Logger log = DasLogger.getLogger((LoggerId)DasLogger.SYSTEM_LOG);
            String elementName = scheme.getName(node.getClass());
            DomNode defl = (DomNode)node.getClass().newInstance();
            Element element = null;
            element = document.createElement(elementName);
            BeanInfo info = BeansUtil.getBeanInfo(node.getClass());
            PropertyDescriptor[] properties = info.getPropertyDescriptors();
            for (int i = 0; i < properties.length; ++i) {
                Element child;
                Object value1;
                int j;
                String clasName;
                Element propertyElement;
                PropertyDescriptor pd = properties[i];
                String propertyName = pd.getName();
                if (propertyName.equals("class") || propertyName.equals("controller")) continue;
                log.fine("serializing property \"" + propertyName + "\" of " + elementName + " id=" + node.getId());
                Method readMethod = pd.getReadMethod();
                Method writeMethod = pd.getWriteMethod();
                if (writeMethod == null || readMethod == null) {
                    log.info("skipping property \"" + propertyName + "\" of " + elementName + ", failed to find read and write method.");
                    continue;
                }
                Object value = null;
                try {
                    value = readMethod.invoke((Object)node, new Object[0]);
                }
                catch (IllegalAccessException ex) {
                    log.log(Level.SEVERE, null, ex);
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    log.log(Level.SEVERE, null, ex);
                    continue;
                }
                catch (InvocationTargetException ex) {
                    log.log(Level.SEVERE, null, ex);
                    continue;
                }
                if (value == null) {
                    log.info("skipping property " + propertyName + " of " + elementName + ", value is null.");
                    continue;
                }
                if (propertyName.equals("id") && ((String)value).length() > 0) {
                    element.setAttribute(propertyName, (String)value);
                    continue;
                }
                IndexedPropertyDescriptor ipd = null;
                if (pd instanceof IndexedPropertyDescriptor) {
                    ipd = (IndexedPropertyDescriptor)pd;
                }
                if (value instanceof DomNode) {
                    propertyElement = document.createElement("property");
                    propertyElement.setAttribute("name", propertyName);
                    propertyElement.setAttribute("type", "DomNode");
                    Element child2 = SerializeUtil.getDomElement(document, (DomNode)value, scheme);
                    propertyElement.appendChild(child2);
                    element.appendChild(propertyElement);
                    continue;
                }
                if (ipd != null && DomNode.class.isAssignableFrom(ipd.getIndexedPropertyType())) {
                    propertyElement = document.createElement("property");
                    propertyElement.setAttribute("name", propertyName);
                    clasName = scheme.getName(ipd.getIndexedPropertyType());
                    propertyElement.setAttribute("class", clasName);
                    propertyElement.setAttribute("length", String.valueOf(Array.getLength(value)));
                    for (j = 0; j < Array.getLength(value); ++j) {
                        value1 = Array.get(value, j);
                        child = SerializeUtil.getDomElement(document, (DomNode)value1, scheme);
                        propertyElement.appendChild(child);
                    }
                    element.appendChild(propertyElement);
                    continue;
                }
                if (ipd != null) {
                    propertyElement = document.createElement("property");
                    propertyElement.setAttribute("name", propertyName);
                    clasName = scheme.getName(ipd.getIndexedPropertyType());
                    propertyElement.setAttribute("class", clasName);
                    propertyElement.setAttribute("length", String.valueOf(Array.getLength(value)));
                    for (j = 0; j < Array.getLength(value); ++j) {
                        value1 = Array.get(value, j);
                        child = SerializeUtil.getElementForLeafNode(document, ipd.getIndexedPropertyType(), value1, null);
                        propertyElement.appendChild(child);
                    }
                    element.appendChild(propertyElement);
                    continue;
                }
                Object defltValue = DomUtil.getPropertyValue(defl, pd.getName());
                Element prop = SerializeUtil.getElementForLeafNode(document, pd.getPropertyType(), value, defltValue);
                if (prop == null) {
                    log.warning("unable to serialize " + propertyName);
                    continue;
                }
                prop.setAttribute("name", pd.getName());
                element.appendChild(prop);
            }
            return element;
        }
        catch (IntrospectionException ex) {
            Logger.getLogger(SerializeUtil.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(SerializeUtil.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(SerializeUtil.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(SerializeUtil.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(SerializeUtil.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    public static Element getElementForLeafNode(Document document, Class propClass, Object value, Object defltValue) {
        boolean isDef = defltValue == value || defltValue != null && defltValue.equals(value);
        SerializeDelegate sd = SerializeRegistry.getDelegate((Class)propClass);
        if (sd == null) {
            return null;
        }
        Element prop = document.createElement("property");
        if (sd instanceof XMLSerializeDelegate) {
            prop.appendChild(((XMLSerializeDelegate)sd).xmlFormat(document, value));
            prop.setAttribute("type", sd.typeId(value.getClass()));
        } else {
            prop.setAttribute("type", sd.typeId(value.getClass()));
            prop.setAttribute("value", sd.format(value));
            if (!isDef) {
                if (defltValue == null) {
                    prop.setAttribute("default", "null");
                } else {
                    prop.setAttribute("default", sd.format(defltValue));
                }
            }
        }
        return prop;
    }

    private static Element firstChildElement(Element element) {
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!(nl.item(i) instanceof Element)) continue;
            return (Element)nl.item(i);
        }
        throw new IllegalArgumentException("Element has no children that are elements");
    }

    public static Object getLeafNode(Element element) throws ParseException {
        String type = element.getAttribute("type");
        SerializeDelegate sd = SerializeRegistry.getByName((String)type);
        if (sd == null) {
            throw new IllegalArgumentException("unable to find serialize delegate for \"" + type + "\"");
        }
        if (element.hasChildNodes()) {
            return ((XMLSerializeDelegate)sd).xmlParse(SerializeUtil.firstChildElement(element));
        }
        return sd.parse(type, element.getAttribute("value"));
    }

    public static DomNode getDomNode(Element element, VapScheme scheme) throws ParseException {
        try {
            DomNode node = null;
            String clasName = element.getNodeName();
            Class claz = scheme.getClass(clasName);
            node = (DomNode)claz.newInstance();
            BeanInfo info = BeansUtil.getBeanInfo(node.getClass());
            PropertyDescriptor[] properties = info.getPropertyDescriptors();
            HashMap<String, PropertyDescriptor> pp = new HashMap<String, PropertyDescriptor>();
            for (int i = 0; i < properties.length; ++i) {
                pp.put(properties[i].getName(), properties[i]);
            }
            if (element.hasAttribute("id")) {
                node.setId(element.getAttribute("id"));
            }
            NodeList kids = element.getChildNodes();
            for (int i = 0; i < kids.getLength(); ++i) {
                Node k = kids.item(i);
                if (!(k instanceof Element)) continue;
                Element e = (Element)k;
                try {
                    PropertyDescriptor pd = (PropertyDescriptor)pp.get(e.getAttribute("name"));
                    if (pd == null) {
                        throw new NullPointerException("expected to find attribute \"name\"");
                    }
                    String slen = e.getAttribute("length");
                    if (slen != null && slen.length() > 0) {
                        Object c1;
                        int j;
                        int ik;
                        NodeList arraykids;
                        clasName = e.getAttribute("class");
                        Class c = scheme.getClass(clasName);
                        int n = Integer.parseInt(e.getAttribute("length"));
                        Object arr = Array.newInstance(c, n);
                        if (DomNode.class.isAssignableFrom(c)) {
                            arraykids = e.getChildNodes();
                            ik = 0;
                            for (j = 0; j < n; ++j) {
                                while (ik < arraykids.getLength() && !(arraykids.item(ik) instanceof Element)) {
                                    ++ik;
                                }
                                if (!(arraykids.item(ik) instanceof Element)) {
                                    throw new ParseException("didn't find " + n + " elements under array item in " + e.getAttribute("name"), 0);
                                }
                                c1 = SerializeUtil.getDomNode((Element)arraykids.item(ik), scheme);
                                ++ik;
                                Array.set(arr, j, c1);
                            }
                            pd.getWriteMethod().invoke((Object)node, arr);
                            continue;
                        }
                        arraykids = e.getChildNodes();
                        ik = 0;
                        for (j = 0; j < n; ++j) {
                            c1 = null;
                            while (!(arraykids.item(ik) instanceof Element)) {
                                ++ik;
                            }
                            c1 = SerializeUtil.getLeafNode((Element)arraykids.item(ik));
                            ++ik;
                            Array.set(arr, j, c1);
                        }
                        pd.getWriteMethod().invoke((Object)node, arr);
                        continue;
                    }
                    String stype = e.getAttribute("type");
                    if (!stype.equals("DomNode")) {
                        Object child = SerializeUtil.getLeafNode(e);
                        pd.getWriteMethod().invoke((Object)node, child);
                        continue;
                    }
                    Node childElement = e.getFirstChild();
                    while (!(childElement instanceof Element)) {
                        childElement = childElement.getNextSibling();
                    }
                    DomNode child = SerializeUtil.getDomNode((Element)childElement, scheme);
                    pd.getWriteMethod().invoke((Object)node, child);
                    continue;
                }
                catch (RuntimeException ex) {
                    if (scheme.resolveProperty(e, node)) {
                        System.err.println("imported " + e.getAttribute("name"));
                        continue;
                    }
                    scheme.addUnresolvedProperty(e, node, ex);
                    continue;
                }
                catch (Exception ex) {
                    if (scheme.resolveProperty(e, node)) {
                        System.err.println("imported " + e.getAttribute("name"));
                        continue;
                    }
                    scheme.addUnresolvedProperty(e, node, ex);
                }
            }
            String unres = scheme.describeUnresolved();
            if (unres != null && unres.trim().length() > 0) {
                System.err.println(unres);
            }
            return node;
        }
        catch (IntrospectionException ex) {
            Logger.getLogger(SerializeUtil.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(SerializeUtil.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(SerializeUtil.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(SerializeUtil.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    static {
        SerializeRegistry.register(BindingModel.class, (SerializeDelegate)new BindingModelSerializeDelegate());
        SerializeRegistry.register(Connector.class, (SerializeDelegate)new ConnectorSerializeDelegate());
        SerializeRegistry.register(Datum.class, (SerializeDelegate)new DatumSerializeDelegate());
        SerializeRegistry.register(Enum.class, (SerializeDelegate)new TypeSafeEnumSerializeDelegate());
        SerializeRegistry.register(Color.class, (SerializeDelegate)new ColorSerializeDelegate());
        SerializeRegistry.register(DasColorBar.Type.class, (SerializeDelegate)new TypeSafeEnumSerializeDelegate());
        SerializeRegistry.register(DefaultPlotSymbol.class, (SerializeDelegate)new TypeSafeEnumSerializeDelegate());
        SerializeRegistry.register(PsymConnector.class, (SerializeDelegate)new TypeSafeEnumSerializeDelegate());
        SerializeRegistry.register(SpectrogramRenderer.RebinnerEnum.class, (SerializeDelegate)new TypeSafeEnumSerializeDelegate());
        SerializeRegistry.register(RenderType.class, (SerializeDelegate)new TypeSafeEnumSerializeDelegate());
        SerializeRegistry.register(PlotSymbol.class, (SerializeDelegate)new TypeSafeEnumSerializeDelegate());
    }
}

