/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.Timer;
import org.das2.util.ClassMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanvasLayoutPanel
extends JLabel {
    JComponent target;
    ClassMap<Color> types;
    Timer timer;
    private boolean adjusting = false;
    transient MouseListener mouseListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            int mwidth;
            double scale;
            if (CanvasLayoutPanel.this.target == null) {
                return;
            }
            int twidth = CanvasLayoutPanel.this.target.getWidth();
            int theight = CanvasLayoutPanel.this.target.getHeight();
            if ((double)theight * (scale = (double)(mwidth = CanvasLayoutPanel.this.getWidth()) / (double)twidth) > (double)CanvasLayoutPanel.this.getHeight()) {
                scale = (double)CanvasLayoutPanel.this.getHeight() / (double)theight;
            }
            CanvasLayoutPanel.this.adjusting = true;
            for (int i = CanvasLayoutPanel.this.target.getComponentCount() - 1; i >= 0; --i) {
                boolean invisibleEdgeClick;
                Component c = CanvasLayoutPanel.this.target.getComponent(i);
                Color color = (Color)CanvasLayoutPanel.this.types.get(c.getClass());
                if (color == null) continue;
                Rectangle bounds = ((JComponent)c).getBounds();
                Rectangle mbounds = new Rectangle((int)((double)bounds.x * scale), (int)((double)bounds.y * scale), (int)((double)bounds.width * scale), (int)((double)bounds.height * scale));
                int km = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
                boolean bl = invisibleEdgeClick = !c.isVisible() && CanvasLayoutPanel.this.rectEdgeClicked(mbounds, e.getX(), e.getY());
                if (!c.isVisible() && !invisibleEdgeClick || !mbounds.contains(e.getX(), e.getY()) && !invisibleEdgeClick) continue;
                if ((e.getModifiers() & km) == km) {
                    if (CanvasLayoutPanel.this.selectedComponents.contains(c)) {
                        CanvasLayoutPanel.this.selectedComponents.remove(c);
                        CanvasLayoutPanel.this.component = null;
                    } else {
                        CanvasLayoutPanel.this.selectedComponents.add(c);
                        CanvasLayoutPanel.this.component = c;
                    }
                } else {
                    CanvasLayoutPanel.this.component = c;
                    CanvasLayoutPanel.this.selectedComponents.clear();
                    CanvasLayoutPanel.this.selectedComponents.add(c);
                }
                CanvasLayoutPanel.this.repaint();
                CanvasLayoutPanel.this.firePropertyChange(CanvasLayoutPanel.PROP_COMPONENT, null, c);
                if ((e.getModifiers() & km) != km) continue;
                CanvasLayoutPanel.this.firePropertyChange(CanvasLayoutPanel.PROP_SELECTEDCOMPONENTS, null, CanvasLayoutPanel.this.selectedComponents);
            }
            CanvasLayoutPanel.this.adjusting = false;
        }
    };
    protected Object component = null;
    public static final String PROP_COMPONENT = "component";
    protected List<Object> selectedComponents = new ArrayList<Object>();
    public static final String PROP_SELECTEDCOMPONENTS = "selectedComponents";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    transient ComponentListener componentListener = new ComponentListener(){

        public void componentResized(ComponentEvent e) {
            CanvasLayoutPanel.this.timer.restart();
        }

        public void componentMoved(ComponentEvent e) {
            CanvasLayoutPanel.this.timer.restart();
        }

        public void componentShown(ComponentEvent e) {
            CanvasLayoutPanel.this.timer.restart();
        }

        public void componentHidden(ComponentEvent e) {
            CanvasLayoutPanel.this.timer.restart();
        }
    };

    public CanvasLayoutPanel() {
        this.types = new ClassMap();
        this.timer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CanvasLayoutPanel.this.repaint();
            }
        });
        this.timer.setRepeats(false);
        this.addMouseListener(this.mouseListener);
    }

    private boolean rectEdgeClicked(Rectangle r, int x, int y) {
        boolean e0 = Math.abs(r.getX() - (double)x) < 10.0;
        boolean e1 = Math.abs(r.getY() - (double)y) < 10.0;
        boolean e2 = Math.abs(r.getX() + r.getWidth() - (double)x) < 10.0;
        boolean e3 = Math.abs(r.getY() + r.getHeight() - (double)y) < 10.0;
        return (e0 || e1 || e2 || e3) && r.intersects(x - 10, y - 10, x + 20, y + 20);
    }

    public Object getComponent() {
        return this.component;
    }

    public void setComponent(Object component) {
        Object oldComponent = this.component;
        this.component = component;
        this.repaint();
        this.firePropertyChange(PROP_COMPONENT, oldComponent, component);
    }

    public List<Object> getSelectedComponents() {
        return new ArrayList<Object>(this.selectedComponents);
    }

    public void setSelectedComponents(List<Object> selectedComponents) {
        if (this.adjusting) {
            return;
        }
        List<Object> oldSelectedComponents = this.selectedComponents;
        this.selectedComponents = new ArrayList<Object>(selectedComponents);
        this.propertyChangeSupport.firePropertyChange(PROP_SELECTEDCOMPONENTS, oldSelectedComponents, selectedComponents);
    }

    private Color getTranslucentColor(Color c, int alpha) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    @Override
    protected void paintComponent(Graphics g1) {
        if (this.target == null) {
            return;
        }
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.getBackground());
        int theight = this.target.getHeight();
        int twidth = this.target.getWidth();
        int mwidth = this.getWidth();
        double scale = (double)mwidth / (double)twidth;
        if ((double)theight * scale > (double)this.getHeight()) {
            scale = (double)this.getHeight() / (double)theight;
        }
        g.fillRect(0, 0, mwidth, (int)((double)theight * scale));
        BasicStroke selectedStroke = new BasicStroke(3.0f);
        BasicStroke normalStroke = new BasicStroke(1.0f);
        for (int i = 0; i < this.target.getComponentCount(); ++i) {
            Component c = this.target.getComponent(i);
            Color color = (Color)this.types.get(c.getClass());
            if (color == null) continue;
            Rectangle bounds = ((JComponent)c).getBounds();
            Rectangle mbounds = new Rectangle((int)((double)bounds.x * scale), (int)((double)bounds.y * scale), (int)((double)bounds.width * scale), (int)((double)bounds.height * scale));
            if (!c.isVisible()) {
                g.setColor(this.getTranslucentColor(color, 160));
                Graphics2D g2 = g;
                if (this.selectedComponents.contains(c)) {
                    g2.setStroke(selectedStroke);
                } else {
                    g2.setStroke(normalStroke);
                }
                mbounds = new Rectangle(mbounds.x + 5, mbounds.y + 5, mbounds.width - 10, mbounds.height - 10);
                g2.drawRoundRect(mbounds.x, mbounds.y, mbounds.width, mbounds.height, 10, 10);
                g2.setStroke(normalStroke);
                continue;
            }
            if (c == this.component) {
                g.setColor(this.getTranslucentColor(color, 160));
                g.fillRoundRect(mbounds.x, mbounds.y, mbounds.width, mbounds.height, 10, 10);
                g.setColor(this.getTranslucentColor(color, 220));
                g.setStroke(selectedStroke);
                g.drawRoundRect(mbounds.x, mbounds.y, mbounds.width, mbounds.height, 10, 10);
                g.setStroke(normalStroke);
                continue;
            }
            if (this.selectedComponents.contains(c)) {
                g.setColor(this.getTranslucentColor(color, 130));
                g.fillRoundRect(mbounds.x, mbounds.y, mbounds.width, mbounds.height, 10, 10);
                g.setColor(this.getTranslucentColor(color, 220));
                g.drawRoundRect(mbounds.x, mbounds.y, mbounds.width, mbounds.height, 10, 10);
                continue;
            }
            g.setColor(this.getTranslucentColor(color, 60));
            g.fillRoundRect(mbounds.x, mbounds.y, mbounds.width, mbounds.height, 10, 10);
            g.setColor(this.getTranslucentColor(color, 160));
            g.drawRoundRect(mbounds.x, mbounds.y, mbounds.width, mbounds.height, 10, 10);
        }
    }

    public void setContainer(JComponent c) {
        this.target = c;
        c.addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent e) {
                e.getChild().addComponentListener(CanvasLayoutPanel.this.componentListener);
                CanvasLayoutPanel.this.timer.restart();
            }

            public void componentRemoved(ContainerEvent e) {
                e.getChild().removeComponentListener(CanvasLayoutPanel.this.componentListener);
                CanvasLayoutPanel.this.timer.restart();
            }
        });
    }

    public void addComponentType(Class c, Color color) {
        this.types.put(c, (Object)color);
    }
}

