/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.datasource;

import java.util.List;
import javax.swing.JOptionPane;
import org.das2.components.DasProgressPanel;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.datasource.DataSourceEditorPanel;
import org.virbo.datasource.DataSourceEditorPanelUtil;
import org.virbo.datasource.DataSourceFormat;
import org.virbo.datasource.DataSourceRegistry;

public class TestFindDiscoveryDataSources {
    public static void main(String[] args) {
        DataSourceFormat s;
        DataSourceRegistry registry = DataSourceRegistry.getInstance();
        registry.discoverFactories();
        registry.discoverRegistryEntries();
        System.err.println("== Autoplot can format to ==");
        List exts = registry.getFormatterExtensions();
        for (String ext : exts) {
            s = DataSourceRegistry.getInstance().getFormatByExt(ext);
            System.err.printf("%s: %s\n", ext, s);
        }
        System.err.println("== Autoplot can read ==");
        exts = registry.getSourceExtensions();
        for (String ext : exts) {
            s = DataSourceRegistry.getInstance().getSource(ext);
            System.err.printf("%s: %s\n", ext, s);
        }
        System.err.println("== Autoplot can discover ==");
        exts = registry.getSourceEditorExtensions();
        for (String ext : exts) {
            String uri = "vap+" + ext.substring(1) + ":";
            try {
                DataSourceEditorPanel p = DataSourceEditorPanelUtil.getEditorByExt((String)ext);
                if (p.reject(uri)) {
                    System.err.printf("           (nope) %s: %s\n", ext, p);
                    continue;
                }
                System.err.printf("%s: %s\n", ext, p);
                p.prepare(uri, null, (ProgressMonitor)DasProgressPanel.createFramed((String)("entering " + ext)));
                p.setURI(uri);
                JOptionPane.showMessageDialog(null, p.getPanel());
            }
            catch (Exception ex) {
                System.err.printf("           (exception) %s  %s\n", ext, ex);
            }
        }
    }
}

