/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.PrintWriter;
import org.virbo.autoplot.ScriptContext;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dsops.Ops;
import org.virbo.jythonsupport.Util;

public class Test007 {
    public static void doTest(int id, String uri) throws Exception {
        long t0 = System.currentTimeMillis();
        QDataSet ds = Util.getDataSet((String)uri);
        double t = (double)(System.currentTimeMillis() - t0) / 1000.0;
        MutablePropertyDataSet hist = (MutablePropertyDataSet)Ops.autoHistogram((QDataSet)ds);
        hist.putProperty("TITLE", (Object)uri);
        String label = String.format("test007_%03d", id);
        hist.putProperty("LABEL", (Object)label);
        ScriptContext.formatDataSet((QDataSet)hist, label + ".qds");
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null) {
            MutablePropertyDataSet hist2 = (MutablePropertyDataSet)Ops.autoHistogram((QDataSet)dep0);
            ScriptContext.formatDataSet((QDataSet)hist2, label + ".dep0.qds");
        } else {
            PrintWriter pw = new PrintWriter(label + ".dep0.qds");
            pw.println("no dep0");
            pw.close();
        }
        ScriptContext.plot(ds);
        int i = uri.lastIndexOf("/");
        ScriptContext.setTitle(uri.substring(i + 1));
        ScriptContext.writeToPng(String.format("test007_%03d.png", id));
        System.err.printf("Read in %9.3f seconds (%s): %s\n", t, label, uri);
    }

    public static void main(String[] args) {
        try {
            ScriptContext.setCanvasSize(750, 300);
            ScriptContext.getDocumentModel().getOptions().setAutolayout(false);
            ScriptContext.getDocumentModel().getCanvases(0).getMarginColumn().setRight("100%-10em");
            Test007.doTest(0, "vap+tsds:http://timeseries.org/get.cgi?StartDate=19980101&EndDate=20090101&ppd=1&ext=bin&out=tsml&param1=NGDC_NOAA15_SEM2-33-v0");
            Test007.doTest(1, "vap+tsds:http://timeseries.org/cgi-bin/get.cgi?StartDate=19900301&EndDate=19900302&ppd=24&ext=bin&out=bin&param1=SourceAcronym_Subset2-1-v0");
            Test007.doTest(2, "vap+tsds:http://timeseries.org/get3.cgi?StartDate=19900301&EndDate=19900301&ppd=24&ext=bin&out=ncml&param1=SourceAcronym_Subset2-1-v0");
            Test007.doTest(3, "vap+tsds:http://timeseries.org/get3.cgi?StartDate=19930101&EndDate=20031231&ppd=1&ext=bin&out=ncml&param1=Kanekal_SAMPEX_elo_1hour-1-v0");
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

