/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.PrintWriter;
import org.virbo.autoplot.ScriptContext;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dsops.Ops;
import org.virbo.jythonsupport.Util;

public class Test008 {
    public static boolean debug = false;

    public static void doTest(int id, String uri) throws Exception {
        long t0 = System.currentTimeMillis();
        QDataSet ds = Util.getDataSet((String)uri);
        double t = (double)(System.currentTimeMillis() - t0) / 1000.0;
        MutablePropertyDataSet hist = (MutablePropertyDataSet)Ops.autoHistogram((QDataSet)ds);
        hist.putProperty("TITLE", (Object)uri);
        String label = String.format("test008_%03d", id);
        hist.putProperty("LABEL", (Object)label);
        ScriptContext.formatDataSet((QDataSet)hist, label + ".qds");
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null) {
            MutablePropertyDataSet hist2 = (MutablePropertyDataSet)Ops.autoHistogram((QDataSet)dep0);
            ScriptContext.formatDataSet((QDataSet)hist2, label + ".dep0.qds");
        } else {
            PrintWriter pw = new PrintWriter(label + ".dep0.qds");
            pw.println("no dep0");
            pw.close();
        }
        ScriptContext.plot(ds);
        ScriptContext.setCanvasSize(750, 300);
        int i = uri.lastIndexOf("/");
        ScriptContext.setTitle(uri.substring(i + 1));
        ScriptContext.writeToPng(String.format("test008_%03d.png", id));
        System.err.printf("Read in %9.3f seconds (%s): %s\n", t, label, uri);
    }

    public static void main(String[] args) {
        try {
            ScriptContext.getDocumentModel().getOptions().setAutolayout(false);
            ScriptContext.getDocumentModel().getCanvases(0).getMarginColumn().setRight("100%-10em");
            Test008.doTest(0, "file:///home/jbf/ct/hudson/data.backup/dat/ACE_sis_level2_data_1hr_1283.txt?time=year&timeFormat=%Y+%j+%H+%M+%S&depend1Labels=5:13&rank2=5:13&skip=2&validMin=2e-09");
            ScriptContext.load("/home/jbf/ct/hudson/vap/ace_sis_level2_data_server_v1.03.vap");
            ScriptContext.setCanvasSize(750, 300);
            ScriptContext.writeToPng("test008_001.png");
            Test008.doTest(2, "file:///home/jbf/ct/hudson/data.backup/dat/ACE_sis_level2_data_1hr_1283.txt?time=year&timeFormat=%Y+%j+%H+%M+%S&intervalTag=start&depend1Labels=5:13&rank2=5:13&skip=2&validMin=2e-09");
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

