/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Random;
import org.das2.client.DataSetStreamHandler;
import org.das2.dataset.DataSet;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.stream.StreamHandler;
import org.das2.stream.StreamTool;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.autoplot.ScriptContext;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.FDataSet;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.QubeDataSetIterator;
import org.virbo.dataset.WritableDataSet;
import org.virbo.dsops.Ops;
import org.virbo.qstream.QDataSetStreamHandler;
import org.virbo.qstream.SimpleStreamFormatter;
import org.virbo.qstream.StreamException;
import test.BundleBinsDemo;
import test.endtoend.TestSupport;

public class Test013 {
    static long t0 = System.currentTimeMillis();

    public static void xxx(String id) {
        System.err.println("-- timer -- " + id + " --: " + (System.currentTimeMillis() - t0));
        t0 = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void formatParse(QDataSet ds, String file) throws FileNotFoundException, IOException, StreamException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            SimpleStreamFormatter format = new SimpleStreamFormatter();
            System.err.println("attempt to format " + ds + " into " + file);
            format.format(ds, (OutputStream)out, true);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            QDataSetStreamHandler handler = new QDataSetStreamHandler();
            System.err.println("attempt to parse " + file);
            org.virbo.qstream.StreamTool.readStream((ReadableByteChannel)Channels.newChannel(in), (org.virbo.qstream.StreamHandler)handler);
            QDataSet qds = handler.getDataSet();
            System.err.println(qds);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private static QDataSet test1() throws ParseException, StreamException, IOException {
        QDataSet ds = Ops.timegen((String)"2003-09-09", (String)("1 " + Units.days), (int)11);
        Test013.formatParse(ds, "test013_test1.qds");
        return ds;
    }

    private static QDataSet test1_5() throws ParseException, StreamException, IOException {
        QDataSet ds = Ops.labels((String[])new String[]{"B-GSM,X", "B-GSM,Y", "B-GSM,Z"});
        Test013.formatParse(ds, "test013_test1_5.qds");
        return ds;
    }

    private static QDataSet test2() throws ParseException, StreamException, IOException {
        MutablePropertyDataSet tags = (MutablePropertyDataSet)Ops.timegen((String)"2003-09-09", (String)("1 " + Units.days), (int)11);
        tags.putProperty("NAME", (Object)"time");
        MutablePropertyDataSet ds = (MutablePropertyDataSet)Ops.findgen((int)11, (int)3);
        ds.putProperty("DEPEND_0", (Object)tags);
        ds.putProperty("NAME", (Object)"B_GSM");
        MutablePropertyDataSet labels = (MutablePropertyDataSet)Ops.labels((String[])new String[]{"B-GSM-X", "B-GSM-Y", "B-GSM-Z"});
        labels.putProperty("NAME", (Object)"dimLabels");
        ds.putProperty("DEPEND_1", (Object)labels);
        Test013.formatParse((QDataSet)ds, "test013_test2.qds");
        return ds;
    }

    private static QDataSet test3() throws ParseException, StreamException, IOException {
        MutablePropertyDataSet tags = (MutablePropertyDataSet)Ops.timegen((String)"2003-09-09", (String)("13.86 " + Units.seconds), (int)11);
        tags.putProperty("NAME", (Object)"time");
        MutablePropertyDataSet ds = (MutablePropertyDataSet)Ops.multiply((QDataSet)Ops.pow((QDataSet)Ops.replicate((double)100000.0, (int)11, (int)3), (QDataSet)Ops.randomu((long)12345L, (int)11, (int)3)), (QDataSet)Ops.randomu((long)12345L, (int)11, (int)3));
        ds.putProperty("DEPEND_0", (Object)tags);
        ds.putProperty("NAME", (Object)"B_GSM");
        MutablePropertyDataSet mode = (MutablePropertyDataSet)Ops.floor((QDataSet)Ops.multiply((QDataSet)Ops.randomu((long)12345L, (int)11), (QDataSet)Ops.replicate((long)4L, (int)11)));
        EnumerationUnits u = new EnumerationUnits("quality");
        u.createDatum(0, (Object)"Good");
        u.createDatum(1, (Object)"Better");
        u.createDatum(2, (Object)"Best");
        u.createDatum(3, (Object)"Perfect");
        mode.putProperty("UNITS", (Object)u);
        mode.putProperty("DEPEND_0", (Object)tags);
        mode.putProperty("NAME", (Object)"quality");
        ds.putProperty("DEPEND_0", (Object)tags);
        ds.putProperty("NAME", (Object)"B_GSM");
        MutablePropertyDataSet labels = (MutablePropertyDataSet)Ops.labels((String[])new String[]{"B-GSM-X", "B-GSM-Y", "B-GSM-Z"});
        labels.putProperty("NAME", (Object)"dimLabels");
        ds.putProperty("DEPEND_1", (Object)labels);
        ds.putProperty("PLANE_0", (Object)mode);
        Test013.formatParse((QDataSet)ds, "test013_test3.qds");
        return ds;
    }

    private static QDataSet test4_rank3() throws ParseException, StreamException, IOException {
        DDataSet ds = (DDataSet)Ops.dindgen((int)3, (int)4, (int)5);
        ds.putValue(1, 2, 3, 0.05);
        Test013.formatParse((QDataSet)ds, "test013_test4_rank3.qds");
        return ds;
    }

    private static QDataSet test0_rank2() throws ParseException, StreamException, IOException {
        DDataSet ds = (DDataSet)Ops.dindgen((int)3, (int)4);
        String file = "test013_test0_rank2.qds";
        Test013.formatParse((QDataSet)ds, file);
        return ds;
    }

    private static QDataSet test5() throws StreamException, IOException {
        DDataSet ds = (DDataSet)Ops.dindgen((int)5);
        String file = "test013_test5.qds";
        Test013.formatParse((QDataSet)ds, file);
        return ds;
    }

    private static QDataSet test6() throws StreamException, IOException {
        QDataSet result = null;
        result = Ops.join(result, (QDataSet)Ops.dindgen((int)5));
        result = Ops.join((QDataSet)result, (QDataSet)Ops.dindgen((int)5));
        result = Ops.join((QDataSet)result, (QDataSet)Ops.dindgen((int)5));
        result = Ops.join((QDataSet)result, (QDataSet)Ops.dindgen((int)4));
        result = Ops.join((QDataSet)result, (QDataSet)Ops.dindgen((int)4));
        result = Ops.join((QDataSet)result, (QDataSet)Ops.dindgen((int)4));
        result = Ops.join((QDataSet)result, (QDataSet)Ops.dindgen((int)4));
        Test013.formatParse(result, "test013_test6.qds");
        return result;
    }

    private static void test8() throws ParseException, IOException, StreamException {
        MutablePropertyDataSet dsBundle = (MutablePropertyDataSet)Ops.labels((String[])new String[]{"X", "Y", "Z"});
        int seed = 1234;
        int len0 = 34;
        MutablePropertyDataSet ds1 = (MutablePropertyDataSet)Ops.add((QDataSet)Ops.randomn((long)seed, (int)34, (int)3), (QDataSet)Ops.outerProduct((QDataSet)Ops.replicate((long)30L, (int)34), (QDataSet)Ops.ones((int)3)));
        QDataSet ds0 = Ops.timegen((String)"2000-01-01T10:00", (String)"1s", (int)34);
        ds1.putProperty("DEPEND_0", (Object)ds0);
        ds1.putProperty("DEPEND_1", (Object)dsBundle);
        int len1 = 44;
        MutablePropertyDataSet ds2 = (MutablePropertyDataSet)Ops.add((QDataSet)Ops.randomn((long)seed, (int)44, (int)3), (QDataSet)Ops.outerProduct((QDataSet)Ops.replicate((long)35L, (int)44), (QDataSet)Ops.ones((int)3)));
        ds0 = Ops.timegen((String)"2000-01-01T11:00", (String)"1s", (int)44);
        ds2.putProperty("DEPEND_0", (Object)ds0);
        ds2.putProperty("DEPEND_1", (Object)dsBundle);
        int len2 = 54;
        MutablePropertyDataSet ds3 = (MutablePropertyDataSet)Ops.add((QDataSet)Ops.randomn((long)seed, (int)54, (int)3), (QDataSet)Ops.outerProduct((QDataSet)Ops.replicate((long)40L, (int)54), (QDataSet)Ops.ones((int)3)));
        ds0 = Ops.timegen((String)"2000-01-01T12:00", (String)"1s", (int)54);
        ds3.putProperty("DEPEND_0", (Object)ds0);
        ds3.putProperty("DEPEND_1", (Object)dsBundle);
        MutablePropertyDataSet ds = (MutablePropertyDataSet)Ops.join((QDataSet)Ops.join((QDataSet)ds1, (QDataSet)ds2), (QDataSet)ds3);
        Test013.formatParse((QDataSet)ds, "test013_test8.qds");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static QDataSet test7() throws StreamException, IOException {
        int nrec = 190000;
        long t0 = System.currentTimeMillis();
        FDataSet result = FDataSet.createRank1((int)nrec);
        Test013.funData((WritableDataSet)result, 9.2, 0.01, 0, false);
        DDataSet dep0 = DDataSet.createRank1((int)nrec);
        Test013.funData((WritableDataSet)dep0, 10000.0, 0.01, 0, true);
        result.putProperty("DEPEND_0", (Object)dep0);
        Random rand = new Random(12345L);
        for (int i = 0; i < 13; ++i) {
            FDataSet planeds = FDataSet.createRank1((int)nrec);
            Test013.funData((WritableDataSet)planeds, rand.nextDouble() * 100.0, rand.nextDouble() * 10.0, 0, false);
            planeds.putProperty("NAME", (Object)("myplane_" + i));
            result.putProperty("PLANE_" + i, (Object)planeds);
        }
        System.err.println("generated data in  " + (System.currentTimeMillis() - t0));
        t0 = System.currentTimeMillis();
        System.err.println("formatting... ");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream("test013_test7.qds");
            SimpleStreamFormatter format = new SimpleStreamFormatter();
            format.format((QDataSet)result, (OutputStream)out, false);
            System.err.println("time: " + (System.currentTimeMillis() - t0));
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return result;
    }

    private static void testBundle() throws StreamException, FileNotFoundException, IOException {
        QDataSet ds = BundleBinsDemo.demo1();
        Test013.formatParse(ds, "test013_testBundle.qds");
    }

    private static void funData(WritableDataSet ds, double start, double res, int seed, boolean mono) {
        Random rand = new Random(seed);
        if (!mono) {
            QubeDataSetIterator it = new QubeDataSetIterator((QDataSet)ds);
            while (it.hasNext()) {
                it.next();
                it.putValue(ds, start);
                start += res * (rand.nextDouble() - 0.5);
            }
        } else {
            QubeDataSetIterator it = new QubeDataSetIterator((QDataSet)ds);
            while (it.hasNext()) {
                it.next();
                it.putValue(ds, start);
                start += res;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void formatBenchmark() throws ParseException, IOException, StreamException {
        int nrec = 100000;
        MutablePropertyDataSet tags = (MutablePropertyDataSet)Ops.timegen((String)"2003-09-09", (String)("1 " + Units.days), (int)nrec);
        tags.putProperty("NAME", (Object)"time");
        MutablePropertyDataSet ds = (MutablePropertyDataSet)Ops.randomn((long)12345L, (int)nrec, (int)3);
        ds.putProperty("DEPEND_0", (Object)tags);
        ds.putProperty("NAME", (Object)"B_GSM");
        MutablePropertyDataSet labels = (MutablePropertyDataSet)Ops.findgen((int)3);
        labels.putProperty("NAME", (Object)"dimLabels");
        ds.putProperty("DEPEND_1", (Object)labels);
        for (int j = 0; j < 2; ++j) {
            boolean ascii = j == 0;
            SimpleStreamFormatter format = new SimpleStreamFormatter();
            for (int i = 0; i < 3; ++i) {
                long t0 = System.currentTimeMillis();
                String filename = ascii ? "test013_benchmark1.qds" : "test013_benchmark1.binary.qds";
                FileOutputStream fo = null;
                try {
                    fo = new FileOutputStream(filename);
                    format.format((QDataSet)ds, (OutputStream)fo, ascii);
                }
                finally {
                    fo.close();
                }
                System.err.println("Time to write " + nrec + " records: " + (System.currentTimeMillis() - t0));
            }
        }
    }

    public static void parseBenchmark() throws FileNotFoundException, StreamException, org.das2.stream.StreamException {
        Test013.readAsciiQds();
        Test013.readBinaryQds();
    }

    private static void readStream(File f) throws FileNotFoundException, StreamException, org.das2.stream.StreamException {
        String ext = f.toString().substring(f.toString().lastIndexOf("."));
        if (ext.equals(".qds")) {
            long t0 = System.currentTimeMillis();
            FileInputStream in = new FileInputStream(f);
            QDataSetStreamHandler handler = new QDataSetStreamHandler();
            org.virbo.qstream.StreamTool.readStream((ReadableByteChannel)Channels.newChannel(in), (org.virbo.qstream.StreamHandler)handler);
            QDataSet qds = handler.getDataSet();
            System.err.println("Time to read " + qds.length() + " records: " + (System.currentTimeMillis() - t0));
        } else {
            long t0 = System.currentTimeMillis();
            FileInputStream in = new FileInputStream(f);
            DataSetStreamHandler handler = new DataSetStreamHandler(new HashMap(), (ProgressMonitor)new NullProgressMonitor());
            StreamTool.readStream((ReadableByteChannel)Channels.newChannel(in), (StreamHandler)handler);
            DataSet ds = handler.getDataSet();
            System.err.println("Time to read " + ds.getXLength() + " records: " + (System.currentTimeMillis() - t0));
        }
    }

    private static void readAsciiQds() throws FileNotFoundException, StreamException, org.das2.stream.StreamException {
        File f = new File("test013_benchmark1.qds");
        for (int i = 0; i < 5; ++i) {
            Test013.readStream(f);
        }
    }

    private static void readBinaryQds() throws FileNotFoundException, StreamException, org.das2.stream.StreamException {
        File f = new File("test013_benchmark1.binary.qds");
        for (int i = 0; i < 5; ++i) {
            Test013.readStream(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeLimitPrecision() throws StreamException, IOException {
        QDataSetStreamHandler handler = new QDataSetStreamHandler();
        org.virbo.qstream.StreamTool.readStream((ReadableByteChannel)Channels.newChannel(new FileInputStream("/home/jbf/ct/hudson/data.backup/qds/too_many_decimals.qds")), (org.virbo.qstream.StreamHandler)handler);
        File f = new File("test013_writeLimitPrecision.qds");
        QDataSet ds = handler.getDataSet("means");
        SimpleStreamFormatter format = new SimpleStreamFormatter();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(f);
            format.format(ds, (OutputStream)out, true);
        }
        finally {
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }

    public static void main(String[] args) {
        try {
            Test013.test8();
            Test013.test6();
            Test013.xxx("init");
            Test013.writeLimitPrecision();
            Test013.xxx("writeLimitPrecision");
            Test013.test0_rank2();
            Test013.xxx("test0_rank2()");
            Test013.test1();
            Test013.xxx("test1");
            Test013.test1_5();
            Test013.xxx("test1_5");
            Test013.test2();
            Test013.xxx("test2");
            Test013.test3();
            Test013.xxx("test3");
            Test013.test4_rank3();
            Test013.xxx("test4_rank3");
            Test013.test5();
            Test013.xxx("test5");
            Test013.test6();
            Test013.xxx("test6 disabled until bug is resolved");
            Test013.test7();
            Test013.xxx("test7");
            Test013.testBundle();
            Test013.xxx("testBundle");
            Test013.formatBenchmark();
            Test013.xxx("formatBenchmark");
            Test013.parseBenchmark();
            Test013.xxx("parseBenchmark");
            MutablePropertyDataSet ds = TestSupport.sampleDataRank2(100000, 30);
            ds.putProperty("DEPEND_0", (Object)Ops.timegen((String)"2009-08-25T10:00", (String)"13.6 ms", (int)100000));
            ds.putProperty("DEPEND_1", (Object)Ops.exp10((QDataSet)Ops.linspace((double)1.01, (double)3.4, (int)30)));
            Test013.xxx("created fake rank2");
            ScriptContext.formatDataSet((QDataSet)ds, "test013_001.qds?type=binary");
            Test013.xxx("test013_001.qds");
            ScriptContext.formatDataSet((QDataSet)ds, "test013_002.qds");
            Test013.xxx("test013_002.qds");
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

