/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DatumUtil;

public class Test026 {
    public static void doTest(int id, String test, String ref) throws Exception {
        DatumRange dr = DatumRangeUtil.parseTimeRange((String)test);
        DatumRange drref = DatumRangeUtil.parseTimeRange((String)ref);
        if (!drref.equals((Object)dr)) {
            System.err.println(id + ": " + test + " != " + ref + "     " + dr + " != " + drref);
            throw new IllegalArgumentException("no parse exception, but parsed incorrectly.");
        }
        System.err.println(id + ": " + test + "\t" + drref.min() + "\t" + DatumUtil.asOrderOneUnits((Datum)drref.width()));
    }

    public static void main(String[] args) {
        try {
            Test026.doTest(0, "2000-01-01T13:00Z to 2000-01-01T14:00", "2000-01-01T13:00Z to 2000-01-01T14:00");
            Test026.doTest(1, "2000-01-01 13:00 to 14:00", "2000-01-01T13:00Z to 2000-01-01T14:00");
            Test026.doTest(2, "2000-01-02", "2000-01-02T00:00Z to 2000-01-03T00:00");
            Test026.doTest(3, "2000-002", "2000-01-02T00:00Z to 2000-01-03T00:00");
            Test026.doTest(4, "2000-02", "2000-02-01T00:00Z to 2000-03-01T00:00");
            Test026.doTest(5, "2000-feb", "2000-02-01T00:00Z to 2000-03-01T00:00");
            Test026.doTest(6, "2000", "2000-01-01T00:00Z to 2001-01-01T00:00");
            Test026.doTest(7, "2000-01-01 to 2000-01-05", "2000-01-01T00:00Z to 2000-01-05T00:00");
            Test026.doTest(8, "2000-01-01 through 2000-01-05", "2000-01-01T00:00Z to 2000-01-06T00:00");
            Test026.doTest(9, "2001-01-01 span 10 days", "2001-01-01T00:00Z to 2001-01-11T00:00");
            Test026.doTest(10, "2000-01-01T13:00Z/PT1H", "2000-01-01T13:00Z/2000-01-01T14:00");
            Test026.doTest(11, "20000101T1300Z/PT1H", "2000-01-01T13:00Z/2000-01-01T14:00");
            Test026.doTest(12, "2000-01-01T00:00Z/P1D", "2000-01-01T00:00Z/2000-01-01T24:00");
            Test026.doTest(13, "2007-03-01T13:00:00Z/P1Y2M10DT2H30M", "2007-03-01T13:00:00Z/2008-05-11T15:30:00Z");
            Test026.doTest(14, "2007-03-01T13:00:00Z/2008-05-11T15:30:00Z", "2007-03-01T13:00:00Z/2008-05-11T15:30:00Z");
            Test026.doTest(15, "P1Y2M10DT2H30M/2008-05-11T15:30:00Z", "2007-03-01T13:00:00Z/2008-05-11T15:30:00Z");
            Test026.doTest(16, "2007-009/2007-021", "2007-01-09T00:00:00Z/2007-01-21T00:00:00Z");
            Test026.doTest(17, "2007-05-15/2007-05-30", "2007-05-15T00:00:00Z/2007-05-30T00:00:00Z");
            Test026.doTest(18, "2007-03-01/P5D", "2007-03-01T00:00:00Z/2007-03-06T00:00:00Z");
            Test026.doTest(19, "P5D/2007-03-06", "2007-03-01T00:00:00Z/2007-03-06T00:00:00Z");
            Test026.doTest(20, "2000-01-01T13:00/PT1H", "2000-01-01 13:00 to 14:00");
            Test026.doTest(30, "1000", "1000-01-01T00:00Z to 1001-01-01T00:00");
            Test026.doTest(31, "9000", "9000-01-01T00:00Z to 9001-01-01T00:00");
            Test026.doTest(32, "2000-01-01T00:00:00 span .000001 sec", "2000-01-01T00:00:00.000000 to 2000-01-01T00:00:00.000001");
            Test026.doTest(33, "2000-01-01T00:00:00 span .000000001 sec", "2000-01-01T00:00:00.000000 to 2000-01-01T00:00:00.000000001");
            Test026.doTest(34, "2002-01-01T10:10:10 span .000000001 sec", "2002-01-01T10:10:10.000000 to 2002-01-01T10:10:10.000000001");
            Test026.doTest(35, "Aug 1969 through Sep 1970", "Aug 1 1969 to Oct 1 1970");
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

