/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyReflectedFunction;
import org.python.util.InteractiveInterpreter;
import org.virbo.jythonsupport.JythonUtil;

public class Test029 {
    public static void main(String[] args) throws IOException {
        int status = Test029.testBuiltIns();
        if (status != 0) {
            System.exit(status);
        }
        if ((status = Test029.testJythonLib()) != 0) {
            System.exit(status);
        }
    }

    private static int testJythonLib() throws IOException {
        int c;
        URL s = Test029.class.getResource("/glob.py");
        InputStream in = s.openStream();
        int count = 0;
        while ((c = in.read()) != -1) {
            if (c != 10) continue;
            ++count;
        }
        in.close();
        System.err.printf("glob.py is approx %d lines long.\n", count);
        InteractiveInterpreter interp = JythonUtil.createInterpreter((boolean)false);
        interp.exec("import glob\n");
        PyObject res = interp.eval("glob.glob('*')\n");
        System.err.println(res);
        return 0;
    }

    private static int testBuiltIns() throws IOException {
        String builtIns = "abs() \tdivmod() \tinput() \topen() \tstaticmethod() all() \tenumerate() \tint() \tord() \tstr() any() \teval() \tisinstance() \tpow() \tsum() basestring() \texecfile() \tissubclass() \tprint() \tsuper() bin() \tfile() \titer() \tproperty() \ttuple() bool() \tfilter() \tlen() \trange() \ttype() bytearray() \tfloat() \tlist() \traw_input() \tunichr() callable() \tformat() \tlocals() \treduce() \tunicode()chr() \tfrozenset() \tlong() \treload() \tvars()classmethod() \tgetattr() \tmap() \trepr() \txrange()cmp() \tglobals() \tmax() \treversed() \tzip()compile() \thasattr() \tmemoryview() \tround() \t__import__()complex() \thash() \tmin() \tset() \tapply()delattr() \thelp() \tnext() \tsetattr() \tbuffer()dict() \thex() \tobject() \tslice() \tcoerce()dir() \tid() \toct() \tsorted() \tintern()";
        String supported = "abs() pow()";
        String notYetSupported = "all() any()  print()  bin()  bytearray()   format()  frozenset()   reversed()   memoryview()   set()   help()   next()   buffer()   sorted() ";
        String[] bb = builtIns.replaceAll("\\(\\)", " ").split("\\s+");
        InteractiveInterpreter interp = JythonUtil.createInterpreter((boolean)false);
        for (int i = 0; i < bb.length; ++i) {
            String b = bb[i];
            try {
                PyObject result = interp.eval(b);
                if (result instanceof PyReflectedFunction) {
                    System.err.println("!!!" + b + ": " + result);
                    if (supported.contains(b)) continue;
                    return -3;
                }
                System.err.println("   " + b + ": " + result);
                continue;
            }
            catch (PyException ex) {
                System.err.println("Error finding symbol \"" + b + "\"");
                if (notYetSupported.contains(b)) continue;
                return -2;
            }
        }
        return 0;
    }
}

