/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import org.das2.client.DasServer;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.stream.StreamDescriptor;
import org.virbo.autoplot.ScriptContext;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dsops.Ops;
import org.virbo.jythonsupport.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Test501 {
    private static final int testid = 501;

    static void flatten(TreeModel tm, String root, Object node, List<String> result) {
        for (int i = 0; i < tm.getChildCount(node); ++i) {
            Object child = tm.getChild(node, i);
            if (tm.isLeaf(child)) {
                String ss = (String)((DefaultMutableTreeNode)child).getUserObject();
                result.add(root + "/" + ss);
                continue;
            }
            String us = (String)((DefaultMutableTreeNode)child).getUserObject();
            Test501.flatten(tm, root + "/" + us, child, result);
        }
    }

    private static void do1(String uri, int id) throws Exception {
        long t0 = System.currentTimeMillis();
        QDataSet ds = Util.getDataSet((String)uri);
        double t = (double)(System.currentTimeMillis() - t0) / 1000.0;
        MutablePropertyDataSet hist = (MutablePropertyDataSet)Ops.autoHistogram((QDataSet)ds);
        hist.putProperty("TITLE", (Object)uri);
        String label = String.format("test%03d_%03d", 501, id);
        hist.putProperty("LABEL", (Object)label);
        ScriptContext.formatDataSet((QDataSet)hist, label + ".qds");
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null) {
            MutablePropertyDataSet hist2 = (MutablePropertyDataSet)Ops.autoHistogram((QDataSet)dep0);
            ScriptContext.formatDataSet((QDataSet)hist2, label + ".dep0.qds");
        } else {
            PrintWriter pw = new PrintWriter(label + ".dep0.qds");
            pw.println("no dep0");
            pw.close();
        }
        ScriptContext.plot(ds);
        ScriptContext.setCanvasSize(750, 300);
        int i = uri.lastIndexOf("/");
        ScriptContext.getApplicationModel().waitUntilIdle(true);
        String fileUri = uri.substring(i + 1);
        if (!ScriptContext.getDocumentModel().getPlotElements(0).getComponent().equals("")) {
            String dsstr = String.valueOf(ScriptContext.getDocumentModel().getDataSourceFilters(0).getController().getDataSet());
            fileUri = fileUri + " " + dsstr + " " + ScriptContext.getDocumentModel().getPlotElements(0).getComponent();
        }
        ScriptContext.setTitle(fileUri);
        ScriptContext.writeToPng(String.format("test%03d_%03d.png", 501, id));
        System.err.printf("Read in %9.3f seconds (%s): %s\n", t, label, uri);
    }

    public static void main(String[] args) throws Exception {
        TreeModel tm = DasServer.plasmaWaveGroup.getDataSetListWithDiscovery();
        ArrayList<String> ids = new ArrayList<String>();
        Test501.flatten(tm, "", tm.getRoot(), ids);
        LinkedHashMap<Integer, String> failures = new LinkedHashMap<Integer, String>();
        ArrayList<Integer> skip = new ArrayList<Integer>(Arrays.asList(3, 4, 5, 6, 7, 18));
        int count = 0;
        for (String id : ids) {
            if (id.contains("/testing/")) {
                System.err.println("skipping /testing/: " + id);
                continue;
            }
            if (id.contains("juno/waves") && id.contains("housekeeping.dsdf") && !id.contains("/juno/waves/flight/housekeeping.dsdf")) {
                skip.add(count);
            }
            ++count;
        }
        System.err.println("Skipping the tests: " + skip);
        int iid = 0;
        for (String id : ids) {
            System.err.println(String.format("==== test %d of %d ========================================================", iid, count));
            if (id.contains("/testing/")) {
                System.err.println("ids containing /testing/ are automatically skipped: " + id);
                continue;
            }
            if (skip.contains(iid)) {
                ++iid;
                System.err.println("test marked for skipping in Test501.java: " + id);
                continue;
            }
            StreamDescriptor dsdf = DasServer.plasmaWaveGroup.getStreamDescriptor(DasServer.plasmaWaveGroup.getURL(id));
            String exampleRange = (String)dsdf.getProperty("exampleRange");
            DatumRange tr = DatumRangeUtil.parseTimeRangeValid((String)exampleRange);
            String uri = "vap+das2server:" + DasServer.plasmaWaveGroup.getURL() + "?dataset=" + id + "&start_time=" + tr.min() + "&end_time=" + tr.max();
            System.err.println("id: " + id);
            System.err.println("uri: " + uri);
            try {
                Test501.do1(uri, iid);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                failures.put(iid, uri);
            }
            ++iid;
        }
        System.err.println("DONE...");
        if (failures.size() > 0) {
            System.err.println(String.format("found %d failures:", failures.size()));
            Iterator<Object> i$ = failures.keySet().iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                System.err.println(String.format("%3d: %s", i, failures.get(i)));
            }
            System.exit(1);
        } else {
            System.exit(0);
        }
    }
}

