/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import java.util.Map;
import org.das2.datum.Units;
import org.virbo.dataset.ArrayDataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.WritableDataSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DDataSet
extends ArrayDataSet {
    double[] back;
    private static final boolean RANGE_CHECK = true;
    public static final String version = "20110217";

    public static DDataSet createRank1(int len0) {
        return new DDataSet(1, len0, 1, 1, 1);
    }

    public static DDataSet createRank2(int len0, int len1) {
        return new DDataSet(2, len0, len1, 1, 1);
    }

    public static DDataSet createRank3(int len0, int len1, int len2) {
        return new DDataSet(3, len0, len1, len2, 1);
    }

    public static DDataSet createRank4(int len0, int len1, int len2, int len3) {
        return new DDataSet(4, len0, len1, len2, len3);
    }

    public static DDataSet create(int[] qube) {
        if (qube.length == 0) {
            return new DDataSet(0, 1, 1, 1, 1);
        }
        if (qube.length == 1) {
            return DDataSet.createRank1(qube[0]);
        }
        if (qube.length == 2) {
            return DDataSet.createRank2(qube[0], qube[1]);
        }
        if (qube.length == 3) {
            return DDataSet.createRank3(qube[0], qube[1], qube[2]);
        }
        if (qube.length == 4) {
            return DDataSet.createRank4(qube[0], qube[1], qube[2], qube[3]);
        }
        if (qube.length == 0) {
            return new DDataSet(0, 1, 1, 1, 1);
        }
        throw new IllegalArgumentException("bad qube");
    }

    public static DDataSet wrap(double[] data, int[] qube) {
        if (qube.length == 1) {
            return new DDataSet(1, qube[0], 1, 1, 1, data);
        }
        if (qube.length == 2) {
            return new DDataSet(2, qube[0], qube[1], 1, 1, data);
        }
        if (qube.length == 3) {
            return new DDataSet(3, qube[0], qube[1], qube[2], 1, data);
        }
        if (qube.length == 4) {
            return new DDataSet(4, qube[0], qube[1], qube[2], qube[3], data);
        }
        if (qube.length == 0) {
            return new DDataSet(0, 1, 1, 1, 1, data);
        }
        throw new IllegalArgumentException("bad qube");
    }

    protected DDataSet(int rank, int len0, int len1, int len2, int len3) {
        this(rank, len0, len1, len2, len3, new double[len0 * len1 * len2 * len3]);
    }

    protected DDataSet(int rank, int len0, int len1, int len2, int len3, double[] back) {
        if (back == null) {
            throw new NullPointerException("back was null");
        }
        this.back = back;
        this.rank = rank;
        this.len0 = len0;
        this.len1 = len1;
        this.len2 = len2;
        this.len3 = len3;
        if (rank > 1) {
            this.putProperty("QUBE", Boolean.TRUE);
        }
    }

    @Override
    protected Object getBack() {
        return this.back;
    }

    @Override
    protected void setBack(Object back) {
        this.back = (double[])back;
    }

    @Override
    public double value() {
        if (this.rank != 0) {
            throw new IllegalArgumentException("rank 0 access on rank " + this.rank + " dataset");
        }
        return this.back[0];
    }

    @Override
    public double value(int i0) {
        if (this.rank != 1) {
            throw new IllegalArgumentException("rank 1 access on rank " + this.rank + " dataset");
        }
        if (i0 < 0 || i0 >= this.len0) {
            throw new IndexOutOfBoundsException("i0=" + i0 + " " + this);
        }
        return this.back[i0];
    }

    @Override
    public double value(int i0, int i1) {
        if (this.rank != 2) {
            throw new IllegalArgumentException("rank 2 access on rank " + this.rank + " dataset");
        }
        if (i0 < 0 || i0 >= this.len0) {
            throw new IndexOutOfBoundsException("i0=" + i0 + " " + this);
        }
        if (i1 < 0 || i1 >= this.len1) {
            throw new IndexOutOfBoundsException("i1=" + i1 + " " + this);
        }
        return this.back[i0 * this.len1 + i1];
    }

    @Override
    public double value(int i0, int i1, int i2) {
        if (this.rank != 3) {
            throw new IllegalArgumentException("rank 3 access on rank " + this.rank + " dataset");
        }
        if (i0 < 0 || i0 >= this.len0) {
            throw new IndexOutOfBoundsException("i0=" + i0 + " " + this);
        }
        if (i1 < 0 || i1 >= this.len1) {
            throw new IndexOutOfBoundsException("i1=" + i1 + " " + this);
        }
        if (i2 < 0 || i2 >= this.len2) {
            throw new IndexOutOfBoundsException("i2=" + i2 + " " + this);
        }
        return this.back[i0 * this.len1 * this.len2 + i1 * this.len2 + i2];
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        if (this.rank != 4) {
            throw new IllegalArgumentException("rank 4 access on rank " + this.rank + " dataset");
        }
        if (i0 < 0 || i0 >= this.len0) {
            throw new IndexOutOfBoundsException("i0=" + i0 + " " + this);
        }
        if (i1 < 0 || i1 >= this.len1) {
            throw new IndexOutOfBoundsException("i1=" + i1 + " " + this);
        }
        if (i2 < 0 || i2 >= this.len2) {
            throw new IndexOutOfBoundsException("i2=" + i2 + " " + this);
        }
        if (i3 < 0 || i3 >= this.len3) {
            throw new IndexOutOfBoundsException("i3=" + i3 + " " + this);
        }
        return this.back[i0 * this.len1 * this.len2 * this.len3 + i1 * this.len2 * this.len3 + i2 * this.len3 + i3];
    }

    @Override
    public void putValue(double value) {
        this.back[0] = value;
    }

    @Override
    public void putValue(int i0, double value) {
        if (i0 < 0 || i0 >= this.len0) {
            throw new IndexOutOfBoundsException("i0=" + i0 + " " + this);
        }
        this.back[i0] = value;
    }

    @Override
    public void putValue(int i0, int i1, double value) {
        if (i0 < 0 || i0 >= this.len0) {
            throw new IndexOutOfBoundsException("i0=" + i0 + " " + this);
        }
        if (i1 < 0 || i1 >= this.len1) {
            throw new IndexOutOfBoundsException("i1=" + i1 + " " + this);
        }
        this.back[i0 * this.len1 + i1] = value;
    }

    @Override
    public void putValue(int i0, int i1, int i2, double value) {
        if (i0 < 0 || i0 >= this.len0) {
            throw new IndexOutOfBoundsException("i0=" + i0 + " " + this);
        }
        if (i1 < 0 || i1 >= this.len1) {
            throw new IndexOutOfBoundsException("i1=" + i1 + " " + this);
        }
        if (i2 < 0 || i2 >= this.len2) {
            throw new IndexOutOfBoundsException("i2=" + i2 + " " + this);
        }
        this.back[i0 * this.len1 * this.len2 + i1 * this.len2 + i2] = value;
    }

    @Override
    public void putValue(int i0, int i1, int i2, int i3, double value) {
        if (i0 < 0 || i0 >= this.len0) {
            throw new IndexOutOfBoundsException("i0=" + i0 + " " + this);
        }
        if (i1 < 0 || i1 >= this.len1) {
            throw new IndexOutOfBoundsException("i1=" + i1 + " " + this);
        }
        if (i2 < 0 || i2 >= this.len2) {
            throw new IndexOutOfBoundsException("i2=" + i2 + " " + this);
        }
        if (i3 < 0 || i3 >= this.len3) {
            throw new IndexOutOfBoundsException("i3=" + i3 + " " + this);
        }
        this.back[i0 * this.len1 * this.len2 * this.len3 + i1 * this.len2 * this.len3 + i2 * this.len3 + i3] = value;
    }

    @Override
    public void putLength(int len) {
        if (len > this.len0) {
            throw new IllegalArgumentException("dataset cannot be lengthened");
        }
        this.len0 = len;
    }

    @Override
    public String toString() {
        return DataSetUtil.toString(this);
    }

    public static DDataSet wrap(double[] back) {
        return new DDataSet(1, back.length, 1, 1, 1, back);
    }

    public static DDataSet wrap(double[] xx, Units xunits) {
        DDataSet result = DDataSet.wrap(xx);
        result.putProperty("UNITS", xunits);
        return result;
    }

    public static DDataSet wrapRank2(double[] back, int n1) {
        return new DDataSet(2, back.length / n1, n1, 1, 1, back);
    }

    public static DDataSet wrapRank3(double[] back, int n1, int n2) {
        return new DDataSet(3, back.length / (n1 * n2), n1, n2, 1, back);
    }

    public static DDataSet wrap(double[] back, int nx, int ny) {
        return new DDataSet(2, nx, ny, 1, 1, back);
    }

    public static DDataSet wrap(double[] back, int rank, int len0, int len1, int len2) {
        return new DDataSet(rank, len0, len1, len2, 1, back);
    }

    public static DDataSet wrap(double[] back, int rank, int len0, int len1, int len2, int len3) {
        return new DDataSet(rank, len0, len1, len2, len3, back);
    }

    @Override
    public DDataSet setUnits(Units units) {
        this.properties.put("UNITS", units);
        return this;
    }

    public static void copyElements(DDataSet src, int srcpos, DDataSet dest, int destpos, int len) {
        if (src.len1 != dest.len1 || src.len2 != dest.len2) {
            throw new IllegalArgumentException("src and dest geometry don't match");
        }
        DDataSet.copyElements(src, srcpos, dest, destpos, len * src.len1 * src.len2, false);
    }

    public static void copyElements(DDataSet src, int srcpos, DDataSet dest, int destpos, int len, boolean checkAlias) {
        if (checkAlias && src.len1 * src.len2 != dest.len1 * dest.len2) {
            throw new IllegalArgumentException("src and dest geometry don't match");
        }
        int srcpos1 = srcpos * src.len1 * src.len2;
        int destpos1 = destpos * dest.len1 * dest.len2;
        int len1 = len;
        System.arraycopy(src.back, srcpos1, dest.back, destpos1, len1);
    }

    @Override
    public QDataSet slice(int i) {
        int nrank = this.rank - 1;
        int noff1 = i * this.len1 * this.len2 * this.len3;
        int noff2 = (i + 1) * this.len1 * this.len2 * this.len3;
        double[] newback = new double[noff2 - noff1];
        System.arraycopy(this.back, noff1, newback, 0, noff2 - noff1);
        Map<String, Object> props = DataSetOps.sliceProperties0(i, DataSetUtil.getProperties(this));
        props = DataSetUtil.sliceProperties(this, i, props);
        DDataSet result = new DDataSet(nrank, this.len1, this.len2, this.len3, 1, newback);
        DataSetUtil.putProperties(props, result);
        return result;
    }

    @Override
    public QDataSet trim(int start, int end) {
        int nrank = this.rank;
        int noff1 = start * this.len1 * this.len2 * this.len3;
        int noff2 = end * this.len1 * this.len2 * this.len3;
        double[] newback = new double[noff2 - noff1];
        System.arraycopy(this.back, noff1, newback, 0, noff2 - noff1);
        DDataSet result = new DDataSet(nrank, end - start, this.len1, this.len2, this.len3, newback);
        Map<String, Object> props = DataSetUtil.getProperties(this);
        props.remove("DEPEND_0");
        DataSetUtil.putProperties(props, result);
        QDataSet dep0 = (QDataSet)this.property("DEPEND_0");
        if (dep0 != null) {
            result.putProperty("DEPEND_0", dep0.trim(start, end));
        }
        return result;
    }

    @Override
    public <T> T capability(Class<T> clazz) {
        if (clazz == WritableDataSet.class) {
            return (T)this;
        }
        return super.capability(clazz);
    }
}

