/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import java.util.Map;
import org.virbo.dataset.ArrayDataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.WritableDataSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FDataSet
extends ArrayDataSet {
    float[] back;
    public static final String version = "20090606";

    public static FDataSet createRank1(int len0) {
        return new FDataSet(1, len0, 1, 1, 1);
    }

    public static FDataSet createRank2(int len0, int len1) {
        return new FDataSet(2, len0, len1, 1, 1);
    }

    public static FDataSet createRank3(int len0, int len1, int len2) {
        return new FDataSet(3, len0, len1, len2, 1);
    }

    public static FDataSet createRank4(int len0, int len1, int len2, int len3) {
        return new FDataSet(4, len0, len1, len2, len3);
    }

    public static FDataSet create(int[] qube) {
        if (qube.length == 0) {
            return new FDataSet(0, 1, 1, 1, 1);
        }
        if (qube.length == 1) {
            return FDataSet.createRank1(qube[0]);
        }
        if (qube.length == 2) {
            return FDataSet.createRank2(qube[0], qube[1]);
        }
        if (qube.length == 3) {
            return FDataSet.createRank3(qube[0], qube[1], qube[2]);
        }
        if (qube.length == 4) {
            return FDataSet.createRank4(qube[0], qube[1], qube[2], qube[3]);
        }
        throw new IllegalArgumentException("bad qube");
    }

    public static FDataSet wrap(float[] data, int[] qube) {
        if (qube.length == 1) {
            return new FDataSet(1, qube[0], 1, 1, 1, data);
        }
        if (qube.length == 2) {
            return new FDataSet(2, qube[0], qube[1], 1, 1, data);
        }
        if (qube.length == 3) {
            return new FDataSet(3, qube[0], qube[1], qube[2], 1, data);
        }
        if (qube.length == 4) {
            return new FDataSet(4, qube[0], qube[1], qube[2], qube[3], data);
        }
        throw new IllegalArgumentException("bad qube");
    }

    public static FDataSet wrap(float[] back, int rank, int len0, int len1, int len2) {
        return new FDataSet(rank, len0, len1, len2, 1, back);
    }

    protected FDataSet(int rank, int len0, int len1, int len2, int len3) {
        this(rank, len0, len1, len2, len3, new float[len0 * len1 * len2 * len3]);
    }

    protected FDataSet(int rank, int len0, int len1, int len2, int len3, float[] back) {
        this.back = back;
        this.rank = rank;
        this.len0 = len0;
        this.len1 = len1;
        this.len2 = len2;
        this.len3 = len3;
        if (rank > 1) {
            this.putProperty("QUBE", Boolean.TRUE);
        }
    }

    @Override
    protected Object getBack() {
        return this.back;
    }

    @Override
    protected void setBack(Object back) {
        this.back = (float[])back;
    }

    @Override
    public double value() {
        float v = this.back[0];
        return v == this.fill ? this.dfill : (double)v;
    }

    @Override
    public double value(int i0) {
        float v = this.back[i0];
        return v == this.fill ? this.dfill : (double)v;
    }

    @Override
    public double value(int i0, int i1) {
        float v = this.back[i0 * this.len1 + i1];
        return v == this.fill ? this.dfill : (double)v;
    }

    @Override
    public double value(int i0, int i1, int i2) {
        float v = this.back[i0 * this.len1 * this.len2 + i1 * this.len2 + i2];
        return v == this.fill ? this.dfill : (double)v;
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        float v = this.back[i0 * this.len1 * this.len2 * this.len3 + i1 * this.len2 * this.len3 + i2 * this.len3 + i3];
        return v == this.fill ? this.dfill : (double)v;
    }

    @Override
    public void putValue(double value) {
        this.back[0] = (float)value;
    }

    @Override
    public void putValue(int i0, double value) {
        this.back[i0] = (float)value;
    }

    @Override
    public void putValue(int i0, int i1, double value) {
        this.back[i0 * this.len1 + i1] = (float)value;
    }

    @Override
    public void putValue(int i0, int i1, int i2, double value) {
        this.back[i0 * this.len1 * this.len2 + i1 * this.len2 + i2] = (float)value;
    }

    @Override
    public void putValue(int i0, int i1, int i2, int i3, double value) {
        this.back[i0 * this.len1 * this.len2 * this.len3 + i1 * this.len2 * this.len3 + i2 * this.len3 + i3] = (float)value;
    }

    public static FDataSet wrap(float[] back) {
        return new FDataSet(1, back.length, 1, 1, 1, back);
    }

    public static FDataSet wrap(float[] back, int nx, int ny) {
        return new FDataSet(2, nx, ny, 1, 1, back);
    }

    public static FDataSet wrap(float[] back, int nx, int ny, int nz) {
        return new FDataSet(3, nx, ny, nz, 1, back);
    }

    @Override
    public void putProperty(String name, Object value) {
        super.putProperty(name, value);
        if (name.equals("FILL_VALUE")) {
            this.checkFill();
        }
    }

    @Override
    public QDataSet slice(int i) {
        int nrank = this.rank - 1;
        int noff1 = i * this.len1 * this.len2 * this.len3;
        int noff2 = (i + 1) * this.len1 * this.len2 * this.len3;
        float[] newback = new float[noff2 - noff1];
        System.arraycopy(this.back, noff1, newback, 0, noff2 - noff1);
        Map<String, Object> props = DataSetOps.sliceProperties0(i, DataSetUtil.getProperties(this));
        props = DataSetUtil.sliceProperties(this, i, props);
        FDataSet result = new FDataSet(nrank, this.len1, this.len2, this.len3, 1, newback);
        DataSetUtil.putProperties(props, result);
        return result;
    }

    @Override
    public QDataSet trim(int start, int end) {
        int nrank = this.rank;
        int noff1 = start * this.len1 * this.len2 * this.len3;
        int noff2 = end * this.len1 * this.len2 * this.len3;
        float[] newback = new float[noff2 - noff1];
        System.arraycopy(this.back, noff1, newback, 0, noff2 - noff1);
        FDataSet result = new FDataSet(nrank, end - start, this.len1, this.len2, this.len3, newback);
        Map<String, Object> props = DataSetUtil.getProperties(this);
        props.remove("DEPEND_0");
        DataSetUtil.putProperties(props, result);
        QDataSet dep0 = (QDataSet)this.property("DEPEND_0");
        if (dep0 != null) {
            result.putProperty("DEPEND_0", dep0.trim(start, end));
        }
        return result;
    }

    @Override
    public <T> T capability(Class<T> clazz) {
        if (clazz == WritableDataSet.class) {
            return (T)this;
        }
        return super.capability(clazz);
    }
}

