/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import java.util.ArrayList;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetIterator;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.WritableDataSet;

public class QubeDataSetIterator
implements DataSetIterator {
    private DimensionIterator[] it = new DimensionIterator[4];
    private DimensionIteratorFactory[] fit = new DimensionIteratorFactory[4];
    private boolean isAllIndexLists;
    private int rank;
    private int[] qube;
    private QDataSet ds;
    private boolean allnext = true;

    public QubeDataSetIterator(QDataSet ds) {
        if (Boolean.TRUE.equals(ds.property("QUBE"))) {
            this.qube = DataSetUtil.qubeDims(ds);
            this.ds = ds;
        } else {
            this.ds = ds;
        }
        this.rank = ds.rank();
        for (int i = 0; i < ds.rank(); ++i) {
            this.fit[i] = new StartStopStepIteratorFactory(0, null, 1);
        }
        this.initialize();
    }

    private QubeDataSetIterator(QDataSet ds, DimensionIteratorFactory[] fits) {
        if (Boolean.TRUE.equals(ds.property("QUBE"))) {
            this.qube = DataSetUtil.qubeDims(ds);
            this.ds = ds;
        } else {
            this.ds = ds;
        }
        this.rank = ds.rank();
        this.ds = ds;
        this.fit = fits;
        this.initialize();
    }

    public static QubeDataSetIterator sliceIterator(QDataSet ds, int sliceIndex) {
        QubeDataSetIterator result;
        if (ds.rank() == 0) {
            throw new IllegalArgumentException("can't slice rank 0");
        }
        if (ds.rank() == 1) {
            throw new IllegalArgumentException("can't slice rank 1");
        }
        if (ds.rank() == 2) {
            result = new QubeDataSetIterator(ds, new DimensionIteratorFactory[]{new SingletonIteratorFactory(sliceIndex), new StartStopStepIteratorFactory(0, ds.length(sliceIndex), 1)});
        } else if (ds.rank() == 3) {
            result = new QubeDataSetIterator(ds, new DimensionIteratorFactory[]{new SingletonIteratorFactory(sliceIndex), new StartStopStepIteratorFactory(0, ds.length(sliceIndex), 1), new StartStopStepIteratorFactory(0, null, 1)});
        } else if (ds.rank() == 4) {
            result = new QubeDataSetIterator(ds, new DimensionIteratorFactory[]{new SingletonIteratorFactory(sliceIndex), new StartStopStepIteratorFactory(0, ds.length(sliceIndex), 1), new StartStopStepIteratorFactory(0, null, 1), new StartStopStepIteratorFactory(0, null, 1)});
        } else {
            throw new IllegalArgumentException("rank limit");
        }
        return result;
    }

    public void setIndexIteratorFactory(int dim, DimensionIteratorFactory fit) {
        this.fit[dim] = fit;
        this.initialize();
    }

    private void initialize() {
        boolean allLi = true;
        for (int i = 0; i < this.rank; ++i) {
            int dimLength = this.dimLength(i);
            this.it[i] = this.fit[i].newIterator(dimLength);
            if (this.it[i] instanceof IndexListIterator) continue;
            allLi = false;
        }
        this.isAllIndexLists = allLi;
    }

    private final int dimLength(int idim) {
        if (this.qube != null) {
            return this.qube[idim];
        }
        int result = 0;
        switch (idim) {
            case 0: {
                result = this.ds.length();
                break;
            }
            case 1: {
                result = this.ds.length(Math.max(0, this.index(0)));
                break;
            }
            case 2: {
                result = this.ds.length(Math.max(0, this.index(0)), Math.max(0, this.index(1)));
                break;
            }
            case 3: {
                result = this.ds.length(Math.max(0, this.index(0)), Math.max(0, this.index(1)), Math.max(0, this.index(2)));
                break;
            }
            default: {
                throw new IllegalArgumentException("dimension not supported: " + idim);
            }
        }
        return result;
    }

    public boolean hasNext() {
        if (this.rank == 0) {
            return this.allnext;
        }
        if (this.it[0].length() == 0) {
            return false;
        }
        int i = this.rank - 1;
        if (this.it[i].hasNext()) {
            return true;
        }
        if (i > 0) {
            for (int j = i - 1; j >= 0; --j) {
                if (!this.it[j].hasNext()) continue;
                return true;
            }
        }
        return false;
    }

    public void next() {
        int i;
        if (this.allnext) {
            for (i = 0; i < this.rank - 1; ++i) {
                if (this.isAllIndexLists && this.it[i] instanceof IndexListIterator) continue;
                this.it[i].nextIndex();
            }
            this.allnext = false;
            if (this.rank == 0) {
                return;
            }
        }
        if (this.it[i = this.rank - 1].hasNext()) {
            this.it[i].nextIndex();
            if (this.it[i] instanceof IndexListIterator) {
                for (int k = 0; k < i; ++k) {
                    if (!this.isAllIndexLists || !(this.it[k] instanceof IndexListIterator)) continue;
                    this.it[k].nextIndex();
                }
            }
        } else if (i > 0) {
            for (int j = i - 1; j >= 0; --j) {
                int k;
                if (!this.it[j].hasNext()) continue;
                this.it[j].nextIndex();
                if (this.it[j] instanceof IndexListIterator) {
                    for (k = 0; k < j; ++k) {
                        if (!this.isAllIndexLists || !(this.it[k] instanceof IndexListIterator)) continue;
                        this.it[k].nextIndex();
                    }
                }
                for (k = j + 1; k <= i; ++k) {
                    this.it[k] = this.fit[k].newIterator(this.dimLength(k));
                    this.it[k].nextIndex();
                }
                break;
            }
        } else {
            throw new IllegalArgumentException("no more elements");
        }
    }

    public int index(int dim) {
        return this.it[dim].index();
    }

    public int length(int dim) {
        return this.it[dim].length();
    }

    public int rank() {
        int result = this.rank;
        for (int i = 0; i < this.it.length; ++i) {
            if (!(this.it[i] instanceof SingletonIterator)) continue;
            --result;
        }
        return result;
    }

    public String toString() {
        if (this.rank == 0) {
            return "Iter hasNext=" + this.hasNext();
        }
        String its = this.it[0].toString();
        String ats = "" + this.it[0].index();
        for (int i = 1; i < this.rank; ++i) {
            its = its + "," + this.it[i].toString();
            ats = ats + "," + this.it[i].index();
        }
        return "Iter [" + its + "] @ [" + ats + "] ";
    }

    public DDataSet createEmptyDs() {
        int[] qube;
        ArrayList<Integer> qqube = new ArrayList<Integer>();
        ArrayList<Integer> dimMap = new ArrayList<Integer>();
        for (int i = 0; i < this.it.length; ++i) {
            boolean reform;
            if (this.it[i] == null || (reform = this.it[i] instanceof SingletonIterator)) continue;
            qqube.add(this.it[i].length());
            dimMap.add(i);
        }
        if (this.isAllIndexLists) {
            qube = new int[]{this.it[0].length()};
        } else {
            qube = new int[qqube.size()];
            for (int i = 0; i < qqube.size(); ++i) {
                qube[i] = (Integer)qqube.get(i);
            }
        }
        DDataSet result = DDataSet.create(qube);
        for (int i = 0; i < dimMap.size(); ++i) {
            int idim = (Integer)dimMap.get(i);
            QDataSet dep = (QDataSet)this.ds.property("DEPEND_" + i);
            QDataSet bund = (QDataSet)this.ds.property("BUNDLE_" + i);
            if (!(this.fit[idim] instanceof StartStopStepIteratorFactory)) continue;
            if (dep != null && dep.rank() == 1) {
                StartStopStepIterator sssi = (StartStopStepIterator)this.it[idim];
                if (sssi.step == 1 && sssi.start == 0 && sssi.stop == dep.length()) {
                    result.putProperty("DEPEND_" + i, dep);
                    continue;
                }
                if (sssi.step == 1) {
                    result.putProperty("DEPEND_" + i, dep.trim(sssi.start, sssi.stop));
                    continue;
                }
                MutablePropertyDataSet depSlice = DataSetOps.trim(dep, sssi.start, sssi.stop, sssi.step);
                result.putProperty("DEPEND_" + i, depSlice);
                continue;
            }
            if (bund == null || this.it[idim].length() != dep.length()) continue;
            result.putProperty("BUNDLE_" + i, dep);
        }
        return result;
    }

    public final double getValue(QDataSet ds) {
        switch (this.rank) {
            case 0: {
                return ds.value();
            }
            case 1: {
                return ds.value(this.index(0));
            }
            case 2: {
                return ds.value(this.index(0), this.index(1));
            }
            case 3: {
                return ds.value(this.index(0), this.index(1), this.index(2));
            }
            case 4: {
                return ds.value(this.index(0), this.index(1), this.index(2), this.index(3));
            }
        }
        throw new IllegalArgumentException("rank limit");
    }

    public final void putValue(WritableDataSet ds, double v) {
        switch (this.rank) {
            case 0: {
                ds.putValue(v);
                return;
            }
            case 1: {
                ds.putValue(this.index(0), v);
                return;
            }
            case 2: {
                ds.putValue(this.index(0), this.index(1), v);
                return;
            }
            case 3: {
                ds.putValue(this.index(0), this.index(1), this.index(2), v);
                return;
            }
            case 4: {
                ds.putValue(this.index(0), this.index(1), this.index(2), this.index(3), v);
                return;
            }
        }
        throw new IllegalArgumentException("rank limit");
    }

    public static class SingletonIteratorFactory
    implements DimensionIteratorFactory {
        int index;

        public SingletonIteratorFactory(int index) {
            this.index = index;
        }

        public DimensionIterator newIterator(int length) {
            return new SingletonIterator(this.index);
        }
    }

    public static class SingletonIterator
    implements DimensionIterator {
        int index;
        boolean hasNext = true;

        public SingletonIterator(int index) {
            this.index = index;
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public int nextIndex() {
            this.hasNext = false;
            return this.index;
        }

        public int index() {
            return this.index;
        }

        public int length() {
            return 1;
        }

        public String toString() {
            return "" + this.index;
        }
    }

    public static class IndexListIteratorFactory
    implements DimensionIteratorFactory {
        QDataSet ds;

        public IndexListIteratorFactory(QDataSet ds) {
            this.ds = ds;
        }

        public DimensionIterator newIterator(int length) {
            return new IndexListIterator(this.ds);
        }
    }

    public static class IndexListIterator
    implements DimensionIterator {
        QDataSet ds;
        int index;

        public IndexListIterator(QDataSet ds) {
            this.ds = ds;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.index < this.ds.length() - 1;
        }

        public int nextIndex() {
            ++this.index;
            return (int)this.ds.value(this.index);
        }

        public int index() {
            return (int)this.ds.value(this.index);
        }

        public int length() {
            return this.ds.length();
        }

        public String toString() {
            String dstr = this.ds.toString();
            dstr = dstr.replace("(dimensionless)", "");
            return "[" + dstr + " @ " + this.index + "]";
        }
    }

    public static class StartStopStepIteratorFactory
    implements DimensionIteratorFactory {
        Number start;
        Number stop;
        Number step;

        public StartStopStepIteratorFactory(Number start, Number stop, Number step) {
            this.start = start;
            this.stop = stop;
            this.step = step;
        }

        public DimensionIterator newIterator(int length) {
            int step1;
            int start1 = this.start == null ? 0 : this.start.intValue();
            int stop1 = this.stop == null ? length : this.stop.intValue();
            int n = step1 = this.step == null ? 1 : this.step.intValue();
            if (start1 < 0) {
                start1 = length + start1;
            }
            if (stop1 < 0) {
                stop1 = length + stop1;
            }
            return new StartStopStepIterator(start1, stop1, step1, this.start == null && this.stop == null && this.step == null);
        }
    }

    public static class StartStopStepIterator
    implements DimensionIterator {
        int start;
        int stop;
        int step;
        int index;
        boolean all;

        public StartStopStepIterator(int start, int stop, int step, boolean all) {
            this.start = start;
            this.stop = stop;
            this.step = step;
            this.index = start - step;
            this.all = all;
        }

        public boolean hasNext() {
            return this.index + this.step < this.stop;
        }

        public int nextIndex() {
            this.index += this.step;
            return this.index;
        }

        public int index() {
            return this.index;
        }

        public int length() {
            int remainder = (this.stop - this.start) % this.step;
            return (this.stop - this.start) / this.step + (remainder > 0 ? 1 : 0);
        }

        public String toString() {
            return this.all ? ":" : "" + this.start + ":" + this.stop + (this.step == 1 ? "" : ":" + this.step);
        }
    }

    public static interface DimensionIteratorFactory {
        public DimensionIterator newIterator(int var1);
    }

    public static interface DimensionIterator {
        public boolean hasNext();

        public int nextIndex();

        public int index();

        public int length();
    }
}

