/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.virbo.dataset.AbstractDataSet;
import org.virbo.dataset.DRank0DataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.Slice0DataSet;
import org.virbo.dsops.Ops;

public class Slice1DataSet
extends AbstractDataSet {
    QDataSet ds;
    int index;

    public Slice1DataSet(QDataSet ds, int index) {
        this(ds, index, true, false);
    }

    public Slice1DataSet(QDataSet ds, int index, boolean unbundle) {
        this(ds, index, false, unbundle);
    }

    Slice1DataSet(QDataSet ds, int index, boolean addContext, boolean unbundle) {
        String prop;
        QDataSet plane0;
        Units dep1units;
        if (ds.rank() > 4) {
            throw new IllegalArgumentException("rank limit > 4");
        }
        if (ds.rank() < 2) {
            throw new IllegalArgumentException("rank limit < 2");
        }
        this.ds = ds;
        this.index = index;
        QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
        QDataSet bundle1 = (QDataSet)ds.property("BUNDLE_1");
        if (bundle1 != null && !unbundle) {
            System.err.println("we're not going to do this correctly, use unbundle instead");
        }
        String label = null;
        Units units = dep1units = dep1 == null ? null : (Units)dep1.property("UNITS");
        if (dep1 != null && dep1.rank() == 1 && dep1units instanceof EnumerationUnits) {
            label = String.valueOf(dep1units.createDatum(dep1.value(index)));
        }
        if (dep1 != null) {
            if (dep1.rank() == 1) {
                if (label != null) {
                    this.putProperty("LABEL", label);
                    this.putProperty("NAME", Ops.safeName(label));
                    if (addContext) {
                        DataSetUtil.addContext(this, (QDataSet)new Slice0DataSet(dep1, index, false));
                    }
                } else if (addContext) {
                    DataSetUtil.addContext(this, (QDataSet)new Slice0DataSet(dep1, index, false));
                }
            } else if (dep1.rank() == 2) {
                if (addContext) {
                    DataSetUtil.addContext(this, (QDataSet)new Slice1DataSet(dep1, index, false));
                }
            } else {
                System.err.println("slice on non-qube, dep1 has rank=" + dep1.rank());
            }
        } else {
            DRank0DataSet context = DataSetUtil.asDataSet(index);
            context.putProperty("NAME", "slice1");
            if (addContext) {
                DataSetUtil.addContext(this, (QDataSet)context);
            }
        }
        this.putProperty("DEPEND_0", ds.property("DEPEND_0"));
        this.putProperty("DEPEND_1", ds.property("DEPEND_2"));
        this.putProperty("DEPEND_2", ds.property("DEPEND_3"));
        this.putProperty("BUNDLE_0", ds.property("BUNDLE_0"));
        this.putProperty("BUNDLE_1", null);
        this.putProperty("BINS_0", ds.property("BINS_0"));
        this.putProperty("BINS_1", null);
        for (int i = 0; i < 50 && (plane0 = (QDataSet)ds.property(prop = "PLANE_" + i)) != null; ++i) {
            if (plane0.rank() < 2) {
                this.putProperty(prop, plane0);
                continue;
            }
            this.putProperty(prop, new Slice1DataSet(plane0, index, addContext));
        }
        this.putProperty("WEIGHTS", null);
        DataSetUtil.copyDimensionProperties(ds, this);
    }

    public int rank() {
        return this.ds.rank() - 1;
    }

    public double value(int i) {
        return this.ds.value(i, this.index);
    }

    public double value(int i0, int i1) {
        return this.ds.value(i0, this.index, i1);
    }

    public double value(int i0, int i1, int i2) {
        return this.ds.value(i0, this.index, i1, i2);
    }

    public Object property(String name) {
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        if (DataSetUtil.isInheritedProperty(name)) {
            return this.ds.property(name);
        }
        return null;
    }

    public int length() {
        return this.ds.length();
    }

    public int length(int i) {
        return this.ds.length(i, this.index);
    }

    public int length(int i0, int i1) {
        return this.ds.length(i0, this.index, i1);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Slice1DataSet) {
            Slice1DataSet that = (Slice1DataSet)obj;
            return that.ds.equals(this.ds) && that.index == this.index;
        }
        return false;
    }

    public int hashCode() {
        return this.ds.hashCode() + this.index;
    }
}

