/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import org.virbo.dataset.AbstractDataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.Slice0DataSet;

public class TrimDataSet
extends AbstractDataSet {
    final int offset;
    final int len;
    final QDataSet ds;

    public TrimDataSet(QDataSet ds, int start, int stop) {
        String prop;
        QDataSet plane0;
        QDataSet dep1;
        this.ds = ds;
        this.offset = start;
        this.len = stop - start;
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null) {
            this.putProperty("DEPEND_0", new TrimDataSet(dep0, start, stop));
        }
        if ((dep1 = (QDataSet)ds.property("DEPEND_1")) != null && dep1.rank() == 2) {
            this.putProperty("DEPEND_1", new TrimDataSet(dep1, start, stop));
        }
        for (int i = 0; i < 50 && (plane0 = (QDataSet)ds.property(prop = "PLANE_" + i)) != null; ++i) {
            if (plane0.rank() < 1) {
                this.putProperty(prop, plane0);
                continue;
            }
            this.putProperty(prop, new TrimDataSet(plane0, start, stop));
        }
        String[] p = new String[]{"DELTA_MINUS", "DELTA_PLUS"};
        for (int i = 0; i < p.length; ++i) {
            QDataSet delta = (QDataSet)ds.property(p[i]);
            if (delta == null || delta.rank() <= 0) continue;
            this.putProperty(p[i], new TrimDataSet(delta, start, stop));
        }
    }

    public int rank() {
        return this.ds.rank();
    }

    public double value(int i) {
        return this.ds.value(this.offset + i);
    }

    public double value(int i0, int i1) {
        return this.ds.value(i0 + this.offset, i1);
    }

    public double value(int i0, int i1, int i2) {
        return this.ds.value(i0 + this.offset, i1, i2);
    }

    public Object property(String name) {
        Object p = super.property(name);
        if (p != null) {
            return p;
        }
        if (DataSetUtil.isInheritedProperty(name)) {
            return this.ds.property(name);
        }
        return null;
    }

    public Object property(String name, int i) {
        Object p = super.property(name, i);
        if (p != null) {
            return p;
        }
        if (DataSetUtil.isInheritedProperty(name)) {
            return p != null ? p : this.ds.property(name, i + this.offset);
        }
        return null;
    }

    public int length() {
        return this.len;
    }

    public int length(int i0) {
        return this.ds.length(this.offset + i0);
    }

    public int length(int i0, int i1) {
        return this.ds.length(this.offset + i0, i1);
    }

    public QDataSet slice(int i) {
        return new Slice0DataSet(this.ds, this.offset + i);
    }

    public QDataSet trim(int start, int end) {
        if (end >= this.len) {
            throw new IllegalArgumentException("end>len");
        }
        if (start < 0) {
            throw new IllegalArgumentException("start<0");
        }
        return new TrimDataSet(this.ds, start + this.offset, start + this.offset + end);
    }
}

