/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.datasource.jython;

import java.beans.ExceptionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyStringMap;
import org.python.core.adapter.PyObjectAdapter;
import org.python.util.PythonInterpreter;
import org.virbo.datasource.AbstractDataSourceFactory;
import org.virbo.datasource.CompletionContext;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.DataSourceFactory;
import org.virbo.datasource.URISplit;
import org.virbo.datasource.jython.JythonDataSource;
import org.virbo.datasource.jython.JythonEditorPanel;
import org.virbo.jythonsupport.JythonOps;
import org.virbo.jythonsupport.PyQDataSet;
import org.virbo.jythonsupport.PyQDataSetAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JythonDataSourceFactory
extends AbstractDataSourceFactory {
    ExceptionListener listener;

    public DataSource getDataSource(URI uri) throws Exception {
        JythonDataSource result = new JythonDataSource(uri, this);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getNames(URI uri, ProgressMonitor mon) throws Exception {
        PythonInterpreter interp = new PythonInterpreter();
        Py.getAdapter().addPostClass((PyObjectAdapter)new PyQDataSetAdapter());
        interp.set("monitor", (Object)mon);
        interp.execfile(JythonOps.class.getResource("imports.py").openStream(), "imports.py");
        File src = DataSetURI.getFile((URI)uri, (ProgressMonitor)new NullProgressMonitor());
        URISplit split = URISplit.parse((URI)uri);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        try {
            interp.exec("params=dict()");
            for (Map.Entry e : params.entrySet()) {
                String s = (String)e.getKey();
                if (s.equals("arg_0")) continue;
                interp.exec("params['" + s + "']=" + (String)e.getValue());
            }
            interp.execfile((InputStream)new FileInputStream(src));
            PyStringMap map = (PyStringMap)interp.getLocals();
            PyList list = map.keys();
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (int i = 0; i < list.__len__(); ++i) {
                String key = (String)list.get(i);
                PyObject o = map.get((PyObject)Py.newString((String)key));
                if (!(o instanceof PyQDataSet)) continue;
                result.put(key, o);
            }
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        finally {
            mon.finished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map<String, Param> getParams(URI uri, ProgressMonitor mon) throws IOException {
        BufferedReader reader = null;
        File src = DataSetURI.getFile((URI)uri, (ProgressMonitor)new NullProgressMonitor());
        LinkedHashMap<String, Param> result = new LinkedHashMap<String, Param>();
        try {
            reader = new LineNumberReader(new BufferedReader(new FileReader(src)));
            String vnarg = "\\s*([a-zA-Z_][a-zA-Z0-9_]*)\\s*";
            String sarg = "\\s*\\'([a-zA-Z_][a-zA-Z0-9_]*)\\'\\s*";
            String aarg = "\\s*(\\'[^\\']+\\')\\s*";
            String farg = "\\s*([0-9\\.\\+-eE]+)\\s*";
            Pattern p = Pattern.compile(vnarg + "=\\s*getParam\\(" + sarg + "\\," + aarg + "(\\," + aarg + ")?\\).*");
            Pattern fp = Pattern.compile(vnarg + "=\\s*getParam\\(" + sarg + "\\," + farg + "(\\," + aarg + ")?\\).*");
            String line = reader.readLine();
            while (line != null) {
                Matcher m = p.matcher(line);
                if (!m.matches()) {
                    m = fp.matcher(line);
                }
                if (m.matches()) {
                    Param parm = new Param();
                    parm.name = m.group(2);
                    parm.label = m.group(1);
                    parm.doc = m.group(5);
                    if (m.group(3) == null) {
                        System.err.println("error handle");
                    } else {
                        parm.type = (char)(m.group(3).startsWith("'") ? 65 : 70);
                        String sval = parm.type == 'A' ? m.group(3).substring(1, m.group(3).length() - 1) : m.group(3);
                        parm.deft = parm.type == 'F' ? Double.valueOf(Double.parseDouble(sval)) : sval;
                    }
                    result.put(parm.name, parm);
                }
                line = reader.readLine();
            }
            reader.close();
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {
                Logger.getLogger(JythonEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }

    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        Map<String, Param> po2;
        Param pp;
        String paramName;
        ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            String ext = DataSetURI.fromUri((URI)cc.resourceURI);
            int i = ext.lastIndexOf(".");
            if (i != -1) {
                ext = ext.substring(i + 1);
            }
            if (ext.equals("jyds") || ext.equals("jy") || ext.equals("py")) {
                Map<String, Object> po = this.getNames(cc.resourceURI, mon);
                for (String n : po.keySet()) {
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, n, (DataSourceFactory)this, "arg_0", null, null));
                }
                Map<String, Param> po22 = JythonDataSourceFactory.getParams(cc.resourceURI, (ProgressMonitor)new NullProgressMonitor());
                for (String n : po22.keySet()) {
                    Param parm = po22.get(n);
                    if (parm.doc == null) {
                        parm.doc = "";
                    }
                    if (!parm.name.equals(parm.label)) {
                        parm.doc = parm.doc + " (named " + parm.label + " in the script)";
                    }
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, n + "=", n + " default is '" + po22.get((Object)n).deft + "'", po22.get((Object)n).doc));
                }
            } else {
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "script=", "the name of the python script to run"));
            }
        } else if (cc.context == CompletionContext.CONTEXT_PARAMETER_VALUE && !(paramName = CompletionContext.get((Object)CompletionContext.CONTEXT_PARAMETER_NAME, (CompletionContext)cc)).equals("script") && (pp = (po2 = JythonDataSourceFactory.getParams(cc.resourceURI, (ProgressMonitor)new NullProgressMonitor())).get(paramName)) != null) {
            if (pp.deft instanceof Number) {
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, String.valueOf(pp.deft), paramName + " default is '" + pp.deft + "'", pp.doc));
            } else {
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, String.format("'%s'", pp.deft), paramName + " default is '" + pp.deft + "'", pp.doc));
            }
        }
        return result;
    }

    public boolean reject(String surl, ProgressMonitor mon) {
        if (surl.contains("?")) {
            URISplit split = URISplit.parse((String)surl);
            return split.params.length() <= 0;
        }
        try {
            URISplit split = URISplit.parse((String)surl);
            if (split.scheme.equals("inline")) {
                return false;
            }
            File src = DataSetURI.getFile((URL)DataSetURI.getURL((String)surl), (ProgressMonitor)new NullProgressMonitor());
            BufferedReader reader = new BufferedReader(new FileReader(src));
            String s = reader.readLine();
            boolean haveResult = false;
            while (s != null) {
                if (s.trim().startsWith("result")) {
                    haveResult = true;
                    break;
                }
                if (s.trim().startsWith("data")) {
                    haveResult = true;
                    break;
                }
                s = reader.readLine();
            }
            reader.close();
            return !haveResult;
        }
        catch (IOException ex) {
            Logger.getLogger(JythonDataSourceFactory.class.getName()).log(Level.SEVERE, null, ex);
            return true;
        }
    }

    protected static Map<String, String> getParameters(String surl, ProgressMonitor mon) throws IOException {
        File src = DataSetURI.getFile((URL)DataSetURI.getURL((String)surl), (ProgressMonitor)new NullProgressMonitor());
        BufferedReader reader = new BufferedReader(new FileReader(src));
        String s = reader.readLine();
        Pattern assignPattern = Pattern.compile("\\s*([_a-zA-Z][_a-zA-Z0-9]*)\\s*=.*(#(.*))?");
        Pattern defPattern = Pattern.compile("def .*");
        boolean inDef = false;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        boolean haveResult = false;
        while (s != null) {
            Matcher m;
            Matcher defm;
            if (!inDef) {
                defm = defPattern.matcher(s);
                if (defm.matches()) {
                    inDef = true;
                }
            } else if (s.length() > 0 && !Character.isWhitespace(s.charAt(0))) {
                defm = defPattern.matcher(s);
                inDef = defm.matches();
            }
            if (!inDef && (m = assignPattern.matcher(s)).matches()) {
                if (m.group(3) != null) {
                    result.put(m.group(1), m.group(3));
                } else {
                    result.put(m.group(1), s);
                }
            }
            s = reader.readLine();
        }
        reader.close();
        return result;
    }

    public void addExeceptionListener(ExceptionListener listener) {
        this.listener = listener;
    }

    static class Param {
        String name;
        String label;
        Object deft;
        String doc;
        char type;

        Param() {
        }
    }
}

