/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.datasource.jython;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import org.das2.components.TearoffTabbedPane;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.layout.GroupLayout;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSourceEditorPanel;
import org.virbo.datasource.URISplit;
import org.virbo.datasource.jython.JythonDataSourceFactory;
import org.virbo.jythonsupport.JythonUtil;
import org.virbo.jythonsupport.ui.EditorAnnotationsSupport;
import org.virbo.jythonsupport.ui.EditorTextPane;
import org.virbo.jythonsupport.ui.ScriptPanelSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JythonEditorPanel
extends JPanel
implements DataSourceEditorPanel {
    ScriptPanelSupport support;
    String suri;
    File file;
    boolean hasVariables = false;
    List<JTextField> tflist;
    List<String> paramsList;
    List<String> deftsList;
    List<Character> typesList;
    private JLabel caretPositionLabel;
    protected JLabel fileNameLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JPanel paramsPanel;
    private JPanel scriptPanel;
    private TearoffTabbedPane tearoffTabbedPane1;
    private EditorTextPane textArea;
    private JComboBox variableComboBox;

    public JythonEditorPanel() {
        this.initComponents();
        this.tearoffTabbedPane1.hideMouseAdapter();
        this.support = new ScriptPanelSupport(this.textArea);
        this.support.addCaretLabel(this.caretPositionLabel);
        this.support.addFileLabel(this.fileNameLabel);
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(12);
    }

    private void initComponents() {
        this.variableComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.tearoffTabbedPane1 = new TearoffTabbedPane();
        this.scriptPanel = new JPanel();
        this.caretPositionLabel = new JLabel();
        this.fileNameLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.textArea = new EditorTextPane();
        this.paramsPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.variableComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"(running script)"}));
        this.jLabel1.setText("dataset variable:");
        this.jLabel1.setToolTipText("The dataset pointed to by the URI");
        this.caretPositionLabel.setText("1,1");
        this.fileNameLabel.setMinimumSize(new Dimension(200, 16));
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.add((Component)this.textArea, "Center");
        this.jScrollPane1.setViewportView(this.jPanel1);
        GroupLayout scriptPanelLayout = new GroupLayout((Container)this.scriptPanel);
        this.scriptPanel.setLayout((LayoutManager)scriptPanelLayout);
        scriptPanelLayout.setHorizontalGroup((GroupLayout.Group)scriptPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)scriptPanelLayout.createSequentialGroup().add((Component)this.fileNameLabel, -1, 420, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.caretPositionLabel, -2, 56, -2)).add((Component)this.jScrollPane1, -1, 482, Short.MAX_VALUE));
        scriptPanelLayout.setVerticalGroup((GroupLayout.Group)scriptPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)scriptPanelLayout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 208, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)scriptPanelLayout.createParallelGroup(2).add((Component)this.fileNameLabel, -2, 20, -2).add((Component)this.caretPositionLabel))));
        this.tearoffTabbedPane1.addTab("script", (Component)this.scriptPanel);
        this.paramsPanel.setLayout(new BoxLayout(this.paramsPanel, 1));
        this.tearoffTabbedPane1.addTab("params", (Component)this.paramsPanel);
        this.jLabel2.setText("Select from the variables calculated by the script, 'data' is used by default:");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.variableComboBox, 0, 351, Short.MAX_VALUE).addContainerGap()).add((Component)this.tearoffTabbedPane1, -1, 494, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.tearoffTabbedPane1, -1, 277, Short.MAX_VALUE).add(2, 2, 2).add((Component)this.jLabel2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.variableComboBox, -2, -1, -2))));
    }

    public JPanel getPanel() {
        return this;
    }

    private boolean doVariables(File f, Map<String, String> params) {
        boolean hasVars = false;
        this.tflist = new ArrayList<JTextField>();
        this.paramsList = new ArrayList<String>();
        this.deftsList = new ArrayList<String>();
        this.typesList = new ArrayList<Character>();
        try {
            Map<String, JythonDataSourceFactory.Param> parms = JythonDataSourceFactory.getParams(f.toURI(), (ProgressMonitor)new NullProgressMonitor());
            this.paramsPanel.add(new JLabel("<html>This script has these input parameters.  Buttons on the right show default values.<br><br></html>"));
            for (Map.Entry<String, JythonDataSourceFactory.Param> e : parms.entrySet()) {
                String val;
                JythonDataSourceFactory.Param parm = e.getValue();
                String vname = parm.name;
                String label = parm.label;
                if (parm.doc == null) {
                    label = vname + ":";
                } else {
                    String doc = parm.doc;
                    doc = doc.substring(1, doc.length() - 1);
                    if (!parm.label.equals(parm.name)) {
                        doc = doc + " (" + parm.label + " internally)";
                    }
                    label = "<html>" + parm.name + ", <em>" + doc + "</em>:</html>";
                }
                JLabel l = new JLabel(label);
                l.setAlignmentX(0.0f);
                this.paramsPanel.add(l);
                JPanel valuePanel = new JPanel();
                valuePanel.setLayout(new BoxLayout(valuePanel, 0));
                JTextField tf = new JTextField(50);
                Dimension x = tf.getPreferredSize();
                x.width = Integer.MAX_VALUE;
                tf.setMaximumSize(x);
                tf.setAlignmentX(0.0f);
                if (params.get(vname) != null) {
                    val = params.get(vname);
                    if (val.startsWith("'")) {
                        val = val.substring(1);
                    }
                    if (val.endsWith("'")) {
                        val = val.substring(0, val.length() - 1);
                    }
                } else {
                    val = String.valueOf(parm.deft);
                }
                tf.setText(val);
                valuePanel.add(tf);
                final String fdeft = String.valueOf(parm.deft);
                final JTextField ftf = tf;
                JButton defaultButton = new JButton(new AbstractAction(fdeft){

                    public void actionPerformed(ActionEvent e) {
                        ftf.setText(fdeft);
                    }
                });
                defaultButton.setToolTipText("Click to reset to default");
                valuePanel.add(defaultButton);
                valuePanel.setAlignmentX(0.0f);
                this.paramsPanel.add(valuePanel);
                this.tflist.add(tf);
                this.paramsList.add(parm.name);
                this.deftsList.add(String.valueOf(parm.deft));
                this.typesList.add(Character.valueOf(parm.type));
                hasVars = true;
            }
            boolean bl = hasVars = parms.size() > 0;
            if (!hasVars) {
                this.paramsPanel.add(new JLabel("<html><em>no parameters</em></html>"));
            }
            this.paramsPanel.add(Box.createVerticalGlue());
        }
        catch (IOException ex) {
            Logger.getLogger(JythonEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        return hasVars;
    }

    public void setURI(String url) {
        try {
            this.suri = url;
            URISplit split = URISplit.parse((String)this.suri);
            File f = DataSetURI.getFile((URI)DataSetURI.getResourceURI((URI)DataSetURI.toUri((String)url)), (ProgressMonitor)new NullProgressMonitor());
            this.support.loadFile(f);
            Map<String, String> results = JythonDataSourceFactory.getParameters(url, (ProgressMonitor)new NullProgressMonitor());
            String[] dropList = new String[results.size() + 1];
            int i = 0;
            int idx = -1;
            LinkedHashMap params = URISplit.parseParams((String)split.params);
            String param = (String)params.remove("arg_0");
            dropList[0] = "";
            for (Map.Entry<String, String> ent : results.entrySet()) {
                dropList[i + 1] = ent.getKey() + ":  " + ent.getValue();
                if (param != null && param.equals(ent.getKey())) {
                    idx = i + 1;
                }
                ++i;
            }
            this.variableComboBox.setModel(new DefaultComboBoxModel<String>(dropList));
            if (idx >= 0) {
                this.variableComboBox.setSelectedIndex(idx);
            } else {
                this.variableComboBox.setSelectedIndex(0);
            }
            this.hasVariables = this.doVariables(f, params);
            if (this.hasVariables) {
                this.tearoffTabbedPane1.setSelectedIndex(1);
            }
            ArrayList errs = new ArrayList();
            if (JythonUtil.pythonLint((URI)f.toURI(), errs)) {
                System.err.println(errs);
                EditorAnnotationsSupport esa = this.textArea.getEditorAnnotationsSupport();
                for (String s : errs) {
                    String[] ss = s.split(":", 2);
                    try {
                        String doc = ss[1];
                        doc = doc.replaceAll("<", "&lt;");
                        doc = doc.replaceAll(">", "&gt;");
                        esa.annotateLine(Integer.parseInt(ss[0]), "warning", "variable is defined before execution: " + doc);
                    }
                    catch (BadLocationException ex) {
                        Logger.getLogger(JythonEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(JythonEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getURI() {
        URISplit split = URISplit.parse((String)this.suri);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        String param = (String)this.variableComboBox.getSelectedItem();
        int i = param.indexOf(":");
        if (i == -1) {
            params.put("arg_0", param.trim());
        } else {
            params.put("arg_0", param.substring(0, i).trim());
        }
        for (int j = 0; j < this.paramsList.size(); ++j) {
            String name = this.paramsList.get(j);
            String value = this.tflist.get(j).getText();
            String deft = this.deftsList.get(j);
            char type = this.typesList.get(j).charValue();
            if (value.equals(deft) && !params.containsKey(name)) continue;
            if (type == 'A') {
                if (!(value = value.replaceAll("'", "")).startsWith("'") || !value.endsWith("'")) {
                    value = "'" + value + "'";
                }
                params.put(name, value);
                continue;
            }
            params.put(name, value);
        }
        split.params = URISplit.formatParams((Map)params);
        if (this.support.isDirty()) {
            try {
                FileWriter writer = new FileWriter(this.support.getFile());
                writer.write(this.textArea.getText());
                writer.close();
            }
            catch (IOException ex) {
                Logger.getLogger(JythonEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return URISplit.format((URISplit)split);
    }

    public boolean reject(String uri) throws Exception {
        URISplit split = URISplit.parse((String)uri);
        return split.file == null || split.file.length() == 0 || split.file.equals("file:///");
    }

    public boolean prepare(String uri, Window parent, ProgressMonitor mon) throws Exception {
        DataSetURI.getFile((URI)DataSetURI.getResourceURI((URI)DataSetURI.toUri((String)uri)), (ProgressMonitor)mon);
        return true;
    }
}

