/*
 * Decompiled with CFR 0.152.
 */
package ftpfs;

import ftpfs.FtpFileObject;
import ftpfs.ftp.FtpBean;
import ftpfs.ftp.FtpException;
import ftpfs.ftp.FtpObserver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.util.FileUtil;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystemUtil;
import org.das2.util.filesystem.KeyChain;
import org.das2.util.filesystem.WebFileSystem;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.datasource.DataSourceUtil;

public class FTPBeanFileSystem
extends WebFileSystem {
    public static final int LISTING_TIMEOUT_MS = 20000;

    FTPBeanFileSystem(URI root) throws FileSystem.FileSystemOfflineException {
        super(root, FTPBeanFileSystem.userLocalRoot(root));
        try {
            this.listDirectory("/");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.offline = true;
        }
    }

    private static File userLocalRoot(URI root) {
        File local = FileSystem.settings().getLocalCacheDir();
        String userInfo = root.getUserInfo();
        if (userInfo != null && userInfo.contains(":")) {
            userInfo = userInfo.substring(0, userInfo.indexOf(58));
        }
        String s = root.getScheme() + "/" + (userInfo != null ? userInfo + "@" : "") + root.getHost() + "/" + root.getPath();
        local = new File(local, s);
        try {
            FileSystemUtil.maybeMkdirs((File)local);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("unable to mkdirs " + local);
        }
        return local;
    }

    public boolean isDirectory(String filename) throws IOException {
        File f = new File(this.localRoot, filename);
        if (f.exists()) {
            return f.isDirectory();
        }
        if (filename.endsWith("/")) {
            return true;
        }
        File parentFile = f.getParentFile();
        String parent = this.getLocalName(parentFile);
        if (!parent.endsWith("/")) {
            parent = parent + "/";
        }
        String[] list = this.listDirectory(parent);
        String lookFor = filename.startsWith("/") ? filename.substring(1) + "/" : filename + "/";
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].equals(lookFor)) continue;
            return true;
        }
        return false;
    }

    private boolean copyFile(File partFile, File targetFile) throws IOException {
        logger.log(Level.FINER, "ftpBeanFilesystem copyFile({0},{1}", new Object[]{partFile, targetFile});
        WritableByteChannel dest = Channels.newChannel(new FileOutputStream(targetFile));
        ReadableByteChannel src = Channels.newChannel(new FileInputStream(partFile));
        DataSourceUtil.transfer(src, dest);
        return true;
    }

    private long parseTime1970(String time, Calendar context) {
        try {
            return (long)TimeUtil.toDatum((TimeUtil.TimeStruct)TimeUtil.parseTime((String)time)).doubleValue((Units)Units.t1970);
        }
        catch (ParseException ex) {
            try {
                return (long)TimeUtil.toDatum((TimeUtil.TimeStruct)TimeUtil.parseTime((String)("" + context.get(1) + " " + time))).doubleValue((Units)Units.t1970);
            }
            catch (ParseException ex1) {
                return -1L;
            }
        }
    }

    public FileSystem.DirectoryEntry[] parseLsl(String dir, File listing) throws IOException {
        FileInputStream in = new FileInputStream(listing);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String aline = reader.readLine();
        boolean done = aline == null;
        String types = "d-";
        long bytesRead = 0L;
        ArrayList<FileSystem.DirectoryEntry> result = new ArrayList<FileSystem.DirectoryEntry>(20);
        int lineNum = 1;
        int sizePos = 31;
        int modifiedPos = 42;
        while (!done) {
            bytesRead = bytesRead + (long)aline.length() + 1L;
            if ((aline = aline.trim()).length() == 0) {
                done = true;
                continue;
            }
            char type = aline.charAt(0);
            if (type != 't' || aline.indexOf("total") == 0) {
                // empty if block
            }
            if (types.indexOf(type) != -1) {
                int i = aline.lastIndexOf(32);
                FileSystem.DirectoryEntry item = new FileSystem.DirectoryEntry((FileSystem)this);
                item.name = aline.substring(i + 1);
                try {
                    item.size = Long.parseLong(aline.substring(sizePos, sizePos + 11).trim());
                }
                catch (NumberFormatException ex) {
                    item.size = Long.parseLong(aline.substring(sizePos, sizePos + 10).trim());
                }
                item.type = (char)(type == 'd' ? 100 : 102);
                item.modified = this.parseTime1970(aline.substring(modifiedPos, modifiedPos + 12), Calendar.getInstance());
                result.add(item);
            }
            aline = reader.readLine();
            ++lineNum;
            done = aline == null;
        }
        reader.close();
        return result.toArray(new FileSystem.DirectoryEntry[result.size()]);
    }

    protected void resetListCache(String directory) {
        File f = new File(this.localRoot, (directory = FTPBeanFileSystem.toCanonicalFolderName((String)directory)) + ".listing");
        if (!f.delete()) {
            throw new IllegalArgumentException("unable to delete .listing file: " + f);
        }
    }

    public void resetListingCache() {
        if (!FileUtil.deleteWithinFileTree((File)this.localRoot, (String)".listing")) {
            throw new IllegalArgumentException("unable to delete all .listing files");
        }
    }

    public boolean isListingCached(String directory) {
        File listing = this.listingFile(directory);
        if (listing.exists() && System.currentTimeMillis() - listing.lastModified() < 20000L) {
            logger.fine(String.format("listing date is %f5.2 seconds old", (double)(System.currentTimeMillis() - listing.lastModified()) / 1000.0));
            return true;
        }
        return false;
    }

    private File listingFile(String directory) {
        File f = new File(this.localRoot, directory);
        try {
            FileSystemUtil.maybeMkdirs((File)f);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("unable to mkdir " + f);
        }
        File listing = new File(this.localRoot, directory + ".listing");
        return listing;
    }

    public final synchronized String[] listDirectory(String directory) throws IOException {
        if (this.isListingCached(directory = FTPBeanFileSystem.toCanonicalFolderName((String)directory))) {
            logger.log(Level.FINE, "using cached listing for {0}", directory);
            File listing = this.listingFile(directory);
            FileSystem.DirectoryEntry[] des = this.parseLsl(directory, listing);
            String[] result = new String[des.length];
            for (int i = 0; i < des.length; ++i) {
                result[i] = des[i].name + (des[i].type == 'd' ? "/" : "");
            }
            return result;
        }
        boolean successOrCancel = false;
        if (this.isOffline()) {
            File f = new File(this.localRoot, directory);
            if (!f.exists()) {
                throw new FileSystem.FileSystemOfflineException("unable to list " + f + " when offline");
            }
            String[] listing = f.list();
            return listing;
        }
        URL url = this.getRootURL();
        String userInfo = null;
        while (!successOrCancel) {
            try {
                File newDir = new File(this.localRoot, directory);
                FileSystemUtil.maybeMkdirs((File)newDir);
                File listing = new File(this.localRoot, directory + ".listing");
                File listingt = new File(this.localRoot, directory + ".listing.temp");
                FtpBean bean = new FtpBean();
                try {
                    userInfo = KeyChain.getDefault().getUserInfo(url);
                    if (userInfo != null) {
                        String[] userHostArr = userInfo.split(":");
                        if (userHostArr.length == 1) {
                            userHostArr = new String[]{userHostArr[0], "pass"};
                        } else if (userHostArr.length == 0) {
                            userHostArr = new String[]{"user", "pass"};
                        }
                        bean.ftpConnect(url.getHost(), userHostArr[0], userHostArr[1]);
                    } else {
                        bean.ftpConnect(url.getHost(), "ftp");
                    }
                    String cwd = bean.getDirectory();
                    bean.setDirectory(cwd + this.getRootURL().getPath() + directory.substring(1));
                }
                catch (NullPointerException ex) {
                    ex.printStackTrace();
                    IOException ex2 = new IOException("Unable to make connection to " + this.getRootURL().getHost());
                    ex2.initCause(ex);
                    throw ex2;
                }
                catch (CancelledOperationException ex) {
                    throw new FileSystem.FileSystemOfflineException("user cancelled credentials");
                }
                String ss = bean.getDirectoryContentAsString();
                FileWriter fw = new FileWriter(listingt);
                fw.write(ss);
                fw.close();
                if (!listingt.renameTo(listing)) {
                    throw new IllegalArgumentException("unable to rename file " + listingt + " to " + listing);
                }
                successOrCancel = true;
                FileSystem.DirectoryEntry[] des = this.parseLsl(directory, listing);
                String[] result = new String[des.length];
                for (int i = 0; i < des.length; ++i) {
                    result[i] = des[i].name + (des[i].type == 'd' ? "/" : "");
                }
                return result;
            }
            catch (FtpException e) {
                if (e.getMessage().startsWith("530")) {
                    if (userInfo == null) {
                        userInfo = "user:pass";
                        url = new URL(url.getProtocol() + "://" + userInfo + "@" + url.getHost() + url.getFile());
                    }
                    KeyChain.getDefault().clearUserPassword(url);
                    continue;
                }
                throw new IOException(e.getMessage());
            }
        }
        return new String[]{"should not get here"};
    }

    protected void uploadFile(String filename, File srcFile, final ProgressMonitor mon) throws IOException {
        logger.log(Level.FINE, "ftpfs uploadFile({0})", filename);
        Object out = null;
        Object is = null;
        filename = FTPBeanFileSystem.toCanonicalFilename((String)filename);
        URL url = new URL(this.getRootURL(), filename.substring(1));
        String[] ss = FileSystem.splitUrl((String)url.toString());
        try {
            FtpBean bean = new FtpBean();
            String fname = ss[2].substring(ss[1].length());
            String userInfo = KeyChain.getDefault().getUserInfo(this.getRootURL());
            if (userInfo != null) {
                String[] userHostArr = userInfo.split(":");
                bean.ftpConnect(this.getRootURL().getHost(), userHostArr[0], userHostArr[1]);
            } else {
                bean.ftpConnect(this.getRootURL().getHost(), "ftp");
            }
            String cwd = bean.getDirectory();
            bean.setDirectory(cwd + fname);
            String lfilename = ss[3].substring(ss[2].length());
            long size = srcFile.length();
            mon.setTaskSize(size);
            mon.started();
            final long t0 = System.currentTimeMillis();
            FtpObserver observer = new FtpObserver(){
                int totalBytes = 0;

                public void byteRead(int bytes) {
                    this.totalBytes += bytes;
                    if (mon.isCancelled()) {
                        throw new RuntimeException(new InterruptedIOException("transfer cancelled by user"));
                    }
                    long dt = System.currentTimeMillis() - t0;
                    mon.setTaskProgress((long)this.totalBytes);
                    mon.setProgressMessage(this.totalBytes / 1000 + "KB read at " + (long)this.totalBytes / dt + " KB/sec");
                }

                public void byteWrite(int bytes) {
                    this.totalBytes += bytes;
                    mon.setTaskProgress((long)this.totalBytes);
                    if (mon.isCancelled()) {
                        throw new RuntimeException(new InterruptedIOException("transfer cancelled by user"));
                    }
                    long dt = System.currentTimeMillis() - t0;
                    mon.setTaskProgress((long)this.totalBytes);
                    mon.setProgressMessage(this.totalBytes / 1000 + "KB written at " + (long)this.totalBytes / dt + " KB/sec");
                }
            };
            bean.putBinaryFile(srcFile.getAbsolutePath(), lfilename, observer);
            FtpFileObject fo = (FtpFileObject)this.getFileObject(filename);
            this.resetListCache(fo.getParent().getNameExt());
            this.listDirectory(fo.getParent().getNameExt());
            bean.close();
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            if (ex.getCause() instanceof IOException) {
                throw (IOException)ex.getCause();
            }
            throw new IOException(ex.toString());
        }
        catch (FtpException ex) {
            throw new IOException(ex.getMessage());
        }
        catch (CancelledOperationException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    protected void downloadFile(String filename, File targetFile, File partFile, final ProgressMonitor mon) throws IOException {
        Lock lock = this.getDownloadLock(filename, targetFile, mon);
        if (lock == null) {
            return;
        }
        logger.log(Level.FINE, "ftpfs downloadFile({0})", filename);
        FileOutputStream out = null;
        InputStream is = null;
        try {
            filename = FTPBeanFileSystem.toCanonicalFilename((String)filename);
            URL url = new URL(this.getRootURL(), filename.substring(1));
            String[] ss = FileSystem.splitUrl((String)url.toString());
            url = this.getRootURL();
            String userInfo = null;
            boolean done = false;
            while (!done) {
                try {
                    FtpBean bean = new FtpBean();
                    userInfo = KeyChain.getDefault().getUserInfo(url);
                    if (userInfo != null) {
                        String[] userHostArr = userInfo.split(":");
                        if (userHostArr.length == 1) {
                            userHostArr = new String[]{userHostArr[0], "pass"};
                        } else if (userHostArr.length == 0) {
                            userHostArr = new String[]{"user", "pass"};
                        }
                        bean.ftpConnect(this.getRootURL().getHost(), userHostArr[0], userHostArr[1]);
                        String cwd = bean.getDirectory();
                        bean.setDirectory(cwd + ss[2].substring(ss[1].length()));
                    } else {
                        bean.ftpConnect(this.getRootURL().getHost(), "ftp");
                        String cwd = bean.getDirectory();
                        bean.setDirectory(cwd + ss[2].substring(ss[1].length()));
                    }
                    File listingFile = new File(targetFile.getParentFile(), ".listing");
                    if (!listingFile.exists()) {
                        String listing = bean.getDirectoryContentAsString();
                        FileOutputStream out2 = new FileOutputStream(listingFile);
                        out2.write(listing.getBytes());
                        out2.close();
                    }
                    long size = this.getFileObject(filename).getSize();
                    mon.setTaskSize(size);
                    mon.started();
                    final long t0 = System.currentTimeMillis();
                    FtpObserver observer = new FtpObserver(){
                        int totalBytes = 0;

                        public void byteRead(int bytes) {
                            this.totalBytes += bytes;
                            if (mon.isCancelled()) {
                                throw new RuntimeException(new InterruptedIOException("transfer cancelled by user"));
                            }
                            long dt = Math.max(1L, System.currentTimeMillis() - t0);
                            mon.setTaskProgress((long)this.totalBytes);
                            mon.setProgressMessage(this.totalBytes / 1000 + "KB read at " + (long)this.totalBytes / dt + " KB/sec");
                        }

                        public void byteWrite(int bytes) {
                            this.totalBytes += bytes;
                            mon.setTaskProgress((long)this.totalBytes);
                        }
                    };
                    bean.getBinaryFile(ss[3].substring(ss[2].length()), partFile.toString(), observer);
                    bean.close();
                    done = true;
                }
                catch (RuntimeException ex) {
                    ex.printStackTrace();
                    if (ex.getCause() instanceof IOException) {
                        throw (IOException)ex.getCause();
                    }
                    IOException tex = new IOException(ex.toString());
                    tex.initCause(ex);
                    throw tex;
                }
                catch (FtpException ex) {
                    if (ex.getMessage().startsWith("530")) {
                        if (userInfo == null) {
                            userInfo = "user:pass";
                            url = new URL(url.getProtocol() + "://" + userInfo + "@" + url.getHost() + url.getFile());
                        }
                        KeyChain.getDefault().clearUserPassword(url);
                        continue;
                    }
                    throw new IOException(ex.getMessage());
                }
                catch (CancelledOperationException ex) {
                    throw new FileSystem.FileSystemOfflineException("user cancelled credentials");
                }
            }
            if (this.copyFile(partFile, targetFile) && !partFile.delete()) {
                throw new IllegalArgumentException("unable to delete file " + partFile);
            }
        }
        catch (IOException e) {
            if (out != null) {
                out.close();
            }
            if (is != null) {
                is.close();
            }
            if (!partFile.delete()) {
                throw new IllegalArgumentException("unable to delete file " + partFile);
            }
            throw e;
        }
        finally {
            mon.finished();
            lock.unlock();
        }
    }

    public FileObject getFileObject(String filename) {
        return new FtpFileObject(this, filename, new Date(System.currentTimeMillis()));
    }

    boolean delete(FtpFileObject aThis) throws IOException {
        String userInfo;
        FtpBean bean = new FtpBean();
        try {
            userInfo = KeyChain.getDefault().getUserInfo(this.getRootURL());
        }
        catch (CancelledOperationException ex) {
            IOException result = new IOException(ex.toString());
            throw result;
        }
        String filename = FTPBeanFileSystem.toCanonicalFilename((String)aThis.getNameExt());
        URL url = new URL(this.getRootURL(), filename.substring(1));
        String[] ss = FileSystem.splitUrl((String)url.toString());
        try {
            if (userInfo != null) {
                String[] userHostArr = userInfo.split(":");
                bean.ftpConnect(this.getRootURL().getHost(), userHostArr[0], userHostArr[1]);
                String cwd = bean.getDirectory();
                bean.setDirectory(cwd + ss[2].substring(ss[1].length()));
            } else {
                bean.ftpConnect(this.getRootURL().getHost(), "ftp");
                String cwd = bean.getDirectory();
                bean.setDirectory(cwd + ss[2].substring(ss[1].length()));
            }
            bean.fileDelete(ss[3].substring(ss[2].length()));
            bean.close();
            return true;
        }
        catch (IOException iOException) {
            try {
                bean.close();
            }
            catch (FtpException ex) {
                Logger.getLogger(FTPBeanFileSystem.class.getName()).log(Level.SEVERE, null, ex);
            }
            return false;
        }
        catch (FtpException ftpException) {
            try {
                bean.close();
            }
            catch (FtpException ex) {
                Logger.getLogger(FTPBeanFileSystem.class.getName()).log(Level.SEVERE, null, ex);
            }
            return false;
        }
    }
}

