/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.aggregator;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.DatumRange;
import org.das2.fsm.FileStorageModelNew;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.LocalFileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.datasource.capability.Updating;

public class AggregationPollUpdating
implements Updating {
    FileStorageModelNew fsm;
    DatumRange dr;
    long dirHash;
    long pollCyclePeriodSeconds = -1L;
    boolean dirty = false;
    boolean polling = false;
    private static final int LIMIT_SHORT_CYCLE_PERIOD = 1;
    private static final int LIMIT_SHORT_REMOTE_CYCLE_PERIOD = 10;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public AggregationPollUpdating(FileStorageModelNew fsm, DatumRange dr, long pollCyclePeriodSeconds) {
        this.fsm = fsm;
        this.dr = dr;
        if (fsm.getFileSystem() instanceof LocalFileSystem ? pollCyclePeriodSeconds < 1L : pollCyclePeriodSeconds < 10L) {
            throw new IllegalArgumentException("pollCyclePeriorSeconds too low");
        }
        this.pollCyclePeriodSeconds = pollCyclePeriodSeconds;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
        try {
            this.startPolling();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
        if (!this.pcs.hasListeners(null)) {
            this.stopPolling();
        }
    }

    long dirHash(DatumRange datumRange) throws IOException {
        String[] ss = this.fsm.getBestNamesFor(datumRange, (ProgressMonitor)new NullProgressMonitor());
        long hash = 1L;
        for (int i = 0; i < ss.length; ++i) {
            FileObject fo = this.fsm.getFileSystem().getFileObject(ss[i]);
            long sz = fo.getSize();
            hash = hash + 31L * sz + (long)(31 * ss[i].hashCode());
        }
        return hash;
    }

    public void startPolling() throws IOException {
        if (this.dirHash != 0L || this.polling) {
            return;
        }
        this.dirHash = this.dirHash(this.dr);
        Runnable run = new Runnable(){

            public void run() {
                while (AggregationPollUpdating.this.dirHash != 0L) {
                    try {
                        Thread.sleep(AggregationPollUpdating.this.pollCyclePeriodSeconds * 1000L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(AggregationPollUpdating.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    try {
                        long dirHash1 = AggregationPollUpdating.this.dirHash(AggregationPollUpdating.this.dr);
                        System.err.printf("old: %d   new: %d   %s \n", AggregationPollUpdating.this.dirHash, dirHash1, Thread.currentThread().getName());
                        if (AggregationPollUpdating.this.dirHash != 0L && dirHash1 != AggregationPollUpdating.this.dirHash) {
                            AggregationPollUpdating.this.dirty = true;
                            AggregationPollUpdating.this.dirHash = dirHash1;
                            continue;
                        }
                        if (!AggregationPollUpdating.this.dirty || AggregationPollUpdating.this.dirHash != dirHash1) continue;
                        AggregationPollUpdating.this.pcs.firePropertyChange("dataSet", null, null);
                        AggregationPollUpdating.this.dirty = false;
                    }
                    catch (IOException ex) {
                        System.err.println(ex);
                        throw new RuntimeException(ex);
                    }
                }
                AggregationPollUpdating.this.polling = false;
            }
        };
        this.polling = true;
        new Thread(run, "FilePollUpdating_" + this.dirHash).start();
    }

    public void stopPolling() {
        this.dirHash = 0L;
    }

    public boolean isPolling() {
        return this.polling;
    }

    public static void main(String[] args) throws FileSystem.FileSystemOfflineException, UnknownHostException, URISyntaxException, IOException, InterruptedException {
        FileStorageModelNew fsm = FileStorageModelNew.create((FileSystem)FileSystem.create((URI)new URI("file:/home/jbf/eg/data/agg/")), (String)"hk_h0_mag_$Y$m$d_v02.cdf");
        AggregationPollUpdating a = new AggregationPollUpdating(fsm, null, 1L);
        a.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                System.err.println(evt.toString());
            }
        });
        a.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                System.err.println(evt.getNewValue() + "  " + Thread.currentThread().getName());
            }
        });
        Thread.sleep(6000L);
        a.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                System.err.println(evt.getNewValue() + "  " + Thread.currentThread().getName() + "  *** ");
            }
        });
    }
}

