/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.datasource;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import org.das2.DasApplication;
import org.das2.components.DasProgressPanel;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.system.MonitorFactory;
import org.das2.system.RequestProcessor;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.layout.GroupLayout;
import org.virbo.aggregator.AggregatingDataSourceFactory;
import org.virbo.datasource.CompletionsList;
import org.virbo.datasource.DataSetSelectorDemo;
import org.virbo.datasource.DataSetSelectorSupport;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSourceEditorDialog;
import org.virbo.datasource.DataSourceEditorPanel;
import org.virbo.datasource.DataSourceEditorPanelUtil;
import org.virbo.datasource.DataSourceFactory;
import org.virbo.datasource.DataSourceRegistry;
import org.virbo.datasource.DataSourceUtil;
import org.virbo.datasource.FileSystemUtil;
import org.virbo.datasource.SourceTypesBrowser;
import org.virbo.datasource.URISplit;
import org.virbo.datasource.capability.TimeSeriesBrowse;
import org.virbo.datasource.ui.PromptComboBoxEditor;
import org.virbo.datasource.ui.PromptTextField;
import org.virbo.dsops.Ops;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSetSelector
extends JPanel {
    public static final String PROP_RECENT = "recent";
    private static int MAX_RECENT = 20;
    boolean needToAddKeys = true;
    Runnable completionsRunnable = null;
    ProgressMonitor completionsMonitor = null;
    JPopupMenu completionsPopupMenu = null;
    JTextField editor;
    DataSetSelectorSupport support = new DataSetSelectorSupport(this);
    public static final String PROPERTY_MESSAGE = "message";
    static final Logger logger = Logger.getLogger("virbo.dataset.ui");
    MonitorFactory monitorFactory = null;
    Timer maybePlotTimer;
    int keyModifiers = 0;
    private Action ABOUT_PLUGINS_ACTION = new AbstractAction("About Plugins"){

        public void actionPerformed(ActionEvent e) {
            String about = DataSetSelectorSupport.getPluginsText();
            JOptionPane.showMessageDialog(DataSetSelector.this, about);
        }
    };
    private boolean popupCancelled = false;
    private JButton browseButton;
    private JComboBox dataSetSelector;
    private JButton plotItButton;
    private boolean doItemStateChange = false;
    private String browseTypeExt;
    protected boolean hidePlayButton = false;
    public static final String PROP_HIDEPLAYBUTTON = "hidePlayButton";
    private transient ArrayList actionListenerList;
    private List<String> recent;
    private String message;
    Map<String, Action> actionTriggers = new LinkedHashMap<String, Action>();
    protected boolean plotItButtonVisible = true;
    public static final String PROP_PLOTITBUTTONVISIBLE = "plotItButtonVisible";
    Map<String, Action> browseTriggers = new LinkedHashMap<String, Action>();
    protected boolean enableDataSource = true;
    public static final String PROP_ENABLEDATASOURCE = "enableDataSource";
    private DatumRange timeRange = null;
    public static final String PROP_TIMERANGE = "timeRange";
    protected boolean suggestFsAgg = true;
    public static final String PROP_SUGGESTFSAGG = "suggestFsAgg";
    protected boolean suggestFiles = true;
    public static final String PROP_SUGGESTFILES = "suggestFiles";
    private String acceptPattern = null;
    private String alternatePeer;
    private String alternatePeerCard;
    private boolean expertMode = true;

    public DataSetSelector() {
        this.initComponents();
        this.dataSetSelector.setEditor(new PromptComboBoxEditor("Enter data location"));
        this.editor = (JTextField)this.dataSetSelector.getEditor().getEditorComponent();
        this.dataSetSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataSetSelector.this.keyModifiers = e.getModifiers();
            }
        });
        this.addCompletionKeys();
        this.addAbouts();
        this.maybePlotTimer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                Runnable run = new Runnable(){

                    public void run() {
                        DataSetSelector.this.maybePlotImmediately();
                    }
                };
                RequestProcessor.invokeLater((Runnable)run);
            }
        });
        this.maybePlotTimer.setRepeats(false);
        this.editor.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    DataSetSelector.this.showPopup(e);
                }
            }

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    DataSetSelector.this.showPopup(e);
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    DataSetSelector.this.showPopup(e);
                }
            }
        });
    }

    public JTextField getEditor() {
        return this.editor;
    }

    private ProgressMonitor getMonitor() {
        return this.getMonitor("Please Wait", "unidentified task in progress");
    }

    private ProgressMonitor getMonitor(String label, String desc) {
        if (this.monitorFactory == null) {
            return DasApplication.getDefaultApplication().getMonitorFactory().getMonitor(label, desc);
        }
        return this.monitorFactory.getMonitor(label, desc);
    }

    public void setMonitorFactory(MonitorFactory factory) {
        this.monitorFactory = factory;
    }

    private void showPluginsScreen() {
        StringBuilder msg = new StringBuilder();
        msg.append("<html>Unable to use the address <br><br>").append(this.getValue()).append("<br><br>Qualify the address by adding a supported plugin id (e.g. vap+dat:)<br>").append("or use an address that matches one of these triggers:<br><br>");
        for (String at : this.actionTriggers.keySet()) {
            msg.append(at).append("<br>");
        }
        msg.append("</html>");
        JOptionPane.showMessageDialog(this, msg, "Unrecognized address", 0);
    }

    private void maybePlotImmediately() {
        block25: {
            Pattern accept;
            String surl = this.getValue();
            if (surl.equals("")) {
                logger.finest("empty value, returning");
                return;
            }
            if (surl.startsWith("vap+internal:")) {
                this.firePlotDataSetURL();
                return;
            }
            for (String actionTriggerRegex : this.actionTriggers.keySet()) {
                if (!Pattern.matches(actionTriggerRegex, surl)) continue;
                logger.finest("matches action trigger");
                Action action = this.actionTriggers.get(actionTriggerRegex);
                action.actionPerformed(new ActionEvent(this, 123, "dataSetSelect"));
                return;
            }
            Pattern pattern = accept = this.acceptPattern == null ? null : Pattern.compile(this.acceptPattern);
            if (!this.enableDataSource && (accept == null || accept.matcher(surl).matches())) {
                this.firePlotDataSetURL();
                return;
            }
            String ext = DataSetURI.getExt(surl);
            if (ext != null && ext.equals("vap")) {
                this.firePlotDataSetURL();
                return;
            }
            try {
                if (surl.endsWith("/") || surl.contains("/?") || surl.endsWith(".zip") || surl.contains(".zip?") || surl.endsWith(".ZIP") || surl.contains(".ZIP?")) {
                    int carotpos = this.editor.getCaretPosition();
                    this.setMessage("busy: getting filesystem completions.");
                    this.showCompletions(surl, carotpos);
                    break block25;
                }
                if (surl.endsWith("/..")) {
                    int carotpos = surl.lastIndexOf("/..");
                    if ((carotpos = surl.lastIndexOf("/", carotpos - 1)) != -1) {
                        this.setValue(surl.substring(0, carotpos + 1));
                        this.dataSetSelector.getEditor().setItem(surl.substring(0, carotpos + 1));
                        this.editor.setCaretPosition(carotpos + 1);
                        this.maybePlotImmediately();
                    }
                    break block25;
                }
                try {
                    URI uri = DataSetURI.getURI(surl);
                    if (uri == null) {
                        this.setMessage("URI cannot be formed from \"" + surl + "\"");
                        return;
                    }
                    DataSourceFactory f = DataSetURI.getDataSourceFactory(uri, this.getMonitor());
                    if (f == null) {
                        SourceTypesBrowser browser = new SourceTypesBrowser();
                        browser.getDataSetSelector().setValue(DataSetURI.fromUri(DataSetURI.getResourceURI(surl)));
                        int r = JOptionPane.showConfirmDialog(this, browser, "Select Data Source Type", 2);
                        if (r == 0) {
                            surl = browser.getUri();
                            this.getEditor().setText(surl);
                            this.setValue(surl);
                            this.maybePlot(true);
                            return;
                        }
                        this.showPluginsScreen();
                        return;
                    }
                    this.setMessage("busy: checking to see if uri looks acceptable");
                    String surl1 = surl;
                    ProgressMonitor mon = this.getMonitor();
                    if (f.reject(surl1, mon)) {
                        if (f instanceof AggregatingDataSourceFactory) {
                            AggregatingDataSourceFactory aggf = (AggregatingDataSourceFactory)f;
                            if (this.timeRange != null && UnitsUtil.isTimeLocation((Units)this.timeRange.getUnits())) {
                                try {
                                    String delegateUri = AggregatingDataSourceFactory.getDelegateDataSourceFactoryUri(surl);
                                    DataSourceFactory ddsf = AggregatingDataSourceFactory.getDelegateDataSourceFactory(surl);
                                    if (!ddsf.reject(delegateUri, mon) && !f.reject(surl1 = URISplit.putParam(surl, "timerange", this.timeRange.toString()), mon)) {
                                        this.setMessage("accepted aggregation after setting timerange");
                                        int modifiers = this.keyModifiers;
                                        this.setValue(surl1);
                                        this.keyModifiers = modifiers;
                                        this.firePlotDataSetURL();
                                        return;
                                    }
                                }
                                catch (IllegalArgumentException ex) {
                                    JOptionPane.showMessageDialog(this.plotItButton, ex.getMessage());
                                    this.setMessage(ex.getMessage());
                                    ex.printStackTrace();
                                    return;
                                }
                            }
                        }
                        this.setMessage("busy: uri rejected, inspecting resource for parameters");
                        this.browseSourceType();
                        break block25;
                    }
                    if (mon.isCancelled()) {
                        this.setMessage("download cancelled");
                        return;
                    }
                    this.setMessage("resolving uri to data set as " + DataSourceRegistry.getInstance().getExtensionFor(f));
                    this.firePlotDataSetURL();
                }
                catch (DataSetURI.NonResourceException ex) {
                    int carotpos = surl.length();
                    this.setMessage("no extension or mime type, try filesystem completions");
                    this.showCompletions(surl, carotpos);
                }
                catch (IllegalArgumentException ex) {
                    this.setMessage(ex.getMessage());
                    ex.printStackTrace();
                    this.firePlotDataSetURL();
                }
                catch (URISyntaxException ex) {
                    this.setMessage(ex.getMessage());
                    ex.printStackTrace();
                    this.firePlotDataSetURL();
                }
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
                this.setMessage(ex.getMessage());
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.setMessage(ex.getMessage());
            }
        }
    }

    public void maybePlot(boolean allowModifiers) {
        logger.log(Level.FINE, "go {0}", this.getValue());
        if (!allowModifiers) {
            this.keyModifiers = 0;
        }
        this.maybePlotTimer.restart();
    }

    public void maybePlot(int keyModifiers) {
        this.keyModifiers = keyModifiers;
        if ((keyModifiers & 8) == 8) {
            this.browseSourceType();
        } else {
            this.maybePlot(true);
        }
    }

    private void firePlotDataSetURL() {
        String value;
        ArrayList<String> r = new ArrayList<String>(this.getRecent());
        if (r.contains(value = this.getValue())) {
            r.remove(value);
        }
        r.add(value);
        while (r.size() > MAX_RECENT) {
            r.remove(0);
        }
        ActionEvent e = new ActionEvent(this, 123, "dataSetSelect", this.keyModifiers);
        this.fireActionListenerActionPerformed(e);
    }

    private boolean maybeHandleException(Exception ex) {
        String msg = ex.getMessage();
        if (msg == null) {
            msg = ex.toString();
        }
        if ((msg = msg.trim()) == null) {
            msg = "";
        }
        if (ex instanceof FileNotFoundException && msg.length() == 0) {
            msg = "File not found";
        }
        if ((ex instanceof FileNotFoundException || ex.toString().contains("file not found") || ex.toString().contains("root does not exist")) && msg.length() > 0) {
            if (msg.startsWith("File not found: ")) {
                String[] ss = msg.split(":", 2);
                msg = "<html>" + ss[0] + ":<br>" + ss[1] + "</html>";
            }
            JOptionPane.showMessageDialog(this, msg, "No Such File", 2);
            this.setMessage("" + ex.getMessage());
            return true;
        }
        return false;
    }

    public void browseSourceType() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        String surl = ((String)this.dataSetSelector.getEditor().getItem()).trim();
        boolean wasRejected = false;
        DataSourceEditorPanel edit = null;
        try {
            edit = DataSourceEditorPanelUtil.getDataSourceEditorPanel(DataSetURI.getURIValid(surl));
            if (edit != null && edit.reject(surl)) {
                edit = null;
                wasRejected = true;
            }
            if (edit != null) {
                try {
                    Method m = edit.getClass().getDeclaredMethod("setExpertMode", Boolean.TYPE);
                    m.invoke((Object)edit, this.isExpertMode());
                }
                catch (NoSuchMethodException ex) {}
            }
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(DataSetSelector.class.getName()).log(Level.SEVERE, null, ex);
            edit = null;
        }
        catch (Exception ex) {
            Logger.getLogger(DataSetSelector.class.getName()).log(Level.SEVERE, null, ex);
            edit = null;
        }
        if (edit != null) {
            final Window window = SwingUtilities.getWindowAncestor(this);
            final DataSourceEditorPanel fedit = edit;
            final String fsurl = surl;
            Runnable run = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    DataSourceEditorDialog dialog;
                    String surl = fsurl;
                    if (DataSetSelector.this.timeRange != null && UnitsUtil.isTimeLocation((Units)DataSetSelector.this.timeRange.getUnits())) {
                        try {
                            DataSourceFactory dsf = DataSetURI.getDataSourceFactory(DataSetURI.getURI(surl), (ProgressMonitor)new NullProgressMonitor());
                            TimeSeriesBrowse tsb = dsf.getCapability(TimeSeriesBrowse.class);
                            if (tsb != null && !DataSetSelector.this.timeRange.equals((Object)DatumRangeUtil.parseTimeRangeValid((String)"2010-01-01"))) {
                                tsb.setURI(surl);
                                tsb.setTimeRange(DataSetSelector.this.timeRange);
                                surl = tsb.getURI();
                            }
                        }
                        catch (ParseException ex) {
                            Logger.getLogger(DataSetSelector.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(DataSetSelector.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (IllegalArgumentException ex) {
                            Logger.getLogger(DataSetSelector.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (URISyntaxException ex) {
                            Logger.getLogger(DataSetSelector.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    try {
                        boolean proceed = fedit.prepare(surl, window, DataSetSelector.this.getMonitor("download file", "downloading file to preparing editor"));
                        if (!proceed) {
                            return;
                        }
                    }
                    catch (InterruptedIOException ex) {
                        DataSetSelector.this.setMessage("download cancelled");
                        return;
                    }
                    catch (Exception ex) {
                        if (!DataSetSelector.this.maybeHandleException(ex)) {
                            throw new RuntimeException(ex);
                        }
                        return;
                    }
                    finally {
                        DataSetSelector.this.setCursor(Cursor.getDefaultCursor());
                    }
                    fedit.setURI(surl);
                    String title = "Editing URI " + surl;
                    if (window instanceof Frame) {
                        dialog = new DataSourceEditorDialog((Frame)window, (Component)fedit.getPanel(), true);
                    } else if (window instanceof Dialog) {
                        dialog = new DataSourceEditorDialog((Dialog)window, (Component)fedit.getPanel(), true);
                    } else {
                        throw new RuntimeException("parent windowAncestor type is not supported.");
                    }
                    dialog.setTitle(title);
                    if (DataSetSelector.this.actionListenerList == null || DataSetSelector.this.actionListenerList.isEmpty()) {
                        dialog.setPlayButton(false);
                    } else {
                        dialog.setExpertMode(DataSetSelector.this.isExpertMode());
                    }
                    dialog.setVisible(true);
                    if (!dialog.isCancelled()) {
                        logger.log(Level.FINE, "dataSetSelector.setSelectedItem(\"{0}\");", fedit.getURI());
                        DataSetSelector.this.dataSetSelector.setSelectedItem(fedit.getURI());
                        DataSetSelector.this.keyModifiers = dialog.getModifiers();
                        DataSetSelector.this.maybePlot(true);
                    } else {
                        DataSetSelector.this.setMessage("editor cancelled");
                    }
                }
            };
            Thread thread = new Thread(run);
            thread.start();
        } else {
            int carotpos;
            this.setCursor(Cursor.getDefaultCursor());
            if (!wasRejected) {
                if (!surl.contains("?")) {
                    surl = surl + "?";
                }
                this.setValue(surl);
            }
            carotpos = (carotpos = surl.indexOf("?")) == -1 ? surl.length() : ++carotpos;
            surl = surl.substring(0, carotpos);
            this.showCompletions(surl, carotpos);
        }
    }

    public void showCompletions() {
        JTextField tf = (JTextField)this.dataSetSelector.getEditor().getEditorComponent();
        String surl = tf.getText();
        int carotpos = tf.getCaretPosition();
        this.setMessage("busy: getting completions");
        this.showCompletions(surl, carotpos);
    }

    private static void maybeClearVap(URISplit split) {
        if (split.vapScheme != null && split.vapScheme.equals("vap")) {
            split.vapScheme = null;
            split.formatCarotPos -= 4;
        }
    }

    private void showCompletions(String surl1, int carotpos1) {
        String surl2 = surl1.trim();
        int off = surl1.indexOf(surl2);
        String surl = surl2;
        int carotpos = carotpos1 - off;
        URISplit split = URISplit.parse(surl, carotpos, true);
        boolean shortFsCompletion = carotpos < 6 && (surl.startsWith("/") || surl.length() > 1 && Character.isLetter(surl.charAt(0)) && surl.charAt(1) == ':');
        boolean haveSource = DataSourceRegistry.getInstance().hasSourceByExt(DataSetURI.getExt(surl));
        if ((split.file == null || split.resourceUriCarotPos > split.file.length()) && haveSource) {
            this.showFactoryCompletions(surl, carotpos);
        } else if (carotpos == 0 || !surl.substring(0, carotpos).contains(":") && (carotpos < 4 && surl.substring(0, carotpos).equals("vap".substring(0, carotpos)) || surl.length() > 3 && surl.substring(0, 3).equals("vap"))) {
            this.showTypesCompletions(surl, carotpos);
        } else if (carotpos < 6 && !shortFsCompletion) {
            String[] types = new String[]{"ftp://", "http://", "https://", "file:/", "sftp://"};
            ArrayList<DataSetURI.CompletionResult> result = new ArrayList<DataSetURI.CompletionResult>();
            for (int i = 0; i < types.length; ++i) {
                if (types[i].length() < carotpos || !surl.substring(0, carotpos).equals(types[i].substring(0, carotpos))) continue;
                result.add(new DataSetURI.CompletionResult(types[i], ""));
            }
            this.showCompletionsGui("", result);
        } else if (surl.startsWith("vap") && surl.substring(0, carotpos).split("\\:", -2).length == 2) {
            String[] types = new String[]{"ftp://", "http://", "https://", "file:/", "sftp://"};
            String[] sp = surl.substring(0, carotpos).split("\\:", -2);
            String test = sp[1];
            int testCarotpos = carotpos - (sp[0].length() + 1);
            ArrayList<DataSetURI.CompletionResult> result = new ArrayList<DataSetURI.CompletionResult>();
            for (int i = 0; i < types.length; ++i) {
                if (types[i].length() < testCarotpos || !test.substring(0, testCarotpos).equals(types[i].substring(0, testCarotpos))) continue;
                result.add(new DataSetURI.CompletionResult(sp[0] + ":" + types[i], ""));
            }
            this.showCompletionsGui("", result);
        } else {
            int firstSlashAfterHost;
            if (split.scheme != null && split.scheme.equals("file")) {
                if (!surl.startsWith("vap")) {
                    DataSetSelector.maybeClearVap(split);
                }
                this.showFileSystemCompletions(URISplit.format(split), split.formatCarotPos);
                return;
            }
            if (!this.enableDataSource) {
                split.formatCarotPos = split.formatCarotPos - (split.vapScheme == null ? 0 : split.vapScheme.length() - 1);
                split.vapScheme = null;
            }
            int n = firstSlashAfterHost = split.authority == null ? 0 : split.authority.length();
            if (split.resourceUriCarotPos <= firstSlashAfterHost) {
                if (!surl.startsWith("vap")) {
                    DataSetSelector.maybeClearVap(split);
                }
                String doHost = URISplit.format(split);
                this.showHostCompletions(doHost, split.formatCarotPos);
            } else {
                if (!surl.startsWith("vap")) {
                    DataSetSelector.maybeClearVap(split);
                }
                this.showFileSystemCompletions(URISplit.format(split), split.formatCarotPos);
            }
        }
    }

    private void calcAndShowCompletions(Runnable run) {
        if (this.completionsRunnable != null) {
            this.completionsMonitor.cancel();
            this.completionsRunnable = null;
        }
        this.completionsMonitor = this.getMonitor();
        this.completionsMonitor.setLabel("getting completions");
        this.completionsRunnable = run;
        new Thread(this.completionsRunnable, "completionsThread").start();
    }

    private void showCompletionsGui(final String labelPrefix, List<DataSetURI.CompletionResult> completions) {
        CompletionsList.CompletionListListener listener = new CompletionsList.CompletionListListener(){

            public void itemSelected(DataSetURI.CompletionResult s1) {
                DataSetSelector.this.setValue(s1.completion);
                if (s1.maybePlot) {
                    DataSetSelector.this.maybePlot(true);
                }
            }
        };
        this.completionsPopupMenu = CompletionsList.fillPopupNew(completions, labelPrefix, new JPopupMenu(), listener);
        this.setMessage("done getting completions");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    int xpos2 = DataSetSelector.this.editor.getGraphics().getFontMetrics().stringWidth(labelPrefix);
                    BoundedRangeModel model = DataSetSelector.this.editor.getHorizontalVisibility();
                    int xpos = xpos2 - model.getValue();
                    xpos = Math.min(model.getExtent(), xpos);
                    if (DataSetSelector.this.dataSetSelector.isShowing()) {
                        DataSetSelector.this.completionsPopupMenu.show(DataSetSelector.this.dataSetSelector, xpos, DataSetSelector.this.dataSetSelector.getHeight());
                    } else {
                        JOptionPane.showMessageDialog(DataSetSelector.this.dataSetSelector, "<html>Completions for " + DataSetSelector.this.getValue() + "<br>are not available when the data set selector is not showing.</html>");
                    }
                    DataSetSelector.this.completionsRunnable = null;
                }
                catch (NullPointerException ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    private void showTypesCompletions(final String surl, final int carotpos) {
        this.calcAndShowCompletions(new Runnable(){

            public void run() {
                String labelPrefix = "";
                try {
                    List<DataSetURI.CompletionResult> completions = DataSetURI.getTypesCompletions(surl, carotpos, DataSetSelector.this.getMonitor());
                    DataSetSelector.this.showCompletionsGui(labelPrefix, completions);
                }
                catch (Exception ex) {
                    Logger.getLogger(DataSetSelector.class.getName()).log(Level.SEVERE, null, ex);
                    JOptionPane.showMessageDialog(DataSetSelector.this, "<html>URI Syntax Exception occurred:<br>" + ex.getLocalizedMessage() + "</html>", "I/O Exception", 2);
                    return;
                }
            }
        });
    }

    private void showHostCompletions(final String surl, final int carotpos) {
        this.calcAndShowCompletions(new Runnable(){

            public void run() {
                ProgressMonitor mon = DataSetSelector.this.getMonitor();
                List<DataSetURI.CompletionResult> completions = null;
                URISplit split = URISplit.parse(surl);
                String surlDir = split.path;
                boolean hasScheme = split.scheme != null;
                String labelPrefix = surlDir == null ? "" : surlDir;
                try {
                    completions = DataSetURI.getHostCompletions(surl, carotpos, mon);
                }
                catch (IOException ex) {
                    DataSetSelector.this.setMessage(ex.toString());
                    JOptionPane.showMessageDialog(DataSetSelector.this, "<html>I/O Exception occurred:<br>" + ex.getLocalizedMessage() + "</html>", "I/O Exception", 2);
                    return;
                }
                String doHost = surl.substring(0, carotpos);
                if (hasScheme && (doHost.endsWith(".gov") || doHost.endsWith(".edu") || doHost.endsWith(".com") || doHost.endsWith(".net"))) {
                    DataSetURI.CompletionResult extra = new DataSetURI.CompletionResult(doHost + "/", "explore this host");
                    boolean haveIt = false;
                    for (int i = 0; i < completions.size(); ++i) {
                        if (!completions.get((int)i).completion.equals(extra.completion)) continue;
                        haveIt = true;
                    }
                    if (!haveIt) {
                        completions.add(extra);
                    }
                }
                DataSetSelector.this.showCompletionsGui(labelPrefix, completions);
            }
        });
    }

    public void showFileSystemCompletions(final boolean suggestFsAgg, final boolean suggestFiles, final String acceptRegex) {
        final String surl = this.editor.getText();
        final int carotpos = this.editor.getCaretPosition();
        this.calcAndShowCompletions(new Runnable(){

            public void run() {
                ProgressMonitor mon = DataSetSelector.this.getMonitor();
                List<DataSetURI.CompletionResult> completions = null;
                String labelPrefix = surl.substring(0, carotpos);
                try {
                    completions = DataSetURI.getFileSystemCompletions(surl, carotpos, suggestFsAgg, suggestFiles, acceptRegex, mon);
                }
                catch (UnknownHostException ex) {
                    ex.printStackTrace();
                    DataSetSelector.this.setMessage("Unknown host: " + ex.getLocalizedMessage());
                    JOptionPane.showMessageDialog(DataSetSelector.this, "<html>Unknown host:<br>" + ex.getLocalizedMessage() + "</html>", "Unknown Host Exception", 2);
                    return;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    DataSetSelector.this.setMessage(ex.toString());
                    JOptionPane.showMessageDialog(DataSetSelector.this, "<html>I/O Exception occurred:<br>" + ex.getLocalizedMessage() + "</html>", "I/O Exception", 2);
                    return;
                }
                catch (URISyntaxException ex) {
                    ex.printStackTrace();
                    DataSetSelector.this.setMessage(ex.toString());
                    JOptionPane.showMessageDialog(DataSetSelector.this, "<html>URI Syntax Exception occurred:<br>" + ex.getLocalizedMessage() + "</html>", "I/O Exception", 2);
                    return;
                }
                int i2 = labelPrefix.lastIndexOf("/");
                if (i2 != -1) {
                    labelPrefix = labelPrefix.substring(0, i2 + 1);
                }
                DataSetSelector.this.showCompletionsGui(labelPrefix, completions);
            }
        });
    }

    private void showFileSystemCompletions(final String surl, final int carotpos) {
        this.calcAndShowCompletions(new Runnable(){

            public void run() {
                ProgressMonitor mon = DataSetSelector.this.getMonitor();
                List<DataSetURI.CompletionResult> completions = null;
                String labelPrefix = surl.substring(0, carotpos);
                String surll = surl;
                int carotposl = carotpos;
                try {
                    String atrigger = DataSetSelector.this.checkActionTrigger(surl);
                    if (atrigger != null) {
                        surll = surl.substring(atrigger.length() + 1);
                        carotposl = carotposl - atrigger.length() - 1;
                        completions = DataSetURI.getFileSystemCompletions(surll, carotposl, DataSetSelector.this.suggestFsAgg, DataSetSelector.this.suggestFiles, DataSetSelector.this.acceptPattern, mon);
                        for (int i = 0; i < completions.size(); ++i) {
                            completions.get((int)i).completable = atrigger + ":" + completions.get((int)i).completable;
                            completions.get((int)i).completion = atrigger + ":" + completions.get((int)i).completion;
                            completions.get((int)i).maybePlot = false;
                        }
                    } else {
                        completions = DataSetURI.getFileSystemCompletions(surll, carotposl, DataSetSelector.this.suggestFsAgg, DataSetSelector.this.suggestFiles, DataSetSelector.this.acceptPattern, mon);
                    }
                }
                catch (UnknownHostException ex) {
                    ex.printStackTrace();
                    DataSetSelector.this.setMessage("Unknown host: " + ex.getLocalizedMessage());
                    JOptionPane.showMessageDialog(DataSetSelector.this, "<html>Unknown host:<br>" + ex.getLocalizedMessage() + "</html>", "Unknown Host Exception", 2);
                    return;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    DataSetSelector.this.setMessage(ex.toString());
                    JOptionPane.showMessageDialog(DataSetSelector.this, "<html>I/O Exception occurred:<br>" + ex.getLocalizedMessage() + "</html>", "I/O Exception", 2);
                    return;
                }
                catch (URISyntaxException ex) {
                    ex.printStackTrace();
                    DataSetSelector.this.setMessage(ex.toString());
                    JOptionPane.showMessageDialog(DataSetSelector.this, "<html>URI Syntax Exception occurred:<br>" + ex.getLocalizedMessage() + "</html>", "I/O Exception", 2);
                    return;
                }
                int i2 = labelPrefix.lastIndexOf("/");
                if (i2 != -1) {
                    labelPrefix = labelPrefix.substring(0, i2 + 1);
                }
                DataSetSelector.this.showCompletionsGui(labelPrefix, completions);
            }
        });
    }

    private void showFactoryCompletions(final String surl, final int carotpos) {
        this.calcAndShowCompletions(new Runnable(){

            public void run() {
                String labelPrefix;
                List<DataSetURI.CompletionResult> completions2;
                try {
                    completions2 = DataSetURI.getFactoryCompletions(surl, carotpos, DataSetSelector.this.completionsMonitor);
                    DataSetSelector.this.setMessage("done getting completions");
                }
                catch (Exception ex) {
                    if (!DataSetSelector.this.maybeHandleException(ex)) {
                        ex.printStackTrace();
                        DataSetSelector.this.setMessage("" + ex.getClass().getName() + " " + ex.getMessage());
                    }
                    return;
                }
                int n = Math.min(carotpos, DataSetSelector.this.editor.getText().length());
                try {
                    labelPrefix = DataSetSelector.this.editor.getText(0, n);
                }
                catch (BadLocationException ex) {
                    throw new RuntimeException(ex);
                }
                DataSetSelector.this.showCompletionsGui(labelPrefix, completions2);
            }
        });
    }

    public final void addCompletionKeys() {
        ActionMap map = this.dataSetSelector.getActionMap();
        map.put("complete", new AbstractAction("completionsPopup"){

            public void actionPerformed(ActionEvent ev) {
                String context = (String)DataSetSelector.this.dataSetSelector.getEditor().getItem();
                if (context == null) {
                    context = "";
                }
                for (String browseTriggerRegex : DataSetSelector.this.browseTriggers.keySet()) {
                    if (!Pattern.matches(browseTriggerRegex, context)) continue;
                    logger.finest("matches browse trigger");
                    Action action = DataSetSelector.this.browseTriggers.get(browseTriggerRegex);
                    action.actionPerformed(new ActionEvent(DataSetSelector.this, 123, "dataSetSelect"));
                    return;
                }
                DataSetSelector.this.showCompletions();
            }
        });
        map.put("plot", new AbstractAction("plotUrl"){

            public void actionPerformed(ActionEvent ev) {
                DataSetSelector.this.setValue(DataSetSelector.this.getEditor().getText());
                DataSetSelector.this.keyModifiers = ev.getModifiers();
                DataSetSelector.this.maybePlot(true);
            }
        });
        this.dataSetSelector.setActionMap(map);
        final JTextField tf = (JTextField)this.dataSetSelector.getEditor().getEditorComponent();
        tf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataSetSelector.this.dataSetSelector.setSelectedItem(tf.getText());
                DataSetSelector.this.keyModifiers = e.getModifiers();
                DataSetSelector.this.maybePlot(true);
            }
        });
        Set trav = Collections.emptySet();
        this.setFocusTraversalKeys(0, trav);
        this.setFocusTraversalKeys(1, trav);
        InputMap imap = SwingUtilities.getUIInputMap(this.dataSetSelector, 1);
        imap.put(KeyStroke.getKeyStroke(32, 2), "complete");
        imap.put(KeyStroke.getKeyStroke(9, 0), "complete");
        imap.put(KeyStroke.getKeyStroke(10, 2), "plot");
        imap.put(KeyStroke.getKeyStroke(10, 1), "plot");
        this.needToAddKeys = false;
    }

    public final void addAbouts() {
        String regex = "about:(.*)";
        this.registerActionTrigger("about:(.*)", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                String ss = DataSetSelector.this.getValue();
                Pattern p = Pattern.compile("about:(.*)");
                Matcher m = p.matcher(ss);
                if (!m.matches()) {
                    throw new IllegalArgumentException("huh?");
                }
                String arg = m.group(1);
                if (arg.equals("plugins")) {
                    DataSetSelector.this.ABOUT_PLUGINS_ACTION.actionPerformed(e);
                }
            }
        });
    }

    private String checkActionTrigger(String surl) {
        for (String s : this.actionTriggers.keySet()) {
            String tr;
            int i;
            if (!surl.matches(s) || (i = s.indexOf(":")) <= -1 || !Ops.safeName((String)(tr = s.substring(0, i))).equals(tr)) continue;
            return tr;
        }
        return null;
    }

    private void initComponents() {
        this.browseButton = new JButton();
        this.plotItButton = new JButton();
        this.dataSetSelector = new JComboBox();
        this.browseButton.setIcon(new ImageIcon(this.getClass().getResource("/org/virbo/datasource/fileMag.png")));
        this.browseButton.setToolTipText("<html>Inspect this resource.<br>\nFor folder names, this enters the file system browser, or shows a list of remote folders.<br>\nFor files, this will enter an editor panel for the resource, or show a list of parameter options.<br>\n</html>\n\n");
        this.browseButton.setMargin(new Insets(2, 2, 2, 2));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataSetSelector.this.browseButtonActionPerformed(evt);
            }
        });
        this.plotItButton.setIcon(new ImageIcon(this.getClass().getResource("/org/virbo/datasource/go.png")));
        this.plotItButton.setToolTipText("<html>Plot this data location, or URI.<br>\nCtrl modifier: plot the dataset by adding a new plot<br>\nShift modifier: plot the dataset as an overplot<br>\n");
        this.plotItButton.setMaximumSize(new Dimension(20, 20));
        this.plotItButton.setMinimumSize(new Dimension(20, 20));
        this.plotItButton.setPreferredSize(new Dimension(20, 20));
        this.plotItButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataSetSelector.this.plotItButtonActionPerformed(evt);
            }
        });
        this.dataSetSelector.setEditable(true);
        this.dataSetSelector.setModel(new DefaultComboBoxModel<String>(new String[]{"(application will put recent items here)"}));
        this.dataSetSelector.setToolTipText("Enter data source address");
        this.dataSetSelector.setMinimumSize(new Dimension(20, 20));
        this.dataSetSelector.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DataSetSelector.this.dataSetSelectorMouseClicked(evt);
            }
        });
        this.dataSetSelector.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent evt) {
                DataSetSelector.this.dataSetSelectorPopupMenuCanceled(evt);
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                DataSetSelector.this.dataSetSelectorPopupMenuWillBecomeInvisible(evt);
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }
        });
        this.dataSetSelector.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                DataSetSelector.this.dataSetSelectorItemStateChanged(evt);
            }
        });
        this.dataSetSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataSetSelector.this.dataSetSelectorActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.dataSetSelector, 0, 320, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.plotItButton, -2, 26, -2).addPreferredGap(0).add((Component)this.browseButton, -2, 20, -2)));
        layout.linkSize(new Component[]{this.browseButton, this.plotItButton}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.plotItButton, -2, -1, -2).add((Component)this.browseButton, -2, 19, -2)).add((Component)this.dataSetSelector, -2, -1, -2)).addContainerGap()));
        layout.linkSize(new Component[]{this.browseButton, this.dataSetSelector, this.plotItButton}, 2);
        this.browseButton.getAccessibleContext().setAccessibleDescription("inspect contents of file or directory");
    }

    private void dataSetSelectorActionPerformed(ActionEvent evt) {
    }

    private void plotItButtonActionPerformed(ActionEvent evt) {
        this.keyModifiers = evt.getModifiers();
        this.setValue(this.getEditor().getText());
        this.maybePlot(true);
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        block19: {
            String context = (String)this.dataSetSelector.getSelectedItem();
            if (context == null) {
                context = "";
            }
            String ext = context == null ? "" : DataSetURI.getExt(context);
            final String fcontext = context;
            for (String browseTriggerRegex : this.browseTriggers.keySet()) {
                if (!Pattern.matches(browseTriggerRegex, context)) continue;
                logger.finest("matches browse trigger");
                Action action = this.browseTriggers.get(browseTriggerRegex);
                action.actionPerformed(new ActionEvent(this, 123, "dataSetSelect"));
                return;
            }
            if (context.trim().length() == 0) {
                context = "file:///";
            }
            if (this.enableDataSource && (context.trim().length() == 0 || context.trim().equals("vap+"))) {
                this.showCompletions();
            } else if (this.enableDataSource && (!context.contains("/?") && context.contains("?") || DataSourceRegistry.getInstance().hasSourceByExt(ext))) {
                this.browseSourceType();
            } else {
                final URISplit split = URISplit.parse(context);
                if (split.scheme != null && (split.scheme.equals("file") || split.scheme.equals("http") || split.scheme.equals("https") || split.scheme.equals("ftp") || split.scheme.equals("sftp"))) {
                    try {
                        if (FileSystemUtil.resourceExists(context) && FileSystemUtil.resourceIsFile(context)) {
                            if (!FileSystemUtil.resourceIsLocal(context)) {
                                Runnable run = new Runnable(){

                                    public void run() {
                                        DasProgressPanel mon = DasProgressPanel.createFramed((Window)SwingUtilities.getWindowAncestor(DataSetSelector.this), (String)("downloading " + split.file.substring(split.path.length())));
                                        try {
                                            FileSystemUtil.doDownload(fcontext, (ProgressMonitor)mon);
                                        }
                                        catch (Exception ex) {
                                            FileSystem.getExceptionHandler().handle((Throwable)ex);
                                        }
                                        DataSetSelector.this.browseSourceType();
                                    }
                                };
                                RequestProcessor.invokeLater((Runnable)run);
                            } else {
                                this.browseSourceType();
                            }
                            break block19;
                        }
                        if (split.scheme.equals("file")) {
                            JFileChooser chooser = new JFileChooser(new File(DataSetURI.toUri(split.path)));
                            chooser.setMultiSelectionEnabled(true);
                            int result = chooser.showOpenDialog(this);
                            if (result == 0) {
                                File[] ff = chooser.getSelectedFiles();
                                File f = chooser.getSelectedFile();
                                String suri = DataSetURI.newUri(context, f.toString());
                                if (ff.length > 1) {
                                    String asuri;
                                    String[] suris = new String[ff.length];
                                    for (int i = 0; i < suris.length; ++i) {
                                        suris[i] = DataSetURI.newUri(context, ff[i].toString());
                                    }
                                    suri = asuri = DataSourceUtil.makeAggregation(suri, suris);
                                }
                                this.setValue(suri);
                                this.maybePlot(false);
                            }
                            break block19;
                        }
                        this.showCompletions();
                    }
                    catch (IOException ex) {
                        FileSystem.getExceptionHandler().handle((Throwable)ex);
                    }
                    catch (URISyntaxException ex) {
                        FileSystem.getExceptionHandler().handle((Throwable)ex);
                    }
                } else {
                    this.showCompletions();
                }
            }
        }
    }

    private void dataSetSelectorItemStateChanged(ItemEvent evt) {
        if (this.doItemStateChange && evt.getStateChange() == 1) {
            this.maybePlot(false);
        }
    }

    private void dataSetSelectorPopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        if (!this.popupCancelled) {
            if ((this.keyModifiers & 8) == 8) {
                this.browseSourceType();
            } else {
                this.maybePlot(true);
            }
        }
        this.popupCancelled = false;
    }

    private void dataSetSelectorMouseClicked(MouseEvent evt) {
    }

    private void dataSetSelectorPopupMenuCanceled(PopupMenuEvent evt) {
        this.popupCancelled = true;
    }

    public String getValue() {
        String val = (String)this.dataSetSelector.getSelectedItem();
        if (val == null) {
            return "";
        }
        return val.trim();
    }

    public void setValue(String value) {
        if (value == null) {
            value = "";
        }
        this.doItemStateChange = false;
        this.dataSetSelector.setSelectedItem(value);
        this.dataSetSelector.repaint();
        this.editor.setText(value);
    }

    public String getBrowseTypeExt() {
        return this.browseTypeExt;
    }

    public void setBrowseTypeExt(String browseTypeExt) {
        String oldBrowseTypeExt = this.browseTypeExt;
        this.browseTypeExt = browseTypeExt;
        this.firePropertyChange("browseTypeExt", oldBrowseTypeExt, browseTypeExt);
    }

    public boolean isHidePlayButton() {
        return this.hidePlayButton;
    }

    public void setHidePlayButton(boolean hidePlayButton) {
        boolean oldHidePlayButton = this.hidePlayButton;
        this.hidePlayButton = hidePlayButton;
        this.plotItButton.setVisible(!hidePlayButton);
        this.firePropertyChange(PROP_HIDEPLAYBUTTON, oldHidePlayButton, hidePlayButton);
    }

    public synchronized void addActionListener(ActionListener listener) {
        if (this.actionListenerList == null) {
            this.actionListenerList = new ArrayList();
        }
        this.actionListenerList.add(listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        if (this.actionListenerList != null) {
            this.actionListenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionListenerActionPerformed(ActionEvent event) {
        ArrayList list;
        DataSetSelector dataSetSelector = this;
        synchronized (dataSetSelector) {
            if (this.actionListenerList == null) {
                return;
            }
            list = (ArrayList)this.actionListenerList.clone();
        }
        for (int i = 0; i < list.size(); ++i) {
            ((ActionListener)list.get(i)).actionPerformed(event);
        }
    }

    public List<String> getRecent() {
        if (this.recent == null) {
            this.recent = new ArrayList<String>();
        }
        return this.recent;
    }

    public void setRecent(List<String> recent) {
        List<String> oldRecent = this.recent;
        this.recent = recent;
        String value = this.editor.getText();
        ArrayList<String> r = new ArrayList<String>(recent);
        Collections.reverse(r);
        this.dataSetSelector.setModel(new DefaultComboBoxModel<Object>(r.toArray()));
        this.editor.setText(value);
        this.support.refreshRecentFilesMenu();
        this.firePropertyChange(PROP_RECENT, oldRecent, recent);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        String oldMessage = this.message;
        this.message = message;
        this.firePropertyChange(PROPERTY_MESSAGE, oldMessage, message);
    }

    public boolean isPlotItButtonVisible() {
        return this.plotItButtonVisible;
    }

    public void setPlotItButtonVisible(boolean plotItButtonVisible) {
        boolean oldPlotItButtonVisible = this.plotItButtonVisible;
        this.plotItButtonVisible = plotItButtonVisible;
        this.plotItButton.setVisible(plotItButtonVisible);
        this.firePropertyChange(PROP_PLOTITBUTTONVISIBLE, oldPlotItButtonVisible, plotItButtonVisible);
    }

    public void registerActionTrigger(String regex, Action action) {
        this.actionTriggers.put(regex, action);
    }

    public void registerBrowseTrigger(String regex, Action action) {
        this.browseTriggers.put(regex, action);
    }

    public Action getOpenLocalAction() {
        return this.support.openLocalAction();
    }

    public Action getOpenLocalVapAction() {
        return this.support.openLocalVapAction();
    }

    public JMenu getRecentMenu() {
        return this.support.recentMenu();
    }

    public void setDisableDataSources(boolean b) {
        this.enableDataSource = !b;
    }

    public boolean isEnableDataSource() {
        return this.enableDataSource;
    }

    public void setEnableDataSource(boolean enableDataSource) {
        boolean oldEnableDataSource = this.enableDataSource;
        this.enableDataSource = enableDataSource;
        this.firePropertyChange(PROP_ENABLEDATASOURCE, oldEnableDataSource, enableDataSource);
    }

    public DatumRange getTimeRange() {
        return this.timeRange;
    }

    public void setTimeRange(DatumRange timerange) {
        DatumRange oldRange = this.timeRange;
        this.timeRange = timerange;
        this.firePropertyChange(PROP_TIMERANGE, oldRange, timerange);
    }

    public boolean isSuggestFsAgg() {
        return this.suggestFsAgg;
    }

    public void setSuggestFsAgg(boolean suggestFsAgg) {
        boolean oldSuggestFsAgg = this.suggestFsAgg;
        this.suggestFsAgg = suggestFsAgg;
        this.firePropertyChange(PROP_SUGGESTFSAGG, oldSuggestFsAgg, suggestFsAgg);
    }

    public boolean isSuggestFiles() {
        return this.suggestFiles;
    }

    public void setSuggestFiles(boolean suggestFiles) {
        boolean oldSuggestFiles = this.suggestFiles;
        this.suggestFiles = suggestFiles;
        this.firePropertyChange(PROP_SUGGESTFILES, oldSuggestFiles, suggestFiles);
    }

    public String getAcceptPattern() {
        return this.acceptPattern;
    }

    public void setAcceptPattern(String acceptPattern) {
        this.acceptPattern = acceptPattern;
    }

    public void setPromptText(String text) {
        if (text == null) {
            throw new NullPointerException("Prompt text can't be null; use empty string instead.");
        }
        ((PromptTextField)this.getEditor()).setPromptText(text);
    }

    public String getPromptText() {
        return ((PromptTextField)this.getEditor()).getPromptText();
    }

    private void showPopup(MouseEvent e) {
        this.getPopupMenu().show(this.editor, e.getX(), e.getY());
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu result = new JPopupMenu();
        JMenuItem cutItem = result.add(new DefaultEditorKit.CutAction());
        cutItem.setText("Cut");
        JMenuItem copyItem = result.add(new DefaultEditorKit.CopyAction());
        copyItem.setText("Copy");
        JMenuItem pasteItem = result.add(new DefaultEditorKit.PasteAction());
        pasteItem.setText("Paste");
        result.add(new JSeparator());
        JMenu fontMenu = new JMenu("Font Size");
        fontMenu.add(new AbstractAction("Big"){

            public void actionPerformed(ActionEvent ev) {
                Font f = DataSetSelector.this.getEditor().getFont();
                int size = 16;
                if (size > 4 && size < 18) {
                    Font nf = f.deriveFont((float)size);
                    DataSetSelector.this.dataSetSelector.setFont(nf);
                }
            }
        });
        fontMenu.add(new AbstractAction("Normal"){

            public void actionPerformed(ActionEvent ev) {
                Font f = DataSetSelector.this.getEditor().getFont();
                int size = DataSetSelector.this.getParent().getFont().getSize();
                if (size > 4 && size < 18) {
                    Font nf = f.deriveFont((float)size);
                    DataSetSelector.this.dataSetSelector.setFont(nf);
                }
            }
        });
        fontMenu.add(new AbstractAction("Small"){

            public void actionPerformed(ActionEvent ev) {
                Font f = DataSetSelector.this.getEditor().getFont();
                int size = 8;
                if (size > 4 && size < 18) {
                    Font nf = f.deriveFont((float)size);
                    DataSetSelector.this.dataSetSelector.setFont(nf);
                }
            }
        });
        result.add(fontMenu);
        if (this.alternatePeerCard != null) {
            result.add(new JSeparator());
            result.add(new AbstractAction(this.alternatePeer){

                public void actionPerformed(ActionEvent ev) {
                    Container trp = DataSetSelector.this.getParent();
                    ((CardLayout)DataSetSelector.this.getParent().getLayout()).show(trp, DataSetSelector.this.alternatePeerCard);
                }
            });
        }
        return result;
    }

    public static void main(String[] args) {
        DataSetSelectorDemo.main(args);
    }

    public void setAlternatePeer(String title, String card) {
        this.alternatePeer = title;
        this.alternatePeerCard = card;
    }

    private boolean isExpertMode() {
        return this.expertMode;
    }

    public void setExpertMode(boolean expert) {
        this.expertMode = expert;
        if (expert) {
            this.plotItButton.setToolTipText("<html>Plot this data location, or URI.<br> Ctrl modifier: plot the dataset by adding a new plot<br> Shift modifier: plot the dataset as an overplot<br> ");
        } else {
            this.plotItButton.setToolTipText("<html>Plot this data location, or URI.<br> ");
        }
    }
}

