/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.datasource;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.filechooser.FileFilter;
import org.virbo.datasource.AutoplotSettings;
import org.virbo.datasource.DataSetSelector;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSourceRegistry;

public class DataSetSelectorSupport {
    DataSetSelector ui;
    public static final String PREF_LAST_OPEN_FOLDER = "last_open_folder";
    public static final String PREF_RECENTLY_OPENED_FILES = "recently_opened_files";
    public static final String PREF_LAST_OPEN_VAP_FOLDER = "last_open_vap_folder";
    public static final String PREF_LAST_OPEN_VAP_FILE = "last_open_vap_file";
    private JMenu recentMenu = null;

    DataSetSelectorSupport(DataSetSelector ui) {
        this.ui = ui;
    }

    private static File userHome() {
        return new File(System.getProperty("user.home"));
    }

    public static String browseLocalVap(Component parent) {
        Preferences prefs = Preferences.userNodeForPackage(AutoplotSettings.class);
        String currentDirectory = prefs.get(PREF_LAST_OPEN_VAP_FOLDER, prefs.get(PREF_LAST_OPEN_FOLDER, DataSetSelectorSupport.userHome().toString()));
        String currentFile = prefs.get(PREF_LAST_OPEN_VAP_FILE, "");
        JFileChooser chooser = new JFileChooser(currentDirectory);
        if (currentFile.length() > 0) {
            chooser.setSelectedFile(new File(currentFile));
        }
        FileFilter ff = new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String t = f.toString();
                if (t == null) {
                    System.err.println("here is that bad state on windows.  bug http://sourceforge.net/tracker/?func=detail&aid=3038977&group_id=199733&atid=970682");
                    t = "" + f;
                    return false;
                }
                return t.endsWith(".vap");
            }

            public String getDescription() {
                return ".vap files";
            }
        };
        chooser.addChoosableFileFilter(ff);
        FileFilter select = ff;
        chooser.setFileFilter(select);
        int result = chooser.showOpenDialog(parent);
        if (result == 0) {
            prefs.put(PREF_LAST_OPEN_VAP_FOLDER, chooser.getSelectedFile().getParent());
            return chooser.getSelectedFile().toURI().toString();
        }
        return null;
    }

    public static String browseLocal(Component parent) {
        Preferences prefs = Preferences.userNodeForPackage(DataSetSelectorSupport.class);
        String currentDirectory = prefs.get(PREF_LAST_OPEN_FOLDER, DataSetSelectorSupport.userHome().toString());
        final HashMap<String, Object> exts = DataSourceRegistry.getInstance().dataSourcesByExt;
        JFileChooser chooser = new JFileChooser(currentDirectory);
        FileFilter ff = new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String t = f.toString();
                if (t == null) {
                    System.err.println("here is that bad state on windows.  bug http://sourceforge.net/tracker/?func=detail&aid=3038977&group_id=199733&atid=970682");
                    t = "" + f;
                    return false;
                }
                String ext = DataSetURI.getExt(t);
                if (ext != null) {
                    ext = "." + ext;
                }
                return t.endsWith(".zip") || t.endsWith(".ZIP") || ext != null && exts.containsKey(ext);
            }

            public String getDescription() {
                return "supported formats";
            }
        };
        chooser.addChoosableFileFilter(ff);
        FileFilter select = ff;
        Iterator<String> i$ = exts.keySet().iterator();
        while (i$.hasNext()) {
            String ext1;
            final String extf = ext1 = i$.next();
            ff = new FileFilter(){

                public boolean accept(File f) {
                    if (f.toString() == null) {
                        return false;
                    }
                    if (f.isDirectory()) {
                        return true;
                    }
                    String t = f.toString();
                    String ext = DataSetURI.getExt(t);
                    if (ext != null) {
                        ext = "." + ext;
                    }
                    return ext != null && extf.equals(ext);
                }

                public String getDescription() {
                    return "*" + extf;
                }
            };
            chooser.addChoosableFileFilter(ff);
        }
        chooser.setFileFilter(select);
        int result = chooser.showOpenDialog(parent);
        if (result == 0) {
            prefs.put(PREF_LAST_OPEN_FOLDER, chooser.getSelectedFile().getParent());
            return chooser.getSelectedFile().toURI().toString();
        }
        return null;
    }

    public Action openLocalAction() {
        return new AbstractAction("Open Data File..."){

            public void actionPerformed(ActionEvent e) {
                String result = DataSetSelectorSupport.browseLocal(DataSetSelectorSupport.this.ui);
                if (result != null) {
                    DataSetSelectorSupport.this.ui.setValue(result);
                    DataSetSelectorSupport.this.ui.maybePlot(false);
                }
            }
        };
    }

    public Action openLocalVapAction() {
        return new AbstractAction("Open .vap File..."){

            public void actionPerformed(ActionEvent e) {
                String result = DataSetSelectorSupport.browseLocalVap(DataSetSelectorSupport.this.ui);
                if (result != null) {
                    DataSetSelectorSupport.this.ui.setValue(result);
                    DataSetSelectorSupport.this.ui.maybePlot(false);
                }
            }
        };
    }

    protected void refreshRecentFilesMenu() {
        if (this.recentMenu != null) {
            this.recentMenu.removeAll();
            if (this.ui.getRecent() == null) {
                return;
            }
            ArrayList<String> recent = new ArrayList<String>(this.ui.getRecent());
            Collections.reverse(recent);
            Iterator<String> i$ = recent.iterator();
            while (i$.hasNext()) {
                String s;
                final String f = s = i$.next();
                AbstractAction a = new AbstractAction(String.valueOf(f)){

                    public void actionPerformed(ActionEvent e) {
                        DataSetSelectorSupport.this.ui.setValue(f);
                        DataSetSelectorSupport.this.ui.maybePlot(false);
                    }
                };
                this.recentMenu.add(a);
            }
        }
    }

    public static String getPluginsText() {
        return DataSourceRegistry.getPluginsText();
    }

    JMenu recentMenu() {
        if (this.recentMenu == null) {
            this.recentMenu = new JMenu("Open Recent");
            this.refreshRecentFilesMenu();
        }
        return this.recentMenu;
    }

    protected void browseSourceTypes() {
    }
}

