/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.datasource;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.URISplit;

public class FileSystemUtil {
    public static String getNameRelativeTo(FileSystem fs, String resource) {
        String s = fs.getRootURI().toString();
        if (resource.startsWith(s)) {
            return resource.substring(s.length());
        }
        return resource;
    }

    public static boolean resourceExists(String context) throws FileSystem.FileSystemOfflineException, UnknownHostException, URISyntaxException {
        URISplit split = URISplit.parse(context);
        FileSystem fs = FileSystem.create((URI)DataSetURI.toUri(split.path));
        return fs.getFileObject(split.file.substring(split.path.length())).exists();
    }

    public static File doDownload(String context, ProgressMonitor mon) throws FileSystem.FileSystemOfflineException, IOException, URISyntaxException {
        URISplit split = URISplit.parse(context);
        FileSystem fs = FileSystem.create((URI)DataSetURI.toUri(split.path));
        File result = fs.getFileObject(split.file.substring(split.path.length())).getFile(mon);
        return result;
    }

    static boolean resourceIsLocal(String context) throws FileSystem.FileSystemOfflineException, UnknownHostException, URISyntaxException {
        URISplit split = URISplit.parse(context);
        FileSystem fs = FileSystem.create((URI)DataSetURI.toUri(split.path));
        return fs.getFileObject(split.file.substring(split.path.length())).isLocal();
    }

    static boolean resourceIsFile(String context) throws FileSystem.FileSystemOfflineException, UnknownHostException, URISyntaxException {
        URISplit split = URISplit.parse(context);
        FileSystem fs = FileSystem.create((URI)DataSetURI.toUri(split.path));
        return fs.getFileObject(split.file.substring(split.path.length())).isData();
    }
}

