/*
 * Decompiled with CFR 0.152.
 */
package zipfs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.ZipEntry;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystemUtil;
import org.das2.util.monitor.ProgressMonitor;
import zipfs.ZipFileSystem;

public class ZipFileObject
extends FileObject {
    private ZipFileSystem zfs;
    private ZipEntry zipEntry;
    private ZipFileObject parent;
    private String name;
    private ArrayList<ZipFileObject> children;

    protected ZipFileObject(ZipFileSystem zfs, ZipEntry zipEntry, ZipFileObject par) {
        this(zfs, zipEntry, par, null);
    }

    protected ZipFileObject(ZipFileSystem zfs, ZipEntry zipEntry, ZipFileObject par, String name) {
        this.zfs = zfs;
        this.zipEntry = zipEntry;
        this.parent = par;
        this.name = name;
        this.children = new ArrayList();
    }

    protected void addChildObject(ZipFileObject child) {
        this.children.add(child);
    }

    public boolean canRead() {
        return true;
    }

    public FileObject[] getChildren() throws IOException {
        return this.children.toArray(new ZipFileObject[0]);
    }

    public InputStream getInputStream(ProgressMonitor monitor) throws IOException {
        if (!this.exists()) {
            throw new FileNotFoundException("file not found in zip: " + this.name);
        }
        return this.zfs.getZipFile().getInputStream(this.zipEntry);
    }

    public ReadableByteChannel getChannel(ProgressMonitor monitor) throws FileNotFoundException, IOException {
        return ((FileInputStream)this.getInputStream(monitor)).getChannel();
    }

    public File getFile(ProgressMonitor monitor) throws FileNotFoundException, IOException {
        if (!this.exists()) {
            throw new FileNotFoundException(String.format("file %s does not exist in %s", this.name, this.zfs.toString()));
        }
        String tmpFileName = this.zfs.getLocalRoot().getAbsoluteFile() + "/" + this.zipEntry.getName();
        File tmpFile = new File(tmpFileName);
        File tmpDir = tmpFile.getParentFile();
        FileSystemUtil.maybeMkdirs((File)tmpDir);
        if (!tmpFile.createNewFile()) {
            throw new IllegalArgumentException("unable to create file " + tmpFile);
        }
        InputStream zStream = this.zfs.getZipFile().getInputStream(this.zipEntry);
        FileSystemUtil.dumpToFile((InputStream)zStream, (File)tmpFile);
        return tmpFile;
    }

    public FileObject getParent() {
        return this.parent;
    }

    public long getSize() {
        if (this.zipEntry == null) {
            return 0L;
        }
        return this.zipEntry.getSize();
    }

    public boolean isData() {
        if (this.zipEntry == null) {
            return false;
        }
        return !this.zipEntry.isDirectory();
    }

    public boolean isFolder() {
        if (this.zipEntry == null) {
            return true;
        }
        return this.zipEntry.isDirectory();
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isLocal() {
        return true;
    }

    public boolean exists() {
        return this.zipEntry != null && this.parent != null;
    }

    public String getNameExt() {
        if (this.isRoot()) {
            return "/";
        }
        if (this.zipEntry != null) {
            return "/" + this.zipEntry.getName();
        }
        return this.parent.getNameExt() + this.name + "/";
    }

    public Date lastModified() {
        if (this.isRoot()) {
            File f = new File(this.zfs.getZipFile().getName());
            return new Date(f.lastModified());
        }
        long when = this.zipEntry.getTime();
        return when > 0L ? new Date(when) : new Date(0L);
    }
}

