/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.Configuration;
import proguard.DataEntryWriterFactory;
import proguard.InputReader;
import proguard.classfile.ClassPool;
import proguard.io.ClassFilter;
import proguard.io.ClassRewriter;
import proguard.io.DataEntryCopier;
import proguard.io.DataEntryNameFilter;
import proguard.io.DataEntryReader;
import proguard.io.DataEntryRenamer;
import proguard.io.DataEntryRewriter;
import proguard.io.DataEntryWriter;
import proguard.io.FilteredDataEntryReader;
import proguard.util.FileNameParser;
import proguard.util.ListParser;

public class OutputWriter {
    private final Configuration configuration;

    public OutputWriter(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool classPool) throws IOException {
        ClassPathEntry classPathEntry;
        int n;
        int n2;
        ClassPath classPath = this.configuration.programJars;
        ClassPathEntry classPathEntry2 = classPath.get(0);
        if (classPathEntry2.isOutput()) {
            throw new IOException("The output jar [" + classPathEntry2.getName() + "] must be specified after an input jar, or it will be empty.");
        }
        for (n2 = 0; n2 < classPath.size() - 1; ++n2) {
            ClassPathEntry classPathEntry3 = classPath.get(n2);
            if (!classPathEntry3.isOutput()) continue;
            if (classPathEntry3.getFilter() == null && classPathEntry3.getJarFilter() == null && classPathEntry3.getWarFilter() == null && classPathEntry3.getEarFilter() == null && classPathEntry3.getZipFilter() == null && classPath.get(n2 + 1).isOutput()) {
                throw new IOException("The output jar [" + classPathEntry3.getName() + "] must have a filter, or all subsequent jars will be empty.");
            }
            for (n = 0; n < classPath.size(); ++n) {
                classPathEntry = classPath.get(n);
                if (classPathEntry.isOutput() || !classPathEntry3.getFile().equals(classPathEntry.getFile())) continue;
                throw new IOException("The output jar [" + classPathEntry3.getName() + "] must be different from all input jars.");
            }
        }
        n2 = 0;
        int n3 = 0;
        for (n = 0; n < classPath.size(); ++n) {
            classPathEntry = classPath.get(n);
            if (!classPathEntry.isOutput()) {
                n3 = n;
                continue;
            }
            int n4 = n + 1;
            if (n4 != classPath.size() && classPath.get(n4).isOutput()) continue;
            this.writeOutput(classPool, classPath, n2, n3 + 1, n4);
            n2 = n4;
        }
    }

    private void writeOutput(ClassPool classPool, ClassPath classPath, int n, int n2, int n3) throws IOException {
        try {
            DataEntryReader dataEntryReader;
            DataEntryWriter dataEntryWriter = DataEntryWriterFactory.createDataEntryWriter(classPath, n2, n3);
            ClassRewriter classRewriter = new ClassRewriter(classPool, dataEntryWriter);
            DataEntryReader dataEntryReader2 = new DataEntryCopier(dataEntryWriter);
            if (this.configuration.adaptResourceFileContents != null) {
                dataEntryReader = new DataEntryRewriter(classPool, dataEntryWriter);
                DataEntryReader dataEntryReader3 = dataEntryReader2 = this.configuration.adaptResourceFileContents.size() > 0 ? new FilteredDataEntryReader(new DataEntryNameFilter(new ListParser(new FileNameParser()).parse(this.configuration.adaptResourceFileContents)), dataEntryReader, dataEntryReader2) : dataEntryReader;
            }
            if (this.configuration.adaptResourceFileNames != null) {
                dataEntryReader = new DataEntryRenamer(classPool, dataEntryReader2);
                dataEntryReader2 = this.configuration.adaptResourceFileNames.size() > 0 ? new FilteredDataEntryReader(new DataEntryNameFilter(new ListParser(new FileNameParser()).parse(this.configuration.adaptResourceFileNames)), dataEntryReader, dataEntryReader2) : dataEntryReader;
            }
            dataEntryReader = new ClassFilter(classRewriter, dataEntryReader2);
            new InputReader(this.configuration).readInput("  Copying resources from program ", classPath, n, n2, dataEntryReader);
            dataEntryWriter.close();
        }
        catch (IOException iOException) {
            throw new IOException("Can't write [" + classPath.get(n2).getName() + "] (" + iOException.getMessage() + ")");
        }
    }
}

