/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;

public class VariableSizeUpdater
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor {
    private static final boolean DEBUG = false;

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.u2maxLocals = ClassUtil.internalMethodParameterSize(method.getDescriptor(clazz), method.getAccessFlags());
        codeAttribute.instructionsAccept(clazz, method, this);
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
        int n2 = variableInstruction.variableIndex + 1;
        if (variableInstruction.isCategory2()) {
            ++n2;
        }
        if (codeAttribute.u2maxLocals < n2) {
            codeAttribute.u2maxLocals = n2;
        }
    }
}

