/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.util.MemberFinder;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class ClassReferenceInitializer
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
ConstantVisitor,
AttributeVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
AnnotationVisitor,
ElementValueVisitor {
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final WarningPrinter missingWarningPrinter;
    private final WarningPrinter dependencyWarningPrinter;
    private final MemberFinder memberFinder = new MemberFinder();

    public ClassReferenceInitializer(ClassPool classPool, ClassPool classPool2, WarningPrinter warningPrinter, WarningPrinter warningPrinter2) {
        this.programClassPool = classPool;
        this.libraryClassPool = classPool2;
        this.missingWarningPrinter = warningPrinter;
        this.dependencyWarningPrinter = warningPrinter2;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.constantPoolEntriesAccept(this);
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
        programClass.attributesAccept(this);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        libraryClass.fieldsAccept(this);
        libraryClass.methodsAccept(this);
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        programField.referencedClass = this.findReferencedClass(programClass.getName(), programField.getDescriptor(programClass));
        programField.attributesAccept(programClass, this);
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        programMethod.referencedClasses = this.findReferencedClasses(programClass.getName(), programMethod.getDescriptor(programClass));
        programMethod.attributesAccept(programClass, this);
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        libraryField.referencedClass = this.findReferencedClass(libraryClass.getName(), libraryField.getDescriptor(libraryClass));
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        libraryMethod.referencedClasses = this.findReferencedClasses(libraryClass.getName(), libraryMethod.getDescriptor(libraryClass));
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        stringConstant.javaLangStringClass = this.findClass(clazz.getName(), "java/lang/String");
    }

    @Override
    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        String string = refConstant.getClassName(clazz);
        Clazz clazz2 = this.findClass(clazz.getName(), string);
        if (clazz2 != null && !ClassUtil.isInternalArrayType(string)) {
            String string2 = refConstant.getName(clazz);
            String string3 = refConstant.getType(clazz);
            boolean bl = refConstant.getTag() == 9;
            refConstant.referencedMember = this.memberFinder.findMember(clazz, clazz2, string2, string3, bl);
            refConstant.referencedClass = this.memberFinder.correspondingClass();
            if (refConstant.referencedMember == null && this.missingWarningPrinter != null) {
                this.missingWarningPrinter.print("Warning: " + ClassUtil.externalClassName(clazz.getName()) + ": can't find referenced " + (bl ? "field '" + ClassUtil.externalFullFieldDescription(0, string2, string3) : "method '" + ClassUtil.externalFullMethodDescription(string, 0, string2, string3)) + "' in class " + ClassUtil.externalClassName(string));
            }
        }
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        String string = clazz.getName();
        classConstant.referencedClass = this.findClass(string, classConstant.getName(clazz));
        classConstant.javaLangClassClass = this.findClass(string, "java/lang/Class");
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        String string;
        String string2;
        String string3 = clazz.getName();
        Clazz clazz2 = this.findClass(string3, string2 = enclosingMethodAttribute.getClassName(clazz));
        if (clazz2 == null) {
            if (this.missingWarningPrinter != null) {
                this.missingWarningPrinter.print("Warning: " + ClassUtil.externalClassName(string3) + ": can't find enclosing class " + ClassUtil.externalClassName(string2));
            }
            return;
        }
        if (enclosingMethodAttribute.u2nameAndTypeIndex == 0) {
            return;
        }
        String string4 = enclosingMethodAttribute.getName(clazz);
        Method method = clazz2.findMethod(string4, string = enclosingMethodAttribute.getType(clazz));
        if (method == null) {
            if (this.missingWarningPrinter != null) {
                this.missingWarningPrinter.print("Warning: " + ClassUtil.externalClassName(string3) + ": can't find enclosing method '" + ClassUtil.externalFullMethodDescription(string2, 0, string4, string) + "' in class " + ClassUtil.externalClassName(string2));
            }
            return;
        }
        enclosingMethodAttribute.referencedClass = clazz2;
        enclosingMethodAttribute.referencedMethod = method;
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.attributesAccept(clazz, method, this);
    }

    @Override
    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        signatureAttribute.referencedClasses = this.findReferencedClasses(clazz.getName(), clazz.getString(signatureAttribute.u2signatureIndex));
    }

    @Override
    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        annotationsAttribute.annotationsAccept(clazz, this);
    }

    @Override
    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        parameterAnnotationsAttribute.annotationsAccept(clazz, method, this);
    }

    @Override
    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        annotationDefaultAttribute.defaultValueAccept(clazz, this);
    }

    @Override
    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        localVariableInfo.referencedClass = this.findReferencedClass(clazz.getName(), clazz.getString(localVariableInfo.u2descriptorIndex));
    }

    @Override
    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        localVariableTypeInfo.referencedClasses = this.findReferencedClasses(clazz.getName(), clazz.getString(localVariableTypeInfo.u2signatureIndex));
    }

    @Override
    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        annotation.referencedClasses = this.findReferencedClasses(clazz.getName(), clazz.getString(annotation.u2typeIndex));
        annotation.elementValuesAccept(clazz, this);
    }

    @Override
    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
        this.initializeElementValue(clazz, annotation, constantElementValue);
    }

    @Override
    public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        this.initializeElementValue(clazz, annotation, enumConstantElementValue);
        enumConstantElementValue.referencedClasses = this.findReferencedClasses(clazz.getName(), clazz.getString(enumConstantElementValue.u2typeNameIndex));
    }

    @Override
    public void visitClassElementValue(Clazz clazz, Annotation annotation, ClassElementValue classElementValue) {
        this.initializeElementValue(clazz, annotation, classElementValue);
        classElementValue.referencedClasses = this.findReferencedClasses(clazz.getName(), clazz.getString(classElementValue.u2classInfoIndex));
    }

    @Override
    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        this.initializeElementValue(clazz, annotation, annotationElementValue);
        annotationElementValue.annotationAccept(clazz, this);
    }

    @Override
    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        this.initializeElementValue(clazz, annotation, arrayElementValue);
        arrayElementValue.elementValuesAccept(clazz, annotation, this);
    }

    private void initializeElementValue(Clazz clazz, Annotation annotation, ElementValue elementValue) {
        if (annotation != null && annotation.referencedClasses != null && elementValue.u2elementNameIndex != 0) {
            Clazz clazz2;
            String string = clazz.getString(elementValue.u2elementNameIndex);
            elementValue.referencedClass = clazz2 = annotation.referencedClasses[0];
            elementValue.referencedMethod = clazz2.findMethod(string, null);
        }
    }

    private Clazz findReferencedClass(String string, String string2) {
        DescriptorClassEnumeration descriptorClassEnumeration = new DescriptorClassEnumeration(string2);
        descriptorClassEnumeration.nextFluff();
        if (descriptorClassEnumeration.hasMoreClassNames()) {
            return this.findClass(string, descriptorClassEnumeration.nextClassName());
        }
        return null;
    }

    private Clazz[] findReferencedClasses(String string, String string2) {
        DescriptorClassEnumeration descriptorClassEnumeration = new DescriptorClassEnumeration(string2);
        int n = descriptorClassEnumeration.classCount();
        if (n > 0) {
            Clazz[] clazzArray = new Clazz[n];
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                String string3 = descriptorClassEnumeration.nextFluff();
                String string4 = descriptorClassEnumeration.nextClassName();
                Clazz clazz = this.findClass(string, string4);
                if (clazz == null) continue;
                clazzArray[i] = clazz;
                bl = true;
            }
            if (bl) {
                return clazzArray;
            }
        }
        return null;
    }

    private Clazz findClass(String string, String string2) {
        if (ClassUtil.isInternalArrayType(string2) && !ClassUtil.isInternalClassType(string2)) {
            return null;
        }
        Clazz clazz = this.programClassPool.getClass(string2);
        if (clazz == null) {
            clazz = this.libraryClassPool.getClass(string2);
            if (clazz == null && this.missingWarningPrinter != null) {
                this.missingWarningPrinter.print("Warning: " + ClassUtil.externalClassName(string) + ": can't find referenced class " + ClassUtil.externalClassName(string2));
            }
        } else if (this.dependencyWarningPrinter != null) {
            this.dependencyWarningPrinter.print("Warning: library class " + ClassUtil.externalClassName(string) + " depends on program class " + ClassUtil.externalClassName(string2));
        }
        return clazz;
    }
}

