/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ParticularDoubleValue;
import proguard.evaluation.value.ParticularIntegerValue;
import proguard.evaluation.value.ParticularLongValue;
import proguard.evaluation.value.SpecificFloatValue;
import proguard.evaluation.value.SpecificValueFactory;
import proguard.evaluation.value.ValueFactory;

final class ParticularFloatValue
extends SpecificFloatValue {
    private final float value;

    public ParticularFloatValue(float f) {
        this.value = f;
    }

    @Override
    public float value() {
        return this.value;
    }

    @Override
    public FloatValue negate() {
        return new ParticularFloatValue(-this.value);
    }

    @Override
    public IntegerValue convertToInteger() {
        return new ParticularIntegerValue((int)this.value);
    }

    @Override
    public LongValue convertToLong() {
        return new ParticularLongValue((long)this.value);
    }

    @Override
    public DoubleValue convertToDouble() {
        return new ParticularDoubleValue(this.value);
    }

    @Override
    public FloatValue generalize(FloatValue floatValue) {
        return floatValue.generalize(this);
    }

    @Override
    public FloatValue add(FloatValue floatValue) {
        return (double)this.value == 0.0 ? floatValue : floatValue.add(this);
    }

    @Override
    public FloatValue subtract(FloatValue floatValue) {
        return (double)this.value == 0.0 ? floatValue.negate() : floatValue.subtractFrom(this);
    }

    @Override
    public FloatValue subtractFrom(FloatValue floatValue) {
        return (double)this.value == 0.0 ? floatValue : floatValue.subtract(this);
    }

    @Override
    public FloatValue multiply(FloatValue floatValue) {
        return floatValue.multiply(this);
    }

    @Override
    public FloatValue divide(FloatValue floatValue) {
        return floatValue.divideOf(this);
    }

    @Override
    public FloatValue divideOf(FloatValue floatValue) {
        return floatValue.divide(this);
    }

    @Override
    public FloatValue remainder(FloatValue floatValue) {
        return floatValue.remainderOf(this);
    }

    @Override
    public FloatValue remainderOf(FloatValue floatValue) {
        return floatValue.remainder(this);
    }

    @Override
    public IntegerValue compare(FloatValue floatValue) {
        return floatValue.compareReverse(this);
    }

    @Override
    public FloatValue generalize(ParticularFloatValue particularFloatValue) {
        return this.value == particularFloatValue.value ? this : ValueFactory.FLOAT_VALUE;
    }

    @Override
    public FloatValue add(ParticularFloatValue particularFloatValue) {
        return new ParticularFloatValue(this.value + particularFloatValue.value);
    }

    @Override
    public FloatValue subtract(ParticularFloatValue particularFloatValue) {
        return new ParticularFloatValue(this.value - particularFloatValue.value);
    }

    @Override
    public FloatValue subtractFrom(ParticularFloatValue particularFloatValue) {
        return new ParticularFloatValue(particularFloatValue.value - this.value);
    }

    @Override
    public FloatValue multiply(ParticularFloatValue particularFloatValue) {
        return new ParticularFloatValue(this.value * particularFloatValue.value);
    }

    @Override
    public FloatValue divide(ParticularFloatValue particularFloatValue) {
        return new ParticularFloatValue(this.value / particularFloatValue.value);
    }

    @Override
    public FloatValue divideOf(ParticularFloatValue particularFloatValue) {
        return new ParticularFloatValue(particularFloatValue.value / this.value);
    }

    @Override
    public FloatValue remainder(ParticularFloatValue particularFloatValue) {
        return new ParticularFloatValue(this.value % particularFloatValue.value);
    }

    @Override
    public FloatValue remainderOf(ParticularFloatValue particularFloatValue) {
        return new ParticularFloatValue(particularFloatValue.value % this.value);
    }

    @Override
    public IntegerValue compare(ParticularFloatValue particularFloatValue) {
        return this.value < particularFloatValue.value ? SpecificValueFactory.INTEGER_VALUE_M1 : (this.value == particularFloatValue.value ? SpecificValueFactory.INTEGER_VALUE_0 : SpecificValueFactory.INTEGER_VALUE_1);
    }

    @Override
    public boolean isParticular() {
        return true;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && this.value == ((ParticularFloatValue)object).value;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Float.floatToIntBits(this.value);
    }

    public String toString() {
        return this.value + "f";
    }
}

