/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dataset.conv.ATDRadarConvention;
import ucar.nc2.util.CancelTask;

public class Cosmic1Convention
extends ATDRadarConvention {
    public static boolean isMine(NetcdfFile ncfile) {
        if (null == ncfile.findDimension("MSL_alt")) {
            return false;
        }
        if (null == ncfile.findGlobalAttribute("start_time")) {
            return false;
        }
        if (null == ncfile.findGlobalAttribute("stop_time")) {
            return false;
        }
        String center = ncfile.findAttValueIgnoreCase(null, "center", null);
        return center != null && center.equals("UCAR/CDAAC");
    }

    public Cosmic1Convention() {
        this.conventionName = "Cosmic1";
    }

    public void augmentDataset(NetcdfDataset ds, CancelTask cancelTask) throws IOException {
        double start = ds.readAttributeDouble(null, "start_time", Double.NaN);
        double stop = ds.readAttributeDouble(null, "stop_time", Double.NaN);
        Dimension dim = ds.findDimension("MSL_alt");
        int n = dim.getLength();
        double incr = (stop - start) / (double)n;
        String timeUnits = "seconds since 1970-01-01 00:00 UTC";
        VariableDS timeVar = new VariableDS(ds, null, null, "time", DataType.DOUBLE, dim.getName(), timeUnits, null);
        ds.addVariable(null, timeVar);
        timeVar.addAttribute(new Attribute("units", timeUnits));
        timeVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        ArrayDouble.D1 data = (ArrayDouble.D1)Array.factory(DataType.DOUBLE, new int[]{n});
        for (int i = 0; i < n; ++i) {
            data.set(i, start + (double)i * incr);
        }
        timeVar.setCachedData(data, false);
        Variable v = ds.findVariable("Lat");
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
        v = ds.findVariable("Lon");
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
        ds.finish();
    }

    protected AxisType getAxisType(NetcdfDataset ncDataset, VariableEnhanced v) {
        String name = v.getShortName();
        if (name.equals("time")) {
            return AxisType.Time;
        }
        if (name.equals("Lat")) {
            return AxisType.Lat;
        }
        if (name.equals("Lon")) {
            return AxisType.Lon;
        }
        if (name.equals("MSL_alt")) {
            return AxisType.Height;
        }
        return null;
    }
}

