/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.point.standard.TableConfig;

public class CoordSysEvaluator {
    public static void findCoords(TableConfig nt, NetcdfDataset ds) {
        CoordinateSystem use = CoordSysEvaluator.findBestCoordinateSystem(ds);
        if (use == null) {
            return;
        }
        for (CoordinateAxis axis : use.getCoordinateAxes()) {
            if (axis.getAxisType() == AxisType.Lat) {
                nt.lat = axis.getShortName();
                continue;
            }
            if (axis.getAxisType() == AxisType.Lon) {
                nt.lon = axis.getShortName();
                continue;
            }
            if (axis.getAxisType() == AxisType.Time) {
                nt.time = axis.getShortName();
                continue;
            }
            if (axis.getAxisType() != AxisType.Height) continue;
            nt.elev = axis.getShortName();
        }
    }

    public static String findCoordNameByType(NetcdfDataset ds, AxisType atype) {
        CoordinateAxis coordAxis = CoordSysEvaluator.findCoordByType(ds, atype);
        return coordAxis == null ? null : coordAxis.getName();
    }

    public static CoordinateAxis findCoordByType(NetcdfDataset ds, AxisType atype) {
        CoordinateSystem use = CoordSysEvaluator.findBestCoordinateSystem(ds);
        if (use == null) {
            return null;
        }
        for (CoordinateAxis axis : use.getCoordinateAxes()) {
            if (axis.getAxisType() != atype) continue;
            return axis;
        }
        for (CoordinateAxis axis : ds.getCoordinateAxes()) {
            if (axis.getAxisType() != atype) continue;
            return axis;
        }
        return null;
    }

    public static CoordinateAxis findCoordByTypeAndDimension(NetcdfDataset ds, AxisType atype, Dimension outer) {
        CoordinateSystem use = CoordSysEvaluator.findBestCoordinateSystem(ds);
        if (use == null) {
            return null;
        }
        for (CoordinateAxis axis : use.getCoordinateAxes()) {
            if (axis.getAxisType() != atype) continue;
            if (outer == null && axis.getRank() == 0) {
                return axis;
            }
            if (outer == null || !axis.getDimension(0).equals(outer)) continue;
            return axis;
        }
        for (CoordinateAxis axis : ds.getCoordinateAxes()) {
            if (axis.getAxisType() != atype) continue;
            if (outer == null && axis.getRank() == 0) {
                return axis;
            }
            if (outer == null || !axis.getDimension(0).equals(outer)) continue;
            return axis;
        }
        return null;
    }

    public static Dimension findDimensionByType(NetcdfDataset ds, AxisType atype) {
        CoordinateAxis axis = CoordSysEvaluator.findCoordByType(ds, atype);
        if (axis == null) {
            return null;
        }
        if (axis.isScalar()) {
            return null;
        }
        return axis.getDimension(0);
    }

    private static CoordinateSystem findBestCoordinateSystem(NetcdfDataset ds) {
        CoordinateSystem use = null;
        for (CoordinateSystem cs : ds.getCoordinateSystems()) {
            if (use == null) {
                use = cs;
                continue;
            }
            if (cs.getCoordinateAxes().size() <= use.getCoordinateAxes().size()) continue;
            use = cs;
        }
        return use;
    }
}

