/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataFactory;
import ucar.nc2.Variable;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.Join;

public class JoinArray
implements Join {
    Variable v;
    Array data;
    Type type;
    int param;

    public JoinArray(Variable v, Type type, int param) {
        this.v = v;
        this.type = type;
        this.param = param;
        try {
            this.data = v.read();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public StructureData getJoinData(Cursor cursor) {
        int recnum = -1;
        switch (this.type) {
            case modulo: {
                recnum = cursor.recnum[0] % this.param;
                break;
            }
            case divide: {
                recnum = cursor.recnum[0] / this.param;
                break;
            }
            case raw: {
                recnum = cursor.recnum[0];
            }
        }
        return StructureDataFactory.make(this.v.getShortName(), this.data.getObject(recnum));
    }

    public Variable findVariable(String varName) {
        return varName.equals(this.v.getName()) ? this.v : null;
    }

    public String toString() {
        return "JoinArray{v=" + this.v.getName() + ", type=" + (Object)((Object)this.type) + ", param=" + this.param + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        modulo,
        divide,
        raw;

    }
}

