/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard.plug;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.CF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.point.standard.CoordSysEvaluator;
import ucar.nc2.ft.point.standard.Evaluator;
import ucar.nc2.ft.point.standard.JoinArray;
import ucar.nc2.ft.point.standard.Table;
import ucar.nc2.ft.point.standard.TableConfig;
import ucar.nc2.ft.point.standard.TableConfigurerImpl;

public class CFpointObs
extends TableConfigurerImpl {
    public boolean isMine(FeatureType wantFeatureType, NetcdfDataset ds) {
        String datatype = ds.findAttValueIgnoreCase(null, "CF:featureType", null);
        if (datatype == null) {
            datatype = ds.findAttValueIgnoreCase(null, "CF-featureType", null);
        }
        if (datatype == null) {
            datatype = ds.findAttValueIgnoreCase(null, "CFfeatureType", null);
        }
        if (datatype == null) {
            return false;
        }
        if (CF.FeatureType.valueOf(datatype) == null) {
            return false;
        }
        String conv = ds.findAttValueIgnoreCase(null, "Conventions", null);
        if (conv == null) {
            return false;
        }
        StringTokenizer stoke = new StringTokenizer(conv, ",");
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken().trim();
            if (!toke.startsWith("CF")) continue;
            return true;
        }
        return false;
    }

    public TableConfig getConfig(FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) throws IOException {
        CF.FeatureType ftype;
        String ftypeS = ds.findAttValueIgnoreCase(null, "CF:featureType", null);
        if (ftypeS == null) {
            ftypeS = ds.findAttValueIgnoreCase(null, "CF-featureType", null);
        }
        if (ftypeS == null) {
            ftypeS = ds.findAttValueIgnoreCase(null, "CFfeatureType", null);
        }
        if (ftypeS == null) {
            ftype = CF.FeatureType.point;
        } else {
            try {
                ftype = CF.FeatureType.valueOf(ftypeS);
            }
            catch (Throwable t) {
                ftype = ftypeS.equalsIgnoreCase("stationProfileTimeSeries") ? CF.FeatureType.stationProfile : CF.FeatureType.point;
            }
        }
        if (!this.checkCoordinates(ds, errlog)) {
            return null;
        }
        switch (ftype) {
            case point: {
                return this.getPointConfig(ds, errlog);
            }
            case stationTimeSeries: {
                return this.getStationConfig(ds, errlog);
            }
            case profile: {
                return this.getProfileConfig(ds, errlog);
            }
            case trajectory: {
                return this.getTrajectoryConfig(ds, errlog);
            }
            case stationProfile: {
                return this.getStationProfileConfig(ds, errlog);
            }
            case section: {
                return this.getSectionConfig(ds, errlog);
            }
        }
        return null;
    }

    private Encoding identifyEncoding(NetcdfDataset ds, CF.FeatureType ftype, Formatter errlog) {
        String ragged_rowSize = Evaluator.getVariableWithAttribute(ds, "standard_name", "ragged_rowSize");
        if (ragged_rowSize != null) {
            return Encoding.raggedContiguous;
        }
        String ragged_parentIndex = Evaluator.getVariableWithAttribute(ds, "standard_name", "ragged_parentIndex");
        if (ragged_parentIndex != null) {
            return Encoding.raggedIndex;
        }
        String ragged_parentId = Evaluator.getVariableWithAttribute(ds, "standard_name", "parentId");
        if (ragged_parentId != null) {
            return Encoding.flat;
        }
        CoordinateAxis lat = CoordSysEvaluator.findCoordByType(ds, AxisType.Lat);
        if (lat == null) {
            errlog.format("Must have a Latitude coordinate", new Object[0]);
            return null;
        }
        switch (ftype) {
            case point: {
                return Encoding.multidim;
            }
            case stationTimeSeries: 
            case profile: 
            case stationProfile: {
                if (lat.getRank() == 0) {
                    return Encoding.single;
                }
                if (lat.getRank() == 1) {
                    return Encoding.multidim;
                }
                errlog.format("CFpointObs %s Must have Lat/Lon coordinates of rank 0 or 1", new Object[]{ftype});
                return null;
            }
            case trajectory: 
            case section: {
                if (lat.getRank() == 1) {
                    return Encoding.single;
                }
                if (lat.getRank() == 2) {
                    return Encoding.multidim;
                }
                errlog.format("CFpointObs %s Must have Lat/Lon coordinates of rank 1 or 2", new Object[]{ftype});
                return null;
            }
        }
        return null;
    }

    private boolean checkCoordinates(NetcdfDataset ds, Formatter errlog) {
        List<Dimension> dimLon;
        List<Dimension> dimLat;
        CoordinateAxis lon;
        CoordinateAxis lat;
        boolean ok = true;
        CoordinateAxis time = CoordSysEvaluator.findCoordByType(ds, AxisType.Time);
        if (time == null) {
            errlog.format("CFpointObs cant find a Time coordinate", new Object[0]);
            ok = false;
        }
        if ((lat = CoordSysEvaluator.findCoordByType(ds, AxisType.Lat)) == null) {
            errlog.format("CFpointObs cant find a Latitude coordinate", new Object[0]);
            ok = false;
        }
        if ((lon = CoordSysEvaluator.findCoordByType(ds, AxisType.Lon)) == null) {
            errlog.format("CFpointObs cant find a Longitude coordinate", new Object[0]);
            ok = false;
        }
        if (!((Object)(dimLat = lat.getDimensions())).equals(dimLon = lon.getDimensions())) {
            errlog.format("Lat and Lon coordinate dimensions must match lat=%s lon=%s %n", lat.getNameAndDimensions(), lon.getNameAndDimensions());
            ok = false;
        }
        return ok;
    }

    private TableConfig getPointConfig(NetcdfDataset ds, Formatter errlog) {
        CoordinateAxis time = CoordSysEvaluator.findCoordByType(ds, AxisType.Time);
        if (time.getRank() != 1) {
            errlog.format("CFpointObs type=point: coord time must have rank 1, coord var= " + time.getName(), new Object[0]);
            return null;
        }
        Dimension obsDim = time.getDimension(0);
        boolean hasStruct = Evaluator.hasRecordStructure(ds);
        TableConfig obsTable = new TableConfig(Table.Type.Structure, obsDim.getName());
        obsTable.structName = hasStruct ? "record" : obsDim.getName();
        obsTable.isPsuedoStructure = !hasStruct;
        obsTable.dim = obsDim;
        obsTable.time = time.getName();
        obsTable.featureType = FeatureType.POINT;
        CoordSysEvaluator.findCoords(obsTable, ds);
        return obsTable;
    }

    private TableConfig getStationConfig(NetcdfDataset ds, Formatter errlog) throws IOException {
        Encoding encoding = this.identifyEncoding(ds, CF.FeatureType.stationTimeSeries, errlog);
        if (encoding == null) {
            return null;
        }
        TableConfig stnTable = this.makeStationTable(ds, FeatureType.STATION, encoding, errlog);
        if (stnTable == null) {
            return null;
        }
        CoordinateAxis time = CoordSysEvaluator.findCoordByType(ds, AxisType.Time);
        Dimension obsDim = time.getDimension(time.getRank() - 1);
        TableConfig obsConfig = null;
        switch (encoding) {
            case single: {
                obsConfig = this.makeSingle(ds, obsDim, errlog);
                break;
            }
            case raggedContiguous: {
                obsConfig = this.makeRaggedContiguous(ds, stnTable, obsDim, errlog);
                break;
            }
            case raggedIndex: {
                obsConfig = this.makeRaggedIndex(ds, obsDim, errlog);
                break;
            }
            case multidim: {
                obsConfig = this.makeMultidim(ds, stnTable, obsDim, errlog);
                break;
            }
            case flat: {
                throw new UnsupportedOperationException("CFpointObs flat encoding");
            }
        }
        if (obsConfig == null) {
            return null;
        }
        stnTable.addChild(obsConfig);
        return stnTable;
    }

    private TableConfig getProfileConfig(NetcdfDataset ds, Formatter errlog) throws IOException {
        Encoding encoding = this.identifyEncoding(ds, CF.FeatureType.trajectory, errlog);
        if (encoding == null) {
            return null;
        }
        TableConfig parentTable = this.makeParentTable(ds, FeatureType.PROFILE, encoding, errlog);
        if (parentTable == null) {
            return null;
        }
        CoordinateAxis z = CoordSysEvaluator.findCoordByType(ds, AxisType.Height);
        Dimension obsDim = z.getDimension(z.getRank() - 1);
        TableConfig obsConfig = null;
        switch (encoding) {
            case single: {
                obsConfig = this.makeSingle(ds, obsDim, errlog);
                break;
            }
            case raggedContiguous: {
                obsConfig = this.makeRaggedContiguous(ds, parentTable, obsDim, errlog);
                break;
            }
            case raggedIndex: {
                obsConfig = this.makeRaggedIndex(ds, obsDim, errlog);
                break;
            }
            case multidim: {
                obsConfig = this.makeMultidim(ds, parentTable, obsDim, errlog);
                break;
            }
            case flat: {
                throw new UnsupportedOperationException("CFpointObs flat encoding");
            }
        }
        if (obsConfig == null) {
            return null;
        }
        parentTable.addChild(obsConfig);
        return parentTable;
    }

    private TableConfig getTrajectoryConfig(NetcdfDataset ds, Formatter errlog) throws IOException {
        Encoding encoding = this.identifyEncoding(ds, CF.FeatureType.trajectory, errlog);
        if (encoding == null) {
            return null;
        }
        TableConfig parentTable = this.makeParentTable(ds, FeatureType.TRAJECTORY, encoding, errlog);
        if (parentTable == null) {
            return null;
        }
        CoordinateAxis time = CoordSysEvaluator.findCoordByType(ds, AxisType.Time);
        Dimension obsDim = time.getDimension(time.getRank() - 1);
        TableConfig obsConfig = null;
        switch (encoding) {
            case single: {
                obsConfig = this.makeSingle(ds, obsDim, errlog);
                break;
            }
            case raggedContiguous: {
                obsConfig = this.makeRaggedContiguous(ds, parentTable, obsDim, errlog);
                break;
            }
            case raggedIndex: {
                obsConfig = this.makeRaggedIndex(ds, obsDim, errlog);
                break;
            }
            case multidim: {
                obsConfig = this.makeMultidim(ds, parentTable, obsDim, errlog);
                break;
            }
            case flat: {
                throw new UnsupportedOperationException("CFpointObs flat encoding");
            }
        }
        if (obsConfig == null) {
            return null;
        }
        parentTable.addChild(obsConfig);
        return parentTable;
    }

    private TableConfig getStationProfileConfig(NetcdfDataset ds, Formatter errlog) throws IOException {
        Encoding encoding = this.identifyEncoding(ds, CF.FeatureType.stationProfile, errlog);
        if (encoding == null) {
            return null;
        }
        TableConfig parentTable = this.makeStationTable(ds, FeatureType.STATION_PROFILE, encoding, errlog);
        if (parentTable == null) {
            return null;
        }
        Object profileDim = null;
        Object zDim = null;
        CoordinateAxis time = CoordSysEvaluator.findCoordByType(ds, AxisType.Time);
        if (time.getRank() == 0) {
            errlog.format("stationProfile cannot have a scalar time coordinate", new Object[0]);
            return null;
        }
        CoordinateAxis z = CoordSysEvaluator.findCoordByType(ds, AxisType.Height);
        if (z.getRank() == 0) {
            errlog.format("stationProfile cannot have a scalar z coordinate", new Object[0]);
            return null;
        }
        Dimension obsDim = time.getDimension(time.getRank() - 1);
        TableConfig obsConfig = null;
        switch (encoding) {
            case single: {
                obsConfig = this.makeSingle(ds, obsDim, errlog);
                break;
            }
            case raggedContiguous: {
                obsConfig = this.makeRaggedContiguous(ds, parentTable, obsDim, errlog);
                break;
            }
            case raggedIndex: {
                obsConfig = this.makeRaggedIndex(ds, obsDim, errlog);
                break;
            }
            case multidim: {
                obsConfig = this.makeMultidim(ds, parentTable, obsDim, errlog);
                break;
            }
            case flat: {
                throw new UnsupportedOperationException("CFpointObs flat encoding");
            }
        }
        if (obsConfig == null) {
            return null;
        }
        parentTable.addChild(obsConfig);
        return parentTable;
    }

    private TableConfig getSectionConfig(NetcdfDataset ds, Formatter errlog) {
        return null;
    }

    private TableConfig makeStationTable(NetcdfDataset ds, FeatureType ftype, Encoding encoding, Formatter errlog) throws IOException {
        CoordinateAxis alt;
        CoordinateAxis lat = CoordSysEvaluator.findCoordByType(ds, AxisType.Lat);
        CoordinateAxis lon = CoordSysEvaluator.findCoordByType(ds, AxisType.Lon);
        Dimension stationDim = encoding == Encoding.single ? null : lat.getDimension(0);
        Table.Type stationTableType = null;
        switch (encoding) {
            case single: {
                stationTableType = Table.Type.Top;
                break;
            }
            default: {
                stationTableType = Table.Type.Structure;
            }
        }
        TableConfig stnTable = new TableConfig(stationTableType, "station");
        stnTable.featureType = ftype;
        stnTable.stnId = this.matchStandardName(ds, "station_id", stationDim, errlog);
        stnTable.stnDesc = this.matchStandardName(ds, "station_desc", stationDim, errlog);
        stnTable.stnWmoId = this.matchStandardName(ds, "station_wmoid", stationDim, errlog);
        stnTable.stnAlt = this.matchStandardName(ds, "station_altitude", stationDim, errlog);
        stnTable.lat = lat.getName();
        stnTable.lon = lon.getName();
        if (encoding != Encoding.single) {
            boolean stnIsStruct = Evaluator.hasRecordStructure(ds) && stationDim.isUnlimited();
            stnTable.isPsuedoStructure = !stnIsStruct;
            stnTable.dim = stationDim;
            String string = stnTable.structName = stnIsStruct ? "record" : stationDim.getName();
            if (stnTable.stnId == null) {
                errlog.format("Must have a Station id variable with standard name station_id", new Object[0]);
                return null;
            }
        }
        if (stnTable.stnAlt == null && (alt = CoordSysEvaluator.findCoordByType(ds, AxisType.Height)) != null) {
            if (encoding == Encoding.single && alt.getRank() == 0) {
                stnTable.stnAlt = alt.getName();
            }
            if (encoding != Encoding.single && lat.getRank() == alt.getRank() && alt.getDimension(0).equals(stationDim)) {
                stnTable.stnAlt = alt.getName();
            }
        }
        return stnTable;
    }

    private TableConfig makeParentTable(NetcdfDataset ds, FeatureType ftype, Encoding encoding, Formatter errlog) throws IOException {
        CoordinateAxis lat = CoordSysEvaluator.findCoordByType(ds, AxisType.Lat);
        Dimension parentDim = encoding == Encoding.single ? null : lat.getDimension(0);
        Table.Type parentTableType = null;
        switch (encoding) {
            case single: {
                parentTableType = Table.Type.Top;
                break;
            }
            default: {
                parentTableType = Table.Type.Structure;
            }
        }
        TableConfig parentTable = new TableConfig(parentTableType, ftype.toString());
        parentTable.lat = this.matchAxisType(ds, AxisType.Lat, parentDim);
        parentTable.lon = this.matchAxisType(ds, AxisType.Lon, parentDim);
        parentTable.elev = this.matchAxisType(ds, AxisType.Height, parentDim);
        parentTable.time = this.matchAxisType(ds, AxisType.Time, parentDim);
        parentTable.featureType = ftype;
        if (encoding != Encoding.single) {
            boolean stnIsStruct = Evaluator.hasRecordStructure(ds) && parentDim.isUnlimited();
            parentTable.isPsuedoStructure = !stnIsStruct;
            parentTable.dim = parentDim;
            parentTable.structName = stnIsStruct ? "record" : parentDim.getName();
        }
        return parentTable;
    }

    private String matchStandardName(NetcdfDataset ds, String standard_name, Dimension outer, Formatter errlog) {
        Variable var;
        String varname = Evaluator.getVariableWithAttribute(ds, "standard_name", standard_name);
        if (varname != null && outer != null && !(var = ds.findVariable(varname)).getDimension(0).equals(outer)) {
            errlog.format("Station variable %s must have outer dimension that matches latitude/longitude dimension %s%n", standard_name, outer);
            return null;
        }
        return varname;
    }

    private String matchAxisType(NetcdfDataset ds, AxisType type, Dimension outer) {
        CoordinateAxis var = CoordSysEvaluator.findCoordByTypeAndDimension(ds, type, outer);
        if (var == null) {
            return null;
        }
        return var.getShortName();
    }

    private TableConfig makeRaggedContiguous(NetcdfDataset ds, TableConfig parentTable, Dimension obsDim, Formatter errlog) throws IOException {
        TableConfig obsTable = new TableConfig(Table.Type.Contiguous, obsDim.getName());
        obsTable.dim = obsDim;
        obsTable.lat = this.matchAxisType(ds, AxisType.Lat, obsDim);
        obsTable.lon = this.matchAxisType(ds, AxisType.Lon, obsDim);
        obsTable.elev = this.matchAxisType(ds, AxisType.Height, obsDim);
        obsTable.time = this.matchAxisType(ds, AxisType.Time, obsDim);
        boolean obsIsStruct = Evaluator.hasRecordStructure(ds) && obsDim.isUnlimited();
        obsTable.structName = obsIsStruct ? "record" : obsDim.getName();
        obsTable.isPsuedoStructure = !obsIsStruct;
        obsTable.numRecords = this.matchStandardName(ds, "ragged_rowSize", parentTable.dim, errlog);
        if (null == obsTable.numRecords) {
            return null;
        }
        Variable v = ds.findVariable(obsTable.numRecords);
        Array numRecords = v.read();
        int n = (int)v.getSize();
        obsTable.startIndex = new int[n];
        int i = 0;
        int count = 0;
        while (numRecords.hasNext()) {
            obsTable.startIndex[i++] = count;
            count = (int)((long)count + numRecords.nextLong());
        }
        return obsTable;
    }

    private TableConfig makeRaggedIndex(NetcdfDataset ds, Dimension obsDim, Formatter errlog) throws IOException {
        TableConfig obsTable = new TableConfig(Table.Type.ParentIndex, obsDim.getName());
        obsTable.dim = obsDim;
        obsTable.lat = this.matchAxisType(ds, AxisType.Lat, obsDim);
        obsTable.lon = this.matchAxisType(ds, AxisType.Lon, obsDim);
        obsTable.elev = this.matchAxisType(ds, AxisType.Height, obsDim);
        obsTable.time = this.matchAxisType(ds, AxisType.Time, obsDim);
        boolean obsIsStruct = Evaluator.hasRecordStructure(ds) && obsDim.isUnlimited();
        obsTable.structName = obsIsStruct ? "record" : obsDim.getName();
        obsTable.isPsuedoStructure = !obsIsStruct;
        obsTable.parentIndex = this.matchStandardName(ds, "ragged_parentIndex", obsDim, errlog);
        if (null == obsTable.parentIndex) {
            return null;
        }
        Variable rpIndex = ds.findVariable(obsTable.parentIndex);
        Array index = rpIndex.read();
        int childIndex = 0;
        HashMap<Integer, List<Integer>> map = new HashMap<Integer, List<Integer>>((int)(2L * index.getSize()));
        while (index.hasNext()) {
            int parent = index.nextInt();
            ArrayList<Integer> list = (ArrayList<Integer>)map.get(parent);
            if (list == null) {
                list = new ArrayList<Integer>();
                map.put(parent, list);
            }
            list.add(childIndex);
            ++childIndex;
        }
        obsTable.indexMap = map;
        return obsTable;
    }

    private TableConfig makeMultidim(NetcdfDataset ds, TableConfig parentTable, Dimension obsDim, Formatter errlog) throws IOException {
        Dimension stationDim = parentTable.dim;
        Table.Type obsTableType = parentTable.isPsuedoStructure ? Table.Type.MultiDimStructurePsuedo : Table.Type.MultiDimInner;
        TableConfig obsTable = new TableConfig(obsTableType, obsDim.getName());
        obsTable.dim = obsDim;
        obsTable.lat = this.matchAxisType(ds, AxisType.Lat, obsDim);
        obsTable.lon = this.matchAxisType(ds, AxisType.Lon, obsDim);
        obsTable.elev = this.matchAxisType(ds, AxisType.Height, obsDim);
        obsTable.time = this.matchAxisType(ds, AxisType.Time, obsDim);
        ArrayList<String> obsVars = null;
        List<Variable> vars = ds.getVariables();
        ArrayList<String> stnVars = new ArrayList<String>(vars.size());
        obsVars = new ArrayList<String>(vars.size());
        for (Variable orgV : vars) {
            Dimension dim0;
            if (orgV instanceof Structure || (dim0 = orgV.getDimension(0)) == null || !dim0.equals(stationDim)) continue;
            if (orgV.getRank() == 1 || orgV.getRank() == 2 && orgV.getDataType() == DataType.CHAR) {
                stnVars.add(orgV.getShortName());
                continue;
            }
            Dimension dim1 = orgV.getDimension(1);
            if (dim1 == null || !dim1.equals(obsDim)) continue;
            obsVars.add(orgV.getShortName());
        }
        parentTable.vars = parentTable.isPsuedoStructure ? stnVars : null;
        obsTable.isPsuedoStructure = parentTable.isPsuedoStructure;
        obsTable.dim = stationDim;
        obsTable.inner = obsDim;
        obsTable.structName = parentTable.isPsuedoStructure ? stationDim.getName() : "record";
        obsTable.vars = obsVars;
        Variable time = ds.findVariable(obsTable.time);
        if (time.getRank() == 1) {
            obsTable.addJoin(new JoinArray(time, JoinArray.Type.raw, 0));
        }
        return obsTable;
    }

    private TableConfig makeSingle(NetcdfDataset ds, Dimension obsDim, Formatter errlog) throws IOException {
        Table.Type obsTableType = Table.Type.Structure;
        TableConfig obsTable = new TableConfig(obsTableType, obsDim.getName());
        obsTable.dim = obsDim;
        obsTable.lat = this.matchAxisType(ds, AxisType.Lat, obsDim);
        obsTable.lon = this.matchAxisType(ds, AxisType.Lon, obsDim);
        obsTable.elev = this.matchAxisType(ds, AxisType.Height, obsDim);
        obsTable.time = this.matchAxisType(ds, AxisType.Time, obsDim);
        boolean obsIsStruct = Evaluator.hasRecordStructure(ds) && obsDim.isUnlimited();
        obsTable.structName = obsIsStruct ? "record" : obsDim.getName();
        obsTable.isPsuedoStructure = !obsIsStruct;
        return obsTable;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Encoding {
        single,
        multidim,
        raggedContiguous,
        raggedIndex,
        flat;

    }
}

