/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard.plug;

import java.util.Date;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.ft.point.standard.Table;
import ucar.nc2.ft.point.standard.TableConfig;
import ucar.nc2.ft.point.standard.TableConfigurerImpl;
import ucar.nc2.units.SimpleUnit;

public class Cosmic
extends TableConfigurerImpl {
    private static String dimName = "MSL_alt";
    private static String dimVarName = "MSL_alt";
    private static String latVarName = "Lat";
    private static String lonVarName = "Lon";
    private static String elevVarName = "MSL_alt";
    private static String trajId = "trajectory data";

    public boolean isMine(FeatureType wantFeatureType, NetcdfDataset ds) {
        String center = ds.findAttValueIgnoreCase(null, "center", null);
        return center != null && center.equals("UCAR/CDAAC");
    }

    public TableConfig getConfig(FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) {
        TableConfig traj = new TableConfig(Table.Type.Top, "traj");
        traj.featureType = FeatureType.TRAJECTORY;
        TableConfig obs = new TableConfig(Table.Type.Structure, "point");
        obs.isPsuedoStructure = true;
        obs.dim = ds.findDimension("MSL_alt");
        obs.lat = "Lat";
        obs.lon = "Lon";
        obs.time = "time";
        obs.elev = "MSL_alt";
        traj.addChild(obs);
        return traj;
    }

    private Structure buildStructure(NetcdfDataset ncd, String structureId) {
        Structure trajStructure = new Structure(ncd, null, null, structureId);
        List<Dimension> list = ncd.getRootGroup().getDimensions();
        if (list.size() != 1) {
            return null;
        }
        Dimension d = list.get(0);
        if (!d.getName().equals(dimName)) {
            return null;
        }
        trajStructure.setDimensions("");
        Variable dimVar = ncd.getRootGroup().findVariable(dimVarName);
        if (dimVar == null) {
            return null;
        }
        list = dimVar.getDimensions();
        if (list.size() != 1) {
            return null;
        }
        d = list.get(0);
        if (!d.getName().equals(dimName)) {
            return null;
        }
        String units = dimVar.findAttribute("units").getStringValue();
        if (!SimpleUnit.isCompatible(units, "km")) {
            return null;
        }
        trajStructure.addMemberVariable(dimVar);
        Variable latVar = ncd.getRootGroup().findVariable(latVarName);
        if (latVar == null) {
            return null;
        }
        list = latVar.getDimensions();
        if (list.size() != 1) {
            return null;
        }
        d = list.get(0);
        if (!d.getName().equals(dimName)) {
            return null;
        }
        units = latVar.findAttribute("units").getStringValue();
        if (!SimpleUnit.isCompatible(units, "deg")) {
            return null;
        }
        trajStructure.addMemberVariable(latVar);
        Variable lonVar = ncd.getRootGroup().findVariable(lonVarName);
        if (lonVar == null) {
            return null;
        }
        list = lonVar.getDimensions();
        if (list.size() != 1) {
            return null;
        }
        d = list.get(0);
        if (!d.getName().equals(dimName)) {
            return null;
        }
        units = lonVar.findAttribute("units").getStringValue();
        if (!SimpleUnit.isCompatible(units, "deg")) {
            return null;
        }
        trajStructure.addMemberVariable(lonVar);
        Variable elevVar = ncd.getRootGroup().findVariable(elevVarName);
        if (elevVar == null) {
            return null;
        }
        list = elevVar.getDimensions();
        if (list.size() != 1) {
            return null;
        }
        d = list.get(0);
        if (!d.getName().equals(dimName)) {
            return null;
        }
        units = elevVar.findAttribute("units").getStringValue();
        if (!SimpleUnit.isCompatible(units, "km")) {
            return null;
        }
        trajStructure.addMemberVariable(elevVar);
        Variable timeVar = new Variable(ncd, null, null, "time");
        timeVar.setDataType(DataType.DOUBLE);
        timeVar.setDimensions(list);
        Date time = this.makeTime(ncd);
        ncd.setValues(timeVar, d.getLength(), time.getTime(), 0.0);
        timeVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        timeVar.addAttribute(new Attribute("units", "milliseconds since 1970-01-01 00:00 UTC"));
        trajStructure.addMemberVariable(timeVar);
        for (Variable curVar : ncd.getVariables()) {
            if (curVar.getRank() <= 0 || curVar.equals(dimVar) || curVar.equals(latVar) || curVar.equals(lonVar) || curVar.equals(elevVar) || trajStructure != null && curVar.equals(trajStructure)) continue;
            trajStructure.addMemberVariable(curVar);
        }
        ncd.addVariable(null, new StructureDS(null, trajStructure));
        return trajStructure;
    }

    Date makeTime(NetcdfDataset ds) {
        int year = ds.readAttributeInteger(null, "year", 0);
        int month = ds.readAttributeInteger(null, "month", 0);
        int dayOfMonth = ds.readAttributeInteger(null, "day", 0);
        int hourOfDay = ds.readAttributeInteger(null, "hour", 0);
        int minute = ds.readAttributeInteger(null, "minute", 0);
        int second = ds.readAttributeInteger(null, "second", 0);
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.clear();
        cal.set(year, month, dayOfMonth, hourOfDay, minute, second);
        return cal.getTime();
    }
}

