/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import java.util.IdentityHashMap;
import org.das2.datum.Datum;
import org.das2.datum.Units;

public class Basis {
    public static final Basis fahrenheit = new Basis("fahrenheit", "fahrenheit", physicalZero, 255.37, Units.celciusDegrees);
    public static final Basis kelvin = new Basis("kelvin", "kelvin", physicalZero, 0.0, Units.celciusDegrees);
    public static final Basis centigrade = new Basis("centigrade", "centigrade", physicalZero, 273.15, Units.celciusDegrees);
    public static final Basis since2000 = new Basis("since2000", "since 2000-01-01T00:00Z", null, 0.0, null);
    public static final Basis since2010 = new Basis("since2010", "since 2010-01-01T00:00Z", since2000, 3.156192E8, Units.seconds);
    public static final Basis since1980 = new Basis("since1980", "since 1980-01-01T00:00Z", since2000, -6.31152E8, Units.seconds);
    public static final Basis since1970 = new Basis("since1970", "since 1970-01-01T00:00Z", since2000, -9.380448E8, Units.seconds);
    public static final Basis since1958 = new Basis("since1958", "since 1958-01-01T00:00Z", since2000, -1.325376E9, Units.seconds);
    public static final Basis modifiedJulian = new Basis("modifiedJulian", "since 1858-11-17T00:00Z", since2000, 4.4534016E9, Units.seconds);
    public static final Basis since0000 = new Basis("since0000", "since 01-Jan-0000T00:00Z", since2000, 6.3113904E10, Units.seconds);
    public static final Basis physicalZero = new Basis("", "physical zero", null, 0.0, null);
    private IdentityHashMap<Basis, Datum> bases;
    private String id;
    private String description;
    private Basis parent;

    public Basis(String id, String description, Basis parent, double d, Units offsetUnits) {
        this.id = id;
        this.description = description;
        this.parent = parent;
        if (parent != null) {
            parent.bases.put(this, offsetUnits.createDatum(d));
        } else {
            this.bases = new IdentityHashMap();
        }
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    double getOffset(Basis basis, Units u) {
        if (this.parent == null) {
            return this.bases.get(basis).doubleValue(u);
        }
        double d0 = this.parent.bases.get(this).doubleValue(u);
        double d1 = this.parent.bases.get(basis).doubleValue(u);
        return d0 - d1;
    }

    public void registerConverter(Basis toBasis, double d, Units u) {
        this.bases.put(toBasis, u.createDatum(d));
    }

    public static void main(String[] args) {
        Basis since2010x = new Basis("since2010", "since 2010-01-01T00:00Z", since2000, 3.156192E14, Units.microseconds);
        Basis since2011 = new Basis("since2011", "since 2011-01-01T00:00Z", since2000, 3.471552E14, Units.microseconds);
        System.err.println(since2011.getOffset(since2010x, Units.days));
        System.err.println(centigrade.getOffset(fahrenheit, Units.fahrenheitDegrees));
    }
}

