/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.datum.Units;
import org.das2.datum.format.DatumFormatterFactory;
import org.das2.datum.format.EnumerationDatumFormatterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumerationUnits
extends Units {
    private HashMap<Integer, Datum> ordinals = new HashMap();
    private int highestOrdinal = 0;
    private HashMap<Object, Datum> objects = new HashMap();
    private HashMap<Datum, Object> invObjects = new HashMap();
    private static HashMap<Class, EnumerationUnits> unitsInstances;

    public EnumerationUnits(String id) {
        this(id, "");
    }

    public EnumerationUnits(String id, String description) {
        super(id, description);
    }

    public static Datum createDatumAndUnits(Object object) {
        return EnumerationUnits.create(object).createDatum(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum createDatum(int ival, Object object) {
        Datum d;
        if (this.objects.containsKey(object)) {
            return this.objects.get(object);
        }
        EnumerationUnits enumerationUnits = this;
        synchronized (enumerationUnits) {
            if (this.highestOrdinal < ival) {
                this.highestOrdinal = ival;
            }
        }
        Integer ordinal = ival;
        Datum.Double result = new Datum.Double(ordinal, (Units)this);
        if (this.ordinals.containsKey(ordinal) && !this.invObjects.get(d = this.ordinals.get(ordinal)).equals(object)) {
            throw new IllegalArgumentException("value already exists for this ordinal!");
        }
        this.ordinals.put(ordinal, result);
        this.invObjects.put(result, object);
        this.objects.put(object, result);
        return result;
    }

    public DatumVector createDatumVector(Object[] objects) {
        double[] doubles = new double[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            doubles[i] = this.createDatum(objects[i]).doubleValue(this);
        }
        return DatumVector.newDatumVector(doubles, (Units)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum createDatum(Object object) {
        if (this.objects.containsKey(object)) {
            return this.objects.get(object);
        }
        EnumerationUnits enumerationUnits = this;
        synchronized (enumerationUnits) {
            ++this.highestOrdinal;
        }
        Integer ordinal = this.highestOrdinal;
        Datum.Double result = new Datum.Double(ordinal, (Units)this);
        this.ordinals.put(ordinal, result);
        this.invObjects.put(result, object);
        this.objects.put(object, result);
        return result;
    }

    public Map<Integer, Datum> getValues() {
        return Collections.unmodifiableMap(this.ordinals);
    }

    @Override
    public Datum createDatum(int value) {
        Integer key = value;
        if (this.ordinals.containsKey(key)) {
            return this.ordinals.get(key);
        }
        throw new IllegalArgumentException("No Datum exists for this ordinal: " + value);
    }

    @Override
    public Datum createDatum(long value) {
        return this.createDatum((int)value);
    }

    @Override
    public Datum createDatum(Number value) {
        return this.createDatum(value.intValue());
    }

    public Object getObject(Datum datum) {
        if (this.invObjects.containsKey(datum)) {
            return this.invObjects.get(datum);
        }
        throw new IllegalArgumentException("This Datum doesn't map back to an object!  This shouldn't happen!");
    }

    public static synchronized EnumerationUnits create(Object o) {
        Class<?> c;
        if (unitsInstances == null) {
            unitsInstances = new HashMap();
        }
        if (unitsInstances.containsKey(c = o.getClass())) {
            return unitsInstances.get(c);
        }
        EnumerationUnits result = new EnumerationUnits(c.toString() + "Unit");
        unitsInstances.put(c, result);
        return result;
    }

    @Override
    public Datum createDatum(double d) {
        return this.createDatum((int)d);
    }

    @Override
    public Datum createDatum(double d, double resolution) {
        return this.createDatum((int)d);
    }

    @Override
    public DatumFormatterFactory getDatumFormatterFactory() {
        return EnumerationDatumFormatterFactory.getInstance();
    }

    @Override
    public Datum subtract(Number a, Number b, Units bUnits) {
        throw new IllegalArgumentException("subtract on EnumerationUnit");
    }

    @Override
    public Datum add(Number a, Number b, Units bUnits) {
        throw new IllegalArgumentException("add on EnumerationUnit");
    }

    @Override
    public Datum divide(Number a, Number b, Units bUnits) {
        throw new IllegalArgumentException("divide on EnumerationUnit");
    }

    @Override
    public Datum multiply(Number a, Number b, Units bUnits) {
        throw new IllegalArgumentException("multiply on EnumerationUnit");
    }

    @Override
    public Datum parse(String s) throws ParseException {
        Datum result = null;
        for (Object key : this.objects.keySet()) {
            Datum value = this.objects.get(key);
            if (!key.toString().equals(s)) continue;
            if (result == null) {
                result = this.objects.get(key);
                continue;
            }
            throw new IllegalStateException("Multiple Objects' string representations match");
        }
        if (result == null) {
            throw new ParseException("no objects match \"" + s + "\"", 0);
        }
        return result;
    }

    public int getHighestOrdinal() {
        return this.highestOrdinal;
    }

    @Override
    public String toString() {
        return this.getId() + "(ordinal)";
    }
}

