/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.das2.datum.Basis;
import org.das2.datum.Datum;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.LocationUnits;
import org.das2.datum.NumberUnits;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.UnitsConverter;
import org.das2.datum.format.DatumFormatterFactory;

public abstract class Units {
    private static Map unitsMap = new HashMap();
    public static final Units dimensionless = new NumberUnits("", "dimensionless quantities");
    public static final Units radians = new NumberUnits("radian");
    public static final Units degrees = new NumberUnits("degrees");
    public static final Units celciusDegrees;
    public static final Units fahrenheitDegrees;
    public static final Units hours;
    public static final Units minutes;
    public static final Units seconds;
    public static final Units milliseconds;
    public static final Units microseconds;
    public static final Units nanoseconds;
    public static final Units picoseconds;
    public static final Units days;
    public static final Units bytesPerSecond;
    public static final Units kiloBytesPerSecond;
    public static final Units bytes;
    public static final Units kiloBytes;
    public static final Units hertz;
    public static final Units kiloHertz;
    public static final Units megaHertz;
    public static final Units eV;
    public static final Units pcm3;
    public static final Units kelvin;
    public static final Units cmps;
    public static final Units v2pm2Hz;
    public static final Units wpm2;
    public static final Units inches;
    public static final Units meters;
    public static final Units kiloMeters;
    public static final Units centigrade;
    public static final Units fahrenheitScale;
    public static final TimeLocationUnits us2000;
    public static final TimeLocationUnits us1980;
    public static final TimeLocationUnits t2010;
    public static final TimeLocationUnits t2000;
    public static final TimeLocationUnits t1970;
    public static final TimeLocationUnits mj1958;
    public static final TimeLocationUnits mjd;
    public static final TimeLocationUnits cdfEpoch;
    public static final Units percent;
    public static final Units dB;
    public static final Units percentIncrease;
    public static final Units log10Ratio;
    public static final Units logERatio;
    private String id;
    private String description;
    private Map conversionMap = new IdentityHashMap();
    private static final double FILL_DOUBLE = -1.0E31;
    private static final float FILL_FLOAT = -1.0E31f;
    private static final int FILL_INT = Integer.MAX_VALUE;
    private static final long FILL_LONG = Long.MAX_VALUE;

    protected Units(String id) {
        this(id, "");
    }

    protected Units(String id, String description) {
        this.id = id;
        this.description = description;
        unitsMap.put(id, this);
    }

    public String getId() {
        return this.id;
    }

    public void registerConverter(Units toUnits, UnitsConverter converter) {
        this.conversionMap.put(toUnits, converter);
        UnitsConverter inverse = (UnitsConverter)toUnits.conversionMap.get(this);
        if (inverse == null || inverse.getInverse() != converter) {
            toUnits.registerConverter(this, converter.getInverse());
        }
    }

    public Units[] getConvertableUnits() {
        HashSet<Units> result = new HashSet<Units>();
        LinkedList<Units> queue = new LinkedList<Units>();
        queue.add(this);
        while (!queue.isEmpty()) {
            Units current = (Units)queue.removeFirst();
            for (Map.Entry entry : current.conversionMap.entrySet()) {
                Units next = (Units)entry.getKey();
                if (result.contains(next)) continue;
                queue.add(next);
                result.add(next);
            }
        }
        return result.toArray(new Units[result.size()]);
    }

    public boolean isConvertableTo(Units toUnits) {
        UnitsConverter result = Units.getConverterInternal(this, toUnits);
        return result != null;
    }

    public static UnitsConverter getConverter(Units fromUnits, Units toUnits) {
        UnitsConverter result = Units.getConverterInternal(fromUnits, toUnits);
        if (result == null) {
            throw new InconvertibleUnitsException(fromUnits, toUnits);
        }
        return result;
    }

    private static synchronized UnitsConverter getConverterInternal(Units fromUnits, Units toUnits) {
        if (fromUnits == toUnits) {
            return UnitsConverter.IDENTITY;
        }
        if (fromUnits.conversionMap.get(toUnits) != null) {
            return (UnitsConverter)fromUnits.conversionMap.get(toUnits);
        }
        HashMap<Units, Units> visited = new HashMap<Units, Units>();
        visited.put(fromUnits, null);
        LinkedList<Units> queue = new LinkedList<Units>();
        queue.add(fromUnits);
        while (!queue.isEmpty()) {
            Units current = (Units)queue.removeFirst();
            for (Map.Entry entry : current.conversionMap.entrySet()) {
                Units next = (Units)entry.getKey();
                if (visited.containsKey(next)) continue;
                visited.put(next, current);
                queue.add(next);
                if (next != toUnits) continue;
                return Units.buildConversion(fromUnits, toUnits, visited);
            }
        }
        return null;
    }

    private static UnitsConverter buildConversion(Units fromUnits, Units toUnits, Map parentMap) {
        ArrayList<Units> list = new ArrayList<Units>();
        Units current = toUnits;
        while (current != null) {
            list.add(current);
            current = (Units)parentMap.get(current);
        }
        UnitsConverter converter = UnitsConverter.IDENTITY;
        for (int i = list.size() - 1; i > 0; --i) {
            Units a = (Units)list.get(i);
            Units b = (Units)list.get(i - 1);
            UnitsConverter c = (UnitsConverter)a.conversionMap.get(b);
            converter = converter.append(c);
        }
        fromUnits.registerConverter(toUnits, converter);
        return converter;
    }

    public UnitsConverter getConverter(Units toUnits) {
        return Units.getConverter(this, toUnits);
    }

    public final double convertDoubleTo(Units toUnits, double value) {
        if (this == toUnits) {
            return value;
        }
        return Units.getConverter(this, toUnits).convert(value);
    }

    public String toString() {
        return this.id;
    }

    public Units getOffsetUnits() {
        return this;
    }

    public Basis getBasis() {
        return Basis.physicalZero;
    }

    public abstract Datum createDatum(double var1);

    public abstract Datum createDatum(int var1);

    public abstract Datum createDatum(long var1);

    public abstract Datum createDatum(Number var1);

    public abstract Datum createDatum(double var1, double var3);

    public double getFillDouble() {
        return -1.0E31;
    }

    public float getFillFloat() {
        return -1.0E31f;
    }

    public int getFillInt() {
        return Integer.MAX_VALUE;
    }

    public long getFillLong() {
        return Long.MAX_VALUE;
    }

    public Datum getFillDatum() {
        return this.createDatum(-1.0E31);
    }

    public boolean isFill(double value) {
        return value < -1.0E30 || Double.isNaN(value);
    }

    public boolean isFill(float value) {
        return value < -1.0E30f || Float.isNaN(value);
    }

    public boolean isFill(long value) {
        return value == Long.MAX_VALUE;
    }

    public boolean isFill(int value) {
        return value == Integer.MAX_VALUE;
    }

    public boolean isFill(Number value) {
        if (value instanceof Double) {
            return this.isFill(value.doubleValue());
        }
        if (value instanceof Float) {
            return this.isFill(value.floatValue());
        }
        if (value instanceof Integer) {
            return this.isFill(value.intValue());
        }
        if (value instanceof Long) {
            return this.isFill(value.longValue());
        }
        throw new IllegalArgumentException("Unknown Number class: " + value.getClass().toString());
    }

    public boolean isValid(double value) {
        return !Double.isNaN(value) && value > -1.0E30;
    }

    public abstract DatumFormatterFactory getDatumFormatterFactory();

    public abstract Datum parse(String var1) throws ParseException;

    public String format(Datum datum) {
        return this.getDatumFormatterFactory().defaultFormatter().format(datum);
    }

    public String grannyFormat(Datum datum) {
        return this.getDatumFormatterFactory().defaultFormatter().grannyFormat(datum);
    }

    public abstract Datum add(Number var1, Number var2, Units var3);

    public abstract Datum subtract(Number var1, Number var2, Units var3);

    public abstract Datum multiply(Number var1, Number var2, Units var3);

    public abstract Datum divide(Number var1, Number var2, Units var3);

    public static Units getByName(String s) {
        Units units = (Units)unitsMap.get(s);
        if (units == null) {
            throw new IllegalArgumentException("Unrecognized units: " + s);
        }
        return units;
    }

    public static void main(String[] args) throws ParseException {
        Datum ratio = Datum.create(100);
        Datum db = ratio.convertTo(dB);
        System.out.println("ratio: " + ratio);
        System.out.println("dB: " + db);
        Datum Hz = Datum.create(1000000.0, hertz);
        Datum kHz = Hz.convertTo(kiloHertz);
        Datum MHz = kHz.convertTo(megaHertz);
        System.out.println("Hz: " + Hz);
        System.out.println("kHz: " + kHz);
        System.out.println("MHz: " + MHz);
    }

    static {
        degrees.registerConverter(radians, new UnitsConverter.ScaleOffset(Math.PI / 180, 0.0));
        celciusDegrees = new NumberUnits("celcius degrees");
        fahrenheitDegrees = new NumberUnits("fahrenheit degrees");
        hours = new NumberUnits("hr");
        minutes = new NumberUnits("min");
        seconds = new NumberUnits("s");
        milliseconds = new NumberUnits("ms");
        microseconds = new NumberUnits("microseconds");
        nanoseconds = new NumberUnits("nanoseconds");
        picoseconds = new NumberUnits("picoseconds");
        days = new NumberUnits("days");
        seconds.registerConverter(milliseconds, UnitsConverter.MILLI);
        seconds.registerConverter(microseconds, UnitsConverter.MICRO);
        seconds.registerConverter(nanoseconds, UnitsConverter.NANO);
        seconds.registerConverter(picoseconds, UnitsConverter.PICO);
        microseconds.registerConverter(nanoseconds, UnitsConverter.MILLI);
        hours.registerConverter(seconds, new UnitsConverter.ScaleOffset(3600.0, 0.0));
        minutes.registerConverter(seconds, new UnitsConverter.ScaleOffset(60.0, 0.0));
        days.registerConverter(seconds, new UnitsConverter.ScaleOffset(86400.0, 0.0));
        bytesPerSecond = new NumberUnits("bytes/s");
        kiloBytesPerSecond = new NumberUnits("KBytes/s");
        bytes = new NumberUnits("bytes");
        kiloBytes = new NumberUnits("KBytes");
        bytesPerSecond.registerConverter(kiloBytesPerSecond, UnitsConverter.KILO);
        bytes.registerConverter(kiloBytes, UnitsConverter.KILO);
        hertz = new NumberUnits("Hz");
        kiloHertz = new NumberUnits("kHz");
        megaHertz = new NumberUnits("MHz");
        hertz.registerConverter(kiloHertz, UnitsConverter.KILO);
        hertz.registerConverter(megaHertz, UnitsConverter.MEGA);
        eV = new NumberUnits("eV");
        pcm3 = new NumberUnits("cm!a-3!n");
        kelvin = new NumberUnits("K");
        cmps = new NumberUnits("cm/s");
        v2pm2Hz = new NumberUnits("V!a2!nm!a-2!nHz!a-1");
        wpm2 = new NumberUnits("W/m!a-2!n");
        inches = new NumberUnits("inch");
        meters = new NumberUnits("m");
        kiloMeters = new NumberUnits("km");
        meters.registerConverter(kiloMeters, UnitsConverter.KILO);
        centigrade = new LocationUnits("centigrade", "centigrade", celciusDegrees, Basis.centigrade);
        fahrenheitScale = new LocationUnits("deg F", "deg F", fahrenheitDegrees, Basis.fahrenheit);
        centigrade.registerConverter(fahrenheitScale, new UnitsConverter.ScaleOffset(1.8, 32.0));
        celciusDegrees.registerConverter(fahrenheitDegrees, new UnitsConverter.ScaleOffset(1.8, 0.0));
        us2000 = new TimeLocationUnits("us2000", "Microseconds since midnight Jan 1, 2000.", microseconds, Basis.since2000);
        us1980 = new TimeLocationUnits("us1980", "Microseconds since midnight Jan 1, 1980.", microseconds, Basis.since1980);
        t2010 = new TimeLocationUnits("t2010", "Seconds since midnight Jan 1, 2010.", seconds, Basis.since2010);
        t2000 = new TimeLocationUnits("t2000", "Seconds since midnight Jan 1, 2000.", seconds, Basis.since2000);
        t1970 = new TimeLocationUnits("t1970", "Seconds since midnight Jan 1, 1970", seconds, Basis.since1970);
        mj1958 = new TimeLocationUnits("mj1958", "Julian - 2436204.5", days, Basis.since1958);
        mjd = new TimeLocationUnits("mjd", "days since midnight November 17, 1858.", days, Basis.modifiedJulian);
        cdfEpoch = new TimeLocationUnits("cdfEpoch", "milliseconds since 01-Jan-0000", milliseconds, Basis.since0000);
        t2000.registerConverter(us2000, UnitsConverter.MICRO);
        us1980.registerConverter(us2000, new UnitsConverter.ScaleOffset(1.0, -6.31152E14));
        us2000.registerConverter(cdfEpoch, new UnitsConverter.ScaleOffset(0.001, 6.3113904E13));
        t2000.registerConverter(t1970, new UnitsConverter.ScaleOffset(1.0, 9.466848E8));
        t2000.registerConverter(t2010, new UnitsConverter.ScaleOffset(1.0, -3.156192E8));
        t2000.registerConverter(mj1958, new UnitsConverter.ScaleOffset(1.1574074074074073E-5, 15340.0));
        t2000.registerConverter(mjd, new UnitsConverter.ScaleOffset(1.1574074074074073E-5, 51544.0));
        percent = new NumberUnits("%", "");
        dB = new NumberUnits("dB", "decibels");
        percentIncrease = new NumberUnits("% diff", "Special dimensionless number, useful for expressing on logarithmic scale.  100% indicates a doubling");
        log10Ratio = new NumberUnits("log10Ratio", "Special dimensionless number, useful for expressing distances on a log10 scale");
        logERatio = new NumberUnits("logERatio", "Special dimensionless number, useful for expressing distances on a logE scale");
        log10Ratio.registerConverter(logERatio, new UnitsConverter.ScaleOffset(Math.log(10.0), 0.0));
        logERatio.registerConverter(percentIncrease, new PercentRatioConverter());
        dB.registerConverter(log10Ratio, new UnitsConverter.ScaleOffset(10.0, 0.0));
    }

    private static class PercentRatioConverter
    extends UnitsConverter {
        private PercentRatioConverter() {
        }

        public double convert(double value) {
            return (Math.exp(value) - 1.0) * 100.0;
        }

        public UnitsConverter getInverse() {
            if (this.inverse == null) {
                this.inverse = new UnitsConverter(){

                    public double convert(double value) {
                        return Math.log(value / 100.0 + 1.0);
                    }

                    public UnitsConverter getInverse() {
                        return PercentRatioConverter.this;
                    }
                };
            }
            return this.inverse;
        }
    }

    private static final class dBConverter
    extends UnitsConverter {
        private dBConverter() {
        }

        public double convert(double value) {
            return 10.0 * Math.log10(value);
        }

        public UnitsConverter getInverse() {
            if (this.inverse == null) {
                this.inverse = new UnitsConverter(){

                    public double convert(double value) {
                        return Math.pow(10.0, value / 10.0);
                    }

                    public UnitsConverter getInverse() {
                        return dBConverter.this;
                    }
                };
            }
            return this.inverse;
        }
    }
}

