/*
 * Decompiled with CFR 0.152.
 */
package org.das2.jythoncompletion;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.das2.jythoncompletion.CompletionContext;
import org.das2.jythoncompletion.Utilities;
import org.python.parser.CharStream;
import org.python.parser.PythonGrammar;
import org.python.parser.ReaderCharStream;
import org.python.parser.Token;
import org.python.parser.TokenMgrError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionSupport {
    private static String join(List<Token> tokens, int offset, int end) {
        StringBuffer result = new StringBuffer(tokens.get((int)offset).image);
        for (int i = 1; i < end - offset; ++i) {
            result.append(tokens.get((int)(offset + i)).image);
        }
        return result.toString();
    }

    public static CompletionContext getCompletionContext(JTextComponent editor) throws BadLocationException {
        int pos = editor.getCaretPosition();
        int i0 = Utilities.getRowStart(editor, pos);
        int i2 = Utilities.getRowEnd(editor, pos);
        String line = editor.getText(i0, i2 - i0);
        int i1 = i0;
        if (i1 == i2) {
            return new CompletionContext("default", null, "");
        }
        i2 = pos -= i0;
        i1 -= i0;
        i0 = 0;
        return CompletionSupport.getCompletionContext(line, pos, i0, i1, i2);
    }

    private static String preProcess(String line, int pos) {
        boolean inQuote;
        char squote = '\'';
        int i = line.indexOf(squote);
        String[] ss = line.substring(0, pos).split("'", -2);
        boolean bl = inQuote = ss.length % 2 == 0;
        if (inQuote) {
            i = line.indexOf(squote, pos);
            if (i == -1) {
                return line.substring(0, pos) + squote;
            }
            return line.substring(0, i + 1);
        }
        squote = '\"';
        i = line.indexOf(squote);
        ss = line.substring(0, pos).split("\"", -2);
        boolean bl2 = inQuote = ss.length % 2 == 0;
        if (inQuote) {
            i = line.indexOf(squote, pos);
            if (i == -1) {
                return line.substring(0, pos) + squote;
            }
            return line.substring(0, i + 1);
        }
        return line.substring(0, pos);
    }

    private static String exprBeforeDot(List<Token> tokens, int pos) {
        String contextString = tokens.get((int)(pos - 1)).image;
        int i = pos - 1;
        if (i > 1 && (tokens.get((int)(pos - 1)).kind == 19 || tokens.get((int)(pos - 1)).kind == 23)) {
            int rparCount = tokens.get((int)(pos - 1)).kind == 19 ? 1 : 0;
            int rbackCount = tokens.get((int)(pos - 1)).kind == 23 ? 1 : 0;
            for (int lpar = i - 1; lpar > 0 && (rparCount > 0 || rbackCount > 0); --lpar) {
                contextString = tokens.get((int)lpar).image + contextString;
                if (lpar >= 0 && tokens.get((int)lpar).kind == 18) {
                    --rparCount;
                } else if (lpar >= 0 && tokens.get((int)lpar).kind == 19) {
                    ++rparCount;
                } else if (lpar >= 0 && tokens.get((int)lpar).kind == 22) {
                    --rbackCount;
                } else if (lpar >= 0 && tokens.get((int)lpar).kind == 23) {
                    ++rbackCount;
                }
                if (rparCount != 0 || lpar <= 0 || tokens.get((int)(lpar - 1)).kind != 91) continue;
                contextString = tokens.get((int)(lpar - 1)).image + contextString;
                if (lpar > 1 && tokens.get((int)(lpar - 2)).kind == 26) {
                    String before = CompletionSupport.exprBeforeDot(tokens, lpar - 2);
                    return before + "." + contextString;
                }
                return contextString;
            }
        }
        boolean notdone = true;
        boolean bl = notdone = i > 1 && tokens.get((int)(i - 1)).kind == 26;
        while (notdone) {
            if (tokens.get((int)(i - 2)).kind == 23 && i >= 5 && tokens.get((int)(i - 4)).kind == 22 && tokens.get((int)(i - 5)).kind == 91) {
                contextString = tokens.get((int)(i - 5)).image + tokens.get((int)(i - 4)).image + tokens.get((int)(i - 3)).image + tokens.get((int)(i - 2)).image + tokens.get((int)(i - 1)).image + contextString;
                i -= 5;
            } else if (tokens.get((int)(i - 2)).kind == 19 && i >= 4 && tokens.get((int)(i - 3)).kind == 18) {
                contextString = tokens.get((int)(i - 4)).image + tokens.get((int)(i - 3)).image + tokens.get((int)(i - 2)).image + tokens.get((int)(i - 1)).image + contextString;
                i -= 4;
            } else {
                contextString = tokens.get((int)(i - 2)).image + tokens.get((int)(i - 1)).image + contextString;
                i -= 2;
            }
            notdone = i > 1 && tokens.get((int)(i - 1)).kind == 26;
        }
        return contextString;
    }

    public static CompletionContext getCompletionContext(String line, int pos, int i0, int i1, int i2) {
        Token t;
        ArrayList<Token> tokens = new ArrayList<Token>(20);
        int myTokenIndex = -1;
        int thisTokenIndex = -1;
        int lastTokenEndPos = -1;
        String completable = null;
        line = CompletionSupport.preProcess(line, pos);
        PythonGrammar g = new PythonGrammar((CharStream)new ReaderCharStream((Reader)new StringReader(line)));
        do {
            try {
                t = g.getNextToken();
            }
            catch (TokenMgrError ex) {
                return new CompletionContext("default", null, "");
            }
            ++thisTokenIndex;
            tokens.add(t);
            if (myTokenIndex == -1 && pos <= t.endColumn) {
                myTokenIndex = thisTokenIndex;
                completable = pos >= t.beginColumn && t.image.length() >= pos + 1 - t.beginColumn ? t.image.substring(0, pos + 1 - t.beginColumn) : "";
            }
            lastTokenEndPos = t.endColumn;
        } while (t.kind != 0 && t.kind != 6);
        if (myTokenIndex == -1 && pos >= lastTokenEndPos) {
            myTokenIndex = thisTokenIndex;
            completable = "";
        }
        CompletionContext result = null;
        if (tokens.size() == 0) {
            return new CompletionContext("default", null, "");
        }
        if (((Token)tokens.get((int)0)).kind == 84) {
            int importTokenIndex = -1;
            for (int i = 1; importTokenIndex == -1 && i < tokens.size(); ++i) {
                if (((Token)tokens.get((int)i)).kind != 83) continue;
                importTokenIndex = i;
            }
            if (importTokenIndex != -1 && myTokenIndex > importTokenIndex) {
                result = new CompletionContext("module", CompletionSupport.join(tokens, 1, importTokenIndex), completable);
            } else if (myTokenIndex < importTokenIndex || importTokenIndex == -1) {
                int ti = myTokenIndex;
                if (((Token)tokens.get((int)(ti - 1))).kind == 26) {
                    --ti;
                }
                if (((Token)tokens.get((int)myTokenIndex)).kind == 26) {
                    completable = "";
                }
                result = new CompletionContext("package", CompletionSupport.join(tokens, 1, ti), completable);
            }
        } else if (((Token)tokens.get((int)0)).kind == 83) {
            if (completable.equals(".")) {
                completable = "";
            }
            if (((Token)tokens.get((int)(myTokenIndex - 1))).image.equals(".")) {
                --myTokenIndex;
            }
            result = new CompletionContext("package", CompletionSupport.join(tokens, 1, myTokenIndex), completable);
        } else {
            if (((Token)tokens.get((int)myTokenIndex)).kind == 26 && ((Token)tokens.get((int)(myTokenIndex - 1))).kind == 91) {
                String contextString = CompletionSupport.exprBeforeDot(tokens, myTokenIndex);
                return new CompletionContext("method", contextString, "");
            }
            if (((Token)tokens.get((int)myTokenIndex)).kind == 26 && ((Token)tokens.get((int)(myTokenIndex - 1))).kind == 19) {
                String contextString = CompletionSupport.exprBeforeDot(tokens, myTokenIndex);
                return new CompletionContext("method", contextString, "");
            }
            if (((Token)tokens.get((int)myTokenIndex)).kind == 26 && ((Token)tokens.get((int)(myTokenIndex - 1))).kind == 23) {
                String contextString = CompletionSupport.exprBeforeDot(tokens, myTokenIndex);
                return new CompletionContext("method", contextString, "");
            }
            if (myTokenIndex > 2 && ((Token)tokens.get((int)myTokenIndex)).kind == 91 && ((Token)tokens.get((int)(myTokenIndex - 1))).kind == 26 && ((Token)tokens.get((int)(myTokenIndex - 2))).kind == 23) {
                String contextString = CompletionSupport.exprBeforeDot(tokens, myTokenIndex - 1);
                return new CompletionContext("method", contextString, completable);
            }
            if (myTokenIndex > 1 && ((Token)tokens.get((int)(myTokenIndex - 1))).kind == 26 && ((Token)tokens.get((int)(myTokenIndex - 2))).kind == 91) {
                String contextString = CompletionSupport.exprBeforeDot(tokens, myTokenIndex - 1);
                return new CompletionContext("method", contextString, completable);
            }
            if (myTokenIndex > 1 && ((Token)tokens.get((int)(myTokenIndex - 1))).kind == 26 && ((Token)tokens.get((int)(myTokenIndex - 2))).kind == 19) {
                String contextString = CompletionSupport.exprBeforeDot(tokens, myTokenIndex - 1);
                return new CompletionContext("method", contextString, ((Token)tokens.get((int)myTokenIndex)).image);
            }
            if (((Token)tokens.get((int)myTokenIndex)).kind == 108 || ((Token)tokens.get((int)myTokenIndex)).kind == 109) {
                if (myTokenIndex > 1 && ((Token)tokens.get((int)(myTokenIndex - 2))).kind == 91) {
                    return new CompletionContext("stringLiteralArgument", ((Token)tokens.get((int)(myTokenIndex - 2))).image, ((Token)tokens.get((int)myTokenIndex)).image);
                }
                return null;
            }
            if (((Token)tokens.get((int)0)).kind == 91) {
                return new CompletionContext("default", null, completable);
            }
        }
        if (result == null) {
            return new CompletionContext("default", null, completable);
        }
        return result;
    }
}

