/*
 * Decompiled with CFR 0.152.
 */
package org.das2.jythoncompletion;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.das2.jythoncompletion.DataSetUrlCompletionItem;
import org.das2.jythoncompletion.Utilities;
import org.das2.jythoncompletion.support.CompletionResultSet;
import org.das2.jythoncompletion.support.CompletionTask;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSourceRegistry;
import org.virbo.datasource.URISplit;

class DataSetUrlCompletionTask
implements CompletionTask {
    JTextComponent editor;

    public DataSetUrlCompletionTask(JTextComponent arg1) {
        this.editor = arg1;
    }

    public void cancel() {
    }

    public void query(CompletionResultSet arg0) {
        try {
            int i0 = Utilities.getRowStart(this.editor, this.editor.getCaretPosition());
            int i1 = Utilities.getRowEnd(this.editor, this.editor.getCaretPosition()) - 1;
            String line = this.editor.getText(i0, i1 - i0);
            int ipos = this.editor.getCaretPosition() - i0;
            i0 = line.lastIndexOf(39, ipos - 1);
            boolean doubleQuotes = false;
            if (i0 == -1) {
                i0 = line.lastIndexOf(34, ipos - 1);
                if (i0 == -1) {
                    throw new IllegalArgumentException("expected single quote");
                }
                doubleQuotes = true;
            }
            ++i0;
            i1 = doubleQuotes ? line.indexOf(34, ipos) : line.indexOf(39, ipos);
            if (i1 == -1) {
                i1 = line.length();
            }
            String surl1 = line.substring(i0, i1);
            int carotPos = ipos - i0;
            URISplit split = URISplit.parse((String)surl1);
            List rs = surl1.contains("?") || DataSourceRegistry.getInstance().hasSourceByExt(split.ext) ? DataSetURI.getFactoryCompletions((String)surl1, (int)carotPos, (ProgressMonitor)new NullProgressMonitor()) : DataSetURI.getFileSystemCompletions((String)surl1, (int)carotPos, (boolean)true, (boolean)true, null, (ProgressMonitor)new NullProgressMonitor());
            for (DataSetURI.CompletionResult rs1 : rs) {
                arg0.addItem(new DataSetUrlCompletionItem(rs1));
            }
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
            Logger.getLogger(DataSetUrlCompletionTask.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Logger.getLogger(DataSetUrlCompletionTask.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void refresh(CompletionResultSet arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

