/*
 * Decompiled with CFR 0.152.
 */
package org.das2.jythoncompletion.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.das2.jythoncompletion.support.CompletionDocumentation;
import org.das2.jythoncompletion.support.CompletionItem;
import org.das2.jythoncompletion.ui.CompletionImpl;
import org.das2.jythoncompletion.ui.CompletionLayoutPopup;
import org.das2.jythoncompletion.ui.CompletionScrollPane;
import org.das2.jythoncompletion.ui.DocumentationScrollPane;

public final class CompletionLayout {
    public static final int COMPLETION_ITEM_HEIGHT = 16;
    private static final int COMPLETION_ANCHOR_HORIZONTAL_SHIFT = 22;
    static final int POPUP_VERTICAL_GAP = 1;
    private Reference<JTextComponent> editorComponentRef;
    private final CompletionPopup completionPopup = new CompletionPopup();
    private final DocPopup docPopup;
    private final TipPopup tipPopup;
    private Stack<CompletionLayoutPopup> visiblePopups;

    CompletionLayout() {
        this.completionPopup.setLayout(this);
        this.completionPopup.setPreferDisplayAboveCaret(false);
        this.docPopup = new DocPopup();
        this.docPopup.setLayout(this);
        this.docPopup.setPreferDisplayAboveCaret(false);
        this.tipPopup = new TipPopup();
        this.tipPopup.setLayout(this);
        this.tipPopup.setPreferDisplayAboveCaret(true);
        this.visiblePopups = new Stack();
    }

    public JTextComponent getEditorComponent() {
        return this.editorComponentRef != null ? this.editorComponentRef.get() : null;
    }

    public void setEditorComponent(JTextComponent editorComponent) {
        this.hideAll();
        this.editorComponentRef = new WeakReference<JTextComponent>(editorComponent);
    }

    private void hideAll() {
        this.completionPopup.hide();
        this.docPopup.hide();
        this.tipPopup.hide();
        this.visiblePopups.clear();
    }

    public void showCompletion(List data, String title, int anchorOffset, ListSelectionListener listSelectionListener, String shortcutHint, int selectedIndex) {
        this.completionPopup.show(data, title, anchorOffset, listSelectionListener, shortcutHint, selectedIndex);
        if (!this.visiblePopups.contains(this.completionPopup)) {
            this.visiblePopups.push(this.completionPopup);
        }
    }

    public boolean hideCompletion() {
        if (this.completionPopup.isVisible()) {
            this.completionPopup.hide();
            this.completionPopup.completionScrollPane = null;
            this.visiblePopups.remove(this.completionPopup);
            return true;
        }
        return false;
    }

    public boolean isCompletionVisible() {
        return this.completionPopup.isVisible();
    }

    public CompletionItem getSelectedCompletionItem() {
        return this.completionPopup.getSelectedCompletionItem();
    }

    public int getSelectedIndex() {
        return this.completionPopup.getSelectedIndex();
    }

    public void processKeyEvent(KeyEvent evt) {
        for (int i = this.visiblePopups.size() - 1; i >= 0; --i) {
            CompletionLayoutPopup popup = (CompletionLayoutPopup)this.visiblePopups.get(i);
            popup.processKeyEvent(evt);
            if (!evt.isConsumed()) continue;
            return;
        }
    }

    public void showDocumentation(CompletionDocumentation doc, int anchorOffset) {
        this.docPopup.show(doc, anchorOffset);
        if (!this.visiblePopups.contains(this.docPopup)) {
            this.visiblePopups.push(this.docPopup);
        }
    }

    public boolean hideDocumentation() {
        if (this.docPopup.isVisible()) {
            ((DocPopup)this.docPopup).getDocumentationScrollPane().currentDocumentation = null;
            this.docPopup.clearHistory();
            this.docPopup.hide();
            this.visiblePopups.remove(this.docPopup);
            return true;
        }
        return false;
    }

    public boolean isDocumentationVisible() {
        return this.docPopup.isVisible();
    }

    public void clearDocumentationHistory() {
        this.docPopup.clearHistory();
    }

    public void showToolTip(JToolTip toolTip, int anchorOffset) {
        this.tipPopup.show(toolTip, anchorOffset);
        if (!this.visiblePopups.contains(this.tipPopup)) {
            this.visiblePopups.push(this.tipPopup);
        }
    }

    public boolean hideToolTip() {
        if (this.tipPopup.isVisible()) {
            this.tipPopup.hide();
            this.visiblePopups.remove(this.tipPopup);
            return true;
        }
        return false;
    }

    public boolean isToolTipVisible() {
        return this.tipPopup.isVisible();
    }

    void updateLayout(CompletionLayoutPopup popup) {
        popup.resetPreferredSize();
        if (popup == this.completionPopup) {
            if (this.isToolTipVisible()) {
                boolean wantAboveCaret;
                boolean bl = wantAboveCaret = !this.tipPopup.isDisplayAboveCaret();
                if (this.completionPopup.isEnoughSpace(wantAboveCaret)) {
                    this.completionPopup.showAlongAnchorBounds(wantAboveCaret);
                } else {
                    Rectangle occupiedBounds = popup.getAnchorOffsetBounds();
                    occupiedBounds = this.tipPopup.unionBounds(occupiedBounds);
                    this.completionPopup.showAlongOccupiedBounds(occupiedBounds, this.tipPopup.isDisplayAboveCaret());
                }
            } else {
                popup.showAlongAnchorBounds();
            }
            if (this.docPopup.isVisible() && (this.docPopup.isOverlapped(popup) || this.docPopup.isOverlapped(this.tipPopup) || this.docPopup.getAnchorOffset() != this.completionPopup.getAnchorOffset() || !this.docPopup.isShowRetainedPreferredSize())) {
                this.updateLayout(this.docPopup);
            }
        } else if (popup == this.docPopup) {
            if (this.isCompletionVisible()) {
                popup.setAnchorOffset(this.completionPopup.getAnchorOffset());
            }
            Rectangle occupiedBounds = popup.getAnchorOffsetBounds();
            occupiedBounds = this.tipPopup.unionBounds(this.completionPopup.unionBounds(occupiedBounds));
            this.docPopup.showAlongOccupiedBounds(occupiedBounds);
        } else if (popup == this.tipPopup) {
            popup.showAlongAnchorBounds();
            if (this.completionPopup.isOverlapped(popup) || this.docPopup.isOverlapped(popup)) {
                this.updateLayout(this.completionPopup);
            }
        }
    }

    CompletionPopup testGetCompletionPopup() {
        return this.completionPopup;
    }

    private static final class TipPopup
    extends CompletionLayoutPopup {
        private TipPopup() {
        }

        protected void show(JToolTip toolTip, int anchorOffset) {
            JComponent lastComponent = null;
            if (this.isVisible()) {
                lastComponent = this.getContentComponent();
            }
            this.setContentComponent(toolTip);
            this.setAnchorOffset(anchorOffset);
            if (lastComponent != toolTip) {
                this.getLayout().updateLayout(this);
            }
        }

        public void processKeyEvent(KeyEvent evt) {
            if (this.isVisible() && KeyStroke.getKeyStroke(27, 0).equals(KeyStroke.getKeyStrokeForEvent(evt))) {
                evt.consume();
                CompletionImpl.get().hideToolTip();
            }
        }
    }

    private static final class DocPopup
    extends CompletionLayoutPopup {
        private DocPopup() {
        }

        private DocumentationScrollPane getDocumentationScrollPane() {
            return (DocumentationScrollPane)this.getContentComponent();
        }

        protected void show(CompletionDocumentation doc, int anchorOffset) {
            JTextComponent editorComponent = this.getEditorComponent();
            if (editorComponent == null) {
                return;
            }
            if (!this.isVisible()) {
                this.setContentComponent(new DocumentationScrollPane(editorComponent));
            }
            this.getDocumentationScrollPane().setData(doc);
            if (!this.isVisible()) {
                this.setAnchorOffset(anchorOffset);
                this.getLayout().updateLayout(this);
            }
        }

        public void processKeyEvent(KeyEvent evt) {
            Action action;
            Object actionMapKey;
            if (this.isVisible() && (actionMapKey = this.getDocumentationScrollPane().getInputMap().get(KeyStroke.getKeyStrokeForEvent(evt))) != null && (action = this.getDocumentationScrollPane().getActionMap().get(actionMapKey)) != null) {
                action.actionPerformed(new ActionEvent(this.getDocumentationScrollPane(), 0, null));
                evt.consume();
            }
        }

        public void clearHistory() {
            if (this.isVisible()) {
                this.getDocumentationScrollPane().clearHistory();
            }
        }

        protected int getAnchorHorizontalShift() {
            return 22;
        }
    }

    private static final class CompletionPopup
    extends CompletionLayoutPopup {
        private CompletionScrollPane completionScrollPane;

        private CompletionPopup() {
        }

        public void show(List data, String title, int anchorOffset, ListSelectionListener listSelectionListener, String shortcutHint, int selectedIndex) {
            Dimension lastSize;
            JTextComponent editorComponent = this.getEditorComponent();
            if (editorComponent == null) {
                return;
            }
            int lastAnchorOffset = this.getAnchorOffset();
            if (this.isVisible() && this.getContentComponent() == this.completionScrollPane ^ shortcutHint != null) {
                lastSize = this.getContentComponent().getSize();
                this.resetPreferredSize();
            } else {
                lastSize = new Dimension(0, 0);
                this.completionScrollPane = new CompletionScrollPane(editorComponent, listSelectionListener, new MouseAdapter(){

                    public void mouseClicked(MouseEvent evt) {
                        CompletionItem selectedItem;
                        JTextComponent c = CompletionPopup.this.getEditorComponent();
                        if (SwingUtilities.isLeftMouseButton(evt) && c != null && evt.getClickCount() == 2 && (selectedItem = CompletionPopup.this.completionScrollPane.getSelectedCompletionItem()) != null) {
                            LogRecord r = new LogRecord(Level.FINE, "COMPL_MOUSE_SELECT");
                            r.setParameters(new Object[]{null, CompletionPopup.this.completionScrollPane.getSelectedIndex(), selectedItem.getClass().getSimpleName()});
                            CompletionImpl.uilog(r);
                            selectedItem.defaultAction(c);
                        }
                    }
                });
                if (shortcutHint != null) {
                    JPanel panel = new JPanel();
                    panel.setLayout(new BorderLayout());
                    panel.add((Component)this.completionScrollPane, "Center");
                    JLabel label = new JLabel();
                    label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.white), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, Color.gray), BorderFactory.createEmptyBorder(2, 2, 2, 2))));
                    label.setFont(label.getFont().deriveFont((float)label.getFont().getSize() - 2.0f));
                    label.setHorizontalAlignment(4);
                    label.setText("TXT_completion_shortcut_tips");
                    panel.add((Component)label, "South");
                    this.setContentComponent(panel);
                } else {
                    this.setContentComponent(this.completionScrollPane);
                }
            }
            this.completionScrollPane.setData(data, title, selectedIndex);
            this.setAnchorOffset(anchorOffset);
            Dimension prefSize = this.getPreferredSize();
            boolean changePopupSize = this.isVisible() ? prefSize.height != lastSize.height || prefSize.width != lastSize.width || anchorOffset != lastAnchorOffset : true;
            if (changePopupSize) {
                this.getLayout().updateLayout(this);
            }
        }

        public CompletionItem getSelectedCompletionItem() {
            return this.isVisible() ? this.completionScrollPane.getSelectedCompletionItem() : null;
        }

        public int getSelectedIndex() {
            return this.isVisible() ? this.completionScrollPane.getSelectedIndex() : -1;
        }

        public void processKeyEvent(KeyEvent evt) {
            Action action;
            Object actionMapKey;
            if (this.isVisible() && (actionMapKey = this.completionScrollPane.getInputMap().get(KeyStroke.getKeyStrokeForEvent(evt))) != null && (action = this.completionScrollPane.getActionMap().get(actionMapKey)) != null) {
                action.actionPerformed(new ActionEvent(this.completionScrollPane, 0, null));
                evt.consume();
            }
        }

        protected int getAnchorHorizontalShift() {
            return 22;
        }
    }
}

