/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.jythonsupport;

import java.text.ParseException;
import org.das2.datum.Datum;
import org.das2.datum.DatumUtil;
import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyFloat;
import org.python.core.PyFunction;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.QubeDataSetIterator;
import org.virbo.dataset.WritableDataSet;
import org.virbo.jythonsupport.PyQDataSet;
import org.virbo.jythonsupport.PyQDataSetAdapter;

public class JythonOps {
    public static QDataSet applyLambda(QDataSet ds, PyFunction f) {
        QubeDataSetIterator it = new QubeDataSetIterator(ds);
        DDataSet result = DDataSet.create((int[])DataSetUtil.qubeDims((QDataSet)ds));
        while (it.hasNext()) {
            it.next();
            double d = it.getValue(ds);
            PyFloat r = (PyFloat)f.__call__((PyObject)new PyFloat(d));
            it.putValue((WritableDataSet)result, r.getValue());
        }
        return result;
    }

    public static QDataSet applyLambda(QDataSet ds1, QDataSet ds2, PyFunction f) {
        QubeDataSetIterator it = new QubeDataSetIterator(ds1);
        DDataSet result = DDataSet.create((int[])DataSetUtil.qubeDims((QDataSet)ds1));
        while (it.hasNext()) {
            it.next();
            double d1 = it.getValue(ds1);
            double d2 = it.getValue(ds2);
            PyFloat r = (PyFloat)f.__call__((PyObject)new PyFloat(d1), (PyObject)new PyFloat(d2));
            it.putValue((WritableDataSet)result, r.getValue());
        }
        return result;
    }

    public static QDataSet applyLambda(QDataSet ds1, QDataSet ds2, QDataSet ds3, PyFunction f) {
        QubeDataSetIterator it = new QubeDataSetIterator(ds1);
        DDataSet result = DDataSet.create((int[])DataSetUtil.qubeDims((QDataSet)ds1));
        while (it.hasNext()) {
            it.next();
            double d1 = it.getValue(ds1);
            double d2 = it.getValue(ds2);
            double d3 = it.getValue(ds3);
            PyFloat r = (PyFloat)f.__call__((PyObject)new PyFloat(d1), (PyObject)new PyFloat(d2), (PyObject)new PyFloat(d3));
            it.putValue((WritableDataSet)result, r.getValue());
        }
        return result;
    }

    public static QDataSet coerceToDs(PyObject arg0) {
        return JythonOps.dataset(arg0);
    }

    public static QDataSet dataset(PyObject arg0) {
        if (arg0 instanceof PyQDataSet) {
            return ((PyQDataSet)arg0).rods;
        }
        if (arg0 instanceof PyList) {
            return PyQDataSetAdapter.adaptList((PyList)arg0);
        }
        if (arg0 instanceof PyArray) {
            return PyQDataSetAdapter.adaptArray((PyArray)arg0);
        }
        if (arg0 instanceof PyInteger) {
            return DataSetUtil.asDataSet((double)((Double)arg0.__tojava__(Double.class)));
        }
        if (arg0 instanceof PyFloat) {
            return DataSetUtil.asDataSet((double)((Double)arg0.__tojava__(Double.class)));
        }
        if (arg0 instanceof PyString) {
            try {
                return DataSetUtil.asDataSet((Datum)DatumUtil.parse((String)arg0.toString()));
            }
            catch (ParseException ex) {
                throw Py.SyntaxError((String)("unable to parse string: " + arg0));
            }
        }
        throw Py.TypeError((String)("unable to coerce " + arg0 + " to QDataSet"));
    }

    public static void invokeSometime(final PyObject func) {
        Runnable run = new Runnable(){

            public void run() {
                func.__call__();
            }
        };
        new Thread(run).start();
    }

    public static void invokeSometime(final PyObject func, final PyObject arg) {
        Runnable run = new Runnable(){

            public void run() {
                func.__call__(arg);
            }
        };
        new Thread(run).start();
    }
}

