/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import java.util.ArrayList;
import java.util.List;
import org.virbo.dataset.AbstractDataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;

public class BundleDataSet
extends AbstractDataSet {
    List<QDataSet> datasets;
    int rank;
    int len0 = -1;

    public static BundleDataSet createRank0Bundle() {
        return new BundleDataSet(1);
    }

    public static BundleDataSet createRank1Bundle() {
        return new BundleDataSet(2);
    }

    public BundleDataSet() {
        this(2);
    }

    public BundleDataSet(int rank) {
        if (rank > 2) {
            throw new IllegalArgumentException("only rank 1 and 2 are supported.");
        }
        this.rank = rank;
        this.datasets = new ArrayList<QDataSet>();
        if (rank == 2) {
            this.putProperty("BUNDLE_1", new BundleDescriptor());
            this.putProperty("QUBE", Boolean.TRUE);
        } else {
            this.putProperty("BUNDLE_0", new BundleDescriptor());
        }
    }

    public void bundle(QDataSet ds) {
        if (ds.rank() != this.rank - 1) {
            throw new IllegalArgumentException("dataset rank must be " + (this.rank - 1));
        }
        if (this.rank > 1) {
            if (this.len0 == -1) {
                this.len0 = ds.length();
            } else if (ds.length() != this.len0) {
                throw new IllegalArgumentException("dataset length is not consistent with the bundle.");
            }
        }
        this.datasets.add(ds);
    }

    QDataSet unbundle(int i) {
        return this.datasets.get(i);
    }

    public int rank() {
        return this.rank;
    }

    public double value(int i0) {
        return this.datasets.get(i0).value();
    }

    public double value(int i0, int i1) {
        return this.datasets.get(i1).value(i0);
    }

    public Object property(String name, int i0) {
        if (this.rank == 1) {
            return this.datasets.get(i0).property(name);
        }
        return super.property(name);
    }

    public Object property(String name, int i0, int i1) {
        return this.datasets.get(i0).property(name, i1);
    }

    public int length() {
        return this.rank == 2 ? this.len0 : this.datasets.size();
    }

    public int length(int i0) {
        return this.datasets.size();
    }

    public String toString() {
        if (this.rank == 1) {
            return DataSetUtil.format(this);
        }
        if (this.datasets.size() > 4) {
            return "BundleDataSet[" + this.datasets.size() + " datasets: " + this.datasets.get(0) + ", " + this.datasets.get(1) + ", ...]";
        }
        return "BundleDataSet[" + this.datasets.size() + " datasets: " + this.datasets + " ]";
    }

    public class BundleDescriptor
    extends AbstractDataSet {
        public int rank() {
            return 2;
        }

        public int length() {
            return BundleDataSet.this.datasets.size();
        }

        public int length(int i) {
            return 0;
        }

        public Object property(String name, int i) {
            Object v = this.properties.get(name + "__" + i);
            if (i >= BundleDataSet.this.datasets.size()) {
                throw new IndexOutOfBoundsException("No dataset at index " + i + " only " + BundleDataSet.this.datasets.size() + " datasets.");
            }
            if (v == null) {
                return BundleDataSet.this.datasets.get(i).property(name);
            }
            return v;
        }

        public double value(int i0, int i1) {
            throw new IndexOutOfBoundsException("length=0");
        }
    }
}

