/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dsutil;

import java.util.Arrays;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dsops.Ops;

public class BinAverage {
    private BinAverage() {
    }

    public static DDataSet rebin(QDataSet ds, QDataSet newTags0) {
        int i;
        QDataSet dstags = (QDataSet)ds.property("DEPEND_0");
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        double fill = ((Number)wds.property("FILL_VALUE")).doubleValue();
        DDataSet result = DDataSet.createRank1(newTags0.length());
        DDataSet weights = DDataSet.createRank1(newTags0.length());
        int ibin = -1;
        for (i = 0; i < ds.length(); ++i) {
            ibin = DataSetUtil.closest(newTags0, dstags.value(i), ibin);
            double d = ds.value(i);
            double w = wds.value(i);
            double s = result.value(ibin);
            result.putValue(ibin, s + d * w);
            double n = weights.value(ibin);
            weights.putValue(ibin, n + w);
        }
        for (i = 0; i < result.length(); ++i) {
            if (weights.value(i) > 0.0) {
                result.putValue(i, result.value(i) / weights.value(i));
                continue;
            }
            result.putValue(i, fill);
        }
        result.putProperty("DEPEND_0", newTags0);
        return result;
    }

    public static DDataSet rebin(QDataSet ds, QDataSet newTags0, QDataSet newTags1) {
        int i;
        if (ds.rank() != 2) {
            throw new IllegalArgumentException("ds must be rank2");
        }
        QDataSet dstags0 = (QDataSet)ds.property("DEPEND_0");
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        double fill = ((Number)wds.property("FILL_VALUE")).doubleValue();
        DDataSet result = DDataSet.createRank2(newTags0.length(), newTags1.length());
        DDataSet weights = DDataSet.createRank2(newTags0.length(), newTags1.length());
        QDataSet ibin1CacheDs = null;
        int[] ibins1 = null;
        int ibin0 = -1;
        for (i = 0; i < ds.length(); ++i) {
            int j;
            ibin0 = DataSetUtil.closest(newTags0, dstags0.value(i), ibin0);
            QDataSet dstags1 = (QDataSet)ds.property("DEPEND_1", i);
            if (dstags1 != ibin1CacheDs) {
                ibins1 = new int[dstags1.length()];
                Arrays.fill(ibins1, -1);
                for (j = 0; j < dstags1.length(); ++j) {
                    ibins1[j] = DataSetUtil.closest(newTags1, dstags1.value(j), ibins1[j]);
                }
                ibin1CacheDs = dstags1;
            }
            for (j = 0; j < dstags1.length(); ++j) {
                int ibin1 = ibins1[j];
                double d = ds.value(i, j);
                double w = wds.value(i, j);
                double s = result.value(ibin0, ibin1);
                result.putValue(ibin0, ibin1, s + w * d);
                double n = weights.value(ibin0, ibin1);
                weights.putValue(ibin0, ibin1, n + w);
            }
        }
        for (i = 0; i < result.length(); ++i) {
            for (int j = 0; j < result.length(i); ++j) {
                if (weights.value(i, j) > 0.0) {
                    result.putValue(i, j, result.value(i, j) / weights.value(i, j));
                    continue;
                }
                result.putValue(i, j, fill);
            }
        }
        result.putProperty("DEPEND_0", newTags0);
        result.putProperty("DEPEND_1", newTags1);
        result.putProperty("WEIGHTS", weights);
        return result;
    }

    public static QDataSet residuals(QDataSet ds, int boxcarSize) {
        if (ds.rank() != 1) {
            throw new IllegalArgumentException("rank must be 1");
        }
        DDataSet mean = BinAverage.boxcar(ds, boxcarSize);
        QDataSet dres = Ops.pow(Ops.subtract(ds, mean), 2.0);
        QDataSet var = Ops.sqrt(BinAverage.boxcar(dres, boxcarSize));
        QDataSet res = Ops.divide(Ops.abs(Ops.subtract(ds, mean)), var);
        return res;
    }

    public static DDataSet boxcar(QDataSet ds, int size) {
        double w;
        double d;
        int i;
        int nn = ds.length();
        int s2 = size / 2;
        int s3 = s2 + size % 2;
        if (ds.rank() != 1) {
            throw new IllegalArgumentException("dataset must be rank 1");
        }
        if (ds.length() < size) {
            throw new IllegalArgumentException("dataset length is less than window size");
        }
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        DDataSet sums = DDataSet.createRank1(nn);
        DataSetUtil.putProperties(DataSetUtil.getProperties(ds), sums);
        DDataSet weights = DDataSet.createRank1(nn);
        double runningSum = 0.0;
        double runningWeight = 0.0;
        for (i = 0; i < size; ++i) {
            d = ds.value(i);
            w = wds.value(i);
            sums.putValue(i, d);
            weights.putValue(i, w);
            runningSum += d;
            runningWeight += w;
        }
        for (i = s2; i < nn - s3; ++i) {
            sums.putValue(i, runningSum);
            weights.putValue(i, runningWeight);
            double d0 = ds.value(i - s2);
            double w0 = wds.value(i - s2);
            double d2 = ds.value(i - s2 + size);
            double w2 = wds.value(i - s2 + size);
            runningSum += d2 * w2 - d0 * w0;
            runningWeight += w2 - w0;
        }
        for (i = nn - s3; i < nn; ++i) {
            d = ds.value(i);
            w = wds.value(i);
            sums.putValue(i, d);
            weights.putValue(i, w);
        }
        DDataSet result = sums;
        double fill = ((Number)wds.property("FILL_VALUE")).doubleValue();
        for (int i2 = 0; i2 < nn; ++i2) {
            if (weights.value(i2) > 0.0) {
                double s = result.value(i2);
                result.putValue(i2, s / weights.value(i2));
                continue;
            }
            result.putValue(i2, fill);
        }
        result.putProperty("WEIGHTS", weights);
        result.putProperty("DEPEND_0", ds.property("DEPEND_0"));
        result.putProperty("FILL_VALUE", fill);
        return result;
    }

    public static QDataSet rebin(QDataSet ds, int binSize0) {
        int l0 = ds.length();
        DDataSet result = DDataSet.createRank1(l0 / binSize0);
        DDataSet weights = DDataSet.createRank1(l0 / binSize0);
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        int n0 = l0 / binSize0;
        double fill = ((Number)wds.property("FILL_VALUE")).doubleValue();
        for (int i0 = 0; i0 < n0; ++i0) {
            int j0 = i0 * binSize0;
            double s = 0.0;
            double w = 0.0;
            for (int k0 = 0; k0 < binSize0; ++k0) {
                double w1 = wds.value(j0 + k0);
                w += w1;
                s += w1 * ds.value(j0 + k0);
            }
            weights.putValue(i0, w);
            result.putValue(i0, w == 0.0 ? fill : s / w);
        }
        result.putProperty("WEIGHTS", weights);
        result.putProperty("FILL_VALUE", fill);
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null) {
            result.putProperty("DEPEND_0", BinAverage.rebin(dep0, binSize0));
        }
        return result;
    }

    public static QDataSet rebin(QDataSet ds, int binSize0, int binSize1) {
        QDataSet dep1;
        int l0 = ds.length();
        int l1 = ds.length(0);
        DDataSet result = DDataSet.createRank2(l0 / binSize0, l1 / binSize1);
        DDataSet weights = DDataSet.createRank2(l0 / binSize0, l1 / binSize1);
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        int n0 = l0 / binSize0;
        int n1 = l1 / binSize1;
        double fill = ((Number)wds.property("FILL_VALUE")).doubleValue();
        for (int i0 = 0; i0 < n0; ++i0) {
            for (int i1 = 0; i1 < n1; ++i1) {
                int j0 = i0 * binSize0;
                int j1 = i1 * binSize1;
                double s = 0.0;
                double w = 0.0;
                for (int k0 = 0; k0 < binSize0; ++k0) {
                    for (int k1 = 0; k1 < binSize1; ++k1) {
                        double w1 = wds.value(j0 + k0, j1 + k1);
                        w += w1;
                        s += w1 * ds.value(j0 + k0, j1 + k1);
                    }
                }
                weights.putValue(i0, i1, w);
                result.putValue(i0, i1, w == 0.0 ? fill : s / w);
            }
        }
        result.putProperty("WEIGHTS", weights);
        result.putProperty("FILL_VALUE", fill);
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null) {
            result.putProperty("DEPEND_0", BinAverage.rebin(dep0, binSize0));
        }
        if ((dep1 = (QDataSet)ds.property("DEPEND_1")) != null) {
            result.putProperty("DEPEND_1", BinAverage.rebin(dep1, binSize1));
        }
        return result;
    }
}

